@extends('layouts.admin')
@section('content')
    <div class="content-area">
        <div class="card">
            <div class="d-sm-flex align-items-center justify-content-between">
                <h5 class=" mb-0 text-gray-800 pl-3">{{ __('Infra Infotech Whatsapp Api Configuration') }}</h5>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
                    <li class="breadcrumb-item"><a href="javascript:;">{{ __('Whatsapp Settings') }}</a></li>
                    <li class="breadcrumb-item"><a
                            href="{{ route('admin.whatsapp.group.show') }}">{{ __('Infra Infotech API Configuration') }}</a>
                    </li>
                </ol>
            </div>
        </div>
    </div>
    <div class="row mt-3">
        <div class="col-md-2">
            @include('includes.admin.roles.settings')
        </div>
        <div class="col-lg-10">
            <div class="card mb-4">
                <div class="card-body">
                    <form class="geniusform" action="{{ route('admin.whatsapp.config.update') }}" method="POST"
                        enctype="multipart/form-data">
                        @include('includes.admin.form-both')
                        {{ csrf_field() }}
                        <div class="form-group">
                            <label for="inp-title">{{ __('WhatsApp API Status') }}</label>
                            <div class="frm-btn btn-group mb-1">
                                <button type="button"
                                    class="btn btn-sm btn-rounded dropdown-toggle btn-{{ $gs->whatsapp_status == 1 ? 'success' : 'danger' }}"
                                    data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    {{ $gs->whatsapp_status == 1 ? __('Activated') : __('Deactivated') }}
                                </button>
                                <div class="dropdown-menu">
                                    <a class="dropdown-item drop-change" href="javascript:;" data-status="1"
                                        data-val="{{ __('Activated') }}"
                                        data-href="{{ route('admin.gs.status', ['whatsapp_status', 1]) }}">{{ __('Activate') }}</a>
                                    <a class="dropdown-item drop-change" href="javascript:;" data-status="0"
                                        data-val="{{ __('Deactivated') }}"
                                        data-href="{{ route('admin.gs.status', ['whatsapp_status', 0]) }}">{{ __('Deactivate') }}</a>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label>{{ __('Company Name :') }} Infra Infotech</label><br>
                            <label>{{ __('Company Website URL') }} </label>
                            <a href="https://infrainfotech.com" target="_blank"
                                class="text-primary">https://infrainfotech.com</a>
                        </div>
                        <div class="form-group">
                            <label>{{ __('WhatsApp API URL') }} </label>
                            <input type="text" class="input-field" placeholder="{{ __('API Endpoint URL') }}"
                                name="whatsapp_api_url" value="{{ $gs->whatsapp_api_url }}" required>
                        </div>

                        <div class="form-group">
                            <label>{{ __('API Key') }} </label>
                            <input type="text" class="input-field" placeholder="{{ __('Your API Key') }}"
                                name="whatsapp_accessToken" value="{{ $gs->whatsapp_accessToken }}" required>
                        </div>

                        <div class="form-group">
                            <label>{{ __('Whatsapp Channel ID') }} </label>
                            <input type="tel" class="input-field" placeholder="{{ __('Enter Your Channel ID') }}"
                                name="whatsapp_channelId" value="{{ $gs->whatsapp_channelId }}" required>
                        </div>
                        <button type="submit" id="submit-btn"
                            class="btn btn-primary w-100">{{ __('Update WhatsApp Settings') }}</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('scripts')
@endsection
