@extends('layouts.admin')

@section('content')
    <div class="content-area">
        <div class="card">
            <div class="d-sm-flex align-items-center justify-content-between">
                <h5 class=" mb-0 text-gray-800 pl-3">{{ __('Edit Template') }} <a class="btn btn-primary btn-rounded btn-sm"
                        href="{{ url()->previous() }}"><i class="fas fa-arrow-left"></i> {{ __('Back') }}</a></h5>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
                    <li class="breadcrumb-item"><a
                            href="{{ route('admin.mail.edit', $data->id) }}">{{ __('Edit Template') }}</a></li>
                </ol>
            </div>
        </div>
    </div>
    <div class="row mt-3">
        <div class="col-md-2">
            @include('includes.admin.roles.settings')
            @include('includes.admin.form-success')

        </div>
        <div class="col-lg-10">
            <div class="card mb-4 mt-3">
                <div class="card-header py-3 text-center">
                    <div class="row">
                        <div class="col-lg-12 offset-lg-4 col-md-12 offset-md-4">
                            <p>{{ __('Use the BB codes, it show the data dynamically in your whatsapps.') }}</p>
                            <br>
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th>{{ __('Meaning') }}</th>
                                        <th>{{ __('BB Code') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>{{ __('Customer Name') }}</td>
                                        <td>{customer_name}</td>
                                    </tr>
                                    <tr>
                                        <td>{{ __('Withdraw Amount') }}</td>
                                        <td>{amount}</td>
                                    </tr>
                                    <tr>
                                        <td>{{ 'Admin Name' }}</td>
                                        <td>{admin_name}</td>
                                    </tr>
                                    <tr>
                                        <td>{{ __('Admin Whatsapp') }}</td>
                                        <td>{admin_whatsapp}</td>
                                    </tr>
                                    <tr>
                                        <td>{{ __('Website Title') }}</td>
                                        <td>{website_title}</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <div class="card-body">
                    <div class="gocover"
                        style="background: url({{ asset('assets/images/' . $gs->admin_loader) }}) no-repeat scroll center center rgba(45, 45, 45, 0.5);">
                    </div>
                    <form class="geniusform" action="{{ route('admin.whatsapp.update', $data->id) }}" method="POST"
                        enctype="multipart/form-data">
                        @include('includes.admin.form-both')
                        {{ csrf_field() }}

                        <div class="form-group">
                            <label>{{ __('Template Type') }} </label>
                            <input type="text" name="whatsapp_type" class="input-field" required=""
                                value="{{ $data->whatsapp_type }}">
                        </div>

                        <div class="form-group">
                            <label>{{ __('Message Title') }} </label>
                            <input type="text" class="input-field" name="whatsapp_subject"
                                placeholder="{{ __('Message Title') }}" required=""
                                value="{{ $data->whatsapp_subject }}">
                        </div>

                        <div class="form-group">
                            <label>{{ __('Description') }} </label>
                            <textarea class="form-control summernote" name="whatsapp_body" placeholder="{{ __('Description') }}">{{ $data->whatsapp_body }}</textarea>
                        </div>

                        <button type="submit" id="submit-btn" class="btn btn-primary w-100">{{ __('Submit') }}</button>

                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
