@extends('layouts.admin')
<style>
    .select2-container--default .select2-selection--multiple {
        background-color: white;
        border: 1px solid #aaa;
        border-radius: 4px;
        cursor: text;
        padding-bottom: 0;
        padding-top: 0;
        position: relative;
        padding-left: 17px;
    }
</style>
@section('content')
    <div class="content-area">
        <div class="card">
            <div class="d-sm-flex align-items-center justify-content-between">
                <h5 class=" mb-0 text-gray-800 pl-3">{{ __('Group Whatsapp') }}</h5>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
                    <li class="breadcrumb-item"><a href="javascript:;">{{ __('Whatsapp Settings') }}</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('admin.group.show') }}">{{ __('Group Whatsapp') }}</a></li>
                </ol>
            </div>
        </div>
    </div>
    <div class="row mt-3">
        <div class="col-md-2">
            @include('includes.admin.roles.settings')
        </div>
        <div class="col-lg-10">
            <div class="card mb-4">
                <div class="card-body">
                    <form id="geniusform" class="" action="{{ route('admin.whatsapp.group.submit') }}" method="POST"
                        enctype="multipart/form-data">
                        @include('includes.admin.form-both')
                        @include('includes.admin.form-success')

                        {{ csrf_field() }}
                        <div class="form-group">
                            <select name="type" required class="input-field">
                                <option value="">{{ __('Choose User Type') }}</option>
                                <option value="user">{{ __('Property Buyer') }}</option>
                                <option value="tenant">{{ __('Tenant') }}</option>
                                <option value="owner">{{ __('Property Owner') }}</option>
                                <option value="agent">{{ __('Property Agent') }}</option>
                                <option value="builder">{{ __('Builder/Developer') }}</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <select id="city_filter" name="city_filter" class="input-field" required>
                                <option value="">{{ __('Select Cities') }}</option>
                                <option value="all">{{ __('All Cities') }}</option>
                                <option value="top">{{ __('Top Cities') }}</option>
                                <option value="not_top">{{ __('Not Top Cities') }}</option>
                                <option value="one_city">{{ __('Select Specific Cities') }}</option>
                            </select>
                        </div>
                        <div class="form-group d-none" id="sub_city_select" style="font-size: 15px !important;">
                            <select name="cities[]" id="city_selection" class="form-control select2-multiple"
                                multiple="multiple" style="width: 100%; font-size: 12px !important;">

                            </select>
                        </div>
                        <div class="form-group">
                            <select name="message_type" id="message_type" class="input-field" required>
                                <option value="">{{ __('Select Message Type') }}</option>
                                <option value="text">{{ __('Text Message') }}</option>
                                <option value="image">{{ __('Image Message') }}</option>
                            </select>
                        </div>
                        <div class="form-group d-none" id="image_message_div">
                            <label for="image">{{ __('Attach Image') }}</label>
                            <input type="file" name="image" class="form-control">
                        </div>
                        <div class="form-group d-none" id="text_message_div">
                            <textarea class="form-control" name="body" placeholder="{{ __('Type Text Message here...') }}" rows="5"></textarea>
                        </div>
                        <button type="submit" id="submit-btn" class="btn btn-primary w-100">{{ __('Submit') }}</button>
                    </form>
                    <!-- Replace the download button section with this -->
                    <div class="form-group mt-3">
                        <form id="downloadForm" action="{{ route('admin.whatsapp.group.download') }}" method="POST">
                            @csrf
                            <input type="hidden" name="type" id="download_type">
                            <input type="hidden" name="city_filter" id="download_city_filter">
                            <input type="hidden" name="cities" id="download_cities">
                            <button type="submit" class="btn btn-success w-100"
                                id="download-btn">{{ __('Download Data') }}</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('scripts')
    <script>
        $(document).ready(function() {
            // Initialize select2
            $('.select2-multiple').select2({
                placeholder: "{{ __('Select cities') }}",
                allowClear: true
            });

            $('#message_type').change(function() {
                const val = $(this).val();
                $('#text_message_div').toggleClass('d-none', val !== 'text');
                $('#image_message_div').toggleClass('d-none', val !== 'image');
            });
            const cityData = {
                top: @json(
                    $data['topCities']->map(function ($city) {
                        return [
                            'id' => $city->id,
                            'text' => $city->name . ' (' . $city->properties_count . ' properties)',
                        ];
                    })),
                not_top: @json(
                    $data['otherCities']->map(function ($city) {
                        return [
                            'id' => $city->id,
                            'text' => $city->name . ' (' . $city->properties_count . ' properties)',
                        ];
                    })),
                one_city: @json(
                    $data['spacificCities']->map(function ($city) {
                        return [
                            'id' => $city->id,
                            'text' => $city->name . ' (' . $city->properties_count . ' properties)',
                        ];
                    })),
            };

            // City filter labels
            const filterLabels = {
                'all': '{{ __('All Cities Selected') }}',
                'top': '{{ __('Select Top Cities') }}',
                'not_top': '{{ __('Select Regular Cities') }}',
                'one_city': '{{ __('Select Specific Cities') }}'
            };

            // City filter change handler
            $('#city_filter').change(function() {
                const val = $(this).val();
                const subCityDiv = $('#sub_city_select');
                const citySelect = $('#city_selection');

                if (val === 'all') {
                    subCityDiv.addClass('d-none');
                    citySelect.val(null).trigger('change');
                } else if (val) {
                    subCityDiv.removeClass('d-none');
                    citySelect.empty();
                    if (cityData[val]) {
                        $.each(cityData[val], function(i, city) {
                            citySelect.append(new Option(city.text, city.id, false, false));
                        });
                    }
                    citySelect.trigger('change');
                } else {
                    subCityDiv.addClass('d-none');
                    citySelect.empty().trigger('change');
                }
            });
            $('#download-btn').click(function(e) {
                e.preventDefault();

                // Copy form values to download form
                $('#download_type').val($('select[name="type"]').val());
                $('#download_city_filter').val($('select[name="city_filter"]').val());

                // Get selected cities as array
                const cities = $('#city_selection').val() || [];
                $('#download_cities').val(JSON.stringify(cities));
                // Submit download form
                $('#downloadForm').submit();
            });
        });
    </script>
@endsection
