@extends('layouts.front')
@push('css')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/css/intlTelInput.css" />
    <style>
        .iti {
            width: 100%;
        }

        .iti__country-list {
            position: absolute;
            z-index: 2;
            width: 273px;
        }

        .iti__dropdown {
            width: 100% !important;
            box-shadow: 0px 4px 8px rgba(0, 0, 0, 0.1);
            z-index: 1050;
        }

        .btn-primary1 {
            background: #f02c2d
        }

        .form-group {
            margin-bottom: 0px;
        }

        [type="radio"]:checked,
        [type="radio"]:not(:checked) {
            position: absolute;
            left: 1;
        }

        . {
            display: inline-block;
            margin-right: -1rem;
        }
    </style>
@endpush
@section('content')
    <section class="gray"style="background: url('https://images.unsplash.com/photo-1605146769289-440113cc3d00?q=80&w=1470&auto=format&fit=crop&ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D') no-repeat center center;
                                background-size: cover;">
        <div class="container">
            <div class="row align-items-start justify-content-center">
                <div class="col-xl-5">
                    <div class="signup-screen-wrap">
                        <div class="signup-screen-single light card p-4">
                            <div class="text-center">
                                <h4 class="text-center">Give us some details about yourself</h4>
                            </div>
                            <hr>
                            <form id="" class="row" action="{{ route('agent.register.submit') }}"
                                method="POST">
                                @csrf
                                <div class="mb-3 text-dark">
                                    <label class="form-label d-block">Are You</label>

                                    <div class="form-check ">
                                        <input class="form-check-input" type="radio" name="user_type" id="owner"
                                            value="owner" {{ old('user_type') == 'owner' ? 'checked' : '' }}>
                                        <label class="form-check-label" for="owner">Property Owner</label>
                                    </div>

                                    <div class="form-check ">
                                        <input class="form-check-input" type="radio" name="user_type" id="agent"
                                            value="agent" {{ old('user_type') == 'agent' ? 'checked' : '' }}>
                                        <label class="form-check-label" for="agent">Property Agent</label>
                                    </div>

                                    <div class="form-check ">
                                        <input class="form-check-input" type="radio" name="user_type"
                                            id="builder/developer" value="builder/developer"
                                            {{ old('user_type') == 'builder/developer' ? 'checked' : '' }}>
                                        <label class="form-check-label" for="builder/developer">Builder/Developer</label>
                                    </div>
                                </div>
                                <!-- Name Field -->
                                <div class="form-group">
                                    <label class="mb-1">@lang('Your Name')</label>
                                    <input type="text" name="name" class="form-control rounded"
                                        placeholder="Enter Your Name" value="{{ old('name') }}">
                                    @error('name')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                                <!-- Phone Field -->
                                <div class="form-group">
                                    <label class="mb-1">@lang('Phone')</label>
                                    <input type="hidden" name="phone" value="{{ old('phone', session('phone')) }}">
                                    <input type="tel" name="phone" id="phone" class="form-control rounded"
                                        placeholder="Enter Phone Number" value="{{ old('phone', session('phone')) }}"
                                        {{ session('phone') ? 'disabled' : '' }} inputmode="numeric" pattern="[0-9]*">
                                    @error('phone')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>

                                <!-- Email Field -->
                                <div class="form-group">
                                    <label class="mb-1">@lang('Email')</label>
                                    <input type="email" name="email" class="form-control rounded"
                                        value="{{ old('email', session('email')) }}"
                                        {{ session('email') ? 'disabled' : '' }}>
                                    @error('email')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                                <!-- Password Field -->
                                <div class="form-group">
                                    <label class="mb-1">@lang('Password')</label>
                                    <input type="password" name="password" class="form-control rounded" required>
                                    @error('password')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                                <!-- Submit Button -->
                                <div class="form-group">
                                    <button type="submit" class="btn rounded add-listing theme-bg w-100">
                                        @lang('Continue')
                                        <div class="spinner-border formSpin d-none" role="status"></div>
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    @includeIf('partials.front.cta')
@endsection
@push('js')
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="{{ asset('assets/front/js/custom-agent.js') }}"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/intlTelInput.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const phoneInput = document.querySelector("#phone");

            const iti = intlTelInput(phoneInput, {
                initialCountry: "in",
                separateDialCode: true,
                preferredCountries: ["in", "us", "gb"],
                utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/utils.js",
            });

            const continueButton = document.querySelector("#continueButton");
            const otpModal = new bootstrap.Modal(document.getElementById('otpModal'));
            const hiddenPhoneInput = document.querySelector("#hiddenPhoneInput");

            continueButton.addEventListener("click", function() {
                const fullPhoneNumber = iti.getNumber();
                hiddenPhoneInput.value = fullPhoneNumber;
                otpModal.show();
            });
        });
    </script>
    <script>
        document.getElementById('phone').addEventListener('input', function(e) {
            this.value = this.value.replace(/\D/g, ''); // remove all non-digits
        });

        document.addEventListener('DOMContentLoaded', function() {
            const userTypeButtons = document.querySelectorAll('.user-type-btn');
            const userTypeInput = document.getElementById('user_type');

            userTypeButtons.forEach(button => {
                button.addEventListener('click', function() {
                    userTypeInput.value = this.getAttribute('data-value');

                    userTypeButtons.forEach(btn => btn.classList.remove('theme-bg', 'text-white'));
                    this.classList.add('theme-bg', 'text-white');
                });
            });

            document.getElementById('registerform1').addEventListener('submit', function(e) {
                const userType = userTypeInput.value;
                if (!userType) {
                    e.preventDefault();
                    alert('Please select a user type');
                }
            });
        });
    </script>
@endpush
