@extends('layouts.agent')
@push('css')
<link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
<style>
    .contact {
        margin-top: 0 !important;
        /* Mobile default */
    }

    @media (min-width: 768px) {
        .contact {
            margin-top: 25px !important;
            /* Desktop and larger */
        }
    }

    .share-options {
        display: none;
        transition: all 0.2s ease-in-out;
        font-size: 13px;
    }

    .share-options.d-block {
        display: block !important;

    }

    .truncate-text {
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
        max-width: 280px;
        /* Adjust based on your layout */
        display: inline-block;
        vertical-align: middle;
    }
</style>
@endpush
@section('content')
@if (session('message'))
<div class="alert alert-success">
    {{ session('message') }}
</div>
@endif
@if (auth()->check() && !auth()->user()->hasVerifiedEmail())
<div class="modal fade" id="verifyEmailModal" tabindex="-1" role="dialog" aria-labelledby="verifyEmailLabel"
    aria-hidden="true" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content border shadow-lg rounded">
            <div class="modal-header bg-success text-dark">
                <h5 class="modal-title fw-bold" id="verifyEmailLabel">Email Verification Required</h5>
            </div>
            <div class="modal-body">
                <p id="verificationPrompt" class="mb-3">
                    Your email address is not verified. Please click below button to verify your email.
                </p>

                <div id="verificationMessage"></div>

                {{-- ✅ SEND button: shown by default --}}
                <form id="sendVerificationForm">
                    @csrf
                    <button type="submit" class="btn btn-primary btn-sm" id="sendBtn">
                        Send Verification Email
                    </button>
                </form>
            </div>
            <div class="modal-footer">
                <button id="remindMeBtn" type="button" class="btn btn-outline-secondary btn-sm"
                    data-dismiss="modal">
                    Remind Me Later
                </button>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener("DOMContentLoaded", function() {
        setTimeout(() => {
            $('#verifyEmailModal').modal('show');
        }, 300);

        const form = document.getElementById('sendVerificationForm');
        const messageDiv = document.getElementById('verificationMessage');
        const remindBtn = document.getElementById('remindMeBtn');
        const promptText = document.getElementById('verificationPrompt');
        const sendBtn = document.getElementById('sendBtn');

        remindBtn.addEventListener('click', function() {
            $('#verifyEmailModal').modal('hide');
        });

        form.addEventListener('submit', function(e) {
            e.preventDefault();

            messageDiv.innerHTML = `
            <div class="alert alert-success p-2 mt-3" role="alert">
                ✅ Sending verification email...
            </div>`;

            fetch("{{ route('verification.send') }}", {
            
                    method: "POST",
                    headers: {
                        'X-CSRF-TOKEN': '{{ csrf_token() }}',
                        'Accept': 'application/json'
                    },
                })
                            .then(response => response.json())
                            .then(data => {
                                if (data.status === 'success') {
                                    promptText.style.display = 'none';
                                    messageDiv.innerHTML = `
                                        <div class="alert alert-success p-2 mt-3" role="alert">
                                            Please check your inbox for the verification link.
                                        </div>`;
                                    sendBtn.textContent = 'Resend Verification Email';
                                    remindBtn.style.display = 'inline-block';
                                } else if (data.status === 'already_verified') {
                                    messageDiv.innerHTML = `
                                        <div class="alert alert-info p-2 mt-3" role="alert">
                                            ${data.message}
                                        </div>`;
                                    promptText.style.display = 'none';
                                    sendBtn.style.display = 'none';
                                    remindBtn.style.display = 'inline-block';
                                } else {
                                    messageDiv.innerHTML = `
                                        <div class="alert alert-danger p-2 mt-3" role="alert">
                                            ⚠️ ${data.message || 'Something went wrong.'}
                                        </div>`;
                                }
                            })
                            .catch(error => {
                                messageDiv.innerHTML = `
                                    <div class="alert alert-danger p-2 mt-3" role="alert">
                                        ⚠️ ${error.message}
                                    </div>`;
                            });

        });
    });
</script>
@endif
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">{{ __(ucwords($user_type) . ' Dashboard') }}</h1>
        <a href="{{ route('agent.properties.step_1') }}"
            class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm">
            <i class="fas fa-plus fa-sm text-white-50"></i> {{ __('Post Property') }}
        </a>
    </div>
    <!-- Stats Row -->
    <div class="row">
        <!-- Total Properties Card -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">

                            <div class="text-xs font-weight-bold text-primary text-uppercase ">
                                {{ __('Total Properties') }}
                            </div>

                            <a href="{{ route('agent.properties.index') }}">
                                <div class="h5 mb-0 font-weight-bold text-gray-800">{{ count($properties) }}</div>
                            </a>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-home fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Pending Properties Card -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">

                            <div class="text-xs font-weight-bold text-warning text-uppercase ">
                                {{ __('Pending Properties') }}
                            </div>
                            <a href="{{ route('agent.properties.pending') }}">
                                <div class="h5 mb-0 font-weight-bold text-gray-800">{{ count($pending_properties) }}</div>
                            </a>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-clock fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Approved Properties Card -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase ">
                                {{ __('Approved Properties') }}
                            </div>

                            <a href="{{ route('agent.properties.approved') }}">
                                <div class="h5 mb-0 font-weight-bold text-gray-800">{{ count($approved_properties) }}</div>
                            </a>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-indian-rupee-sign fa-2x text-gray-300">₹</i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Total Leads Card -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">

                            <div class="text-xs font-weight-bold text-info text-uppercase ">
                                {{ __('Total Leads') }}
                            </div>
                            <a href="{{ route('agent.properties.enquiries.index') }}">
                                <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $enquiryCount }}</div>
                            </a>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-users fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Total View Contacts -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-danger text-uppercase ">
                                {{ __('Total View Contacts') }}
                            </div>
                            <a href="{{ route('agent.view.contacts') }}">
                                <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $viewedCount }}</div>
                            </a>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-user-check fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="data-container mt-4 mx-2">
        <h4 class="mb-3">@lang('Contacted Properties')</h4>
        @foreach ($contacts as $contact)
        @php $property = $contact->property; @endphp
        @if ($property)
        @php
        $routes = [
        'for_pg' => 'pg.details',
        'for_rent' => 'rent.details',
        'for_sell' => 'buy.details',
        'plot' => 'plot.details',
        'commercial' => 'commercial.details',
        ];

        $propertyUrl = isset($routes[$property->looking_for])
        ? route($routes[$property->looking_for], $property->slug)
        : '#'; // fallback
        @endphp
        <div class="col-12 mb-3  position-relative">
            <div class="position-absolute" style="top: 5px; right: 20px; z-index: 1050;">
                <i class="fas fa-share-alt" style="font-size: 18px; color: #474646; cursor: pointer;"
                    onclick="toggleShareOptions(event, '{{ $property->id }}')"></i>
                <div id="share-options-{{ $property->id }}" class="share-options shadow p-4 rounded bg-white"
                    style="position: absolute; top: 30px; right: 0; min-width: 160px; display: none; z-index: 1060;">

                    <a href="#" onclick="copyLink('{{ $propertyUrl }}'); return false;"
                        class="d-flex align-items-center mt-1">
                        <i class="fas fa-link mr-2 text-primary"></i> Copy Link
                    </a>

                    <a href="https://api.whatsapp.com/send?text={{ urlencode($propertyUrl) }}" target="_blank"
                        class="d-flex align-items-center mt-1">
                        <i class="fab fa-whatsapp mr-2 text-success"></i> WhatsApp
                    </a>

                    <a href="https://www.facebook.com/sharer/sharer.php?u={{ urlencode($propertyUrl) }}"
                        target="_blank" class="d-flex align-items-center mt-1">
                        <i class="fab fa-facebook mr-2 text-primary"></i> Facebook
                    </a>

                    <a href="https://twitter.com/intent/tweet?url={{ urlencode($propertyUrl) }}"
                        target="_blank" class="d-flex align-items-center mt-1">
                        <i class="fab fa-twitter mr-2 text-info"></i> Twitter
                    </a>

                    <a href="https://www.linkedin.com/shareArticle?mini=true&url={{ urlencode($propertyUrl) }}"
                        target="_blank" class="d-flex align-items-center mt-1">
                        <i class="fab fa-linkedin mr-2 text-primary"></i> LinkedIn
                    </a>

                    <a href="https://www.instagram.com/" target="_blank" class="d-flex align-items-center">
                        <i class="fab fa-instagram mr-2 text-danger"></i> Instagram
                    </a>
                </div>
            </div>
            <div class="shadow-sm rounded bg-white overflow-hidden d-flex flex-wrap flex-md-nowrap">
                {{-- Column 1: Property Image --}}
                <div class="property-img position-relative">
                    <img src="{{ asset('assets/images/' . $property->photo) }}" class="img-fluid w-100 h-100"
                        style="object-fit: cover;" alt="{{ $property->name }}">
                    {{-- Badge --}}
                    <span class="badge position-absolute" style="top: 10px; left: 10px; background-color: #f02c2d; color: white;">
                        @if ($property->looking_for == 'for_rent')
                        {{ __('For Rent') }}
                        @elseif ($property->looking_for == 'for_sell')
                        {{ __('For Sell') }}
                        @elseif ($property->looking_for == 'for_pg')
                        {{ __('For PG') }}
                        @else
                        {{ __('Property') }}
                        @endif
                    </span>
                </div>
                {{-- Column 2: Price + Location --}}
                <div class="px-4 pt-1 flex-fill col-12 col-md-3">
                    <p class="text-primary font-weight-bold mb-2" style="font-size: 1.1rem;">
                        {{ showAmount($property->price) }}
                    </p>
                    <p class=" text-muted" style="font-size: 14px;">
                        <i class="fas fa-map-marker-alt mr-1"></i>
                        {{ $property->location->name ?? '' }}
                    </p>
                    <p class="text-muted mb-0">
                        {{ $property->name }}
                    </p>

                </div>
                <div class="px-4 pt-1 col-12 col-md-3 text-md-center">
                    <small class="text-muted d-block  contact">
                        <i class="far fa-clock mr-1"></i>
                        Contacted {{ \Carbon\Carbon::parse($contact->created_at)->format('d M Y \a\t h:i A') }}
                    </small>
                </div>
                <div class="px-4 py-2 col-12 col-md-3 text-md-right">
                    <div id="lead-section-{{ $contact->id }}">
                        @if (Auth::user()->plan_id == null)
                        {{-- For Free Users – Show button & JS logic --}}
                        <button
                            type="button"
                            class="btn btn-sm btn-outline-primary mt-5 view-leads-btn"
                            data-property-id="{{ $property->id }}"
                            data-enquiry-id="{{ $contact->id }}"
                            data-enquiry-user-id="{{ $contact->user_id }}">
                            View Leads
                        </button>

                        <div class="lead-details mt-2" style="display: none;"><br>
                            <p><strong>{{ ucwords($contact->details ?? '') }}</strong></p>
                            <p><i class="fab fa-whatsapp mr-1"></i>{{ $contact->phone ?? '' }}</p>
                            <p><i class="fas fa-envelope mr-1"></i>{{ $contact->email ?? '' }}</p>
                        </div>
                        @else
                        {{-- For Paid Users – Show full lead info always --}}
                        <div class="lead-details mt-2"><br>
                            <p><strong>{{ ucwords($contact->details ?? '') }}</strong></p>
                            <p><i class="fab fa-whatsapp mr-1"></i>{{ $contact->phone ?? '' }}</p>
                            <p><i class="fas fa-envelope mr-1"></i>{{ $contact->email ?? '' }}</p>
                        </div>
                        @endif
                    </div><br>

                    <script>
                        document.addEventListener("DOMContentLoaded", function() {
                            const MAX_VIEWS = 2;
                            const AUTH_USER_TYPE = "{{ strtolower(Auth::user()->user_type) === 'builder/developer' ? 'Developer' : ucwords(Auth::user()->user_type) }}";

                            let viewedEnquiries = JSON.parse(localStorage.getItem("viewedEnquiries") || "[]");

                            // Show already viewed enquiries
                            viewedEnquiries.forEach(function(item, index) {
                                if (index < MAX_VIEWS) { // ✅ only allow first MAX_VIEWS enquiries to show
                                    const section = document.getElementById(`lead-section-${item.enquiryId}`);
                                    if (section) {
                                        const btn = section.querySelector(".view-leads-btn");
                                        const details = section.querySelector(".lead-details");
                                        if (btn) btn.remove();
                                        if (details) details.style.display = "block";
                                    }
                                }
                            });

                            // Attach click event
                            document.querySelectorAll(".view-leads-btn").forEach(function(btn) {
                                btn.addEventListener("click", function() {
                                    const propertyId = this.getAttribute("data-property-id");
                                    const enquiryId = this.getAttribute("data-enquiry-id");
                                    const enquiryUserId = this.getAttribute("data-enquiry-user-id");

                                    // Check already viewed
                                    const alreadyViewed = viewedEnquiries.some(
                                        item => item.enquiryId == enquiryId
                                    );

                                    if (!alreadyViewed) {
                                        // Count how many enquiries unlocked
                                        const userViewedCount = viewedEnquiries.length;

                                        if (userViewedCount >= MAX_VIEWS) {
                                            // Show upgrade modal
                                            const modal = document.createElement('div');
                                            modal.innerHTML = `
                                            <div class="modal fade" id="upgradeModal" tabindex="-1" role="dialog">
                                                <div class="modal-dialog modal-dialog-centered" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title">Upgrade Required</h5>
                                                            <button type="button" class="close" data-dismiss="modal">&times;</button>
                                                        </div>
                                                        <div class="modal-body">
                                                            Dear ${AUTH_USER_TYPE}, you can only view ${MAX_VIEWS} leads on free plan. Kindly upgrade your package to view all.
                                                        </div>
                                                        <div class="modal-footer">
                                                            <a href="{{ route('agent.packages.all')}}" class="btn btn-primary" >OK</a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>`;
                                            document.body.appendChild(modal);
                                            $('#upgradeModal').modal('show');
                                            return;
                                        }

                                        // Save enquiry
                                        viewedEnquiries.push({
                                            enquiryUserId: enquiryUserId,
                                            propertyId: propertyId,
                                            enquiryId: enquiryId
                                        });
                                        localStorage.setItem("viewedEnquiries", JSON.stringify(viewedEnquiries));
                                    }

                                    // Show lead details
                                    const section = document.getElementById(`lead-section-${enquiryId}`);
                                    const leadBtn = section.querySelector(".view-leads-btn");
                                    const leadDetails = section.querySelector(".lead-details");

                                    if (leadBtn) leadBtn.remove();
                                    if (leadDetails) leadDetails.style.display = "block";
                                });
                            });
                        });
                    </script>

                    @if ($property->status == 1)
                    <a class="btn btn-sm btn-outline-primary contact mt-1" href="{{ $propertyUrl }}" target="_blank">
                        View Properties
                    </a>
                    @else
                    <a href="#" class="btn btn-sm btn-outline-primary mt-1 contact"
                        onclick="alert('Property might be pending.'); return false;">
                        View Properties
                    </a>
                    @endif
                </div>


            </div>
        </div>
        @endif
        @endforeach
        <div class="mt-3">
            {{ $contacts->links() }}
        </div>
    </div>
</div>
<br>
@endsection
@section('scripts')
<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
    function toggleShareOptions(event, propertyId) {
        event.stopPropagation();
        var shareOptions = document.getElementById('share-options-' + propertyId);
        shareOptions.style.display = (shareOptions.style.display === 'none' || shareOptions.style.display === '') ?
            'block' : 'none';
        setTimeout(function() {
            shareOptions.style.display = 'none';
        }, 3000);
    }

    function copyLink(link) {
        navigator.clipboard.writeText(link).then(() => {
            alert('Link copied to clipboard!');
        }).catch(() => {
            alert('Failed to copy link!');
        });
    }
    // Close dropdown on click outside
    document.addEventListener('click', function() {
        document.querySelectorAll('.share-options').forEach(el => el.style.display = 'none');
    });
</script>
@endsection