@extends('layouts.agent')

@section('content')
<div class="card">
  <div class="d-sm-flex align-items-center justify-content-between">
    <h5 class=" mb-0 text-gray-800 pl-3">{{ __('Edit Floor Plan') }} <a class="btn btn-primary btn-rounded btn-sm" href="{{route('agent.floor.plan.index',$pid)}}"><i class="fas fa-arrow-left"></i> {{ __('Back') }}</a></h5>
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="{{ route('agent.dashboard') }}">{{ __('Dashboard') }}</a></li>
    </ol>
  </div>
</div>

<div class="row justify-content-center mt-3">
  <div class="col-md-10">
    <div class="card mb-4">
      <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
        <h6 class="m-0 font-weight-bold text-primary">{{ __('Edit Plan Floor Form') }}</h6>
      </div>
      <div class="card-body">
        {{-- <div class="gocover" style="background: url({{asset('assets/images/'.$gs->agent_loader)}}) no-repeat scroll center center rgba(45, 45, 45, 0.5);"></div> --}}
        <form class="geniusform" action="{{route('agent.floor.plan.update',[$data->id,$pid])}}" method="POST" enctype="multipart/form-data">

            @include('includes.agent.form-success')

            {{ csrf_field() }}

            <input type="hidden" name="property_id" value="{{ $pid }}">

            <div class="form-group">
                <label for="name">{{ __('name') }}</label>
                <input type="text" class="form-control" id="name" name="name" placeholder="{{ __('Enter Name') }}" value="{{ $data->name }}" required>
            </div>

            <div class="form-group">
                <label for="size">{{ __('Size') }}</label>
                <select class="form-control" id="slug" name="size" required>
                    <option value="" disabled>{{ __('Select Size') }}</option>
                    <option value="1 RK" @selected($data->size == '1 RK')>1 RK</option>
                    <option value="1 BHK" @selected($data->size == '1 BHK')>1 BHK</option>
                    <option value="1.5 BHK" @selected($data->size == '1.5 BHK')>1.5 BHK</option>
                    <option value="2 BHK" @selected($data->size == '2 BHK')>2 BHK</option>
                    <option value="2.5 BHK" @selected($data->size == '2.5 BHK')>2.5 BHK</option>
                    <option value="3 BHK" @selected($data->size == '3 BHK')>3 BHK</option>
                    <option value="3.5 BHK" @selected($data->size == '3.5 BHK')>3.5 BHK</option>
                    <option value="4 BHK" @selected($data->size == '4 BHK')>4 BHK</option>
                    <option value="4.5 BHK" @selected($data->size == '4.5 BHK')>4.5 BHK</option>
                    <option value="5 BHK" @selected($data->size == '5 BHK')>5 BHK</option>
                    <option value="5+ BHK" @selected($data->size == '5+ BHK')>5+ BHK</option>
                </select>

            </div>

          <div class="form-group">
              <label>{{ __('Set Picture') }} </label>
              <div class="wrapper-image-preview">
                  <div class="box">
                      <div class="back-preview-image" style="background-image: url({{$data->photo ? asset('assets/images/'.$data->photo) : asset('assets/images/placeholder.jpg') }});"></div>
                      <div class="upload-options">
                          <label class="img-upload-label" for="img-upload"> <i class="fas fa-camera"></i> {{ __('Upload Picture') }} </label>
                          <input id="img-upload" type="file" class="image-upload" name="photo" accept="image/*">
                      </div>
                  </div>
              </div>
          </div>

          <button type="submit" id="submit-btn" class="btn btn-primary w-100">{{ __('Submit') }}</button>
        </form>
      </div>
    </div>
  </div>
</div>

@endsection

