@extends('layouts.front')

@push('css')

@endpush

@section('content')
    <!-- ============================ Submit Property Start ================================== -->
    <section class="gray">
        <div class="container">
            <div class="row align-items-start justify-content-center">
                <div class="col-xl-5 col-lg-8 col-md-12">

                    <div class="signup-screen-wrap">
                        <div class="signup-screen-single">
                            <div class="text-center mb-4">
                                <h4 class="m-0 ft-medium">@lang('Login to Your Account')</h4>
                            </div>

                            <form id="loginform" action="{{ route('agent.login.submit') }}" method="post">
                                @includeIf('partials.user.form-both')
                                @csrf
                                <div class="row gy-3">
                                    <div class="form-group">
                                        <!--<label class="mb-1">@lang('Email')</label>-->
                                        <input type="text" name="email" class="form-control rounded" placeholder="@lang('Enter email or Phone')">
                                    </div>

                                    <div class="form-group">
                                        <!--<label class="mb-1">@lang('Password')</label>-->
                                        <input type="password" name="password" class="form-control rounded" placeholder="*******">
                                    </div>

                                    <div class="form-group">
                                        <div class="d-flex align-items-center justify-content-between">
                                            <div class="flex-1">
                                                <input id="remember" class="checkbox-custom" name="remember" type="checkbox">
                                                <label for="remember" class="checkbox-custom-label">@lang('Remember Me')</label>
                                            </div>
                                             <div class="eltio_k2">
                                                <a href="{{ route('user.forgot') }}" class="theme-cl">@lang('Lost Your Password')?</a>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <button type="submit" class="btn btn-md full-width theme-bg text-light rounded ft-medium">
                                            @lang('Login') <div class="spinner-border formSpin" role="status"></div>
                                        </button>
                                    </div>

                                </div>
                            </form>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </section>
    <!-- ============================ Submit Property End ================================== -->
@endsection

@push('js')

@endpush
