@extends('layouts.agent')
@section('content')
    <div class="container-fluid">
        <h4 class="mb-4 mt-5">Active Listings</h4>
        <div class="card mb-4">
            <div class="table-responsive p-3">
                <table class="table table-hover dt-responsive table-smaller" cellspacing="0" width="100%">
                    <thead class="thead-light">
                        <tr>
                            <th>{{ __('Featured Image') }}</th>
                            <th>{{ __('Title') }}</th>
                            <th>{{ __('Category') }}</th>
                            <th>{{ __('Location') }}</th>
                            <th style="white-space: nowrap; min-width:80px;">{{ __('Create Date') }}</th>
                            <th style="white-space: nowrap; min-width:80px;">{{ __('Update Date') }}</th>
                            <th style="white-space: nowrap; min-width:80px;">{{ __('Active Date') }}</th>
                            <th style="white-space: nowrap; min-width:80px;">{{ __('Expire Date') }}</th>
                            <th>{{ __('Status') }}</th>
                            <th>{{ __('Type') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($expiredProperties as $property)
                            <tr>
                                <td>
                                    <img src="{{ $property->photo ? url('assets/images/' . $property->photo) : url('assets/images/noimage.png') }}"
                                        alt="Image" width="100px">
                                </td>
                                <td>{{ $property->name ?? 'Untitled Property' }}</td>
                                <td>{{ $property->category->title ?? '-' }}</td>
                                <td>{{ $property->location->name ?? '-' }}</td>
                                <td>{{ $property->created_at ? \Illuminate\Support\Carbon::parse($property->created_at)->format('d M, Y') : '-' }}
                                </td>
                                <td>{{ $property->updated_at ? \Illuminate\Support\Carbon::parse($property->updated_at)->format('d M, Y') : '-' }}
                                </td>
                                <td>{{ $property->active_date ? \Illuminate\Support\Carbon::parse($property->active_date)->format('d M, Y') : '-' }}
                                </td>
                                <td>{{ $property->expire_date ? \Illuminate\Support\Carbon::parse($property->expire_date)->format('d M, Y') : '-' }}
                                </td>
                                <td>
                                    <span class="badge bg-success text-white">
                                        {{ $property->is_primium ? 'Premium Listing' : 'Free' }}</span>
                                </td>
                                <td><span
                                        class="badge bg-info text-white">{{ $property->looking_for == 'for_rent' ? 'Rent' : 'Sale' }}</span>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="9" class="text-center text-muted">@lang('No expired properties found.')</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection
