@extends('layouts.agent')
@section('content')
    @include('includes.admin.form-success')
    <div class="container-fluid">
        <h4 class="mb-4 mt-5">In-Active Listings</h4>
        <div class="card mb-4">
            <div class="table-responsive p-3">
                <table id="geniustable" class="table table-hover dt-responsive table-smaller" cellspacing="0" width="100%">
                    <thead class="thead-light">
                        <tr>
                            <th>{{ __('Featured Image') }}</th>
                            <th>{{ __('Title') }}</th>
                            <th>{{ __('Category') }}</th>
                            <th>{{ __('Location') }}</th>
                            <th style="white-space: nowrap; min-width:80px;">{{ __('Create Date') }}</th>
                            <th style="white-space: nowrap; min-width:80px;">{{ __('Update Date') }}</th>

                            <th style="white-space: nowrap; min-width:80px;">{{ __('Active Date') }}</th>
                            <th style="white-space: nowrap; min-width:80px;">{{ __('Expire Date') }}</th>
                            <th>{{ __('Type') }}</th>
                            <th>
                                @php
                                    $firstProperty = $expiredProperties->first();
                                @endphp
                                {{ isset($firstProperty) && $firstProperty->status == 1 ? 'Options' : 'Status' }}
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($expiredProperties as $property)
                            <tr>
                                <td>
                                    <img src="{{ $property->photo ? url('assets/images/' . $property->photo) : url('assets/images/noimage.png') }}"
                                        alt="Image" width="100px">
                                </td>
                                <td>{{ $property->name ?? 'Untitled Property' }}</td>
                                <td>{{ $property->category->title ?? '-' }}</td>
                                <td>{{ $property->location->name ?? '-' }}</td>
                                <td>{{ $property->created_at ? \Illuminate\Support\Carbon::parse($property->created_at)->format('d M, Y') : '-' }}
                                </td>
                                <td>{{ $property->updated_at ? \Illuminate\Support\Carbon::parse($property->updated_at)->format('d M, Y') : '-' }}
                                </td>
                                <td>{{ $property->active_date ? \Illuminate\Support\Carbon::parse($property->active_date)->format('d M, Y') : '-' }}
                                </td>
                                <td>{{ $property->expire_date ? \Illuminate\Support\Carbon::parse($property->expire_date)->format('d M, Y') : '-' }}
                                </td>
                                <td><span
                                        class="badge bg-info text-white">{{ $property->looking_for == 'for_rent' ? 'Rent' : 'Sale' }}</span>
                                </td>
                                <td>
                                    @if ($property->status == 1)
                                        <button type="button" class="btn btn-warning mt-2 make-premium-btn"
                                            style="font-size:11px;" data-id="{{ $property->id }}" data-toggle="modal"
                                            data-target="#makePremiumModal">Make Primium</button>
                                    @else
                                        {{ $property->status == 0 ? 'Pending' : ($property->status == 2 ? 'Reject' : 'Re-Approval') }}
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <!-- Make Premium Modal -->
    <div class="modal fade" id="makePremiumModal" tabindex="-1" role="dialog" aria-labelledby="makePremiumModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content border-0 shadow-lg">
                <div class="modal-header bg-warning text-white">
                    <h5 class="modal-title font-weight-bold" id="makePremiumModalLabel">
                        <i class="fas fa-star mr-2"></i> {{ __('Make Listing Premium') }}
                    </h5>
                    <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>

                <div class="modal-body text-center">
                    <div id="premium-credit-info">
                        <div class="mb-3">
                            <h6 class="text-dark">
                                <strong>{{ __('Available Credits:') }}</strong>
                                <span class="badge badge-pill badge-primary ml-2" id="availableCredit">
                                    {{ $availableCredit ?? '--' }}
                                </span>
                            </h6>
                        </div>

                        <div class="mb-4 text-muted" id="premiumMessage">
                            <i class="fas fa-info-circle text-warning mr-1"></i>
                            {{ __('Use 1 available credit to make this listing premium and activate this post.') }}
                        </div>

                        <input type="hidden" id="premiumPropertyId" value="">
                    </div>
                </div>

                <div class="modal-footer justify-content-center">
                    <button type="button" class="btn btn-outline-secondary" data-dismiss="modal">
                        {{ __('Cancel') }}
                    </button>
                    <button type="button" class="btn btn-warning font-weight-bold" id="confirmMakePremium">
                        <i class="fas fa-bolt mr-1"></i> {{ __('Activate with Paid Listing') }}
                    </button>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('scripts')
    <script>
        $(document).on('click', '.make-premium-btn', function() {
            var propertyId = String($(this).data('id')).trim();
            console.log('Selected propertyId:', propertyId); // Debug log
            $('#premiumPropertyId').val(propertyId);
            $('#availableCredit').text('{{ $availableCredit ?? '--' }}');
            $('#makePremiumModal').modal('show');
        });

        // Confirm Make Premium
        $('#confirmMakePremium').on('click', function() {
            var propertyId = String($('#premiumPropertyId').val()).trim();
            console.log('Sending propertyId:', propertyId); // Debug log
            var btn = $(this);
            btn.prop('disabled', true).text('Processing...');
            $.ajax({
                url: "{{ route('agent.properties.makePremium') }}",
                method: 'POST',
                data: {
                    _token: '{{ csrf_token() }}',
                    property_id: propertyId
                },
                success: function(response) {
                    btn.prop('disabled', false).text('Use Credit & Activate');
                    $('#makePremiumModal').modal('hide');
                    if (response.success) {
                        toastr.success(response.message);
                        location.reload();
                    } else {
                        toastr.error(response.message || 'Failed to make premium.');
                    }
                },
                error: function() {
                    btn.prop('disabled', false).text('Use Credit & Activate');
                    toastr.error('Server error.');
                }
            });
        });
        $('#makePremiumModal').on('hidden.bs.modal', function() {
            $('body').removeClass('modal-open');
            $('.modal-backdrop').remove();
        });
    </script>
@endsection
