@extends('layouts.agent')
@section('content')
    <h4 class="mb-4">Your Active Package</h4>
    <div class="container d-flex justify-content-center flex-wrap gap-3">
        @if ($activePlan)
            <div class="w-100 my-3" style="max-width: 350px; min-height: 520px;">
                <div class="card shadow-lg border-0 pricing-card mx-auto h-100">
                    <div class="card-body text-center p-4 d-flex flex-column justify-content-between h-100">
                        <div>
                            {{-- Package Title & Subtitle --}}
                            <h5 class="card-title mb-2"
                                style="font-size: 1.4rem; font-weight: bold; color: {{ $activePlan->price_color ?? '#2980b9' }};">
                                {{ ucwords($activePlan->title) }}
                            </h5>
                            @if ($activePlan->subtitle)
                                <div class="mb-2 text-muted" style="font-size: 1rem;">
                                    {{ $activePlan->subtitle }}
                                </div>
                            @endif

                            {{-- Divider --}}
                            <hr
                                style="border: 0; height: 2px; background: linear-gradient(90deg, {{ $activePlan->price_color ?? '#2980b9' }}, #fff 80%); margin: 0 0 1.2rem 0;">

                            {{-- Price & Duration --}}
                            <div class="display-4 mb-2"
                                style="font-weight: bold; color: {{ $activePlan->price_color ?? '#2980b9' }};">
                                ₹{{ number_format($activePlan->price, 0) }}
                            </div>
                            <div class="mb-3 text-muted" style="font-size: 1rem;">
                                for {{ str_replace('-', ' ', $activePlan->plan_type) ?? '' }} days
                            </div>

                            {{-- Features List --}}
                            <ul class="list-unstyled mb-4 text-left small">
                                <li class="mb-2"><span class="text-success">&#10003;</span> <strong>Post Credit
                                        Limit:</strong>
                                    {{ $activePlan->post_limit }}</li>
                                <li class="mb-2"><span class="text-success">&#10003;</span> <strong>Ad Validity:</strong>
                                    {{ $activePlan->post_duration }} days</li>
                                <li class="mb-2"><span class="text-success">&#10003;</span> <strong>Deal Type:</strong>
                                    {{ ucfirst(str_replace('_', ' ', $activePlan->sale_type)) }}</li>
                                <li class="mb-2"><span class="text-success">&#10003;</span> <strong>Property
                                        Category:</strong>
                                    {{ ucfirst($activePlan->property_type) }}</li>
                                <li class="mb-2">
                                    <span class="text-success">&#10003;</span> <strong>Highlights:</strong>
                                    <ul class="pl-3 mt-1">
                                        @foreach (json_decode($activePlan->attribute, true) ?? [] as $attr)
                                            <li style="list-style-type: disc;">{{ $attr }}</li>
                                        @endforeach
                                    </ul>
                                </li>
                            </ul>

                            {{-- Credit Summary --}}
                            @php
                                $endDateRaw = auth()->user()->plan_end_date;
                                $endDate = $endDateRaw ? \Carbon\Carbon::parse($endDateRaw)->format('Y-m-d') : 'N/A';

                                $startDate =
                                    $endDateRaw && isset($activePlan->post_duration)
                                        ? \Carbon\Carbon::parse($endDateRaw)
                                            ->subDays($activePlan->plan_type)
                                            ->format('Y-m-d')
                                        : 'N/A';

                                $daysLeft = $endDateRaw
                                    ? \Carbon\Carbon::now()->diffInDays(\Carbon\Carbon::parse($endDateRaw), false)
                                    : null;
                            @endphp

                            <div class="border-top pt-3 mt-3 text-left">
                                <div class="row">
                                    <div class="col-12 mb-2">
                                        <h6 class="font-weight-bold text-muted">Credit Summary</h6>
                                    </div>

                                    <div class="col-6 text-center">
                                        <div class="font-weight-bold text-primary" style="font-size: 1.4rem;">
                                            {{ $totalCredit ?? 0 }}
                                        </div>
                                        <small class="text-muted">Total Credits</small>
                                    </div>

                                    <div class="col-6 text-center">
                                        <div class="font-weight-bold text-success text-center" style="font-size: 1.4rem;">
                                            {{ $availableCredit ?? 0 }}
                                        </div>
                                        <small class="text-muted">Available Credits</small>
                                    </div>

                                    <div class="col-6 text-center">
                                        <div class="font-weight-bold text-primary">
                                            {{ $startDate }}
                                        </div>
                                        <small class="text-muted">Package Active Date</small>
                                    </div>

                                    <div class="col-6 text-center">
                                        <div class="font-weight-bold text-success text-center">
                                            {{ $endDate }}
                                        </div>
                                        <small class="text-muted">Package Expire Date</small>
                                    </div>

                                    <div class="col-12 text-center mt-2">
                                        <div
                                            class="font-weight-bold {{ $daysLeft !== null && $daysLeft <= 5 ? 'text-danger' : 'text-warning' }}">
                                            @if ($daysLeft !== null)
                                                @if ($daysLeft > 0)
                                                    Expires in {{ $daysLeft }} day{{ $daysLeft > 1 ? 's' : '' }}
                                                @elseif ($daysLeft === 0)
                                                    Expires Today
                                                @else
                                                    Expired {{ abs($daysLeft) }} day{{ abs($daysLeft) > 1 ? 's' : '' }}
                                                    ago
                                                @endif
                                            @else
                                                N/A
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>

                        {{-- Button --}}
                        <div class="btn mt-auto"
                            style="background: {{ $activePlan->price_color ?? '#2980b9' }}; color: #fff; border-radius: 2rem; font-weight: 600; padding: 0.7rem 2rem;">
                            Current Plan
                        </div>
                    </div>
                </div>
            </div>
        @else
            <div class="text-center text-muted">
                <p>@lang('No active plan')</p>
            </div>
        @endif
    </div>

    <style>
        .pricing-card {
            border-radius: 2rem;
            background: #fff;
            transition: box-shadow 0.3s;
        }

        .pricing-card:hover {
            box-shadow: 0 8px 32px rgba(60, 72, 88, 0.15);
        }

        .display-4 {
            font-size: 2.3rem;
        }

        @media (min-width: 768px) {
            .container.d-flex.flex-wrap.gap-3>div {
                margin-right: 1.5rem;
            }
        }
    </style>
@endsection
