@extends('layouts.agent')
@section('content')
    <div class="container-fluid">
        <h4 class="mb-4 text-center">All Packages for {{ ucwords(auth()->user()->user_type) }}</h4>
        <div class="row justify-content-center">
            @forelse($packages as $package)
                <div class="col-md-6 col-lg-4 mb-4 d-flex align-items-stretch">
                    <div class="card shadow-lg border-0 pricing-card w-100" style="border-radius:2rem;">
                        <div class="card-body text-center p-4">
                            <h5 class="card-title mb-2"
                                style="font-size: 1.3rem; font-weight: bold; color: {{ $package->price_color ?? '#2980b9' }};">
                                {{ ucwords($package->title) }}
                            </h5>
                            @if ($package->subtitle)
                                <div class="mb-2 text-muted" style="font-size: 1rem;">{{ $package->subtitle }}</div>
                            @endif

                            <hr
                                style="border: 0; height: 2px; background: linear-gradient(90deg, {{ $package->price_color ?? '#2980b9' }}, #fff 80%); margin-bottom: 1.2rem;">

                            <div class="display-4 mb-2"
                                style="font-weight: bold; color: {{ $package->price_color ?? '#2980b9' }};">
                                ₹{{ number_format($package->price, 0) }}
                            </div>
                            <div class="mb-3 text-muted" style="font-size: 1rem;">
                                per {{ str_replace('-', ' ', $package->plan_type) ?? '' }} days
                            </div>

                            <ul class="list-unstyled mb-4 text-left small">
                                <li class="mb-2"><span class="text-success">&#10003;</span> <strong>Post Limit :</strong>
                                    {{ $package->post_limit }}</li>
                                <li class="mb-2"><span class="text-success">&#10003;</span> <strong>Ad Duration :</strong>
                                    {{ $package->post_duration }}</li>
                                <li class="mb-2"><span class="text-success">&#10003;</span> <strong>Deal Type :</strong>
                                    {{ ucwords(str_replace('_', ' ', $package->sale_type)) }}</li>
                                <li class="mb-2"><span class="text-success">&#10003;</span> <strong>Property
                                        Category :</strong> {{ ucwords($package->property_type ?? '-') }}</li>

                                <li class="mb-2">
                                    <span class="text-success">&#10003;</span> <strong>Highlights:</strong>
                                    @php
                                        $attrs = json_decode($package->attribute, true);
                                    @endphp
                                    @if (is_array($attrs))
                                        <ul class="pl-3 mt-1">
                                            @foreach ($attrs as $attr)
                                                <li style="list-style-type: disc;">{{ $attr }}</li>
                                            @endforeach
                                        </ul>
                                    @else
                                        <span>{{ $package->attribute ?? '-' }}</span>
                                    @endif
                                </li>
                            </ul>
                            <a class="btn" href="{{ route('user.package.subscription', $package->id) }}"
                                style="background: {{ $package->price_color ?? '#2980b9' }}; color: #fff; border-radius: 2rem; font-weight: 600; padding: 0.7rem 2rem;">
                                {{ $package->status == 1 ? 'Buy' : 'Get This Plan' }}
                            </a>
                        </div>
                    </div>
                </div>
            @empty
                <div class="col-12 text-center text-muted">
                    <p>@lang('No packages found.')</p>
                </div>
            @endforelse
        </div>
    </div>

    <style>
        .pricing-card {
            border-radius: 2rem;
            background: #fff;
            transition: box-shadow 0.3s;
        }

        .pricing-card:hover {
            box-shadow: 0 8px 32px rgba(60, 72, 88, 0.15);
        }

        .display-4 {
            font-size: 2.3rem;
        }
    </style>
@endsection
