@extends('layouts.agent')
@section('content')
    <div class="container-fluid">
        <h4 class="mb-4 mt-5">Expired Packages</h4>
        <div class="card mb-4">
            <div class="table-responsive p-3">
                <table class="table table-hover dt-responsive table-smaller" cellspacing="0" width="100%">
                    <thead class="thead-light">
                        <tr>
                            <th>{{ __('S. No') }}</th>
                            <th>{{ __('Package Title') }}</th>
                            <th style="white-space: nowrap; min-width:80px;">{{ __('Activation Date') }}</th>
                            <th style="white-space: nowrap; min-width:80px;">{{ __('Expired Date') }}</th>
                            <th>{{ __('Status') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($expiredPackages as $index => $package)
                            <tr>
                                <td>{{ $index + 1 }}</td>
                                <td>{{ $package->plan->title ?? '-' }}</td>
                                <td>
                                    {{ $package->activated_at ?? '-' }}
                                </td>
                                <td>
                                    {{ $package->expired_at ?? '-' }}
                                </td>
                                <td>
                                    {!! $package->status
                                        ? '<span class="badge bg-success text-white">Active</span>'
                                        : '<span class="badge bg-danger text-white">Expired</span>' !!}
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="text-center text-muted">
                                    {{ __('No expired packages found.') }}
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection
