@extends('layouts.agent')
@push('css')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/css/intlTelInput.css" />
    <style>
        .iti {
            width: 100%;
        }

        .iti__country-list {
            position: absolute;
            z-index: 2;
            width: 273px;
        }

        .iti__dropdown {
            width: 100% !important;
            box-shadow: 0px 4px 8px rgba(0, 0, 0, 0.1);
            z-index: 1050;
        }
    </style>
@endpush
@section('content')
    <div class="card">
        <div class="d-sm-flex align-items-center justify-content-between py-3">
            <h5 class=" mb-0 text-gray-800 pl-3">{{ __('Edit Profile') }}</h5>
            <ol class="breadcrumb m-0 py-0">
                <li class="breadcrumb-item"><a href="{{ route('agent.dashboard') }}">{{ __('Dashboard') }}</a></li>
            </ol>
        </div>
    </div>
    @if (session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif
    <div class="card mb-4">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 font-weight-bold text-primary">{{ __('Edit Profile Form') }}</h6>
        </div>

        <div class="card-body">
            <div class="gocover"
                style="background: url({{ asset('assets/images/' . $gs->admin_loader) }}) no-repeat scroll center center rgba(45, 45, 45, 0.5);">
            </div>
            <form class="" action="{{ route('agent.profile.update') }}" method="POST" enctype="multipart/form-data">
                @include('includes.admin.form-both')

                {{ csrf_field() }}

                <div class="form-group">
                    <label>{{ __('Profile Picture') }} <small
                            class="small-font">({{ __('Preferred Size 600 X 600') }})</small></label>
                    <div class="wrapper-image-preview">
                        <div class="box">
                            <div class="back-preview-image"
                                style="background-image: url({{ $data->photo ? asset('assets/images/' . $data->photo) : asset('assets/images/placeholder.jpg') }});">
                            </div>
                            <div class="upload-options">
                                <label class="img-upload-label" for="img-upload"> <i class="fas fa-camera"></i>
                                    {{ __('Upload Picture') }} </label>
                                <input id="img-upload" type="file" class="image-upload" name="photo" accept="image/*">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <label for="inp-name">{{ __('Type Of Account') }}</label>
                    <div class="form-control">{{ ucwords($data->user_type) }}
                    </div>
                </div>

                <div class="form-group">
                    <label for="inp-name">{{ __('Country') }}</label>
                    <div class="form-control">
                        {{ $data->country ? $data->country->name : 'India' }}
                    </div>
                </div>

                <div class="form-group">
                    <label for="inp-name">{{ __('State') }}</label>
                    <select class="form-control" id="inp-state" name="state_id" required>
                        <option value="">{{ __('Select State') }}</option>
                        @foreach ($states as $state)
                            <option value="{{ $state->id }}" {{ $data->state_id == $state->id ? 'selected' : '' }}>
                                {{ $state->name }}</option>
                        @endforeach
                    </select>
                </div>

                {{-- for cities --}}
                <div class="form-group">
                    <label for="inp-name">{{ __('City') }}</label>
                    <input type="text" class="form-control" id="inp-name" name="city"
                        placeholder="{{ __('Enter City Name') }}" value="{{ $data->city }}" required>
                </div>

                <div class="form-group">
                    <label for="inp-name">{{ __('Name') }}</label>
                    <input type="text" class="form-control" id="inp-name" name="name"
                        placeholder="{{ __('Enter Name') }}" value="{{ $data->name }}" required>
                </div>

                <div class="form-group">
                    <label for="inp-eml">{{ __('Email Address') }}</label>
                    <input type="email" class="form-control" id="inp-eml" name="email"
                        placeholder="{{ __('Enter Email Address') }}" value="{{ $data->email }}" readonly>
                </div>

                <div class="form-group">
                    <label>@lang('Phone')</label>
                    <input class="form-control" type="tel" name="phone" id="phone" value="+91-{{ $data->phone }}">
                </div>
                <button type="submit" id="submit-btn" class="btn btn-primary w-100">{{ __('Submit') }}</button>
            </form>
        </div>
    </div>
@endsection
@push('js')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/intlTelInput.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const phoneInput = document.getElementById('phone');
            if (phoneInput) {
                try {
                    const iti = intlTelInput(phoneInput, {
                        initialCountry: "in",
                        separateDialCode: true,
                        preferredCountries: ["in", "us", "gb"],
                        utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/utils.js",
                    });
                } catch (error) {
                    console.error('Error initializing intlTelInput:', error);
                }
            }
        });
    </script>
@endpush