@extends('layouts.agent')
@push('css')
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
@endpush
@section('content')
    <div class="card">
    <div class="d-flex justify-content-center">
        @php
            $steps = [
                1 => 'Basic Details',
                2 => 'Property Details',
                3 => 'Location Details',
                4 => 'Photos & Videos',
            ];
            $activeStep = 2; 
        @endphp
        <div class="steps-container my-1">
            @foreach ($steps as $step => $label)
                <div class="step-item">
                    <a href="#" class="step-circle {{ $step == $activeStep ? 'active' : '' }}">
                        {{ $step }}
                    </a>
                    <span class="step-label">{{ $label }}</span>
                    @if ($step < count($steps))
                        <div class="step-line"></div>
                    @endif
                </div>
            @endforeach
        </div>
    </div>
</div>

    <div class="row justify-content-center mt-3">
        <div class="col-md-10 mx-5">
            <form method="POST"
                action="{{ isset($property->id) ? route('agent.properties.additional.info', ['id' => $property->id]) : route('agent.properties.additional.info') }}">
                @csrf
                <div class="row">
                    <div class="col-md-12">
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul class="mb-0">
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        <div class="card room-card mb-3">
                            <div class="card-body">
                                <div class="mb-3">
                                  <h5 class="mb-3 fw-bold pt-2">Additional Details</h5>
                                    <div class="mb-3">
                                        <label class="form-label">One Time Move in Charges (Optional) </label>
                                        <input type="number" class="form-control" name="move_charges" value="{{ old('name', $property->move_charges ?? '') }}" >
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label">Meal Charges Per Month (Optional) </label>
                                        <input type="number" class="form-control" name="meal_charges" value="{{ old('name', $property->meal_charges ?? '') }}" >
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label">Electricity Charges Per Month (Optional) </label>
                                        <input type="number" class="form-control" name="electricity_charges" value="{{ old('name', $property->electricity_charges ?? '') }}" >
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label">Add Additional Information (Optional) </label>
                                        <input type="text" class="form-control" name="additional_info" value="{{ old('name', $property->additional_info ?? '') }}" >
                                    </div>
                                </div>
                            </div>
                            <div class="d-flex justify-content-center my-3">
                            <a href="{{ url('/seller/properties/rooms-amenities', $property->id ?? null) }}" id="back-btn"
                                    class="btn btn-secondary w-25">{{ __('Back') }}</a>
                                <button type="submit" id="submit-btn"
                                    class="btn btn-primary w-25 mx-2">{{ __('Save & Next') }}</button>
                            </div>
                        </div>
                    </div>
            </form>
        </div>
    </div>
@endsection

