@extends('layouts.agent')
@section('content')
    <div class="card">
        <div class="d-sm-flex align-items-center justify-content-between">
            <h5 class=" mb-0 text-gray-800 pl-3">{{ __('Property') }}</h5>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('agent.dashboard') }}">{{ __('Dashboard') }}</a></li>
                <li class="breadcrumb-item"><a href="javascript:;">{{ __('Property') }}</a></li>
            </ol>
        </div>
    </div>

    <div class="row mt-3">
        <div class="col-lg-12">
            @include('includes.admin.form-success')

            <div class="card mb-4">
                <div class="table-responsive p-3">
                    <table id="geniustable" class="table table-hover dt-responsive" cellspacing="0" width="100%">
                        <thead class="thead-light">
                            <tr>
                                <th>{{ __('Featured Image') }}</th>
                                <th>{{ __('Title') }}</th>
                                <th>{{ __('Category') }}</th>
                                <th>{{ __('Location') }}</th>
                                <th>{{ __('Create Date') }}</th>
                                <th>{{ __('Update Date') }}</th>
                                <th>{{ __('Status') }}</th>
                                <th>{{ __('Type') }}</th>
                                <th>{{ __('Options') }}</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </div>
    @includeIf('partials.admin.status')
    @includeIf('partials.admin.delete')
    <!-- Make Premium Modal -->
    <div class="modal fade" id="makePremiumModal" tabindex="-1" role="dialog" aria-labelledby="makePremiumModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content border-0 shadow-lg">
                <div class="modal-header bg-warning text-white">
                    <h5 class="modal-title font-weight-bold" id="makePremiumModalLabel">
                        <i class="fas fa-star mr-2"></i> {{ __('Make Listing Premium') }}
                    </h5>
                    <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>

                <div class="modal-body text-center">
                    <div id="premium-credit-info">
                        <div class="mb-3">
                            <h6 class="text-dark">
                                <strong>{{ __('Available Credits:') }}</strong>
                                <span class="badge badge-pill badge-primary ml-2" id="availableCredit">
                                    {{ $availableCredit ?? '--' }}
                                </span>
                            </h6>
                        </div>

                        <div class="mb-4 text-muted" id="premiumMessage">
                            <i class="fas fa-info-circle text-warning mr-1"></i>
                            {{ __('Use 1 available credit to make this listing premium and activate this post.') }}
                        </div>

                        <input type="hidden" id="premiumPropertyId" value="">
                    </div>
                </div>

                <div class="modal-footer justify-content-center">
                    <button type="button" class="btn btn-outline-secondary" data-dismiss="modal">
                        {{ __('Cancel') }}
                    </button>
                    <button type="button" class="btn btn-warning font-weight-bold" id="confirmMakePremium">
                        <i class="fas fa-bolt mr-1"></i> {{ __('Activate with Paid Listing') }}
                    </button>
                </div>
            </div>
        </div>
    </div>
@endsection



@section('scripts')
    <script type="text/javascript">
        "use strict";

        var table = $('#geniustable').DataTable({
            ordering: false,
            processing: true,
            serverSide: true,
            searching: true,
            ajax: '{{ route('agent.properties.datatables', ['status' => 1]) }}',
            columns: [

                {
                    data: 'photo',
                    name: 'photo',
                    searchable: false,
                    orderable: false
                },
                {
                    data: 'name',
                    name: 'name'
                },
                {
                    data: 'category_id',
                    name: 'category_id'
                },
                {
                    data: 'location_id',
                    name: 'location_id'
                },
                {
                    data: 'created_at',
                    name: 'created_at'
                },
                {
                    data: 'updated_at',
                    name: 'updated_at'
                },
                {
                    data: 'status',
                    name: 'status'
                },
                {
                    data: 'type',
                    name: 'type'
                },
                {
                    data: 'action',
                    searchable: false,
                    orderable: false
                }

            ],
            language: {
                processing: '<img src="{{ asset('assets/images/' . $gs->admin_loader) }}">'
            }
        });

        $(function() {
            $(".btn-area").append('<div class="col-sm-12 col-md-4 pr-3 text-right">' +
                '<a class="btn btn-primary" href="{{ route('agent.properties.step_1') }}">' +
                '<i class="fas fa-plus"></i> {{ __('Add New') }}' +
                '</a>' +
                '</div>');
        });
        // Make Premium button click
        $(document).on('click', '.make-premium-btn', function() {
            var propertyId = $(this).data('id');
            $('#premiumPropertyId').val(propertyId);
            // Show the credit scores from the page (already rendered by blade)
            $('#totalCredit').text('{{ $totalCredit ?? '--' }}');
            $('#availableCredit').text('{{ $availableCredit ?? '--' }}');
            $('#makePremiumModal').modal('show');
        });

        // Confirm Make Premium
        $('#confirmMakePremium').on('click', function() {
            var propertyId = $('#premiumPropertyId').val();
            var btn = $(this);
            btn.prop('disabled', true).text('Processing...');
            $.ajax({
                url: "{{ route('agent.properties.makePremium') }}",
                method: 'POST',
                data: {
                    _token: '{{ csrf_token() }}',
                    property_id: propertyId
                },
                success: function(response) {
                    btn.prop('disabled', false).text('Use Credit & Activate');
                    $('#makePremiumModal').modal('hide');
                    table.ajax.reload();
                    if (response.success) {
                        toastr.success(response.message);
                    } else {
                        toastr.error(response.message || 'Failed to make premium.');
                    }
                },
                error: function() {
                    btn.prop('disabled', false).text('Use Credit & Activate');
                    toastr.error('Server error.');
                }
            });
        });
        $('#makePremiumModal').on('hidden.bs.modal', function() {
            $('body').removeClass('modal-open');
            $('.modal-backdrop').remove();
        });
    </script>
@endsection
