@extends('layouts.agent')
@push('css')
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
    /* You can remove previous width CSS if you want only Bootstrap classes to control width */
</style>
@endpush
@section('content')
<div class="card">
    <div class="d-flex justify-content-center">
        @php
        $steps = [
        1 => 'Basic Details',
        2 => 'Property Details',
        3 => 'Location Details',
        4 => 'Photos & Videos',
        ];
        $currentStep = request()->route()->getName();
        preg_match('/step_(\d+)/', $currentStep, $matches);
        $activeStep = isset($matches[1]) ? (int) $matches[1] : 1;
        @endphp
        <div class="steps-container my-1">
            @foreach ($steps as $step => $label)
            <div class="step-item">
                <a href="#" class="step-circle {{ $step == $activeStep ? 'active' : '' }}">
                    {{ $step }}
                </a>
                <span class="step-label">{{ $label }}</span>
                @if ($step < count($steps))
                    <div class="step-line">
            </div>
            @endif
        </div>
        @endforeach
    </div>
</div>
</div>

<div class="row justify-content-center mt-3">
    <div class="col-md-12">
        @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
        @endif
        <form method="POST"
            action="{{ isset($property->id) ? route('agent.properties.builder_project', ['id' => $property->id]) : route('agent.properties.builder_project') }}"
            id="builder-plan-form">
            @csrf
            <div class="row">

                <div class="col-md-12">
                    <div class="card my-3">
                        <div class="card-body">
                            <div class="form-group mb-3">
                                <label for="name">Property Name</label>
                                <div class="d-flex align-items-center gap-0">
                                    <input type="text" name="name" id="name"
                                        class="form-control w-50 @error('name') is-invalid @enderror"
                                        value="{{ old('name', $property->name ?? '') }}" placeholder="Property Name">
                                </div>
                                @error('name')
                                <div class="text-danger">{{ $message }}</div>
                                @enderror

                            </div>
                        </div>
                    </div>
                    <x-radio-group name="sale_type" label="Sale Type" :options="['new-booking' => 'New Booking', 'resale' => 'Resale']" :selected="old('sale_type', $property->sale_type ?? null)" />

                    <x-construction-status label="Construction Status" :constructionStatus="old('construction_status', $property->construction_status ?? '')" :possessionDate="old('possession_date', $property->possession_date ?? null)"
                        :propertyAge="old('property_age', $property->property_age ?? null)" :property="$property" possessionDateLabel="Available from" />

                    <div class="card p-4 mt-3">
                        <label class="form-label fw-bold">No. of BHK</label><br>
                        @php
                        $bhkOptions = [
                        '1-RK',
                        '1-BHK',
                        '1.5-BHK',
                        '2-BHK',
                        '2.5-BHK',
                        '3-BHK',
                        '3.5-BHK',
                        '4-BHK',
                        '4.5-BHK',
                        '5-BHK',
                        '6-BHK',
                        '6+ BHK'
                        ];

                        // For edit mode, get only those BHKs which exist in floorPlans
                        $isEdit = isset($property) && isset($property->id);
                        $selectedBhk = old('bhk_names');
                        if ($isEdit && empty($selectedBhk)) {
                        $selectedBhk = $property->floorPlans->pluck('name')->toArray();
                        }

                        // Flats data: only for selected BHKs
                        $flatsData = old('flats');
                        if ($isEdit && empty($flatsData)) {
                        $flatsData = $property->floorPlans
                        ->keyBy('name')
                        ->map(function ($item) {
                        return $item->toArray();
                        })
                        ->toArray();
                        }
                        @endphp
                        <div id="bhk-checkboxes" class="d-flex flex-wrap gap-3">
                            @foreach ($bhkOptions as $bhk)
                            @php
                            $safeBhk = str_replace(['.', '+', ' '], ['dot', 'plus', '_'], $bhk);
                            $isChecked = in_array($bhk, $selectedBhk ?? []);
                            @endphp
                            <div class="checkbox-button">
                                <input class="bhk-type-checkbox" type="checkbox" name="bhk_names[]"
                                    value="{{ $bhk }}" id="bhk-{{ $loop->index }}"
                                    {{ $isChecked ? 'checked' : '' }}>
                                <label for="bhk-{{ $loop->index }}">{{ $bhk }}</label>
                            </div>
                            @endforeach
                        </div>
                        @error('bhk_names')
                        <div class="text-danger">{{ $message }}</div>
                        @enderror

                        <div id="bhk-input-sections" class="mt-4">
                            @foreach ($bhkOptions as $bhk)
                            @php
                            $safeBhk = str_replace(['.', '+', ' '], ['dot', 'plus', '_'], $bhk);
                            $flat = $flatsData[$bhk] ?? null;
                            $isChecked = in_array($bhk, $selectedBhk ?? []);
                            @endphp
                            <div class="bhk-block border p-3 mb-3" data-bhk="{{ $bhk }}"
                                id="bhk-block-{{ $safeBhk }}"
                                style="{{ $isChecked ? '' : 'display: none;' }}">
                                <div class="d-flex justify-content-between align-items-center">
                                    <h5>{{ $bhk }}</h5>
                                    <button type="button" class="btn btn-primary btn-sm delete-bhk-block"
                                        data-bhk="{{ $bhk }}">Delete</button>
                                </div>
                                <hr>
                                <!-- No. of Bathrooms -->

                                <div class="card my-3">
                                    <div class="card-body">
                                        <div class="form-group mb-3">
                                            <label>No. of Bathrooms</label>
                                            <div class="d-flex gap-2 flex-wrap">
                                                @foreach ([1, 2, 3, 4, 5] as $option)
                                                <div class="form-check">
                                                    <input class="form-check-input" type="radio"
                                                        name="flats[{{ $bhk }}][no_of_bathroom]"
                                                        id="bathroom-{{ $safeBhk }}-{{ $option }}"
                                                        value="{{ $option }}"
                                                        {{ old("flats.$bhk.no_of_bathroom", $flat['no_of_bathroom'] ?? '') == $option ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                        for="bathroom-{{ $safeBhk }}-{{ $option }}">
                                                        {{ $option }}
                                                    </label>
                                                </div>
                                                @endforeach
                                            </div>
                                            @error("flats.$bhk.no_of_bathroom")
                                            <div class="text-danger">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        <div class="form-group mb-3">
                                            <label>No. of Balcony</label>
                                            <div class="d-flex gap-2 flex-wrap">
                                                @foreach ([1, 2, 3, 4, 5, 6] as $option)
                                                <div class="form-check">
                                                    <input class="form-check-input" type="radio"
                                                        name="flats[{{ $bhk }}][no_of_balcony]"
                                                        id="balcony-{{ $safeBhk }}-{{ $option }}"
                                                        value="{{ $option }}"
                                                        {{ old("flats.$bhk.no_of_balcony", $flat['no_of_balcony'] ?? '') == $option ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                        for="balcony-{{ $safeBhk }}-{{ $option }}">
                                                        {{ $option }}
                                                    </label>
                                                </div>
                                                @endforeach
                                            </div>
                                            @error("flats.$bhk.no_of_balcony")
                                            <div class="text-danger">{{ $message }}</div>
                                            @enderror
                                        </div>

                                        <!-- Covered Parking -->
                                        <div class="form-group mb-3">
                                            <label>Covered Parking</label>
                                            <div class="d-flex gap-2 flex-wrap">
                                                @foreach ([1, 2, 3, '3+'] as $option)
                                                <div class="form-check">
                                                    <input class="form-check-input" type="radio"
                                                        name="flats[{{ $bhk }}][covered_parking]"
                                                        id="covered-{{ $safeBhk }}-{{ $option }}"
                                                        value="{{ $option }}"
                                                        {{ old("flats.$bhk.covered_parking", $flat['covered_parking'] ?? '') == $option ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                        for="covered-{{ $safeBhk }}-{{ $option }}">
                                                        {{ $option }}
                                                    </label>
                                                </div>
                                                @endforeach
                                            </div>
                                            @error("flats.$bhk.covered_parking")
                                            <div class="text-danger">{{ $message }}</div>
                                            @enderror
                                        </div>

                                        <!-- Open Parking -->
                                        <div class="form-group mb-3">
                                            <label>Open Parking</label>
                                            <div class="d-flex gap-2 flex-wrap">
                                                @foreach ([1, 2, 3, '3+'] as $option)
                                                <div class="form-check">
                                                    <input class="form-check-input" type="radio"
                                                        name="flats[{{ $bhk }}][open_parking]"
                                                        id="open-{{ $safeBhk }}-{{ $option }}"
                                                        value="{{ $option }}"
                                                        {{ old("flats.$bhk.open_parking", $flat['open_parking'] ?? '') == $option ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                        for="open-{{ $safeBhk }}-{{ $option }}">
                                                        {{ $option }}
                                                    </label>
                                                </div>
                                                @endforeach
                                            </div>
                                            @error("flats.$bhk.open_parking")
                                            <div class="text-danger">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                                <!-- Furnish Type -->
                                <div class="card my-3">
                                    <div class="card-body">
                                        <div class="form-group mb-3">
                                            <label>Furnish Type</label>
                                            <div class="d-flex gap-2 flex-wrap">
                                                @foreach ([
                                                'fully-furnished' => 'Fully Furnished',
                                                'semi-furnished' => 'Semi Furnished',
                                                'unfurnished' => 'Unfurnished',
                                                ] as $value => $label)
                                                <div class="form-check">
                                                    <input class="form-check-input" type="radio"
                                                        name="flats[{{ $bhk }}][furnish_type]"
                                                        id="furnish-{{ $safeBhk }}-{{ $value }}"
                                                        value="{{ $value }}"
                                                        {{ old("flats.$bhk.furnish_type", $flat['furnish_type'] ?? '') == $value ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                        for="furnish-{{ $safeBhk }}-{{ $value }}">
                                                        {{ $label }}
                                                    </label>
                                                </div>
                                                @endforeach
                                            </div>
                                            @error("flats.$bhk.furnish_type")
                                            <div class="text-danger">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                                <!-- Built Up Area -->
                                <div class="card my-3">
                                    <div class="card-body">
                                        <div class="form-group mb-3">
                                            <label>Built Up Area</label>
                                            <div class="d-flex align-items-center gap-0">
                                                <input type="number"
                                                    name="flats[{{ $bhk }}][built_up_area]"
                                                    class="form-control w-25 @error(" flats.$bhk.built_up_area") is-invalid @enderror"
                                                    value="{{ old("flats.$bhk.built_up_area", $flat['built_up_area'] ?? '') }}"
                                                    placeholder="Enter area">
                                                <select name="flats[{{ $bhk }}][area_unit]"
                                                    class="form-control w-25 area-unit-select"
                                                    data-bhk="{{ $safeBhk }}"
                                                    id="area-unit-{{ $safeBhk }}">
                                                    <option>Select Unit</option>
                                                    <option value="sqm"
                                                        {{ old('flats.' . $bhk . '.area_unit', $flat['area_unit'] ?? '') == 'sqm' ? 'selected' : '' }}>
                                                        Sq. Mtr.</option>
                                                    <option value="sqft"
                                                        {{ old('flats.' . $bhk . '.area_unit', $flat['area_unit'] ?? 'sqft') == 'sqft' ? 'selected' : '' }}>
                                                        Sq. Ft.</option>
                                                </select>
                                            </div>
                                            @error("flats.$bhk.built_up_area")
                                            <div class="text-danger">{{ $message }}</div>
                                            @enderror
                                            @error("flats.$bhk.area_unit")
                                            <div class="text-danger">{{ $message }}</div>
                                            @enderror
                                        </div>

                                        <!-- Carpet Area -->
                                        <div class="form-group mb-3">
                                            <label id="carpet-label-{{ $safeBhk }}">Carpet Area </label>
                                            <div class="d-flex align-items-center gap-0">
                                                <input type="number"
                                                    name="flats[{{ $bhk }}][carpet_area]"
                                                    class="form-control w-50 @error(" flats.$bhk.carpet_area") is-invalid @enderror"
                                                    value="{{ old("flats.$bhk.carpet_area", $flat['carpet_area'] ?? '') }}"
                                                    placeholder="Enter area">
                                            </div>
                                            @error("flats.$bhk.carpet_area")
                                            <div class="text-danger">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                                <!-- Floor Selector -->
                                <div class="card my-3">
                                    <div class="card-body">
                                        @php
                                        $totalFloors = old("flats.$bhk.total_floors", $flat['total_floors'] ?? '');
                                        $propertyOnFloor = old("flats.$bhk.property_on_floor", $flat['property_on_floor'] ?? '');
                                        @endphp

                                        <!-- Total Floors -->
                                        <div class="form-group mb-3">
                                            <label>Total Floors</label>
                                            <div class="d-flex align-items-center gap-0">
                                                <input type="number"
                                                    name="flats[{{ $bhk }}][total_floors]"
                                                    class="form-control w-50 @error(" flats.$bhk.total_floors") is-invalid @enderror"
                                                    value="{{ $totalFloors }}"
                                                    id="total_floors_{{ $bhk }}">
                                            </div>
                                            @error("flats.$bhk.total_floors")
                                            <div class="text-danger">{{ $message }}</div>
                                            @enderror
                                        </div>

                                        <!-- Property on Floor -->
                                        <div class="form-group mb-3">
                                            <label>Property On Floor</label>
                                            <div class="d-flex align-items-center gap-0">
                                                <select
                                                    name="flats[{{ $bhk }}][property_on_floor]"
                                                    class="form-control w-50 @error(" flats.$bhk.property_on_floor") is-invalid @enderror"
                                                    id="property_floor_{{ $bhk }}"
                                                    data-selected="{{ old("flats.$bhk.property_on_floor", $flat['property_on_floor'] ?? '') }}">
                                                    <!-- JS will populate options -->
                                                </select>
                                            </div>
                                            @error("flats.$bhk.property_on_floor")
                                            <div class="text-danger">{{ $message }}</div>
                                            @enderror
                                        </div>

                                    </div>
                                </div>

                                <!-- Price Per Sqft -->
                                <div class="card my-3">
                                    <div class="card-body">
                                        <div class="form-group mb-3">
                                            <label id="price-label-{{ $safeBhk }}">Price Per</label>
                                            <div class="d-flex align-items-center gap-0">
                                                <input type="number"
                                                    name="flats[{{ $bhk }}][price_per_sqft]"
                                                    class="form-control w-50 @error(" flats.$bhk.price_per_sqft") is-invalid @enderror"
                                                    value="{{ old("flats.$bhk.price_per_sqft", $flat['price_per_sqft'] ?? '') }}">
                                            </div>
                                            @error("flats.$bhk.price_per_sqft")
                                            <div class="text-danger">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        <!-- Expected Price -->
                                        <div class="form-group mb-3">
                                            <label>Property Expected Price (In Rs)</label>
                                            <div class="d-flex align-items-center gap-0">
                                                <input type="number"
                                                    name="flats[{{ $bhk }}][expected_price]"
                                                    class="form-control w-50 @error(" flats.$bhk.expected_price") is-invalid @enderror"
                                                    value="{{ old("flats.$bhk.expected_price", $flat['expected_price'] ?? '') }}">
                                            </div>
                                            @error("flats.$bhk.expected_price")
                                            <div class="text-danger">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @endforeach
                        </div>

                        <x-near-by-field label="Address Near By Facility ( 2 Facilities are mandatory )"
                            :facilities="$facilities ?? []" :facilityDistances="$facility_distances ?? []" />

                        <div class="card my-1">
                            <div class="card-body">
                                @if ($attributes)
                                @foreach ($attributes as $key => $attribute)
                                @if ($attribute->name === 'Amenities')
                                <div class="" id="attribute-{{ $key }}">
                                    <div
                                        class="d-flex flex-row align-items-center justify-content-between">
                                        <h6>Amenities For Residential <span class="">( 2 Amenities are mandatory )</span></h6>
                                    </div>
                                    <div class="checkbox-button-group">
                                        @if ($attribute->options)
                                        @foreach ($attribute->options as $okey => $option)
                                        <div class="checkbox-button">
                                            <input type="checkbox" name="attributes[{{ $attribute->name }}][]"
                                                value="{{ $option->id }}"
                                                id="{{ $attribute->name }}-option-{{ $okey }}"
                                                {{ in_array($option->id, old('attributes.' . $attribute->name, $data_attributes[$attribute->name] ?? [])) ? 'checked' : '' }}>
                                            <label for="{{ $attribute->name }}-option-{{ $okey }}">
                                                @if ($option->icon)
                                                <i class="{{ $option->icon }}"></i>
                                                @endif
                                                {{ $option->name }}
                                            </label>
                                        </div>
                                        @endforeach
                                        @endif
                                        @error('attributes')
                                        <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    {{-- JS validation error placeholder --}}
                                    <div class="attribute-error text-danger small mt-2" style="display: none;">
                                        Please select at least 2 options.
                                    </div>
                                </div>
                                @endif
                                @endforeach
                                @endif
                            </div>

                        </div>

                        <div class="d-flex justify-content-center my-3 gap-1">
                            <a href="{{ route('agent.properties.step_1', $property->id ?? null) }}"
                                class="btn btn-secondary w-25">Back</a>
                            <button type="submit" class="btn btn-primary w-25 mx-2">Save & Next</button>
                        </div>
                    </div>
                </div>
        </form>
    </div>
</div>
@endsection

@section('scripts')
<script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
<script>
    $(document).ready(function() {
        // Handle BHK checkbox changes
        $('.bhk-type-checkbox').on('change', function() {
            const bhk = $(this).val();
            const safeBhk = bhk.replace(/\./g, 'dot').replace(/\+/g, 'plus').replace(/\s/g, '_');
            const target = '#bhk-block-' + safeBhk;

            if ($(this).is(':checked')) {
                $(target).slideDown();
            } else {
                $(target).slideUp();
                // Optionally clear values if unchecked
                $(target).find('input, select').val('');
            }
        });

        // Delete BHK block
        $(document).on('click', '.delete-bhk-block', function() {
            const bhk = $(this).data('bhk');
            const safeBhk = bhk.replace(/\./g, 'dot').replace(/\+/g, 'plus').replace(/\s/g, '_');
            const block = $('#bhk-block-' + safeBhk);
            const checkbox = $(".bhk-type-checkbox[value='" + bhk + "']");

            block.slideUp();
            checkbox.prop('checked', false);
        });

        // Initialize visible blocks based on selected BHKs
        const selectedBhkTypes = @json($selectedBhk);
        $('.bhk-block').each(function() {
            const bhk = $(this).data('bhk');
            if (selectedBhkTypes.includes(bhk)) {
                $(this).show();
            } else {
                $(this).hide();
            }
        });

        // Update Price Per label when unit changes
        $('.area-unit-select').on('change', function() {
            var bhk = $(this).data('bhk');
            var unit = $(this).val();
            var label = 'Carpet Area';
            if (unit === 'sqft') {
                label += ' (Sq. Ft.)';
            } else if (unit === 'sqm') {
                label += ' (Sq. Mtr.)';
            }
            $('#carpet-label-' + bhk).text(label);
        });

        // On page load, set Price Per label for each BHK block
        $('.area-unit-select').each(function() {
            var bhk = $(this).data('bhk');
            var unit = $(this).val();
            var label = 'Carpet Area';
            if (unit === 'sqft') {
                label += ' (Sq. Ft.)';
            } else if (unit === 'sqm') {
                label += ' (Sq. Mtr.)';
            }
            $('#carpet-label-' + bhk).text(label);
        });
        // Update Price Per label when unit changes
        $('.area-unit-select').on('change', function() {
            var bhk = $(this).data('bhk');
            var unit = $(this).val();
            var label = 'Price Per';
            if (unit === 'sqft') {
                label += ' (Sq. Ft.)';
            } else if (unit === 'sqm') {
                label += ' (Sq. Mtr.)';
            }
            $('#price-label-' + bhk).text(label);
        });

        // On page load, set Price Per label for each BHK block
        $('.area-unit-select').each(function() {
            var bhk = $(this).data('bhk');
            var unit = $(this).val();
            var label = 'Price Per';
            if (unit === 'sqft') {
                label += ' (Sq. Ft.)';
            } else if (unit === 'sqm') {
                label += ' (Sq. Mtr.)';
            }
            $('#price-label-' + bhk).text(label);
        });

        // Prevent unchecked BHKs from submitting
        $('#builder-plan-form').on('submit', function() {
            $('.bhk-type-checkbox:not(:checked)').prop('disabled', true);
        });
    });
    document.addEventListener('DOMContentLoaded', function() {
        // For every BHK block, set up the floor selector logic
        document.querySelectorAll('[id^="total_floors_"]').forEach(function(totalFloorsInput) {
            const bhk = totalFloorsInput.getAttribute('id').replace('total_floors_', '');
            const floorSelect = document.getElementById(`property_floor_${bhk}`);
            if (!floorSelect) return;

            // Get selected value for this BHK
            const selected = floorSelect.getAttribute('data-selected') || '';

            const staticOptions = `
                <option value="">Select Floor</option>
                <option value="basement">Basement</option>
                <option value="lower-ground">Lower Ground</option>
                <option value="ground">Ground</option>
            `;

            function updateFloorOptions(maxFloor) {
                let options = staticOptions;
                const max = parseInt(maxFloor);
                if (!isNaN(max) && max > 0) {
                    if (max <= 50) {
                        for (let i = 1; i <= max; i++) {
                            options += `<option value="${i}">${i}</option>`;
                        }
                    } else {
                        for (let i = 1; i <= 50; i++) {
                            options += `<option value="${i}">${i}</option>`;
                        }
                        options += `<option value="50+">50+</option>`;
                    }
                }
                floorSelect.innerHTML = options;
                // Set selected value if available
                if (selected) {
                    floorSelect.value = selected;
                }
            }
            // Initial load
            updateFloorOptions(totalFloorsInput.value);
            // Update when user types
            totalFloorsInput.addEventListener('input', function() {
                updateFloorOptions(this.value);
            });
        });
    });
</script>
<script>
    document.querySelector('form').addEventListener('submit', function(e) {
        let group = document.querySelector('[id^="attribute-"]'); // only for Amenities For Commercial
        const checkboxes = group.querySelectorAll('input[type="checkbox"]:checked');
        const errorDiv = group.querySelector('.attribute-error');

        if (checkboxes.length < 2) {
            e.preventDefault();
            errorDiv.style.display = 'block'; // show error under inputs
        } else {
            errorDiv.style.display = 'none'; // hide if valid
        }
    });
</script>
@endsection