@extends('layouts.agent')
@push('css')
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        input[type="radio"] {
            display: none;
        }

        input[type="radio"]+label {
            display: inline-block;
            margin: 5px;
            padding: 5px 10px;
            background-color: #f8f9fa;
            border: 1px solid #ddd;
            border-radius: 5px;
            cursor: pointer;
        }

        label:hover {
            background-color: #f0f0f0;
        }

        input[type="radio"]:checked+label {
            background-color: #007bff;
            color: #fff;
            border-color: #007bff;
        }

        input[type="radio"]:hidden+.parking-label {
            background-color: #e9ecef;
            color: #000;
        }

        input[type="radio"]:checked+.parking-label {
            background-color: #007bff;
            color: #fff;
            border-color: #0056b3;
        }

        .custom-control-input {
            display: none;
        }

        .steps-container {
            display: flex;
            flex-wrap: wrap;
            justify-content: center;
            width: 100%;
            padding: 0 15px;
        }

        .step-item {
            display: flex;
            align-items: center;
            position: relative;
            margin: 5px 0;
        }

        .step-circle {
            min-width: 30px;
            height: 30px;
            border-radius: 50%;
            background-color: #ddd;
            color: #555;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 14px;
            font-weight: bold;
            text-decoration: none;
            z-index: 2;
        }

        .step-circle.active {
            background-color: #007bff;
            color: white;
        }

        .step-label {
            margin: 0 8px;
            white-space: nowrap;
            font-size: 14px;
        }

        .step-line {
            height: 4px;
            background-color: #ddd;
            flex: 1;
            min-width: 20px;
            max-width: 50px;
        }

        /* Responsive adjustments */
        @media (max-width: 768px) {
            .steps-container {
                flex-direction: column;
                align-items: flex-start;
                max-width: 100%;
            }

            .step-item {
                width: 100%;
                margin-bottom: 15px;
            }

            .step-line {
                position: absolute;
                left: 15px;
                top: 30px;
                width: 4px;
                height: 20px;
                min-width: 4px;
            }

            .step-label {
                margin-left: 15px;
            }

            .step-item:last-child .step-line {
                display: none;
            }
        }

        /* Medium screens */
        @media (min-width: 769px) and (max-width: 991px) {
            .step-label {
                font-size: 12px;
            }

            .step-line {
                min-width: 15px;
                max-width: 30px;
            }
        }

        /* Responsive for floor plan cards */
        @media (max-width: 767.98px) {
            #floor-plans-container .card-body .row.g-3.align-items-start>div[class^='col-'] {
                flex: 0 0 100%;
                max-width: 100%;
            }

            .back-preview-image {
                max-width: 100% !important;
                height: 100px !important;
            }
        }

        @media (max-width: 575.98px) {
            .steps-container {
                flex-direction: column;
                align-items: flex-start;
            }

            .step-item {
                width: 100%;
            }

            .step-label {
                margin-left: 10px;
            }
        }

        @media (min-width: 768px) {
            #floor-plans-container .row.small.text-muted>div {
                flex: 0 0 33.3333%;
                max-width: 33.3333%;
            }
        }

        @media (max-width: 767.98px) {
            #floor-plans-container .row.small.text-muted>div {
                flex: 0 0 100%;
                max-width: 100%;
            }

            .back-preview-image {
                max-width: 100% !important;
                height: 100px !important;
            }
        }
    </style>
@endpush
@section('content')
    <div class="card">
        <div class="d-flex justify-content-center">
            @php
                $steps = [
                    1 => 'Basic Details',
                    2 => 'Property Details',
                    3 => 'Location Details',
                    4 => 'Photos & Videos',
                ];
                $currentStep = request()->route()->getName();
                preg_match('/step_(\d+)/', $currentStep, $matches);
                $activeStep = isset($matches[1]) ? (int) $matches[1] : 1;
            @endphp
            <div class="steps-container my-1">
                @foreach ($steps as $step => $label)
                    <div class="step-item">
                        <a href="#" class="step-circle {{ $step == $activeStep ? 'active' : '' }}">
                            {{ $step }}
                        </a>
                        <span class="step-label">{{ $label }}</span>
                        @if ($step < count($steps))
                            <div class="step-line">
                            </div>
                        @endif
                    </div>
                @endforeach
            </div>
        </div>
    </div>
    <div class="row justify-content-center mt-3">
        <div class="col-md-12">
            <form class="" id="property-form"
                action="{{ isset($property->id) ? route('agent.properties.builder_store_step_4', ['id' => $property->id]) : route('agent.properties.builder_store_step_4') }}"
                method="POST" enctype="multipart/form-data">
                {{ csrf_field() }}
                <div class="row card">
                    <div class="col-lg-12">
                        <div class="">
                            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                                <h6>{{ __('Property Images') }}</h6>
                            </div>
                            <div class="card-body">
                                <!-- Property Covered Image -->
                                <div class="form-group">
                                    <div class="card-header py-3 d-flex  justify-content-between">
                                        <h6 class="m-0 ">{{ __('Property Covered Image') }}</h6>
                                    </div>
                                    <div class="wrapper-image-preview">
                                        <div class="box">
                                            <div class="back-preview-image"
                                                style="background-image: url({{ $property->photo ? asset('assets/images/' . $property->photo) : asset('assets/images/placeholder.jpg') }});">
                                            </div>
                                            <div class="upload-options">
                                                <label class="img-upload-label" for="img-upload">
                                                    <i class="fas fa-camera"></i> {{ __('Upload Picture') }}
                                                </label>
                                                <input id="img-upload" type="file" class="image-upload" name="photo"
                                                    accept="image">
                                            </div>
                                        </div>
                                    </div><br>

                                    {{-- error message --}}
                                    @if ($errors->has('photo'))
                                        <span class="text-danger">{{ $errors->first('photo') }}</span>
                                    @endif
                                </div>

                                <!-- Property Image Gallery -->
                                <div class="form-group">
                                    <span class="text-primary">Minimum 4 images are mandatory</span><br>
                                    <button type="button" class="btn btn-secondary set-gallery" data-toggle="modal"
                                        data-target="#setgallery" id="myBtn">
                                        <i class="icofont-plus"></i> {{ __('Upload Property Image Gallery') }}
                                    </button>
                                </div>
                                <div id="error-message" class="text-danger" style="display: none;">
                                    Your uploaded images is still less than 4 please upload atleast 4 images.
                                </div>
                            </div>
                        </div>
                        <div class="">
                            
                            <div class="card-body">
                                <div class="card-header d-flex flex-row align-items-center justify-content-between">
                                <h6>{{ __('Floor Plan Name') }}</h6>
                            </div>
                                <div id="floor-plans-container">
                                    @foreach ($floor_plans as $key => $f_plan)
                                        <div class="card my-3 shadow-sm">
                                            <div class="card-body">
                                                <div class="row align-items-start flex-wrap">
                                                    <div class="col-12 col-md-8">
                                                        <div class="row gx-2 flex-wrap">
                                                            <div class="col-12 col-md-6 mb-3">
                                                                <label for="floor_name_{{ $key }}" class="form-label">Floor Plan Name</label>
                                                                <input type="text" class="form-control" name="floor_name[]" id="floor_name_{{ $key }}" value="{{ $f_plan->floor_name }}" placeholder="Enter Plan Floor Name">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-12 col-md-4">
                                                        <div class="row">
                                                            <div class="col-12 mb-2">
                                                                <div class="back-preview-image mb-2 mx-auto mx-md-0"
                                                                    style="background-image: url({{ $f_plan->photo ? asset('assets/images/' . $f_plan->photo) . '?t=' . time() : asset('assets/images/placeholder.jpg') }}); height: 150px; width: 100%; max-width: 350px; background-size: cover; background-position: center; border-radius: 8px;">
                                                                </div>
                                                            </div>
                                                            <div class="col-12">
                                                                <input type="hidden" name="floor_id[]" value="{{ $f_plan->id }}">
                                                                <div class="form-group">
                                                                    <input type="file" name="floor_images[]" class="form-control" @if (!$f_plan->photo) required @endif>
                                                                    @if (!$f_plan->photo)
                                                                        @error("floor_images.$key")
                                                                            <small class="text-danger">{{ $message }}</small>
                                                                        @enderror
                                                                    @endif
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>

                        <div class="d-flex justify-content-center my-3">
                            <a href="{{ route('agent.properties.step_3', $property->id ?? null) }}" id="back-btn"
                                class="btn btn-secondary w-25">{{ __('Back') }}</a>
                            <button type="submit" id="submit-btn"
                                class="btn btn-primary w-25 mx-2">{{ __('Save') }}</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <div class="modal fade" id="setgallery" tabindex="-1" role="dialog" aria-labelledby="setgallery"
        aria-modal="true">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalCenterTitle">{{ __('Image Gallery') }}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="top-area">
                        <div id="error-message" class="alert alert-danger" style="display: none;">
                            <strong>{{ __('Error!') }}</strong> <span id="error-text"></span>
                        </div>
                        <div class="row">
                            <div class="col-sm-6 text-right">
                                <div class="upload-img-btn">
                                    <form method="POST" enctype="multipart/form-data" id="form-gallery">
                                        {{ csrf_field() }}
                                        <input type="hidden" id="property_id" name="property_id"
                                            value="{{ $property->id }}">
                                        <input type="file" name="gallery[]" class="hidden"
                                            id="property_upload_gallery_edit" accept="image/*" multiple>
                                        <label id="property_gallery_edit" class="pt-2">
                                            <i class="icofont-upload-alt"></i>{{ __('Upload File') }}
                                        </label>
                                    </form>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <a href="javascript:;" class="upload-done" data-dismiss="modal">
                                    <i class="fas fa-check"></i> {{ __('Done') }}
                                </a>
                                <p id="error-text" style="display: none; margin-top: 5px;"></p>
                            </div>
                            <div class="col-sm-12 text-center">
                                <small>{{ __('You can upload multiple Images.') }}</small>
                            </div>
                        </div>
                    </div>
                    <div class="gallery-images">
                        <div class="selected-image">
                            <div class="row">
                                @if ($property->galleries)
                                    @foreach ($property->galleries as $gallery)
                                        <div class="col-sm-6">
                                            <div class="img gallery-img">
                                                <span class="remove-img">
                                                    <i class="fas fa-times"></i>
                                                    <input type="hidden" value="{{ $gallery->id }}">
                                                </span>
                                                <a href="{{ asset('assets/images/' . $gallery->photo) }}"
                                                    target="_blank">
                                                    <img src="{{ asset('assets/images/' . $gallery->photo) }}"
                                                        alt="gallery image" width="100px">
                                                </a>
                                            </div>
                                        </div>
                                    @endforeach
                                @else
                                    <div class="col-12 text-center">
                                        <p>{{ __('No images found.') }}</p>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('scripts')
    <script src="{{ asset('assets/front/js/image_gallary.js') }}"></script>
    <script>
        var mainurl = "{{ url('/') }}";

        $(document).ready(function() {
            // Handle the close button (×) click
            $('#setgallery .close').on('click', function() {
                $('#setgallery').modal('hide');
                cleanupModal();
            });

            // Handle the done button click
            $('.upload-done').on('click', function(e) {
                var uploadedImagesCount = $('.gallery-images .gallery-img').length;
                if (uploadedImagesCount < 4) {
                    alert('Please upload at least 4 images before proceeding.');
                    e.preventDefault();
                } else {
                    $('#setgallery').modal('hide');
                    cleanupModal();
                }
            });

            // Common function to clean up modal
            function cleanupModal() {
                $('body').removeClass('modal-open');
                $('.modal-backdrop').remove();
                $('#form-gallery')[0].reset();
                $('#property_upload_gallery_edit').val('');
            }

            // Form submission validation
            $('#property-form').on('submit', function(e) {
                var uploadedImagesCount = $('.gallery-images .gallery-img').length;
                if (uploadedImagesCount < 4) {
                    $('#error-message').show();
                    e.preventDefault();
                } else {
                    $('#error-message').hide();
                }
            });
        });
    </script>
@endsection
