@extends('layouts.agent')
@push('css')
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
    .zindex-dropdown {
        z-index: 1000;
    }
</style>
@endpush
@section('content')
<div class="card">
    <div class="d-flex justify-content-center">
        @php
        $steps = [
        1 => 'Basic Details',
        2 => 'Property Details',
        3 => 'Location Details',
        4 => 'Photos & Videos',
        ];
        $currentStep = request()->route()->getName();
        preg_match('/step_(\d+)/', $currentStep, $matches);
        $activeStep = isset($matches[1]) ? (int) $matches[1] : 1;
        @endphp
        <div class="steps-container my-1">
            @foreach ($steps as $step => $label)
            <div class="step-item">
                <a href="#" class="step-circle {{ $step == $activeStep ? 'active' : '' }}">
                    {{ $step }}
                </a>
                <span class="step-label">{{ $label }}</span>
                @if ($step < count($steps))
                    <div class="step-line">
            </div>
            @endif
        </div>
        @endforeach
    </div>
</div>
</div>
<div class="row justify-content-center mt-3">
    <div class="card p-4 col-md-12">
        <form id="addressForm"
            action="{{ isset($property->id) ? route('agent.properties.store_step_3', ['id' => $property->id]) : route('agent.properties.store_step_3') }}"
            method="POST">
            {{ csrf_field() }}
            <div class="mb-3">
                <label class="form-label">Select City</label>
                <select class="form-control city-select" id="citySelect" name="location_id" required>
                    <option value=""></option>
                    <optgroup label="Top Cities">
                        @foreach ($topCities as $data)
                        <option value="{{ $data->id }}"
                            data-city="{{ strtolower(Str::slug($data->name)) }}"
                            {{ isset($property) && $property->location_id == $data->id ? 'selected' : '' }}>
                            {{ $data->name }}
                        </option>
                        @endforeach
                    </optgroup>

                    <optgroup label="Other Cities">
                        @foreach ($otherCities as $data)
                        <option value="{{ $data->id }}"
                            data-city="{{ strtolower(Str::slug($data->name)) }}"
                            {{ isset($property) && $property->location_id == $data->id ? 'selected' : '' }}>
                            {{ $data->name }}
                        </option>
                        @endforeach
                    </optgroup>
                </select>
            </div>
            <br>
            <div id="additionalFields" style="display: none;">
                <div class="mb-3 position-relative">
                    <label class="form-label">Building / Apartment / Society Name (Mandatory)</label>
                    <input type="text" class="form-control" name="building"
                        value="{{ isset($property->building) ? $property->building : '' }}" required autocomplete="off">
                </div>
                <div class="mb-3 position-relative" id="localityGroup">
                    <label class="form-label">Locality / Sector (Mandatory)</label>
                    <input type="text" class="form-control" id="localityInput" name="locality" autocomplete="off" readonly
                        value="{{ isset($property->locality) ? $property->locality : '' }}">
                    <div id="localitySuggestionContainer" style="position:absolute; left:0; right:0; z-index:1000;"></div>
                </div>
                <div class="mb-3" id="sublocalityGroup">
                    <label class="form-label">Sublocality / Area / Street (Optional)</label>
                    <input type="text" class="form-control" id="sublocalityInput" name="sub_locality" autocomplete="off" 
                        value="{{ isset($property->sub_locality) ? $property->sub_locality : '' }}">
                </div>
            </div>
            <div class="d-flex justify-content-center mt-3 my-3">
                <a href="{{ url('/seller/properties/additional-info/'. $property->id ?? null) }}" id="back-btn"
                    class="btn btn-secondary w-25">{{ __('Back') }}</a>
                <button type="button" onclick="document.getElementById('addressForm').submit();" id="submit-btn"
                    class="btn btn-primary w-25 mx-2">{{ __('Save & Next') }}</button>
            </div>
        </form>
    </div>
</div>
@endsection
@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script src="https://maps.googleapis.com/maps/api/js?key={{ config('app.google_map_api_key') }}&libraries=places"></script>
<script>
   $(document).ready(function () {
    $('.city-select').select2({
        placeholder: "Select city",
        allowClear: true,
        width: '100%'
    });

    const citySelect = document.getElementById('citySelect');
    const additionalFields = document.getElementById('additionalFields');
    const buildingInput = document.querySelector('[name="building"]');
    const localityInput = document.getElementById('localityInput');
    const sublocalityInput = document.getElementById('sublocalityInput');

    let geocoder;
    let autocompleteBuilding;
    let autocompleteLocality;

    // ✅ Common function to extract locality & sublocality (used for locality autocomplete)
    function parseAddressForLocality(address, cityName) {
        let locality = "";
        let sublocality = "";

        // Clean address
        address = address.replace(/\s+/g, " ").trim();

        // Find city position
        const cityIndex = address.toLowerCase().indexOf(cityName.toLowerCase());
        let beforeCity = cityIndex > -1 ? address.substring(0, cityIndex).trim() : address;

        // Split by commas
        let parts = beforeCity.split(",").map(p => p.trim()).filter(p => p);

        if (parts.length > 0) locality = parts[0];
        if (parts.length > 1) sublocality = parts[parts.length - 1];

        if (locality && sublocality && locality.toLowerCase() === sublocality.toLowerCase()) {
            sublocality = "";
        }

        return { locality, sublocality };
    }

    function clearLocalityFields(makeEditable = true) {
        localityInput.value = '';
        sublocalityInput.value = '';
        if (makeEditable) {
            localityInput.readOnly = false;
        }
    }

    function initializeMapServices() {
        if (!geocoder) geocoder = new google.maps.Geocoder();

        // ✅ Default readonly
        localityInput.readOnly = true;

        // --- Building Autocomplete ---
        if (!autocompleteBuilding) {
            autocompleteBuilding = new google.maps.places.Autocomplete(buildingInput, {
                types: ['establishment'],
                componentRestrictions: { country: 'in' }
            });

            autocompleteBuilding.addListener('place_changed', function () {
                const place = autocompleteBuilding.getPlace();

                if (!place || !place.address_components) {
                    // ❌ Suggestion not selected → allow manual entry
                    localityInput.readOnly = false;
                    return;
                }

                // ✅ Autocomplete selected → autofill
                buildingInput.value = place.name ? place.name.split(",")[0] : '';
                clearLocalityFields(false);

                let city = '';
                let sector = '';
                let area = '';

                place.address_components.forEach(component => {
                    if (component.types.includes("locality")) city = component.long_name;
                    if (component.types.includes("sublocality_level_1")) sector = component.long_name;
                    if (component.types.includes("sublocality_level_2") || component.types.includes("neighborhood")) area = component.long_name;
                });

                // Smart fill rules
                if (sector && area) {
                    localityInput.value = sector;
                    sublocalityInput.value = area;
                    localityInput.readOnly = true;
                } else if (sector && !area) {
                    localityInput.value = sector;
                    sublocalityInput.value = "";
                    localityInput.readOnly = true;
                } else if (!sector && area) {
                    localityInput.value = "";
                    sublocalityInput.value = area;
                    localityInput.readOnly = false;
                } else {
                    clearLocalityFields(true);
                }
            });

            // ✅ If building text changes manually
            buildingInput.addEventListener("input", function () {
                clearLocalityFields(true);
            });
        }

        // --- Locality Autocomplete ---
        if (!autocompleteLocality) {
            autocompleteLocality = new google.maps.places.Autocomplete(localityInput, {
                types: ['(regions)'],
                componentRestrictions: { country: 'in' }
            });

            autocompleteLocality.addListener('place_changed', function () {
                if (localityInput.readOnly) return;

                const place = autocompleteLocality.getPlace();
                if (!place || !place.formatted_address) return;

                const selectedCity = citySelect.options[citySelect.selectedIndex].text || "";
                const { locality, sublocality } = parseAddressForLocality(place.formatted_address, selectedCity);

                localityInput.value = locality || "";
                sublocalityInput.value = sublocality || "";

                if (locality && sublocality) {
                    localityInput.readOnly = false;
                } else {
                    localityInput.readOnly = false;
                }
            });
        }
    }

    function updateAutocompleteBounds() {
        const selectedCity = citySelect.options[citySelect.selectedIndex].text;
        if (selectedCity && geocoder) {
            geocoder.geocode({ address: selectedCity }, function (results, status) {
                if (status === google.maps.GeocoderStatus.OK && results[0]) {
                    const newBounds = results[0].geometry.viewport;

                    if (autocompleteBuilding) {
                        autocompleteBuilding.setBounds(newBounds);
                        autocompleteBuilding.setOptions({ strictBounds: true });
                    }
                    if (autocompleteLocality) {
                        autocompleteLocality.setBounds(newBounds);
                        autocompleteLocality.setOptions({ strictBounds: true });
                    }
                }
            });
        }
    }

    // Page load
    const isEditMode = "{{ isset($property->location_id) ? true : false }}";
    if (isEditMode) {
        additionalFields.style.display = 'block';
        initializeMapServices();
        updateAutocompleteBounds();
    } else {
        additionalFields.style.display = 'none';
        initializeMapServices();
    }

    // City change
    $('#citySelect').on('change', function () {
        if (this.value) {
            additionalFields.style.display = 'block';
            updateAutocompleteBounds();
            clearLocalityFields(true); // ✅ Reset when city changes
            buildingInput.value = '';
            localityInput.readOnly = true;
        } else {
            additionalFields.style.display = 'none';
            clearLocalityFields(true);
            buildingInput.value = '';
            localityInput.readOnly = true;
        }
    });

    // ✅ Extra: if city is retyped in select2 search box (not just changed)
    $('.city-select').on('select2:clear', function () {
        clearLocalityFields(true);
        buildingInput.value = '';
        additionalFields.style.display = 'none';
    });
});

</script>


@endsection