@extends('layouts.agent')
@push('css')
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
@endpush
@section('content')
    <div class="card">
        <div class="d-flex justify-content-center">
            @php
                $steps = [
                    1 => 'Basic Details',
                    2 => 'Property Details',
                    3 => 'Location Details',
                    4 => 'Photos & Videos',
                ];
                $currentStep = request()->route()->getName();
                preg_match('/step_(\d+)/', $currentStep, $matches);
                $activeStep = isset($matches[1]) ? (int) $matches[1] : 1;
            @endphp
            <div class="steps-container my-1">
                @foreach ($steps as $step => $label)
                    <div class="step-item">
                        <a href="#" class="step-circle {{ $step == $activeStep ? 'active' : '' }}">
                            {{ $step }}
                        </a>
                        <span class="step-label">{{ $label }}</span>
                        @if ($step < count($steps))
                            <div class="step-line">
                            </div>
                        @endif
                    </div>
                @endforeach
            </div>
        </div>
    </div>
    <div class="row justify-content-center mt-3">
        <div class="col-md-12">
            <form class="" id="property-form"
                action="{{ isset($property->id) ? route('agent.properties.store_step_4', ['id' => $property->id]) : route('agent.properties.store_step_4') }}"
                method="POST" enctype="multipart/form-data">
                {{ csrf_field() }}
                <div class="row">
                    <div class="col-lg-12">
                        <div class="">
                            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                                <h6>{{ __('Property Images') }}</h6>
                            </div>
                            <div class="card-body">
                                <!-- Property Covered Image -->
                                <div class="form-group">
                                    <div class="card-header py-3 d-flex  justify-content-between">
                                        <h6 class="m-0 ">{{ __('Property Covered Image') }}</h6>
                                    </div>
                                    <div class="wrapper-image-preview">
                                        <div class="box">
                                            <div class="back-preview-image"
                                                style="background-image: url({{ $property->photo ? asset('assets/images/' . $property->photo) : asset('assets/images/placeholder.jpg') }});">
                                            </div>
                                            <div class="upload-options">
                                                <label class="img-upload-label" for="img-upload">
                                                    <i class="fas fa-camera"></i> {{ __('Upload Picture') }}
                                                </label>
                                                <input id="img-upload" type="file" class="image-upload" name="photo"
                                                    accept="image/*">
                                            </div>
                                        </div>
                                    </div><br>

                                    {{-- error message --}}
                                    @if ($errors->has('photo'))
                                        <span class="text-danger">{{ $errors->first('photo') }}</span>
                                    @endif
                                </div>

                                <!-- Property Image Gallery -->
                                <div class="form-group">
                                    <span class="text-primary">Minimum 4 images are mandatory</span><br>
                                    <button type="button" class="btn btn-secondary set-gallery" data-toggle="modal"
                                        data-target="#setgallery" id="myBtn">
                                        <i class="icofont-plus"></i> {{ __('Upload Property Image Gallery') }}
                                    </button>
                                </div>
                                <div id="error-message" class="text-danger" style="display: none;">
                                    Your uploaded images is still less than 4 please upload atleast 4 images.
                                </div>
                            </div>
                        </div>

                        <div class="">
                            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                                <h6>{{ __('Floor Plans Name') }}</h6> 
                            </div>
                            <div class="card-body">
                                <div id="floor-plans-container">
                                    @if ($floor_plans->isEmpty())
                                        <!-- Add empty floor plan fields if no floor plans are available -->
                                        <div class="row floor-plan-field align-items-center">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <input type="hidden" name="floor_id[]" value="">
                                                    <input type="text" class="form-control" name="floor_names[]"
                                                        placeholder="{{ __('Floor Name (E.g: Ground Floor...)') }}">
                                                    @error('floor_names.*')
                                                        <small class="text-danger">{{ $message }}</small>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group mt-2">
                                                    <input type="file" class="form-control" name="floor_images[]"
                                                        accept="image/*" required>
                                                    @error('floor_images.*')
                                                        <small class="text-danger">{{ $message }}</small>
                                                    @enderror
                                                </div>
                                            </div>
                                        </div>
                                    @else
                                        <!-- Display the existing floor plans -->
                                        @foreach ($floor_plans as $key => $f_plan)
                                            <div class="row floor-plan-field align-items-center">
                                                <div class="col-md-4">
                                                    <div class="form-group">
                                                        <input type="hidden" name="floor_id[]"
                                                            value="{{ $f_plan->id }}">
                                                        <input type="text" class="form-control" name="floor_names[]"
                                                            placeholder="{{ __('Floor Name (E.g: Ground Floor...)') }}"
                                                            value="{{ old('floor_names.' . $key, $f_plan->name) }}"
                                                            required>
                                                        @error("floor_names.$key")
                                                            <small class="text-danger">{{ $message }}</small>
                                                        @enderror
                                                    </div>
                                                </div>
                                                <div class="col-md-3">
                                                    <div class="form-group">
                                                        <select class="form-control" name="floor_sizes[]" required>
                                                            <option value="" disabled>{{ __('Select Type') }}
                                                            </option>
                                                            <option value="1 RK" @selected($f_plan->size == '1 RK')>1 RK
                                                            </option>
                                                            <option value="1 BHK" @selected($f_plan->size == '1 BHK')>1 BHK
                                                            </option>
                                                            <option value="1.5 BHK" @selected($f_plan->size == '1.5 BHK')>1.5 BHK
                                                            </option>
                                                            <option value="2 BHK" @selected($f_plan->size == '2 BHK')>2 BHK
                                                            </option>
                                                            <option value="2.5 BHK" @selected($f_plan->size == '2.5 BHK')>2.5 BHK
                                                            </option>
                                                            <option value="3 BHK" @selected($f_plan->size == '3 BHK')>3 BHK
                                                            </option>
                                                            <option value="3.5 BHK" @selected($f_plan->size == '3.5 BHK')>3.5 BHK
                                                            </option>
                                                            <option value="4 BHK" @selected($f_plan->size == '4 BHK')>4 BHK
                                                            </option>
                                                            <option value="4.5 BHK" @selected($f_plan->size == '4.5 BHK')>4.5 BHK
                                                            </option>
                                                            <option value="5 BHK" @selected($f_plan->size == '5 BHK')>5 BHK
                                                            </option>
                                                            <option value="5.5 BHK" @selected($f_plan->size == '5.5 BHK')>5.5 BHK
                                                            </option>
                                                            <option value="6 BHK" @selected($f_plan->size == '6 BHK')>6 BHK
                                                            </option>
                                                            <option value="6.5 BHK" @selected($f_plan->size == '6.5 BHK')>6.5 BHK
                                                            </option>
                                                            <option value="7 BHK" @selected($f_plan->size == '7 BHK')>7 BHK
                                                            </option>
                                                            <option value="7+ BHK" @selected($f_plan->size == '7+ BHK')>7+ BHK
                                                            </option>
                                                        </select>
                                                        @error("floor_sizes.$key")
                                                            <small class="text-danger">{{ $message }}</small>
                                                        @enderror
                                                    </div>
                                                </div>
                                                <div class="col-md-4">
                                                    <div class="back-preview-image"
                                                        style="background-image: url({{ $f_plan->photo ? asset('assets/images/' . $f_plan->photo) . '?t=' . time() : asset('assets/images/placeholder.jpg') }});">
                                                    </div>
                                                    <div class="form-group mt-2">
                                                        <input type="file" class="form-control floor-image-input"
                                                            name="floor_images[]" accept="image/*" id="floorImageInput"
                                                            @if (!$f_plan->photo) required @endif>
                                                        @if (!$f_plan->photo)
                                                            @error("floor_images.$key")
                                                                <small class="text-danger">{{ $message }}</small>
                                                            @enderror
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    @endif
                                </div>
                                <div class="row" style="margin-top: 15px;">
                                    <div class="col-12">
                                        <button type="button" class="btn btn-secondary set-gallery"
                                            id="add-new-floor-plan-btn">Add New</button>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="d-flex justify-content-center my-3">
                            <a href="{{ route('agent.properties.step_3', $property->id ?? null) }}" id="back-btn"
                                class="btn btn-secondary w-25">{{ __('Back') }}</a>
                            <button type="submit" id="submit-btn"
                                class="btn btn-primary w-25 mx-2">{{ __('Save') }}</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="modal fade" id="setgallery" tabindex="-1" role="dialog" aria-labelledby="setgallery"
        aria-modal="true">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalCenterTitle">{{ __('Image Gallery') }}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="top-area">
                        <div id="error-message" class="alert alert-danger" style="display: none;">
                            <strong>{{ __('Error!') }}</strong> <span id="error-text"></span>
                        </div>
                        <div class="row">
                            <div class="col-sm-6 text-right">
                                <div class="upload-img-btn">
                                    <form method="POST" enctype="multipart/form-data" id="form-gallery">
                                        {{ csrf_field() }}
                                        <input type="hidden" id="property_id" name="property_id"
                                            value="{{ $property->id }}">
                                        <input type="file" name="gallery[]" class="hidden"
                                            id="property_upload_gallery_edit" accept="image/*" multiple>
                                        <label id="property_gallery_edit" class="pt-2">
                                            <i class="icofont-upload-alt"></i>{{ __('Upload File') }}
                                        </label>
                                    </form>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <a href="javascript:;" class="upload-done" data-dismiss="modal">
                                    <i class="fas fa-check"></i> {{ __('Done') }}
                                </a>
                                <p id="error-text" style="display: none; margin-top: 5px;"></p>
                            </div>
                            <div class="col-sm-12 text-center">
                                <small>{{ __('You can upload multiple Images.') }}</small>
                            </div>
                        </div>
                    </div>
                    <div class="gallery-images">
                        <div class="selected-image">
                            <div class="row">
                                @if ($property->galleries)
                                    @foreach ($property->galleries as $gallery)
                                        <div class="col-sm-6">
                                            <div class="img gallery-img">
                                                <span class="remove-img">
                                                    <i class="fas fa-times"></i>
                                                    <input type="hidden" value="{{ $gallery->id }}">
                                                </span>
                                                <a href="{{ asset('assets/images/' . $gallery->photo) }}"
                                                    target="_blank">
                                                    <img src="{{ asset('assets/images/' . $gallery->photo) }}"
                                                        alt="gallery image" width="100px">
                                                </a>
                                            </div>
                                        </div>
                                    @endforeach
                                @else
                                    <div class="col-12 text-center">
                                        <p>{{ __('No images found.') }}</p>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('scripts')
    <script src="{{ asset('assets/front/js/image_gallary.js') }}"></script>
    <script>
        var mainurl = "{{ url('/') }}";
        document.addEventListener('DOMContentLoaded', function() {
            const floorPlansContainer = document.getElementById('floor-plans-container');
            const addNewFloorPlanBtn = document.getElementById('add-new-floor-plan-btn');

            addNewFloorPlanBtn.addEventListener('click', function() {
                const newField = document.createElement('div');
                newField.classList.add('row', 'floor-plan-field', 'mt-3');
                newField.innerHTML = `
            <div class="col-md-4">
                <div class="form-group">
                    <input type="hidden" name="floor_id[]" value="">
                    <input type="text" class="form-control" name="floor_names[]" placeholder="Floor Name (E.g: Ground Floor...)">
                </div>
            </div>
            <div class="col-md-3">
                <div class="form-group">
                    <select class="form-control" name="floor_sizes[]">
                        <option value="" disabled selected>Select Type</option>
                        <option value="1 RK">1 RK</option>
                        <option value="1 BHK">1 BHK</option>
                        <option value="1.5 BHK">1.5 BHK</option>
                        <option value="2 BHK">2 BHK</option>
                        <option value="2.5 BHK">2.5 BHK</option>
                        <option value="3 BHK">3 BHK</option>
                        <option value="3.5 BHK">3.5 BHK</option>
                        <option value="4 BHK">4 BHK</option>
                        <option value="4.5 BHK">4.5 BHK</option>
                        <option value="5 BHK">5 BHK</option>
                        <option value="5.5 BHK">5.5 BHK</option>
                        <option value="6 BHK">6 BHK</option>
                        <option value="6.5 BHK">6.5 BHK</option>
                        <option value="7 BHK">7 BHK</option>
                        <option value="7+ BHK">7+ BHK</option>
                    </select>
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group mt-2">
                    <input type="file" class="form-control" name="floor_images[]" accept="image/*">
                </div>
            </div>
            <div class="col-md-1 d-flex align-items-center">
                <button type="button" class="btn btn-secondary btn-sm remove-floor-plan-btn">X</button>
            </div>`;

                floorPlansContainer.appendChild(newField);

                const fileInput = newField.querySelector('input[type="file"]');
                const previewImage = newField.querySelector('.back-preview-image');

                fileInput.addEventListener('change', function(e) {
                    const file = e.target.files[0];
                    if (file) {
                        const reader = new FileReader();
                        reader.onload = function(event) {
                            previewImage.style.backgroundImage = `url(${event.target.result})`;
                        };
                        reader.readAsDataURL(file);
                    }
                });
            });

            floorPlansContainer.addEventListener('click', function(e) {
                if (e.target.classList.contains('remove-floor-plan-btn')) {
                    e.target.closest('.floor-plan-field').remove();
                }
            });
        });
        $(document).ready(function() {
            $('.upload-done').on('click', function() {
                $('#setgallery').modal('hide');

                $('body').removeClass('modal-open');
                $('.modal-backdrop').remove();

                $('#form-gallery')[0].reset();
                $('#property_upload_gallery_edit').val('');
            });
        });

        $(document).ready(function() {
            $('#property-form').on('submit', function(e) {
                var uploadedImagesCount = $('.gallery-images .gallery-img').length;
                if (uploadedImagesCount < 4) {
                    $('#error-message').show();

                    e.preventDefault();
                } else {
                    $('#error-message').hide();
                }
            });
        });

        $(document).ready(function() {
            $('.upload-done').on('click', function(e) {
                var uploadedImagesCount = $('.gallery-images .gallery-img').length;
                if (uploadedImagesCount < 4) {
                    alert('Please upload at least 4 images before proceeding.');
                    e.preventDefault();
                }
            });
        });
    </script>
    <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const addNewFloorPlanBtn = document.getElementById('add-new-floor-plan-btn');
            const floorPlansContainer = document.getElementById('floor-plans-container');
            const floorPlanTemplate = document.getElementById('floor-plan-template');

            if (addNewFloorPlanBtn && floorPlansContainer && floorPlanTemplate) {
                addNewFloorPlanBtn.addEventListener('click', function() {
                    const newField = floorPlanTemplate.content.cloneNode(true);
                    floorPlansContainer.appendChild(newField);
                });

                // Remove handler for dynamically added floor plans
                floorPlansContainer.addEventListener('click', function(e) {
                    if (e.target.classList.contains('remove-floor-plan-btn')) {
                        e.target.closest('.floor-plan-field').remove();
                    }
                });
            }
        });
    </script>
    <script>
        var mainurl = "{{ url('/') }}";
        $(document).ready(function() {
            // Handle the close button (×) click
            $('#setgallery .close').on('click', function() {
                $('#setgallery').modal('hide');
                cleanupModal();
            });

            // Handle the done button click
            $('.upload-done').on('click', function(e) {
                var uploadedImagesCount = $('.gallery-images .gallery-img').length;
                if (uploadedImagesCount < 4) {
                    alert('Please upload at least 4 images before proceeding.');
                    e.preventDefault();
                } else {
                    $('#setgallery').modal('hide');
                    cleanupModal();
                }
            });

            // Common function to clean up modal
            function cleanupModal() {
                $('body').removeClass('modal-open');
                $('.modal-backdrop').remove();
                $('#form-gallery')[0].reset();
                $('#property_upload_gallery_edit').val('');
            }

            // Form submission validation
            $('#property-form').on('submit', function(e) {
                var uploadedImagesCount = $('.gallery-images .gallery-img').length;
                if (uploadedImagesCount < 4) {
                    $('#error-message').show();
                    e.preventDefault();
                } else {
                    $('#error-message').hide();
                }
            });
        });
    </script>
@endsection
