@extends('layouts.agent')
@section('content')
    <div class="card">
        <div class="d-sm-flex align-items-center justify-content-between">
            <h5 class=" mb-0 text-gray-800 pl-3">{{ __('Manage All Properties') }}</h5>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('agent.dashboard') }}">{{ __('Dashboard') }}</a></li>
                <li class="breadcrumb-item"><a href="javascript:;">{{ __('Manage All Properties') }}</a></li>
            </ol>
        </div>
    </div>
    @if(auth()->user()->user_type != "builder/developer")
     <div class="row mb-3 mt-3">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <div class="form-row align-items-center">
                        <div class="col-md-12 mb-2">
                            <label class="mb-1 d-block font-weight-bold">{{ __('Sale Type') }}</label>
                            <div class="form-check form-check-inline">
                                <input class="form-check-input sale-filter" type="radio" name="sale_filter" id="sale"
                                    value="for_sell">
                                <label class="form-check-label px-4" for="sale">{{ __('Sell') }}</label>
                            </div>
                            <div class="form-check form-check-inline">
                                <input class="form-check-input sale-filter" type="radio" name="sale_filter" id="rent"
                                    value="for_rent">
                                <label class="form-check-label px-4" for="rent">{{ __('Rent') }}</label>
                            </div>
                            <div class="form-check form-check-inline">
                                <input class="form-check-input pg-filter" type="radio" name="pg_filter" id="pg"
                                    value="for_pg">
                                <label class="form-check-label px-4" for="pg">{{ __('PG') }}</label>
                            </div>
                            <div class="form-check form-check-inline">
                                <input class="form-check-input sale-filter" type="radio" name="sale_filter" id="all"
                                    value="" checked>
                                <label class="form-check-label px-4" for="all">{{ __('All') }}</label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif
    <div class="row mt-3">
        <div class="col-lg-12">
            @include('includes.admin.form-success')
            @if (session('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            @endif
            <div class="card mb-4">
                <div class="table-responsive p-3">
                    <table id="geniustable" class="table table-bordered table-striped table-smaller" cellspacing="0"
                        width="100%">
                        <thead class="thead-light">
                            <tr>
                                <th>{{ __('Featured Image') }}</th>
                                <th>{{ __('Title') }}</th>
                                <th>{{ __('Category') }}</th>
                                <th>{{ __('Location') }}</th>
                                <th style="white-space: nowrap; min-width:80px;">{{ __('Create Date') }}</th>
                                <th style="white-space: nowrap; min-width:80px;">{{ __('Update Date') }}</th>
                                <th>{{ __('Status') }}</th>
                                <th>{{ __('Listing Type') }}</th>
                                <th>{{ __('Options') }}</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </div>
    @includeIf('partials.admin.status')
    <!-- Delete Confirmation Modal -->
    <div class="modal fade confirm-modal" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalTitle"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">{{ __('Confirm Delete') }}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p class="text-center">
                        {{ __('You are about to delete this property. Every informtation under this property will be deleted.') }}
                    </p>
                    <p class="text-center">{{ __('Do you want to proceed?') }}</p>
                </div>
                <div class="modal-footer">
                    <a href="javascript:;" class="btn btn-secondary" data-dismiss="modal">{{ __('Cancel') }}</a>
                    <a href="javascript:;" class="btn btn-danger btn-ok">{{ __('Delete') }}</a>
                </div>
            </div>
        </div>
    </div>
    <!-- Make Premium Modal -->
    <div class="modal fade" id="makePremiumModal" tabindex="-1" role="dialog" aria-labelledby="makePremiumModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content border-0 shadow-lg">
                <div class="modal-header bg-warning text-white">
                    <h5 class="modal-title font-weight-bold" id="makePremiumModalLabel">
                        <i class="fas fa-star mr-2"></i> {{ __('Make Listing Premium') }}
                    </h5>
                    <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>

                <div class="modal-body text-center">
                    <div id="premium-credit-info">
                        <div class="mb-3">
                            <h6 class="text-dark">
                                <strong>{{ __('Available Credits:') }}</strong>
                                <span class="badge badge-pill badge-primary ml-2" id="availableCredit">
                                    {{ $availableCredit ?? '--' }}
                                </span>
                            </h6>
                        </div>

                        <div class="mb-4 text-muted" id="premiumMessage">
                            <i class="fas fa-info-circle text-warning mr-1"></i>
                            {{ __('Use 1 available credit to make this listing premium and activate this post.') }}
                        </div>

                        <input type="hidden" id="premiumPropertyId" value="">
                    </div>
                </div>

                <div class="modal-footer justify-content-center">
                    <button type="button" class="btn btn-outline-secondary" data-dismiss="modal">
                        {{ __('Cancel') }}
                    </button>
                    <button type="button" class="btn btn-warning font-weight-bold" id="confirmMakePremium">
                        <i class="fas fa-bolt mr-1"></i> {{ __('Activate with Paid Listing') }}
                    </button>
                </div>
            </div>
        </div>
    </div>
    <!-- Rejection Reason Modal -->
    <div class="modal fade" id="rejectionReasonModal" tabindex="-1" role="dialog"
        aria-labelledby="rejectionReasonModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header text-center">
                    <h5 class="text-primary " id="rejectionReasonModalLabel">{{ __('Property Rejection Message') }}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p id="rejectionReasonText" class="text-center"></p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" data-dismiss="modal">{{ __('Close') }}</button>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script type="text/javascript">
        "use strict";
        var table = $('#geniustable').DataTable({
            ordering: true,
            processing: true,
            serverSide: true,
            searching: true,
            lengthMenu: [
                [10, 50, 100, 200, 300, 500, 1000, 2000, 5000, 10000],
                [10, 50, 100, 200, 300, 500, 1000, 2000, 5000, 10000]
            ], // Enable horizontal scroll
            ajax: {
                url: "{{ route('agent.properties.datatables', ['status' => 'all']) }}",
                data: function(d) {
                    // Sale filter
                    d.sale_id = $('input[name="sale_filter"]:checked').val();
                    // PG filter
                    if ($('input[name="pg_filter"]:checked').length) {
                        d.sale_id = $('input[name="pg_filter"]:checked').val();
                    }
                }
            },
            columns: [{
                    data: 'photo',
                    name: 'photo',
                    searchable: false,
                    orderable: false
                },
                {
                    data: 'name',
                    name: 'name'
                },
                {
                    data: 'category_id',
                    name: 'category_id'
                },
                {
                    data: 'location_id',
                    name: 'location_id'
                },
                {
                    data: 'created_at',
                    name: 'created_at'
                },
                {
                    data: 'updated_at',
                    name: 'updated_at'
                },
                {
                    data: 'status',
                    name: 'status'
                },
                {
                    data: 'is_primium',
                    name: 'is_primium',
                    render: function(data) {
                        if (data == 1) {
                            return 'Premium';
                        } else if (data == 2) {
                            return 'Expired';
                        } else {
                            return 'Free';
                        }
                    }
                },
                {
                    data: 'action',
                    searchable: false,
                    orderable: false
                }
            ],
            language: {
                processing: '<img src="{{ asset('assets/images/' . $gs->admin_loader) }}">'
            }
        });
        // Make datatable horizontally draggable
        $(document).ready(function() {
            var tableWrapper = $('.dataTables_scrollBody');
            var isDown = false,
                startX, scrollLeft;
            tableWrapper.on('mousedown', function(e) {
                isDown = true;
                startX = e.pageX - tableWrapper.offset().left;
                scrollLeft = tableWrapper.scrollLeft();
            });
            tableWrapper.on('mouseleave mouseup', function() {
                isDown = false;
            });
            tableWrapper.on('mousemove', function(e) {
                if (!isDown) return;
                e.preventDefault();
                var x = e.pageX - tableWrapper.offset().left;
                var walk = (x - startX) * 1.5;
                tableWrapper.scrollLeft(scrollLeft - walk);
            });
        });

        $(function() {
            $(".btn-area").append('<div class="col-sm-12 col-md-4 pr-3 text-right">' +
                '<a class="btn btn-primary" href="{{ route('agent.properties.step_1', ['id' => null]) }}">' +
                '<i class="fas fa-plus"></i> {{ __('Post Property') }}' +
                '</a>' +
                '</div>');

            // Handle rejection reason button clicks
            $(document).on('click', '.view-rejection-reason', function() {
                var reason = $(this).data('reason');
                $('#rejectionReasonText').text(reason);
                $('#rejectionReasonModal').modal('show');
            });

            // Ensure Bootstrap 4 modal dismiss functionality works
            $(document).on('click', '[data-dismiss="modal"]', function() {
                $(this).closest('.modal').modal('hide');
            });

            // Additional fallback for close buttons
            $('.modal .close, .modal .btn-secondary').on('click', function() {
                $(this).closest('.modal').modal('hide');
            });

            // Make Premium button click
            $(document).on('click', '.make-premium-btn', function() {
                var propertyId = $(this).data('id');
                $('#premiumPropertyId').val(propertyId);
                // Show the credit scores from the page (already rendered by blade)
                $('#totalCredit').text('{{ $totalCredit ?? '--' }}');
                $('#availableCredit').text('{{ $availableCredit ?? '--' }}');
                $('#makePremiumModal').modal('show');
            });
            // Confirm Make Premium
            $('#confirmMakePremium').on('click', function() {
                var propertyId = $('#premiumPropertyId').val();
                var btn = $(this);
                btn.prop('disabled', true).text('Processing...');
                $.ajax({
                    url: "{{ route('agent.properties.makePremium') }}",
                    method: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        property_id: propertyId
                    },
                    success: function(response) {
                        btn.prop('disabled', false).text('Use Credit & Activate');
                        $('#makePremiumModal').modal('hide');
                        table.ajax.reload();
                        if (response.success) {
                            toastr.success(response.message);
                        } else {
                            toastr.error(response.message || 'Failed to make premium.');
                        }
                    },
                    error: function() {
                        btn.prop('disabled', false).text('Use Credit & Activate');
                        toastr.error('Server error.');
                    }
                });
            });
        });
        $(document).on('change', 'input[name="sale_filter"], input[name="pg_filter"]', function() {
            // Ensure only one filter is active at a time
            if ($(this).attr('name') === 'pg_filter') {
                $('input[name="sale_filter"]').prop('checked', false);
                $(this).prop('checked', true);
            } else {
                $('input[name="pg_filter"]').prop('checked', false);
                $(this).prop('checked', true);
            }
            table.ajax.reload();
        });
        $('#makePremiumModal').on('hidden.bs.modal', function() {
            $('body').removeClass('modal-open');
            $('.modal-backdrop').remove();
        });
    </script>
@endsection
