@extends('layouts.agent')
@push('css')
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
@endpush
@section('content')
<div class="card">
    <div class="d-flex justify-content-center">
        @php
        $steps = [
        1 => 'Basic Details',
        2 => 'Property Details',
        3 => 'Location Details',
        4 => 'Photos & Videos',
        ];
        $currentStep = request()->route()->getName();
        preg_match('/step_(\d+)/', $currentStep, $matches);
        $activeStep = isset($matches[1]) ? (int) $matches[1] : 1;
        @endphp
        <div class="steps-container my-1">
            @foreach ($steps as $step => $label)
            <div class="step-item">
                <a href="#" class="step-circle {{ $step == $activeStep ? 'active' : '' }}">
                    {{ $step }}
                </a>
                <span class="step-label">{{ $label }}</span>
                @if ($step < count($steps))
                    <div class="step-line">
            </div>
            @endif
        </div>
        @endforeach
    </div>
</div>
</div>
<div class=" row justify-content-center mt-3">
    <div class="p-4 col-md-12">
        <form id="addressForm"
            action="{{ isset($property->id) ? route('agent.properties.store_office', ['id' => $property->id]) : route('agent.properties.store_office') }}"
            method="POST">
            {{ csrf_field() }}
            <div class="col-md-12">
                <x-normal-input label="Name" name="name" type="text" placeholder="Property Name"
                    :value="old('name', $property->name ?? '')" />

                <x-radio-group name="sale_type" label="Sale Type" :options="['new-booking' => 'New Booking', 'resale' => 'Resale']" :selected="old('sale_type', $property->sale_type ?? null)" />

                <x-construction-status label="Construction Status" :constructionStatus="old('construction_status', $property->construction_status ?? '')" :possessionDate="old('possession_date', $property->possession_date ?? null)" :propertyAge="old('property_age', $property->property_age ?? null)"
                    :property="$property" possessionDateLabel="Possession Date" />

                <x-radio-group label="Furnish Type " name="furnish_type" :options="[
                        'fully-furnished' => 'Fully Furnished',
                        'semi-furnished' => 'Semi Furnished',
                        'unfurnished' => 'Unfurnished',
                    ]" :selected="old('furnish_type', $property->furnish_type ?? null)" />

                <x-normal-input label="Built Up Area" name="built_up_area" type="number" placeholder="Enter area"
                    :value="old('built_up_area', $property->built_up_area ?? '')" data-unit-dependent="true" :unitSelectEnabled="true" />

                <x-normal-input label="Carpet Area" name="carpet_area" type="number" placeholder="" :value="old('carpet_area', $property->carpet_area ?? '')"
                    data-unit-dependent="true" />

                <div class="card my-1">
                    <div class="card-body">
                        <x-floor-selector :totalFloors="old('total_floors', $property->total_floors ?? null)" :propertyOnFloor="old('property_on_floor', $property->property_on_floor ?? null)" />

                    </div>
                </div>
                <x-located-inside-select label="Located Inside" name="located_inside" :options="[
                        'it_park' => 'IT Park',
                        'business_park' => 'Business Park',
                    ]"
                    :selected="old('located_inside', $property->located_inside ?? null)" :otherValue="old('other_located_inside', $property->other_located_inside ?? '')" />

                <x-radio-group label="Zone Type" name="zone_type" :options="[
                        'industrial' => 'Industrial',
                        'commercial' => 'Commercial',
                        'residential' => 'Residential',
                        'special-economic-zone' => 'Special Economic Zone',
                        'open-space' => 'Open Space',
                        'agricultural-zone' => 'Agricultural Zone',
                    ]" :selected="old('zone_type', $property->zone_type ?? null)" />

                <x-near-by-field label="Address Near By Facility ( 2 Facilities are mandatory )" :facilities="$facilities ?? []"
                    :facilityDistances="$facility_distances ?? []" />

                <div class="card my-1">
                    <div class="card-body">
                        @if ($attributes)
                        @foreach ($attributes as $key => $attribute)
                        @if ($attribute->name === 'Amenities For Commercial')
                        <div class="" id="attribute-{{ $key }}">
                            <div
                                class="d-flex flex-row align-items-center justify-content-between">
                                <h6>Amenities For Commercial <span class="">( 2 Amenities are mandatory )</span></h6>
                            </div>
                            <div class="checkbox-button-group">
                                @if ($attribute->options)
                                @foreach ($attribute->options as $okey => $option)
                                <div class="checkbox-button">
                                    <input type="checkbox" name="attributes[{{ $attribute->name }}][]"
                                        value="{{ $option->id }}"
                                        id="{{ $attribute->name }}-option-{{ $okey }}"
                                        {{ in_array($option->id, old('attributes.' . $attribute->name, $data_attributes[$attribute->name] ?? [])) ? 'checked' : '' }}>
                                    <label for="{{ $attribute->name }}-option-{{ $okey }}">
                                        @if ($option->icon)
                                        <i class="{{ $option->icon }}"></i>
                                        @endif
                                        {{ $option->name }}
                                    </label>
                                </div>
                                @endforeach
                                @endif
                                @error('attributes')
                                <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                            {{-- JS validation error placeholder --}}
                            <div class="attribute-error text-danger small mt-2" style="display: none;">
                                Please select at least 2 options.
                            </div>
                        </div>
                        @endif
                        @endforeach
                        @endif
                    </div>
                </div>

                <x-radio-group label="Ownership" name="ownership" :options="[
                        'pre-holder' => 'Pre-Holder',
                        'lease-holder' => 'Lease-Holder',
                        'co-operative-society' => 'Co-Operative Society',
                        'power-of-attorney' => 'Power of Attorney',
                    ]" :selected="old('ownership', $property->ownership ?? null)" />


                <x-normal-input label="Price Per " name="price_per_sqft" type="number" placeholder=""
                    :value="old('price_per_sqft', $property->price_per_sqft ?? '')" data-unit-dependent="true" />

                <x-normal-input label="Property Expected Price ( in Rs )" name="price" type="number" placeholder=""
                    :value="old('price', $property->price ?? '')" />

                <div class="d-flex justify-content-center my-3 gap-2">
                    <a href="{{ route('agent.properties.step_1', $property->id ?? null) }}" id="back-btn"
                        class="btn btn-secondary w-25">{{ __('Back') }}</a>
                    <button type="submit" id="submit-btn"
                        class="btn btn-primary w-25 mx-2">{{ __('Save & Next') }}</button>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection
@section('scripts')
<script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
<script>
    document.querySelector('form').addEventListener('submit', function(e) {
        let group = document.querySelector('[id^="attribute-"]'); // only for Amenities For Commercial
        const checkboxes = group.querySelectorAll('input[type="checkbox"]:checked');
        const errorDiv = group.querySelector('.attribute-error');

        if (checkboxes.length < 2) {
            e.preventDefault();
            errorDiv.style.display = 'block'; // show error under inputs
        } else {
            errorDiv.style.display = 'none'; // hide if valid
        }
    });
</script>
@endsection