@extends('layouts.agent')
@push('css')
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
@endpush
@section('content')
<div class="card">
    <div class="d-flex justify-content-center">
        @php
        $steps = [
        1 => 'Basic Details',
        2 => 'Property Details',
        3 => 'Location Details',
        4 => 'Photos & Videos',
        ];
        $currentStep = request()->route()->getName();
        preg_match('/step_(\d+)/', $currentStep, $matches);
        $activeStep = isset($matches[1]) ? (int) $matches[1] : 1;
        @endphp
        <div class="steps-container my-1">
            @foreach ($steps as $step => $label)
            <div class="step-item">
                <a href="#" class="step-circle {{ $step == $activeStep ? 'active' : '' }}">
                    {{ $step }}
                </a>
                <span class="step-label">{{ $label }}</span>
                @if ($step < count($steps))
                    <div class="step-line">
            </div>
            @endif
        </div>
        @endforeach
    </div>
</div>
</div>
<div class=" row justify-content-center mt-3">
    <div class="p-4 col-md-12">
        <form id="addressForm"
            action="{{ isset($property->id) ? route('agent.properties.store_office', ['id' => $property->id]) : route('agent.properties.store_office') }}"
            method="POST">
            {{ csrf_field() }}
            <div class="col-md-12">
                <x-normal-input label="Name" name="name" type="text" placeholder="Property Name"
                    :value="old('name', $property->name ?? '')" />

                <x-radio-group name="sale_type" label="Sale Type" :options="['new-booking' => 'New Booking', 'resale' => 'Resale']" :selected="old('sale_type', $property->sale_type ?? null)" />

                <x-construction-status label="Construction Status" :constructionStatus="old('construction_status', $property->construction_status ?? '')" :possessionDate="old('possession_date', $property->possession_date ?? null)" :propertyAge="old('property_age', $property->property_age ?? null)"
                    :property="$property" possessionDateLabel="Possession Date" />


                <x-radio-group label="Furnish Type " name="furnish_type" :options="[
                        'fully-furnished' => 'Fully Furnished',
                        'semi-furnished' => 'Semi Furnished',
                        'unfurnished' => 'Unfurnished',
                    ]" :selected="old('furnish_type', $property->furnish_type ?? null)" />

                <x-normal-input label="Built Up Area" name="built_up_area" type="number" placeholder="Enter area"
                    :value="old('built_up_area', $property->built_up_area ?? '')" data-unit-dependent="true" :unitSelectEnabled="true" />

                <x-normal-input label="Carpet Area" name="carpet_area" type="number" placeholder="" :value="old('carpet_area', $property->carpet_area ?? '')"
                    data-unit-dependent="true" />

                <div class="card my-1">
                    <div class="card-body">
                        <x-floor-selector :totalFloors="old('total_floors', $property->total_floors ?? null)" :propertyOnFloor="old('property_on_floor', $property->property_on_floor ?? null)" />
                    </div>
                </div>
                <div class="card" id="located_inside">
                    <div class="card-body">
                        <div class="form-group">
                            <h6 class="my-2">{{ __('Located Inside') }}</h6>
                            <div class="d-flex flex-wrap">
                                <div>
                                    <input type="radio" id="it_park" name="located_inside" value="it-park"
                                        {{ old('located_inside', isset($property) ? $property->located_inside : '') == 'it-park' ? 'checked' : '' }}>
                                    <label for="it_park">&nbsp;IT Park &nbsp;</label>

                                    <input type="radio" id="business_park" name="located_inside" value="business-park"
                                        {{ old('located_inside', isset($property) ? $property->located_inside : '') == 'business-park' ? 'checked' : '' }}>
                                    <label for="business_park">&nbsp;Business Park &nbsp;</label>

                                    <input type="radio" id="other_option" name="located_inside" value="other"
                                        {{ old('located_inside', isset($property) ? $property->located_inside : '') == 'other' ? 'checked' : '' }}>
                                    <label for="other_option">&nbsp;Other &nbsp;</label>
                                </div>
                            </div>

                            <!-- Error message -->
                            @error('located_inside')
                            <small class="text-danger">{{ $message }}</small>
                            @enderror
                        </div>

                        <!-- Other value input field (Initially Hidden) -->
                        <div class="mb-3" id="other-located-input" style="display: none;">
                            <input type="text" class="form-control" id="other_located_inside"
                                name="other_located_inside" placeholder="other ( located inside )"
                                value="{{ old('other_located_inside', isset($property) ? $property->other_located_inside : '') }}">
                        </div>
                    </div>
                </div>

                <div class="card" id="zone_type">
                    <div class="card-body">
                        <div class="form-group">
                            <h6 class="my-2">{{ __('Zone Type') }}</h6>
                            <div class="d-flex flex-wrap">
                                <div>
                                    <input type="radio" id="industrial" name="zone_type" value="industrial"
                                        {{ old('zone_type', isset($property) ? $property->zone_type : '') == 'industrial' ? 'checked' : '' }}>
                                    <label for="industrial">&nbsp;Industrial &nbsp;</label>

                                    <input type="radio" id="commercial" name="zone_type" value="commercial"
                                        {{ old('zone_type', isset($property) ? $property->zone_type : '') == 'commercial' ? 'checked' : '' }}>
                                    <label for="commercial">&nbsp;Commercial &nbsp;</label>

                                    <input type="radio" id="residential" name="zone_type" value="residential"
                                        {{ old('zone_type', isset($property) ? $property->zone_type : '') == 'residential' ? 'checked' : '' }}>
                                    <label for="residential">&nbsp;Residential &nbsp;</label>

                                    <input type="radio" id="special_economic_zone" name="zone_type"
                                        value="special-economic-zone"
                                        {{ old('zone_type', isset($property) ? $property->zone_type : '') == 'special-economic-zone' ? 'checked' : '' }}>
                                    <label for="special_economic_zone">&nbsp;Special Economic Zone &nbsp;</label>

                                    <input type="radio" id="open_space" name="zone_type" value="open-space"
                                        {{ old('zone_type', isset($property) ? $property->zone_type : '') == 'open-space' ? 'checked' : '' }}>
                                    <label for="open_space">&nbsp;Open Space &nbsp;</label>

                                    <input type="radio" id="agricultural_zone" name="zone_type"
                                        value="agricultural-zone"
                                        {{ old('zone_type', isset($property) ? $property->zone_type : '') == 'agricultural-zone' ? 'checked' : '' }}>
                                    <label for="agricultural_zone">&nbsp;Agricultural Zone &nbsp;</label>

                                    <input type="radio" id="other_zone" name="zone_type" value="other"
                                        {{ old('zone_type', isset($property) ? $property->zone_type : '') == 'other' ? 'checked' : '' }}>
                                    <label for="other_zone">&nbsp;Other &nbsp;</label>
                                </div>
                            </div>
                            <!-- Error message -->
                            @error('zone_type')
                            <small class="text-danger">{{ $message }}</small>
                            @enderror
                        </div>
                    </div>
                </div>
                <x-near-by-field label="Address Near By Facility ( 2 Facilities are mandatory )" :facilities="$facilities ?? []"
                    :facilityDistances="$facility_distances ?? []" />
                <div class="card my-1">
                    <div class="card-body">
                        @if ($attributes)
                        @foreach ($attributes as $key => $attribute)
                        @if ($attribute->name === 'Amenities For Commercial')
                        <div class="" id="attribute-{{ $key }}">
                            <div
                                class="d-flex flex-row align-items-center justify-content-between">
                                <h6>Amenities For Commercial <span class="">( 2 Amenities are mandatory )</span></h6>
                            </div>
                            <div class="checkbox-button-group">
                                @if ($attribute->options)
                                @foreach ($attribute->options as $okey => $option)
                                <div class="checkbox-button">
                                    <input type="checkbox" name="attributes[{{ $attribute->name }}][]"
                                        value="{{ $option->id }}"
                                        id="{{ $attribute->name }}-option-{{ $okey }}"
                                        {{ in_array($option->id, old('attributes.' . $attribute->name, $data_attributes[$attribute->name] ?? [])) ? 'checked' : '' }}>
                                    <label for="{{ $attribute->name }}-option-{{ $okey }}">
                                        @if ($option->icon)
                                        <i class="{{ $option->icon }}"></i>
                                        @endif
                                        {{ $option->name }}
                                    </label>
                                </div>
                                @endforeach
                                @endif
                                @error('attributes')
                                <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                            {{-- JS validation error placeholder --}}
                            <div class="attribute-error text-danger small mt-2" style="display: none;">
                                Please select at least 2 options.
                            </div>
                        </div>
                        @endif
                        @endforeach
                        @endif
                    </div>
                </div>

                <x-radio-group label="Ownership" name="ownership" :options="[
                        'pre-holder' => 'Pre-Holder',
                        'lease-holder' => 'Lease-Holder',
                        'co-operative-society' => 'Co-Operative Society',
                        'power-of-attorney' => 'Power of Attorney',
                    ]" :selected="old('ownership', $property->ownership ?? null)" />

                <x-normal-input label="Price Per " name="price_per_sqft" type="number" placeholder=""
                    :value="old('price_per_sqft', $property->price_per_sqft ?? '')" data-unit-dependent="true" />

                <x-normal-input label="Property Expected Price ( in Rs )" name="price" type="number"
                    placeholder="" :value="old('price', $property->price ?? '')" />

                <div class="d-flex justify-content-center my-3 gap-2">
                    <a href="{{ route('agent.properties.step_1', $property->id ?? null) }}" id="back-btn"
                        class="btn btn-secondary w-25">{{ __('Back') }}</a>
                    <button type="submit" id="submit-btn"
                        class="btn btn-primary w-25 mx-2">{{ __('Save & Next') }}</button>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection
@section('scripts')
<script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
<script>
    document.querySelector('form').addEventListener('submit', function(e) {
        let group = document.querySelector('[id^="attribute-"]'); // only for Amenities For Commercial
        const checkboxes = group.querySelectorAll('input[type="checkbox"]:checked');
        const errorDiv = group.querySelector('.attribute-error');

        if (checkboxes.length < 2) {
            e.preventDefault();
            errorDiv.style.display = 'block'; // show error under inputs
        } else {
            errorDiv.style.display = 'none'; // hide if valid
        }
    });
</script>
@endsection