@extends('layouts.agent')
@push('css')
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
@endpush
@section('content')
    <div class="card">
        <div class="d-flex justify-content-center">
            @php
                $steps = [
                    1 => 'Basic Details',
                    2 => 'Property Details',
                    3 => 'Location Details',
                    4 => 'Photos & Videos',
                ];
                $currentStep = request()->route()->getName();
                preg_match('/step_(\d+)/', $currentStep, $matches);
                $activeStep = isset($matches[1]) ? (int) $matches[1] : 1;
            @endphp
            <div class="steps-container my-1">
                @foreach ($steps as $step => $label)
                    <div class="step-item">
                        <a href="#" class="step-circle {{ $step == $activeStep ? 'active' : '' }}">
                            {{ $step }}
                        </a>
                        <span class="step-label">{{ $label }}</span>
                        @if ($step < count($steps))
                            <div class="step-line">
                            </div>
                        @endif
                    </div>
                @endforeach
            </div>
        </div>
    </div>
    <div class="row justify-content-center mt-3">
        <div class="col-md-12">
            <form method="POST"
                action="{{ isset($property->id) ? route('agent.properties.store.pg.step_2', ['id' => $property->id]) : route('agent.properties.store.pg.step_2') }}">
                {{ csrf_field() }}
                <div class="row">
                    <div class="col-md-12">
                        <div class="card my-1">
                            <div class="card-body">
                                <h5 class="mb-3 fw-bold pt-2">PG Details</h5>
                                <x-normal-input-without-card label="PG Name" name="name" type="text"
                                    placeholder="PG Name" :value="old('name', $property->name ?? '')" />
                            </div>
                        </div>
                        <x-normal-input label="Total Beds" name="total_beds" type="number" placeholder=""
                            :value="old('total_beds', $property->total_beds ?? '')" />
                        <div class="card my-1">
                            <div class="card-body">
                                <x-checkbox-group name="pg_for" label="PG is for" :options="['girls' => 'Girls', 'boys' => 'Boys']" :selected="old(
                                    'pg_for',
                                    is_string($property->pg_for ?? '')
                                        ? explode(',', $property->pg_for)
                                        : $property->pg_for ?? [],
                                )" />
                            </div>
                        </div>
                        <div class="card my-1">
                            <div class="card-body">
                                <x-checkbox-group name="suited_for" label="Best suited for" :options="['students' => 'Students', 'professionals' => 'Professionals']"
                                    :selected="old(
                                        'suited_for',
                                        is_string($property->suited_for ?? '')
                                            ? explode(',', $property->suited_for)
                                            : $property->suited_for ?? [],
                                    )" />
                            </div>
                        </div>

                        <div class="card my-1">
                            <div class="card-body">
                                <x-radio-group1 name="meals_available" label="Meals Available" :options="['yes' => 'Yes', 'no' => 'No']"
                                    :selected="old('meals_available', $property->meals_available ?? null)" />
                                <div id="meal-offerings-group" style="display: none;">
                                    <x-checkbox-group name="meal_offerings" :options="['breakfast' => 'Breakfast', 'lunch' => 'Lunch', 'dinner' => 'Dinner']" label="Meal Offerings"
                                        :selected="old(
                                            'meal_offerings',
                                            is_string($property->meal_offerings ?? '')
                                                ? explode(',', $property->meal_offerings)
                                                : $property->meal_offerings ?? [],
                                        )" />

                                    <x-checkbox-group name="meal_speciality" :options="[
                                        'punjabi' => 'Punjabi',
                                        'south_indian' => 'South Indian',
                                        'andhra' => 'Andhra',
                                        'north_indian' => 'North Indian',
                                        'others' => 'Others',
                                    ]"
                                        label="Meal Speciality (Optional)" :selected="old(
                                            'meal_speciality',
                                            is_string($property->meal_speciality ?? '')
                                                ? explode(',', $property->meal_speciality)
                                                : $property->meal_speciality ?? [],
                                        )" />
                                </div>
                            </div>
                        </div>
                        <div class="card my-1">
                            <div class="card-body">
                                <x-normal-input-without-card label="Notice Period (Days)" name="notice_period"
                                    type="number" placeholder="" :value="old('notice_period', $property->notice_period ?? '')" />

                                <x-normal-input-without-card label="Lock in Period (Days)" name="lock_in_period"
                                    type="number" placeholder="" :value="old('lock_in_period', $property->lock_in_period ?? '')" />
                            </div>
                        </div>


                        <div class="card my-1">
                            <div class="card-body">
                                <x-checkbox-group name="common_areas" label="Common Areas" :options="[
                                    'living_room' => 'Living Room',
                                    'kitchen' => 'Kitchen',
                                    'dining_Hall' => 'Dining Hall',
                                    'study_room/library' => 'Study Room / Library',
                                    'breakout_room' => 'Breakout Room',
                                ]"
                                    :selected="old(
                                        'common_areas',
                                        is_string($property->common_areas ?? '')
                                            ? explode(',', $property->common_areas)
                                            : $property->common_areas ?? [],
                                    )" />
                            </div>
                        </div>
                        <div class="card my-1">
                            <div class="card-body">
                                <h5 class="mb-3 fw-bold pt-2">Owner/Caretaker Details</h5>
                                <x-radio-group1 name="caretaker" label="Property Managed By" :options="[
                                    'landlord' => 'Landlord',
                                    'caretaker' => 'Caretaker',
                                    'dedicated_professional' => 'Dedicated Professional',
                                ]"
                                :selected="old('caretaker', $property->caretaker ?? null)" />

                                <x-radio-group1 name="is_manager_stays" label="Property Manager stays at Property"
                                    :options="['yes' => 'Yes', 'no' => 'No']" :selected="old('is_manager_stays', $property->is_manager_stays ?? null)" />
                            </div>
                        </div>


                        <div class="card my-1">
                            <div class="card-body">
                                <h5 class="mb-3 fw-bold pt-2">PG Rules</h5>
                                <x-radio-group1 name="veg_allowed" label="Non-Veg Allowed" :options="['yes' => 'Yes', 'no' => 'No']"
                                    :selected="old('veg_allowed', $property->veg_allowed ?? null)" />
                                <x-radio-group1 name="opposit_sex_allowed" label="Opposit Sex Allowed" :options="['yes' => 'Yes', 'no' => 'No']"
                                    :selected="old('opposit_sex_allowed', $property->opposit_sex_allowed ?? null)" />

                                <x-radio-group1 name="any_time_allowed" label="Any Time Allowed" :options="['yes' => 'Yes', 'no' => 'No']"
                                    :selected="old('any_time_allowed', $property->any_time_allowed ?? null)" />

                                <div id="last_entry_time_wrapper"
                                    style="display: {{ old('any_time_allowed', $property->any_time_allowed ?? null) === 'no' ? 'block' : 'none' }};">
                                    <x-select-group name="last_entry_time" label="Last Time Entry" :options="[
                                        '6:30' => '6:30 PM',
                                        '7:00 PM' => '7:00 PM',
                                        '7:30 PM' => '7:30 PM',
                                        '8:00 PM' => '8:00 PM',
                                        '8:30 PM' => '8:30 PM',
                                        '9:00 PM' => '9:00 PM',
                                        '9:30 PM' => '9:30 PM',
                                        '10:00 PM' => '10:00 PM',
                                        '10:30 PM' => '10:30 PM',
                                        '11:00 PM' => '11:00 PM',
                                        '11:30 PM' => '11:30 PM',
                                        '12:00 AM' => '12:00 AM',
                                        '12:30 AM' => '12:30 AM',
                                        '1:00 AM' => '1:00 AM',
                                        '1:30 AM' => '1:30 AM',
                                        '2:00 AM' => '2:00 AM',
                                    ]"
                                        :selected="old('last_entry_time', $property->last_entry_time ?? '')" />
                                </div>

                                <x-radio-group1 name="visitors_allowed" label="Visitors Allowed" :options="['yes' => 'Yes', 'no' => 'No']"
                                    :selected="old('visitors_allowed', $property->visitors_allowed ?? null)" />
                                <x-radio-group1 name="guardians_allowed" label="Guardians Allowed" :options="['yes' => 'Yes', 'no' => 'No']"
                                    :selected="old('guardians_allowed', $property->guardians_allowed ?? null)" />
                                <x-radio-group1 name="drinking_allowed" label="Drinking Allowed" :options="['yes' => 'Yes', 'no' => 'No']"
                                    :selected="old('drinking_allowed', $property->drinking_allowed ?? null)" />
                                <x-radio-group1 name="smoking_allowed" label="Smoking Allowed" :options="['yes' => 'Yes', 'no' => 'No']"
                                    :selected="old('smoking_allowed', $property->smoking_allowed ?? null)" />
                            </div>
                        </div>
                        <div class="d-flex justify-content-center m-3">
                            <a href="{{ route('agent.properties.step_1', $property->id ?? null) }}" id="back-btn"
                                class="btn btn-secondary w-25">{{ __('Back') }}</a>
                            <button type="submit" id="submit-btn"
                                class="btn btn-primary w-25 mx-2">{{ __('Save & Next') }}</button>
                        </div>
                    </div>
            </form>
        </div>
    </div>
@endsection
@section('scripts')
    <script>
        function toggleMealOfferings() {
            const mealsAvailable = document.querySelector('input[name="meals_available"]:checked');
            const offeringsGroup = document.getElementById('meal-offerings-group');

            if (mealsAvailable && mealsAvailable.value === 'yes') {
                offeringsGroup.style.display = 'block';
            } else {
                offeringsGroup.style.display = 'none';
            }
        }

        document.addEventListener('DOMContentLoaded', function() {
            toggleMealOfferings();

            document.querySelectorAll('input[name="meals_available"]').forEach(radio => {
                radio.addEventListener('change', toggleMealOfferings);
            });
        });
        document.addEventListener('DOMContentLoaded', function() {
            const radios = document.querySelectorAll('input[name="any_time_allowed"]');
            const wrapper = document.getElementById('last_entry_time_wrapper');

            radios.forEach(radio => {
                radio.addEventListener('change', function() {
                    if (this.value === 'no') {
                        wrapper.style.display = 'block';
                    } else {
                        wrapper.style.display = 'none';
                    }
                });
            });
        });
    </script>
@endsection
