@extends('layouts.agent')
@push('css')
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
@endpush
@section('content')
    <div class="card">
        <div class="d-flex justify-content-center">
            @php
                $steps = [
                    1 => 'Basic Details',
                    2 => 'Property Details',
                    3 => 'Location Details',
                    4 => 'Photos & Videos',
                ];
                $currentStep = request()->route()->getName();
                preg_match('/step_(\d+)/', $currentStep, $matches);
                $activeStep = isset($matches[1]) ? (int) $matches[1] : 1;
            @endphp
            <div class="steps-container my-1">
                @foreach ($steps as $step => $label)
                    <div class="step-item">
                        <a href="#" class="step-circle {{ $step == $activeStep ? 'active' : '' }}">
                            {{ $step }}
                        </a>
                        <span class="step-label">{{ $label }}</span>
                        @if ($step < count($steps))
                            <div class="step-line">
                            </div>
                        @endif
                    </div>
                @endforeach
            </div>
        </div>
    </div>
    <div class="row justify-content-center mt-3">
        <div class="col-md-12">
            <form class="" id="property-form"
                action="{{ isset($property->id) ? route('agent.properties.pg_store_step_4', ['id' => $property->id]) : route('agent.properties.pg_store_step_4') }}"
                method="POST" enctype="multipart/form-data">
                {{ csrf_field() }}
                <div class="row">
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul class="mb-0">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    <div class="col-lg-12">
                        <div class="">
                            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                                <h6>{{ __('Property Images') }}</h6>
                            </div>
                            <div class="card-body">
                                <!-- Property Covered Image -->
                                <div class="form-group">
                                    <div class="card-header py-3 d-flex  justify-content-between">
                                        <h6 class="m-0 ">{{ __('Property Covered Image') }}</h6>
                                    </div>
                                    <div class="wrapper-image-preview">
                                        <div class="box">
                                            <div class="back-preview-image"
                                                style="background-image: url({{ $property->photo ? asset('assets/images/' . $property->photo) : asset('assets/images/placeholder.jpg') }});">
                                            </div>
                                            <div class="upload-options">
                                                <label class="img-upload-label" for="img-upload">
                                                    <i class="fas fa-camera"></i> {{ __('Upload Picture') }}
                                                </label>
                                                <input id="img-upload" type="file" class="image-upload" name="photo"
                                                    accept="image">
                                            </div>
                                        </div>
                                    </div><br>

                                    {{-- error message --}}
                                    @if ($errors->has('photo'))
                                        <span class="text-danger">{{ $errors->first('photo') }}</span>
                                    @endif
                                </div>

                                <!-- Property Image Gallery -->
                                <div class="form-group">
                                    <span class="text-primary">Minimum 4 images are mandatory</span><br>
                                    <button type="button" class="btn btn-secondary set-gallery" data-toggle="modal"
                                        data-target="#setgallery" id="myBtn">
                                        <i class="icofont-plus"></i> {{ __('Upload Property Image Gallery') }}
                                    </button>
                                </div>
                                <div id="error-message" class="text-danger" style="display: none;">
                                    Your uploaded images is still less than 4 please upload atleast 4 images.
                                </div>
                            </div>
                        </div>

                        <div class="">
                            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                                <h5 class="text-bold">{{ __('Upload Images for Each Rooms') }}</h5 class="text-bold">
                            </div>
                            <div class="card-body">
                                <div id="floor-plans-container">
                                    @foreach ($rooms as $key => $room)
                                        <div class="card my-3 shadow-sm">
                                            <div class="card-body">
                                                <div class="row g-3 align-items-center">

                                                    {{-- Room Number & Type --}}
                                                    <div class="col-12 col-sm-6 col-md-2">
                                                        <i class="fas fa-door-open fa-2x mb-2"></i>
                                                        <div class="fw-bold">Room {{ $key + 1 }}</div>
                                                        <div class="text-muted small">{{ ucfirst($room->type) }}</div>
                                                    </div>

                                                    {{-- Rent & Deposit --}}
                                                    <div class="col-12 col-sm-6 col-md-3">
                                                        <div><i class="fas fa-rupee-sign me-1"></i> Rent :
                                                            <strong class="text-primary">{{ $room->rent }}</strong>
                                                        </div>
                                                        <div><i class="fas fa-money-bill-wave me-1"></i> Deposit :
                                                            <strong class="text-primary">{{ $room->deposit }}</strong>
                                                        </div>
                                                        <div><i class="fas fa-bed me-1"></i> Total Beds :
                                                            <strong class="text-primary">{{ $room->total_beds }}</strong>
                                                        </div>
                                                    </div>

                                                    {{-- Room Image Preview --}}
                                                    <div class="col-12 col-md-3 ">
                                                        <div class="back-preview-image mb-2 mx-auto"
                                                            style="background-image: url({{ $room->photo ? asset('assets/images/' . $room->photo) . '?t=' . time() : asset('assets/images/placeholder.jpg') }}); height: 120px; width: 150px; background-size: cover; background-position: center; border-radius: 8px;">
                                                        </div>
                                                    </div>

                                                    {{-- Upload Input --}}
                                                    <div class="col-12 col-md-4">
                                                        <input type="hidden" name="room_id[]" value="{{ $room->id }}">
                                                        <div class="form-group">
                                                            <label for="room_images_{{ $room->id }}"
                                                                class="form-label">
                                                                <i class="fas fa-upload me-1"></i> Upload Room Image
                                                            </label>
                                                            <input type="file" name="room_images_{{ $room->id }}"
                                                                class="form-control room-image-input" accept="image/*"
                                                                @if (!$room->photo) required @endif>

                                                            @if (!$room->photo)
                                                                @error("room_images_{$room->id}")
                                                                    <small class="text-danger">{{ $message }}</small>
                                                                @enderror
                                                            @endif
                                                        </div>
                                                    </div>

                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>

                        <div class="d-flex justify-content-center my-3">
                            <a href="{{ route('agent.properties.step_3', $property->id ?? null) }}" id="back-btn"
                                class="btn btn-secondary w-25">{{ __('Back') }}</a>
                            <button type="submit" id="submit-btn"
                                class="btn btn-primary w-25 mx-2">{{ __('Save') }}</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="modal fade" id="setgallery" tabindex="-1" role="dialog" aria-labelledby="setgallery" aria-modal="true">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalCenterTitle">{{ __('Image Gallery') }}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="top-area">
                        <div id="error-message" class="alert alert-danger" style="display: none;">
                            <strong>{{ __('Error!') }}</strong> <span id="error-text"></span>
                        </div>
                        <div class="row">
                            <div class="col-sm-6 text-right">
                                <div class="upload-img-btn">
                                    <form method="POST" enctype="multipart/form-data" id="form-gallery">
                                        {{ csrf_field() }}
                                        <input type="hidden" id="property_id" name="property_id"
                                            value="{{ $property->id }}">
                                        <input type="file" name="gallery[]" class="hidden"
                                            id="property_upload_gallery_edit" accept="image/*" multiple>
                                        <label id="property_gallery_edit" class="pt-2">
                                            <i class="icofont-upload-alt"></i>{{ __('Upload File') }}
                                        </label>
                                    </form>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <a href="javascript:;" class="upload-done" data-dismiss="modal">
                                    <i class="fas fa-check"></i> {{ __('Done') }}
                                </a>
                                <p id="error-text" style="display: none; margin-top: 5px;"></p>
                            </div>
                            <div class="col-sm-12 text-center">
                                <small>{{ __('You can upload multiple Images.') }}</small>
                            </div>
                        </div>
                    </div>
                    <div class="gallery-images">
                        <div class="selected-image">
                            <div class="row">
                                @if ($property->galleries)
                                    @foreach ($property->galleries as $gallery)
                                        <div class="col-sm-6">
                                            <div class="img gallery-img">
                                                <span class="remove-img">
                                                    <i class="fas fa-times"></i>
                                                    <input type="hidden" value="{{ $gallery->id }}">
                                                </span>
                                                <a href="{{ asset('assets/images/' . $gallery->photo) }}"
                                                    target="_blank">
                                                    <img src="{{ asset('assets/images/' . $gallery->photo) }}"
                                                        alt="gallery image" width="100px">
                                                </a>
                                            </div>
                                        </div>
                                    @endforeach
                                @else
                                    <div class="col-12 text-center">
                                        <p>{{ __('No images found.') }}</p>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('scripts')
    <script src="{{ asset('assets/front/js/image_gallary.js') }}"></script>
    <script>
        var mainurl = "{{ url('/') }}";

        $(document).ready(function() {
            // Handle the close button (×) click
            $('#setgallery .close').on('click', function() {
                $('#setgallery').modal('hide');
                cleanupModal();
            });

            // Handle the done button click
            $('.upload-done').on('click', function(e) {
                var uploadedImagesCount = $('.gallery-images .gallery-img').length;
                if (uploadedImagesCount < 4) {
                    alert('Please upload at least 4 images before proceeding.');
                    e.preventDefault();
                } else {
                    $('#setgallery').modal('hide');
                    cleanupModal();
                }
            });

            // Common function to clean up modal
            function cleanupModal() {
                $('body').removeClass('modal-open');
                $('.modal-backdrop').remove();
                $('#form-gallery')[0].reset();
                $('#property_upload_gallery_edit').val('');
            }

            // Form submission validation
            $('#property-form').on('submit', function(e) {
                var uploadedImagesCount = $('.gallery-images .gallery-img').length;
                if (uploadedImagesCount < 4) {
                    $('#error-message').show();
                    e.preventDefault();
                } else {
                    $('#error-message').hide();
                }
            });
        });
    </script>
@endsection
