@extends('layouts.agent')

@push('css')
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
@endpush
@section('content')
<div class="card">
    <div class="d-flex justify-content-center">
        @php
        $steps = [
        1 => 'Basic Details',
        2 => 'Property Details',
        3 => 'Location Details',
        4 => 'Photos & Videos',
        ];
        $currentStep = request()->route()->getName();
        preg_match('/step_(\d+)/', $currentStep, $matches);
        $activeStep = isset($matches[1]) ? (int) $matches[1] : 1;
        @endphp
        <div class="steps-container my-1">
            @foreach ($steps as $step => $label)
            <div class="step-item">
                <a href="#" class="step-circle {{ $step == $activeStep ? 'active' : '' }}">
                    {{ $step }}
                </a>
                <span class="step-label">{{ $label }}</span>
                @if ($step < count($steps))
                    <div class="step-line">
            </div>
            @endif
        </div>
        @endforeach
    </div>
</div>
</div>
<div class="row justify-content-center mt-3">
    <div class="col-md-12">
        <form method="POST"
            action="{{ isset($property->id) ? route('agent.properties.store_resi_rent', ['id' => $property->id]) : route('agent.properties.store_resi_rent') }}">
            {{ csrf_field() }}
            <div class="row">
                <div class="col-md-12">
                    <x-normal-input label="Name" name="name" type="text" placeholder="Property Name"
                        :value="old('name', $property->name ?? '')" />

                    <x-construction-status label="Possession Status" :constructionStatus="old('construction_status', $property->construction_status ?? '')" :possessionDate="old('possession_date', $property->possession_date ?? null)"
                        :propertyAge="old('property_age', $property->property_age ?? null)" :property="$property" possessionDateLabel="Available from" />

                    <x-radio-group label="No. of BHK" name="no_of_bhk" :options="[
                            '1-RK',
                            '1-BHK',
                            '1.5-BHK',
                            '2-BHK',
                            '2.5-BHK',
                            '3-BHK',
                            '3.5-BHK',
                            '4-BHK',
                            '4.5-BHK',
                            '5-BHK',
                            '6-BHK',
                            '6+ BHK',
                        ]" :selected="old('no_of_bhk', isset($property) ? $property->no_of_bhk : '')" />

                    <x-radio-group label="No. of Bathrooms" name="no_of_bathroom" :options="[1, 2, 3, 4, 5]" :selected="old('no_of_bathroom', $property->no_of_bathroom ?? null)" />

                    <x-radio-group label="No. of Balcony" name="no_of_balcony" :options="[1, 2, 3, 4, 5, 6]" :selected="old('no_of_balcony', $property->no_of_balcony ?? null)" />

                    <x-radio-group label="Covered Parking" name="covered_parking" :options="[1, 2, 3, '3+']"
                        :selected="old('covered_parking', $property->covered_parking ?? null)" />

                    <x-radio-group label="Open Parking" name="open_parking" :options="[1, 2, 3, '3+']" :selected="old('open_parking', $property->open_parking ?? null)" />

                    <x-radio-group label="Furnish Type " name="furnish_type" :options="[
                            'fully-furnished' => 'Fully Furnished',
                            'semi-furnished' => 'Semi Furnished',
                            'unfurnished' => 'Unfurnished',
                        ]" :selected="old('furnish_type', $property->furnish_type ?? null)" />

                    <x-normal-input label="Built Up Area" name="built_up_area" type="number" placeholder="Enter area"
                        :value="old('built_up_area', $property->built_up_area ?? '')" data-unit-dependent="true" :unitSelectEnabled="true" :selectedUnit="old('area_unit', $property->area_unit ?? 'sqft')" />

                    <x-normal-input label="Carpet Area" name="carpet_area" type="number" placeholder=""
                        :value="old('carpet_area', $property->carpet_area ?? '')" data-unit-dependent="true" />


                    <div class="card my-1">
                        <div class="card-body">
                            <x-floor-selector :totalFloors="old('total_floors', $property->total_floors ?? null)" :propertyOnFloor="old('property_on_floor', $property->property_on_floor ?? null)" />
                        </div>
                    </div>
                    <x-near-by-field label="Address Near By Facility ( 2 Facilities are mandatory )" :facilities="$facilities ?? []"
                        :facilityDistances="$facility_distances ?? []" />

                    <div class="card my-1">
                        <div class="card-body">
                            @if ($attributes)
                            @foreach ($attributes as $key => $attribute)
                            @if ($attribute->name === 'Amenities')
                            <div class="" id="attribute-{{ $key }}">
                                <div
                                    class="d-flex flex-row align-items-center justify-content-between">
                                    <h6>Amenities For Residential <span class="">( 2 Amenities are mandatory )</span></h6>
                                </div>
                                <div class="checkbox-button-group">
                                    @if ($attribute->options)
                                    @foreach ($attribute->options as $okey => $option)
                                    <div class="checkbox-button">
                                        <input type="checkbox" name="attributes[{{ $attribute->name }}][]"
                                            value="{{ $option->id }}"
                                            id="{{ $attribute->name }}-option-{{ $okey }}"
                                            {{ in_array($option->id, old('attributes.' . $attribute->name, $data_attributes[$attribute->name] ?? [])) ? 'checked' : '' }}>
                                        <label for="{{ $attribute->name }}-option-{{ $okey }}">
                                            @if ($option->icon)
                                            <i class="{{ $option->icon }}"></i>
                                            @endif
                                            {{ $option->name }}
                                        </label>
                                    </div>
                                    @endforeach
                                    @endif
                                    @error('attributes')
                                    <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                                {{-- JS validation error placeholder --}}
                            <div class="attribute-error text-danger small mt-2" style="display: none;">
                                Please select at least 2 options.
                            </div>
                            </div>
                            @endif
                            @endforeach
                            @endif
                        </div>
                    </div>

                   <x-normal-input label="Property Expected Monthly Rent Price ( In Rs )" name="price" type="number"
                            placeholder="" :value="old('price', $property->price ?? '')" />

                        <div class="d-flex justify-content-center my-3">
                            <a href="{{ route('agent.properties.step_1', $property->id ?? null) }}" id="back-btn"
                                class="btn btn-secondary w-25">{{ __('Back') }}</a>
                            <button type="submit" id="submit-btn"
                                class="btn btn-primary w-25 mx-2">{{ __('Save & Next') }}</button>
                    </div>
                </div>
        </form>
    </div>
</div>
@endsection
@section('scripts')
<script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
<script>
    document.querySelector('form').addEventListener('submit', function(e) {
        let group = document.querySelector('[id^="attribute-"]'); // only for Amenities For Commercial
        const checkboxes = group.querySelectorAll('input[type="checkbox"]:checked');
        const errorDiv = group.querySelector('.attribute-error');

        if (checkboxes.length < 2) {
            e.preventDefault();
            errorDiv.style.display = 'block'; // show error under inputs
        } else {
            errorDiv.style.display = 'none'; // hide if valid
        }
    });
</script>
@endsection