@extends('layouts.agent')
@push('css')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
@endpush
@section('content')
    <div class="card">
        <div class="d-flex justify-content-center">
            @php
                $steps = [
                    1 => 'Basic Details',
                    2 => 'Property Details',
                    3 => 'Location Details',
                    4 => 'Photos & Videos',
                ];
                $activeStep = 2;
            @endphp
            <div class="steps-container my-1">
                @foreach ($steps as $step => $label)
                    <div class="step-item">
                        <a href="#" class="step-circle {{ $step == $activeStep ? 'active' : '' }}">
                            {{ $step }}
                        </a>
                        <span class="step-label">{{ $label }}</span>
                        @if ($step < count($steps))
                            <div class="step-line"></div>
                        @endif
                    </div>
                @endforeach
            </div>
        </div>
    </div>
    <div class="row justify-content-center mt-3">
        <div class="col-md-12">
            <form method="POST"
                action="{{ isset($property->id) ? route('agent.properties.store.amenities', ['id' => $property->id]) : route('agent.properties.store.amenities') }}">
                {{ csrf_field() }}
                <div class="row">
                    <div class="col-md-12">
                        @if ($attributes)
                            @foreach ($attributes as $key => $attribute)
                                <div class="" id="attribute-{{ $key }}">
                                    <div
                                        class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                                        <h6>{{ $attribute->name }}
                                        </h6>
                                    </div>
                                    <div class="card-body">
                                        <div class="checkbox-button-group">
                                            @if ($attribute->options)
                                                @foreach ($attribute->options as $okey => $option)
                                                    <div class="checkbox-button">
                                                        <input type="checkbox" name="attributes[{{ $attribute->name }}][]"
                                                            value="{{ $option->id }}"
                                                            id="{{ $attribute->name }}-option-{{ $okey }}"
                                                            {{ in_array($option->id, old('attributes.' . $attribute->name, $data_attributes[$attribute->name] ?? [])) ? 'checked' : '' }}>
                                                        <label for="{{ $attribute->name }}-option-{{ $okey }}">
                                                            @if ($option->icon)
                                                                <i class="{{ $option->icon }}"></i>
                                                            @endif
                                                            {{ $option->name }}
                                                        </label>
                                                    </div>
                                                @endforeach
                                            @endif
                                            @error('attributes')
                                                <div class="text-danger">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        @endif
                        <div class="d-flex justify-content-center my-3">
                            <a href="{{ url('/seller/properties/pg-rooms/'. $property->id ?? null) }}" id="back-btn"
                                class="btn btn-secondary w-25">{{ __('Back') }}</a>
                            <button type="submit" id="submit-btn"
                                class="btn btn-primary w-25 mx-2">{{ __('Save & Next') }}</button>
                        </div>
                    </div>
            </form>
        </div>
    </div>
@endsection
