@extends('layouts.agent')
@push('css')
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
@endpush
@section('content')
    <div class="card">
        <div class="d-flex justify-content-center">
            @php
                $steps = [
                    1 => 'Basic Details',
                    2 => 'Property Details',
                    3 => 'Location Details',
                    4 => 'Photos & Videos',
                ];
                $currentStep = request()->route()->getName();
                preg_match('/step_(\d+)/', $currentStep, $matches);
                $activeStep = isset($matches[1]) ? (int) $matches[1] : 1;
            @endphp
            <div class="steps-container my-1">
                @foreach ($steps as $step => $label)
                    <div class="step-item">
                        <a href="#" class="step-circle {{ $step == $activeStep ? 'active' : '' }}">
                            {{ $step }}
                        </a>
                        <span class="step-label">{{ $label }}</span>
                        @if ($step < count($steps))
                            <div class="step-line">
                            </div>
                        @endif
                    </div>
                @endforeach
            </div>
        </div>
    </div>
    <div class="row justify-content-center mt-3">
        <div class="col-md-10 mx-5">
            <form method="POST"
                action="{{ isset($property->id) ? route('agent.properties.store.rooms.step_2', ['id' => $property->id]) : route('agent.properties.store.rooms.step_2') }}">
                @csrf
                <div class="row">
                    <div class="col-md-12">
                        <div id="rooms-wrapper">
                            @if (old('rooms', null))
                                @foreach (old('rooms') as $index => $oldRoom)
                                    <div class="card room-card mb-3">
                                        <div class="card-header d-flex justify-content-between align-items-center">
                                            <strong>Room <span class="room-number">{{ $index + 1 }}</span></strong>
                                            <a href="javascript:void(0);" class="text-primary delete-room">Delete</a>
                                        </div>
                                        <div class="card-body">
                                            <div class="mb-3">
                                                <label class="form-label">Room Type</label>
                                                <div class="btn-group d-flex flex-wrap gap-2" role="group">
                                                    @foreach (['Private Room', 'Double Sharing', 'Triple Sharing', '3+ Sharing'] as $typeIndex => $type)
                                                        <input type="radio" class="btn-check"
                                                            name="rooms[{{ $index }}][type]"
                                                            value="{{ $type }}"
                                                            id="type_{{ $index }}_{{ $typeIndex }}"
                                                            autocomplete="off"
                                                            {{ isset($oldRoom['type']) && $oldRoom['type'] === $type ? 'checked' : '' }}>
                                                        <label class="btn btn-outline-primary"
                                                            for="type_{{ $index }}_{{ $typeIndex }}">{{ $type }}</label>
                                                    @endforeach
                                                </div>
                                                @error("rooms.$index.type")
                                                    <small class="text-danger d-block">{{ $message }}</small>
                                                @enderror
                                            </div>

                                            <div class="mb-3">
                                                <label class="form-label">Total Beds in this Room</label>
                                                <input type="number" class="form-control"
                                                    name="rooms[{{ $index }}][total_beds]"
                                                    value="{{ $oldRoom['total_beds'] ?? '' }}">
                                                @error("rooms.$index.total_beds")
                                                    <small class="text-danger d-block">{{ $message }}</small>
                                                @enderror
                                            </div>

                                            <div class="mb-3">
                                                <label class="form-label">Rent</label>
                                                <input type="number" class="form-control"
                                                    name="rooms[{{ $index }}][rent]"
                                                    value="{{ $oldRoom['rent'] ?? '' }}">
                                                @error("rooms.$index.rent")
                                                    <small class="text-danger d-block">{{ $message }}</small>
                                                @enderror
                                            </div>

                                            <div class="mb-3">
                                                <label class="form-label">Security Deposit</label>
                                                <input type="number" class="form-control"
                                                    name="rooms[{{ $index }}][deposit]"
                                                    value="{{ $oldRoom['deposit'] ?? '' }}">
                                                @error("rooms.$index.deposit")
                                                    <small class="text-danger d-block">{{ $message }}</small>
                                                @enderror
                                            </div>

                                            <div class="mb-3">
                                                <label class="form-label">Facilities Offered</label>
                                                <div class="checkbox-button-group">
                                                    @php
                                                        $facilityOptions = [
                                                            'ac' => 'AC',
                                                            'tv_in_room' => 'TV in room',
                                                            'personal_cupboard' => 'Personal Cupboard',
                                                            'table_chair' => 'Table Chair',
                                                            'attached_balcony' => 'Attached Balcony',
                                                            'attached_bathroom' => 'Attached Bathroom',
                                                            'meals_included' => 'Meals Included',
                                                        ];
                                                        $selectedFacilities = old(
                                                            'rooms.' . $index . '.facilities',
                                                            [],
                                                        );
                                                        if (isset($oldRoom['facilities'])) {
                                                            if (is_array($oldRoom['facilities'])) {
                                                                $selectedFacilities = $oldRoom['facilities'];
                                                            } elseif (
                                                                is_string($oldRoom['facilities']) &&
                                                                (str_starts_with($oldRoom['facilities'], '[') ||
                                                                    str_starts_with($oldRoom['facilities'], '{'))
                                                            ) {
                                                                $selectedFacilities =
                                                                    json_decode($oldRoom['facilities'], true) ?: [];
                                                            } elseif (is_string($oldRoom['facilities'])) {
                                                                $selectedFacilities = explode(
                                                                    ',',
                                                                    trim($oldRoom['facilities'], '[]"'),
                                                                );
                                                            }
                                                        }
                                                    @endphp
                                                    @foreach ($facilityOptions as $facilityKey => $facilityLabel)
                                                        <div class="checkbox-button">
                                                            <input type="checkbox"
                                                                name="rooms[{{ $index }}][facilities][]"
                                                                id="facility_{{ $index }}_{{ $facilityKey }}"
                                                                value="{{ $facilityKey }}"
                                                                {{ in_array($facilityKey, $selectedFacilities) ? 'checked' : '' }}>
                                                            <label class="form-check-label"
                                                                for="facility_{{ $index }}_{{ $facilityKey }}">{{ $facilityLabel }}</label>
                                                        </div>
                                                    @endforeach
                                                </div>
                                                @error("rooms.$index.facilities")
                                                    <small class="text-danger d-block">{{ $message }}</small>
                                                @enderror
                                            </div>

                                            @if (isset($oldRoom['id']))
                                                <input type="hidden" name="rooms[{{ $index }}][id]"
                                                    value="{{ $oldRoom['id'] }}">
                                            @endif
                                        </div>
                                    </div>
                                @endforeach
                            @else
                                @forelse($rooms as $index => $room)
                                    <div class="card room-card mb-3">
                                        <div class="card-header d-flex justify-content-between align-items-center">
                                            <strong>Room <span class="room-number">{{ $index + 1 }}</span></strong>
                                            <a href="javascript:void(0);" class="text-primary delete-room">Delete</a>
                                        </div>
                                        <div class="card-body">
                                            <div class="mb-3">
                                                <label class="form-label">Room Type</label>
                                                <div class="btn-group d-flex flex-wrap gap-2" role="group">
                                                    @foreach (['Private Room', 'Double Sharing', 'Triple Sharing', '3+ Sharing'] as $typeIndex => $type)
                                                        <input type="radio" class="btn-check"
                                                            name="rooms[{{ $index }}][type]"
                                                            value="{{ $type }}"
                                                            id="type_{{ $index }}_{{ $typeIndex }}"
                                                            autocomplete="off"
                                                            {{ $room->type === $type ? 'checked' : '' }}>
                                                        <label class="btn btn-outline-primary"
                                                            for="type_{{ $index }}_{{ $typeIndex }}">{{ $type }}</label>
                                                    @endforeach
                                                </div>
                                            </div>

                                            <div class="mb-3">
                                                <label class="form-label">Total Beds in this Room</label>
                                                <input type="number" class="form-control"
                                                    name="rooms[{{ $index }}][total_beds]"
                                                    value="{{ $room->total_beds }}">
                                            </div>

                                            <div class="mb-3">
                                                <label class="form-label">Rent</label>
                                                <input type="number" class="form-control"
                                                    name="rooms[{{ $index }}][rent]" value="{{ $room->rent }}">
                                            </div>

                                            <div class="mb-3">
                                                <label class="form-label">Security Deposit</label>
                                                <input type="number" class="form-control"
                                                    name="rooms[{{ $index }}][deposit]"
                                                    value="{{ $room->deposit }}">
                                            </div>

                                            <div class="mb-3">
                                                <label class="form-label">Facilities Offered</label>
                                                <div class="checkbox-button-group">
                                                    @php
                                                        $facilityOptions = [
                                                            'ac' => 'AC',
                                                            'tv_in_room' => 'TV in room',
                                                            'personal_cupboard' => 'Personal Cupboard',
                                                            'table_chair' => 'Table Chair',
                                                            'attached_balcony' => 'Attached Balcony',
                                                            'attached_bathroom' => 'Attached Bathroom',
                                                            'meals_included' => 'Meals Included',
                                                        ];
                                                        $selectedFacilities = [];
                                                        if (isset($room->facilities)) {
                                                            if (is_array($room->facilities)) {
                                                                $selectedFacilities = $room->facilities;
                                                            } elseif (
                                                                is_string($room->facilities) &&
                                                                (str_starts_with($room->facilities, '[') ||
                                                                    str_starts_with($room->facilities, '{'))
                                                            ) {
                                                                $selectedFacilities =
                                                                    json_decode($room->facilities, true) ?: [];
                                                            } elseif (is_string($room->facilities)) {
                                                                $selectedFacilities = explode(
                                                                    ',',
                                                                    trim($room->facilities, '[]"'),
                                                                );
                                                            }
                                                        }
                                                    @endphp
                                                    @foreach ($facilityOptions as $facilityKey => $facilityLabel)
                                                        <div class="checkbox-button">
                                                            <input type="checkbox"
                                                                name="rooms[{{ $index }}][facilities][]"
                                                                id="facility_{{ $index }}_{{ $facilityKey }}"
                                                                value="{{ $facilityKey }}"
                                                                {{ in_array($facilityKey, $selectedFacilities) ? 'checked' : '' }}>
                                                            <label class="form-check-label"
                                                                for="facility_{{ $index }}_{{ $facilityKey }}">{{ $facilityLabel }}</label>
                                                        </div>
                                                    @endforeach
                                                </div>
                                            </div>

                                            <input type="hidden" name="rooms[{{ $index }}][id]"
                                                value="{{ $room->id }}">
                                        </div>
                                    </div>
                                @empty
                                    <div class="card room-card mb-3">
                                        <div class="card-header d-flex justify-content-between align-items-center">
                                            <strong>Room <span class="room-number">1</span></strong>
                                            <a href="javascript:void(0);" class="text-primary delete-room">Delete</a>
                                        </div>
                                        <div class="card-body">
                                            <div class="mb-3">
                                                <label class="form-label">Room Type</label>
                                                <div class="btn-group d-flex flex-wrap gap-2" role="group">
                                                    @foreach (['Private Room', 'Double Sharing', 'Triple Sharing', '3+ Sharing'] as $typeIndex => $type)
                                                        <input type="radio" class="btn-check" name="rooms[0][type]"
                                                            value="{{ $type }}" id="type_0_{{ $typeIndex }}"
                                                            autocomplete="off" {{ $typeIndex === 0 ? 'checked' : '' }}>
                                                        <label class="btn btn-outline-primary"
                                                            for="type_0_{{ $typeIndex }}">{{ $type }}</label>
                                                    @endforeach
                                                </div>
                                            </div>

                                            <div class="mb-3">
                                                <label class="form-label">Total Beds in this Room</label>
                                                <input type="number" class="form-control" name="rooms[0][total_beds]">
                                            </div>

                                            <div class="mb-3">
                                                <label class="form-label">Rent</label>
                                                <input type="number" class="form-control" name="rooms[0][rent]">
                                            </div>

                                            <div class="mb-3">
                                                <label class="form-label">Security Deposit</label>
                                                <input type="number" class="form-control" name="rooms[0][deposit]">
                                            </div>

                                            <div class="mb-3">
                                                <label class="form-label">Facilities Offered</label>
                                                <div class="checkbox-button-group">
                                                                            @foreach ([
                                                        'ac' => 'AC',
                                                        'tv_in_room' => 'TV in room',
                                                        'personal_cupboard' => 'Personal Cupboard',
                                                        'table_chair' => 'Table Chair',
                                                        'attached_balcony' => 'Attached Balcony',
                                                        'attached_bathroom' => 'Attached Bathroom',
                                                        'meals_included' => 'Meals Included',
                                                    ] as $facilityKey => $facilityLabel)
                                                        <div class="checkbox-button">
                                                            <input type="checkbox" name="rooms[0][facilities][]"
                                                                id="facility_0_{{ $facilityKey }}"
                                                                value="{{ $facilityKey }}">
                                                            <label class="form-check-label"
                                                                for="facility_0_{{ $facilityKey }}">{{ $facilityLabel }}</label>
                                                        </div>
                                                    @endforeach
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endforelse
                            @endif
                        </div>

                        <div class="text-center mb-4">
                            <button type="button" class="btn btn-outline-primary add-room">+ Add Another
                                Room</button>
                        </div>
                        <div class="d-flex justify-content-center my-3">
                            <a href="{{ url('/seller/properties/step-2', $property->id ?? null) }}" id="back-btn"
                                class="btn btn-secondary w-25">{{ __('Back') }}</a>
                            <button type="submit" id="submit-btn"
                                class="btn btn-primary w-25 mx-2">{{ __('Save & Next') }}</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
@section('scripts')
    <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
    <script>
        $(document).ready(function() {
            // Initialize roomIndex based on existing rooms or start from 0
            let roomIndex = $('.room-card').length > 0 ? $('.room-card').length : 0;

            function getNewRoomTemplate(index) {
                let types = ['Private Room', 'Double Sharing', 'Triple Sharing', '3+ Sharing'];
                let typeRadios = types.map(function(type, typeIndex) {
                    return `
                <input type="radio" class="btn-check" name="rooms[${index}][type]" value="${type}" id="type_${index}_${typeIndex}" autocomplete="off">
                <label class="btn btn-outline-primary" for="type_${index}_${typeIndex}">${type}</label>
            `;
                }).join('');

                let facilityOptions = {
                    'ac': 'AC',
                    'tv_in_room': 'TV in room',
                    'personal_cupboard': 'Personal Cupboard',
                    'table_chair': 'Table Chair',
                    'attached_balcony': 'Attached Balcony',
                    'attached_bathroom': 'Attached Bathroom',
                    'meals_included': 'Meals Included',
                };

                let facilitiesCheckboxes = Object.entries(facilityOptions).map(function([facilityKey,
                    facilityLabel
                ]) {
                    return `
                <div class="checkbox-button">
                    <input type="checkbox" name="rooms[${index}][facilities][]" id="facility_${index}_${facilityKey}" value="${facilityKey}">
                    <label class="form-check-label" for="facility_${index}_${facilityKey}">${facilityLabel}</label>
                </div>
            `;
                }).join('');

                return `
            <div class="card room-card mb-3">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <strong>Room <span class="room-number">${index + 1}</span></strong>
                    <a href="javascript:void(0);" class="text-primary delete-room">Delete</a>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label class="form-label">Room Type</label>
                        <div class="btn-group d-flex flex-wrap gap-2" role="group">
                            ${typeRadios}
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Total Beds in this Room</label>
                        <input type="number" class="form-control" name="rooms[${index}][total_beds]" >
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Rent</label>
                        <input type="number" class="form-control" name="rooms[${index}][rent]" >
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Security Deposit</label>
                        <input type="number" class="form-control" name="rooms[${index}][deposit]" >
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Facilities Offered</label>
                        <div class="checkbox-button-group">
                            ${facilitiesCheckboxes}
                        </div>
                    </div>
                </div>
            </div>
        `;
            }

            // Add new room - changed selector from #add-room to .add-room
            $('.add-room').on('click', function() {
                $('#rooms-wrapper').append(getNewRoomTemplate(roomIndex));
                roomIndex++;
            });

            // Delete Room Handler
            $(document).on('click', '.delete-room', function() {
                if ($('.room-card').length > 1) {
                    $(this).closest('.room-card').remove();
                    updateRoomNumbers();
                } else {
                    alert("At least one room is .");
                }
            });

            // Update Room Numbers and radio names/ids after delete
            function updateRoomNumbers() {
                $('.room-card').each(function(index) {
                    $(this).find('.room-number').text(index + 1);
                    // Update all input names and radio ids/labels
                    $(this).find('input, label').each(function() {
                        // Update name for inputs
                        if ($(this).attr('name')) {
                            let name = $(this).attr('name');
                            let newName = name.replace(/rooms\[\d+\]/, `rooms[${index}]`);
                            $(this).attr('name', newName);
                        }
                        // Update id for radio inputs
                        if ($(this).hasClass('btn-check')) {
                            let id = $(this).attr('id');
                            let typeIndex = id.split('_')[2];
                            let newId = `type_${index}_${typeIndex}`;
                            $(this).attr('id', newId);
                        }
                        // Update for attribute for radio labels
                        if ($(this).is('label.btn')) {
                            let forAttr = $(this).attr('for');
                            if (forAttr && forAttr.startsWith('type_')) {
                                let typeIndex = forAttr.split('_')[2];
                                let newFor = `type_${index}_${typeIndex}`;
                                $(this).attr('for', newFor);
                            }
                        }
                    });
                });
                roomIndex = $('.room-card').length;
            }
        });
    </script>
@endsection
