@extends('layouts.agent')
@section('content')
    <div class="card">
        @if (session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
        @endif
        
        <div class="d-flex justify-content-center">
            @php
                $steps = [
                    1 => 'Basic Details',
                    2 => 'Property Details',
                    3 => 'Location Details',
                    4 => 'Photos & Videos',
                ];
                $currentStep = request()->route()->getName();
                preg_match('/step_(\d+)/', $currentStep, $matches);
                $activeStep = isset($matches[1]) ? (int) $matches[1] : 1;
            @endphp
            <div class="steps-container my-4">
                @foreach ($steps as $step => $label)
                    <div class="step-item">
                        <a href="#" class="step-circle {{ $step == $activeStep ? 'active' : '' }}">
                            {{ $step }}
                        </a>
                        <span class="step-label">{{ $label }}</span>
                        @if ($step < count($steps))
                            <div class="step-line">
                            </div>
                        @endif
                    </div>
                @endforeach
            </div>
        </div>
    </div>
    <div class="row justify-content-center mt-3">
        <div class="col-md-12">
            <form class=""
                action="{{ isset($property->id) ? route('agent.properties.store_1', ['id' => $property->id]) : route('agent.properties.store_1') }}"
                method="POST">
                {{ csrf_field() }}
                <div class="row">
                    <div class="col-lg-12">
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                            <h6>{{ __('Basic Information') }}</h6>
                        </div>
                        <div class="card mb-4">
                            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                                <h6>{{ __('Property Type') }}</h6>
                            </div>
                            <div class="card-body">
                                <fieldset class="form-group">
                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="type"
                                                    id="residential" value="residential" onclick="toggleCatInput()" {{ old('type', isset($property) ? $property->type : 'residential') == 'residential' ? 'checked' : '' }}>
                                                <label class="form-check-label" for="residential">
                                                    {{ __('Residential') }}
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="type"
                                                    id="commercial" value="commercial" onclick="toggleCatInput()"{{ old('type', isset($property) ? $property->type : '') == 'commercial' ? 'checked' : '' }}
>
                                                <label class="form-check-label" for="commercial">
                                                    {{ __('Commercial') }}
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </fieldset>
                                @error('type')
                                    <small class="text-danger">{{ $message }}</small>
                                @enderror
                            </div>
                        </div>
                        <div class="card mb-4">
                            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                                <h6>{{ __('Looking To') }}</h6>
                            </div>
                            <div class="card-body">
                                <div class="form-group">
                                    <div class="d-flex flex-wrap">
                                        <div class="form-check me-1">
                                            <input type="radio" class="form-check-input" id="customRadio1"
                                                name="looking_for" value="for_sell" {{ old('looking_for', isset($property) ? $property->looking_for : 'for_sell') == 'for_sell' ? 'checked' : '' }}>
                                            <label class="form-check-label" for="customRadio1">
                                                {{ __('Sell') }}
                                            </label>
                                        </div>
                                       @if(auth()->user()->user_type != 'builder/developer')
                                        <div class="form-check">
                                            <input type="radio" class="form-check-input" id="customRadio2"
                                                name="looking_for" value="for_rent" {{ old('looking_for', isset($property) ? $property->looking_for : '') == 'for_rent' ? 'checked' : '' }}
>
                                            <label class="form-check-label" for="customRadio2">
                                                {{ __('Rent') }}
                                            </label>
                                        </div>
                                        <div class="form-check" id="customRadio3" style="display: none;">
                                            <input type="radio" class="form-check-input" id="customRadio3_input"
                                                name="looking_for" value="for_pg" {{ old('looking_for', isset($property) ? $property->looking_for : '') == 'for_pg' ? 'checked' : '' }}
>
                                            <label class="form-check-label" for="customRadio3_input">
                                                {{ __('PG/Co-Living') }}
                                            </label>
                                        </div>
                                        @endif
                                    </div>
                                </div>

                                <!-- Error message -->
                                @error('looking_for')
                                    <small class="text-danger">{{ $message }}</small>
                                @enderror
                            </div>
                        </div>
                        <div class="card my-4">
                            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                                <h6>{{ __('Property Category') }}</h6>
                            </div>
                            <div class="card-body">
                                <div class="form-group">
                                    <div class="d-flex flex-wrap">
                                        @foreach ($categories as $category)
                                            @php
                                                // Determine the selected category
                                                $selectedCategory = old(
                                                    'category_id',
                                                    isset($property) ? $property->category_id : '',
                                                );
                                            @endphp

                                            <div class="me-1 category-item" data-category-id="{{ $category->id }}">
                                                <input type="radio" id="category_{{ $category->id }}" name="category_id"
                                                    value="{{ $category->id }}"
                                                    {{ $selectedCategory == $category->id ? 'checked' : '' }}>
                                                <label for="category_{{ $category->id }}">
                                                    &nbsp;{{ $category->title }} &nbsp;
                                                </label>
                                            </div>

                                            @foreach ($category->child as $childlocation)
                                                <div class="me-1 ms-4 category-item"
                                                    data-category-id="{{ $childlocation->id }}">
                                                    <input type="radio" id="category_{{ $childlocation->id }}"
                                                        name="category_id" value="{{ $childlocation->id }}"
                                                        {{ $selectedCategory == $childlocation->id ? 'checked' : '' }}>
                                                    <label for="category_{{ $childlocation->id }}">
                                                        &nbsp;- {{ $childlocation->title }} &nbsp;
                                                    </label>
                                                </div>
                                            @endforeach
                                        @endforeach
                                    </div>
                                    @error('category_id')
                                        <small class="text-danger">{{ $message }}</small>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <!-- Retail Section -->
                        <div class="card my-4" id="retail-section" style="display: none;">
                            <div class="card-body">
                                <div class="form-group">
                                    <div class="d-flex flex-wrap">
                                        <div class="">
                                            <input type="radio" id="retail-shop" name="retail_space_type"
                                                value="commercial-shops"
                                                {{ old('retail_space_type', $property->retail_space_type ?? '') == 'commercial-shops' ? 'checked' : '' }}>
                                            <label for="retail-shop">&nbsp;Commercial Shops &nbsp;</label>

                                            <input type="radio" id="retail-showroom" name="retail_space_type"
                                                value="commercial-showrooms"
                                                {{ old('retail_space_type', $property->retail_space_type ?? '') == 'commercial-showrooms' ? 'checked' : '' }}>
                                            <label for="retail-showroom">&nbsp;Commercial Showrooms &nbsp;</label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- in case of storage (category_id = 40) -->
                        <div class="card my-4" id="storage-section" style="display: none;">
                            <div class="card-body">
                                <div class="form-group">
                                    <div class="d-flex flex-wrap">
                                        <div class="">
                                            <input type="radio" id="warehouse" name="storage_space_type"
                                                value="warehouse"
                                                {{ old('storage_space_type', $property->storage_space_type ?? '') == 'warehouse' ? 'checked' : '' }}>
                                            <label for="warehouse">&nbsp;Warehouse &nbsp;</label>

                                            <input type="radio" id="cold-storage" name="storage_space_type"
                                                value="cold-storage"
                                                {{ old('storage_space_type', $property->storage_space_type ?? '') == 'cold-storage' ? 'checked' : '' }}>
                                            <label for="cold-storage">&nbsp;Cold Storage &nbsp;</label>
                                        </div>
                                    </div>
                                    <!-- Error message -->
                                    @error('storage_space_type')
                                        <small class="text-danger">{{ $message }}</small>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <!-- in case of Hospitality (category_id = 42) -->
                        <div class="card my-4" id="hospitality-section" style="display: none;">
                            <div class="card-body">
                                <div class="form-group">
                                    <div class="d-flex flex-wrap">
                                        <div class="">
                                            <input type="radio" id="hotel" name="hospitality_space_type"
                                                value="hotel"
                                                {{ old('hospitality_space_type', $property->hospitality_space_type ?? '') == 'hotel' ? 'checked' : '' }}>
                                            <label for="hotel">&nbsp;Hotel/Resorts &nbsp;</label>

                                            <input type="radio" id="guest-house" name="hospitality_space_type"
                                                value="guest-house"
                                                {{ old('hospitality_space_type', $property->hospitality_space_type ?? '') == 'guest-house' ? 'checked' : '' }}>
                                            <label for="guest-house">&nbsp;Guest-House/Banquet-Halls &nbsp;</label>
                                        </div>
                                    </div>
                                    <!-- Error message -->
                                    @error('hospitality_space_type')
                                        <small class="text-danger">{{ $message }}</small>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <!-- in case of industry (category_id = 41) -->
                        <div class="card my-4" id="industry-section" style="display: none;">
                            <div class="card-body">
                                <div class="form-group">
                                    <div class="d-flex flex-wrap">
                                        <div class="">
                                            <input type="radio" id="factory" name="industrial_space_type"
                                                value="factory"
                                                {{ old('industrial_space_type', $property->industrial_space_type ?? '') == 'factory' ? 'checked' : '' }}>
                                            <label for="factory">&nbsp;Factory &nbsp;</label>

                                            <input type="radio" id="manufacturing" name="industrial_space_type"
                                                value="manufacturing"
                                                {{ old('industrial_space_type', $property->industrial_space_type ?? '') == 'manufacturing' ? 'checked' : '' }}>
                                            <label for="manufacturing">&nbsp;Manufacturing &nbsp;</label>
                                        </div>
                                    </div>
                                    <!-- Error message -->
                                    @error('industrial_space_type')
                                        <small class="text-danger">{{ $message }}</small>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <!-- in case of plot (category_id = 33) -->
                        <div class="card my-4" id="plot-section" style="display: none;">
                            <div class="card-body">
                                <div class="form-group">
                                    <div class="d-flex flex-wrap">
                                        <div class="">
                                            <input type="radio" id="commercial-lands" name="plot_space_type"
                                                value="commercial-lands"
                                                {{ old('plot_space_type', $property->plot_space_type ?? '') == 'commercial-lands' ? 'checked' : '' }}>
                                            <label for="commercial-lands">&nbsp;Commercial Plot &nbsp;</label>

                                            <input type="radio" id="industrial-lands" name="plot_space_type"
                                                value="industrial-lands"
                                                {{ old('plot_space_type', $property->plot_space_type ?? '') == 'industrial-lands' ? 'checked' : '' }}>
                                            <label for="industrial-lands">&nbsp;Industrial Lands &nbsp;</label>
                                        </div>
                                    </div>
                                    <!-- Error message -->
                                    @error('plot_space_type')
                                        <small class="text-danger">{{ $message }}</small>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="card my-4" id="submit-btn">
                            <div class="card-body">
                                <div class="card-body">
                                    <button type="submit" class="btn btn-primary w-100">{{ __('Continue') }}
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
@section('scripts')
    <script>
        const categoryMapping = {
            residential: {
                for_sell: [32, 33, 34, 35, 36],
                for_rent: [49, 34, 35, 36],
                for_pg: [36, 34, 35], 
            },
            commercial: {
                for_sell: [38, 39, 40, 41, 42, 33, 44],
                for_rent: [38, 39, 40, 41, 42, 33, 44],
            }
        };

        function togglePGOption() {
            let selectedType = document.querySelector('input[name="type"]:checked')?.value;
            let pgOption = document.getElementById('customRadio3');
            if (selectedType === 'residential') {
                pgOption.style.display = 'block';
            } else {
                pgOption.style.display = 'none';
                document.getElementById('customRadio3_input').checked = false;
            }
        }

        function toggleCategories() {
            let selectedType = document.querySelector('input[name="type"]:checked')?.value;
            let selectedPurpose = document.querySelector('input[name="looking_for"]:checked')?.value;

            if (!selectedType || !selectedPurpose) return;

            let validCategoryIds = categoryMapping[selectedType][selectedPurpose] || [];

            document.querySelectorAll('.category-item').forEach(function(item) {
                let categoryId = parseInt(item.getAttribute('data-category-id'));
                if (validCategoryIds.includes(categoryId)) {
                    item.style.display = 'block';
                } else {
                    item.style.display = 'none';
                }
            });
        }

        // Run on load
        window.addEventListener('DOMContentLoaded', function() {
            // Set default selection if not already set
            if (!document.querySelector('input[name="type"]:checked')) {
                document.getElementById('residential').checked = true;
            }
            if (!document.querySelector('input[name="looking_for"]:checked')) {
                document.getElementById('customRadio1').checked = true;
            }
            togglePGOption();
            toggleCategories();
        });

        // Run when type or looking_for changes
        document.querySelectorAll('input[name="type"]').forEach(el => {
            el.addEventListener('change', function() {
                togglePGOption();
                toggleCategories();
            });
        });

        document.querySelectorAll('input[name="looking_for"]').forEach(el => {
            el.addEventListener('change', toggleCategories);
        });

        function toggleExtraFields() {
            const sections = [
                'retail-section',
                'storage-section',
                'industry-section',
                'hospitality-section',
                'plot-section'
            ];

            // Hide all sections and clear errors
            sections.forEach(sectionId => {
                const section = document.getElementById(sectionId);
                if (section) {
                    section.style.display = 'none';
                    const errorElements = section.querySelectorAll('.error-message');
                    errorElements.forEach(el => el.remove());
                }
            });

            // Show selected section
            const selectedCategory = document.querySelector('input[name="category_id"]:checked');
            const selectedType = document.querySelector('input[name="type"]:checked')?.value;

            if (selectedCategory) {
                const categoryId = parseInt(selectedCategory.value);

                const sectionMap = {
                    39: 'retail-section',
                    40: 'storage-section',
                    42: 'hospitality-section',
                    41: 'industry-section',
                    33: 'plot-section'
                };

                // Show plot-section only if it's selected under commercial
                if (categoryId === 33 && selectedType !== 'commercial') {
                    return; // skip showing plot section
                }

                const activeSectionId = sectionMap[categoryId];
                if (activeSectionId) {
                    document.getElementById(activeSectionId).style.display = 'block';
                }
            }
        }


        // Improved form validation with properly positioned errors
        document.querySelector('form').addEventListener('submit', function(e) {
            e.preventDefault();
            let isValid = true;

            // Clear all previous errors
            document.querySelectorAll('.error-message').forEach(el => el.remove());

            const activeSection = document.querySelector('[id$="-section"][style="display: block;"]');

            if (activeSection) {
                // Validate radio buttons
                const radioGroups = new Set();
                activeSection.querySelectorAll('input[type="radio"][name]').forEach(radio => {
                    radioGroups.add(radio.name);
                });

                radioGroups.forEach(groupName => {
                    if (!activeSection.querySelector(`input[name="${groupName}"]:checked`)) {
                        isValid = false;
                        // Create error message container
                        const errorContainer = document.createElement('div');
                        errorContainer.className = 'w-100'; // Full width container

                        // Create error message
                        const errorElement = document.createElement('small');
                        errorElement.className = 'text-danger error-message d-block mt-1 px-2';
                        errorElement.textContent = 'This field is required';

                        errorContainer.appendChild(errorElement);

                        // Insert after the radio group container
                        const radioContainer = activeSection.querySelector(`input[name="${groupName}"]`)
                            .closest('.d-flex');
                        radioContainer.parentNode.insertBefore(errorContainer, radioContainer.nextSibling);
                    }
                });

                // Validate other required fields
                activeSection.querySelectorAll('input[required], select[required], textarea[required]').forEach(
                    field => {
                        if (!field.value.trim()) {
                            isValid = false;
                            // Create error message container
                            const errorContainer = document.createElement('div');
                            errorContainer.className = 'w-100'; // Full width container

                            // Create error message
                            const errorElement = document.createElement('small');
                            errorElement.className = 'text-danger error-message d-block mt-1';
                            errorElement.textContent = 'This field is required';

                            errorContainer.appendChild(errorElement);

                            // Insert after the field's parent div
                            const fieldContainer = field.closest('.form-group') || field.parentNode;
                            fieldContainer.parentNode.insertBefore(errorContainer, fieldContainer.nextSibling);
                        }
                    });
            }

            if (isValid) {
                this.submit();
            }
        });

        document.addEventListener("DOMContentLoaded", function() {
            toggleCategories();
            toggleExtraFields();

            document.querySelectorAll('input[name="type"]').forEach(function(radio) {
                radio.addEventListener("change", toggleCategories);
            });

            document.querySelectorAll('input[name="category_id"]').forEach(function(radio) {
                radio.addEventListener("change", toggleExtraFields);
            });
        });
    </script>
@endsection
