@extends('layouts.front')

@push('css')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/css/intlTelInput.css" />

    <style>
        .iti {
            width: 100%;
        }

        .iti__country-list {
            position: absolute;
            z-index: 2;
            width: 273px;
        }

        .iti__dropdown {
            width: 100% !important;
            box-shadow: 0px 4px 8px rgba(0, 0, 0, 0.1);
            z-index: 1050;
        }


        .or-divider {
            display: flex;
            align-items: center;
            text-align: center;
            margin: 1.5rem 0;
        }

        .or-divider::before,
        .or-divider::after {
            content: '';
            flex: 1;
            border-bottom: 1px solid #ddd;
        }

        .or-divider:not(:empty)::before {
            margin-right: 0.5em;
        }

        .or-divider:not(:empty)::after {
            margin-left: 0.5em;
        }

        .email-btn {
            background-color: #f5f5f5;
            border: 1px solid #ddd;
            color: #333;
            font-weight: 600;
        }

        .email-btn:hover {
            background-color: #e6e6e6;
            color: #000;
        }
    </style>
@endpush

@section('content')
    <section class="gray"style="background: url('https://images.unsplash.com/photo-1605146769289-440113cc3d00?q=80&w=1470&auto=format&fit=crop&ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D') no-repeat center center;
            background-size: cover;">
        <div class="container my-5">
            <div class="row justify-content-center">
                <div class="col-md-5">
                    <div class="card p-4">
                        @if (session('success'))
                            <div class="alert alert-success">
                                {{ session('success') }}
                            </div>
                        @endif
                        @if (session('error'))
                            <div class="alert alert-danger">
                                {!! session('error') !!}
                            </div>
                        @endif
                        <div class="text-white text-center mb-2 mt-2">
                            <h3>@lang('login/Register')</h3>
                        </div>
                        <div class="card-body">
                            <form id="" action="{{ route('agent.send.otp') }}" method="POST">
                                @includeIf('partials.user.form-both')
                                @csrf
                                <div class="form-group mb-5">
                                    <label for="phone" class="form-label">@lang('Please Enter Your Phone Number')</label>
                                    <input type="number" name="phone" id="phone" class="form-control rounded"
                                        placeholder="Enter Number" required aria-label="Phone Number">

                                </div>
                                <div class="form-group text-center">
                                    <button type="submit" class="btn rounded theme-bg w-100">
                                        @lang('Continue')
                                    </button>

                                    <div class="or-divider">@lang('Or')</div>

                                    <button class="btn email-btn rounded w-100">
                                        <i class="bi bi-envelope me-2"></i><a
                                            href="{{ route('agent.by.email') }}">@lang('Continue with Email')</a>
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    @includeIf('partials.front.cta')
@endsection
@push('js')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/intlTelInput.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const phoneInput = document.getElementById('phone'); // Get phone input element
            if (phoneInput) {
                try {
                    const iti = intlTelInput(phoneInput, {
                        initialCountry: "in",
                        separateDialCode: true,
                        preferredCountries: ["in", "us", "gb"],
                        utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/utils.js",
                    });
                } catch (error) {
                    console.error('Error initializing intlTelInput:', error);
                }
            }
        });
    </script>
@endpush
