@extends('layouts.agent')
@push('css')
<style>
    .contact {
        margin-top: 0 !important;
        /* Mobile default */
    }

    @media (min-width: 768px) {
        .contact {
            margin-top: 25px !important;
            /* Desktop and larger */
        }
    }

    .share-options {
        display: none;
        transition: all 0.2s ease-in-out;
        font-size: 13px;
    }

    .share-options.d-block {
        display: block !important;

    }

    .truncate-text {
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
        max-width: 280px;
        /* Adjust based on your layout */
        display: inline-block;
        vertical-align: middle;
    }
</style>
@endpush
@section('content')
<div class="card">
    <div class="d-sm-flex align-items-center justify-content-between">
        <h5 class=" mb-0 text-gray-800 pl-3">{{ __('Viewed Contacts For These Properties') }}</h5>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('agent.dashboard') }}">{{ __('Dashboard') }}</a></li>
            <li class="breadcrumb-item"><a href="javascript:;">{{ __('Viewed Contacts For These Properties') }}</a></li>
        </ol>
    </div>
</div>
<div class="data-container mt-4 mx-2">
    <h4 class="mb-3">@lang('Viewed Contact Properties')</h4>
    @foreach ($contacts as $contact)
    @php $property = $contact->property; @endphp
    @if ($property)
    @php
    $routes = [
    'for_pg' => 'pg.details',
    'for_rent' => 'rent.details',
    'for_sell' => 'buy.details',
    'plot' => 'plot.details',
    'commercial' => 'commercial.details',
    ];

    $propertyUrl = isset($routes[$property->looking_for])
    ? route($routes[$property->looking_for], $property->slug)
    : '#'; // fallback
    @endphp
    <div class="col-12 mb-3  position-relative">
        <div class="position-absolute" style="top: 5px; right: 20px; z-index: 1050;">
            <i class="fas fa-share-alt" style="font-size: 18px; color: #474646; cursor: pointer;"
                onclick="toggleShareOptions(event, '{{ $property->id }}')"></i>
            <div id="share-options-{{ $property->id }}" class="share-options shadow p-4 rounded bg-white"
                style="position: absolute; top: 30px; right: 0; min-width: 160px; display: none; z-index: 1060;">

                <a href="#" onclick="copyLink('{{ $propertyUrl }}'); return false;"
                    class="d-flex align-items-center mt-1">
                    <i class="fas fa-link mr-2 text-primary"></i> Copy Link
                </a>

                <a href="https://api.whatsapp.com/send?text={{ urlencode($propertyUrl) }}" target="_blank"
                    class="d-flex align-items-center mt-1">
                    <i class="fab fa-whatsapp mr-2 text-success"></i> WhatsApp
                </a>

                <a href="https://www.facebook.com/sharer/sharer.php?u={{ urlencode($propertyUrl) }}"
                    target="_blank" class="d-flex align-items-center mt-1">
                    <i class="fab fa-facebook mr-2 text-primary"></i> Facebook
                </a>

                <a href="https://twitter.com/intent/tweet?url={{ urlencode($propertyUrl) }}"
                    target="_blank" class="d-flex align-items-center mt-1">
                    <i class="fab fa-twitter mr-2 text-info"></i> Twitter
                </a>

                <a href="https://www.linkedin.com/shareArticle?mini=true&url={{ urlencode($propertyUrl) }}"
                    target="_blank" class="d-flex align-items-center mt-1">
                    <i class="fab fa-linkedin mr-2 text-primary"></i> LinkedIn
                </a>

                <a href="https://www.instagram.com/" target="_blank" class="d-flex align-items-center">
                    <i class="fab fa-instagram mr-2 text-danger"></i> Instagram
                </a>
            </div>
        </div>
        <div class="shadow-sm rounded bg-white overflow-hidden d-flex flex-wrap flex-md-nowrap">
            {{-- Column 1: Property Image --}}
            <div class="property-img position-relative">
                <img src="{{ asset('assets/images/' . $property->photo) }}" class="img-fluid w-100 h-100"
                    style="object-fit: cover;" alt="{{ $property->name }}">
                {{-- Badge --}}
                <span class="badge position-absolute" style="top: 10px; left: 10px; background-color: #f02c2d; color: white;">
                    @if ($property->looking_for == 'for_rent')
                    {{ __('For Rent') }}
                    @elseif ($property->looking_for == 'for_sell')
                    {{ __('For Sell') }}
                    @elseif ($property->looking_for == 'for_pg')
                    {{ __('For PG') }}
                    @else
                    {{ __('Property') }}
                    @endif
                </span>
            </div>
            {{-- Column 2: Price + Location --}}
            <div class="px-4 pt-1 flex-fill col-12 col-md-3">
                <p class="text-primary font-weight-bold mb-2" style="font-size: 1.1rem;">
                    {{ showAmount($property->price) }}
                </p>
                <p class=" text-muted" style="font-size: 14px;">
                    <i class="fas fa-map-marker-alt mr-1"></i>
                    {{ $property->location->name ?? '' }}
                </p>
                <p class="text-muted mb-0">
                    {{ $property->name }}
                </p>

            </div>
            <div class="px-4 pt-1 col-12 col-md-3 text-md-center">
                <small class="text-muted d-block  contact">
                    <i class="far fa-clock mr-1"></i>
                    Contacted {{ \Carbon\Carbon::parse($contact->created_at)->format('d M Y \a\t h:i A') }}
                </small>
            </div>
            <div class="px-4 py-2 col-12 col-md-3 text-md-right">
                <div id="lead-section-{{ $contact->id }}">
                    @if (Auth::user()->plan_id == null)
                    {{-- For Free Users – Show button & JS logic --}}
                    <button
                        type="button"
                        class="btn btn-sm btn-outline-primary mt-5 view-leads-btn"
                        data-property-id="{{ $property->id }}"
                        data-enquiry-id="{{ $contact->id }}"
                        data-enquiry-user-id="{{ $contact->user_id }}">
                        View Contact
                    </button>

                    <div class="lead-details mt-2" style="display: none;"><br>
                        <p><strong>{{ ucwords($contact->details ?? '') }}</strong></p>
                        <p><i class="fab fa-whatsapp mr-1"></i>{{ $contact->phone ?? '' }}</p>
                        <p><i class="fas fa-envelope mr-1"></i>{{ $contact->email ?? '' }}</p>
                    </div>
                    @else
                    {{-- For Paid Users – Show full lead info always --}}
                    <div class="lead-details mt-2"><br>
                        <p><strong>{{ ucwords($contact->details ?? '') }}</strong></p>
                        <p><i class="fab fa-whatsapp mr-1"></i>{{ $contact->phone ?? '' }}</p>
                        <p><i class="fas fa-envelope mr-1"></i>{{ $contact->email ?? '' }}</p>
                    </div>
                    @endif
                </div><br>

                <script>
                    document.addEventListener("DOMContentLoaded", function() {
                        const MAX_VIEWS = 2;
                        const AUTH_USER_TYPE = "{{ strtolower(Auth::user()->user_type) === 'builder/developer' ? 'Developer' : ucwords(Auth::user()->user_type) }}";

                        let viewedContacts = JSON.parse(localStorage.getItem("viewedContacts") || "[]");

                        // Show already viewed enquiries
                        viewedContacts.forEach(function(item, index) {
                            if (index < MAX_VIEWS) { // ✅ only allow first MAX_VIEWS enquiries to show
                                const section = document.getElementById(`lead-section-${item.enquiryId}`);
                                if (section) {
                                    const btn = section.querySelector(".view-leads-btn");
                                    const details = section.querySelector(".lead-details");
                                    if (btn) btn.remove();
                                    if (details) details.style.display = "block";
                                }
                            }
                        });

                        // Attach click event
                        document.querySelectorAll(".view-leads-btn").forEach(function(btn) {
                            btn.addEventListener("click", function() {
                                const propertyId = this.getAttribute("data-property-id");
                                const enquiryId = this.getAttribute("data-enquiry-id");
                                const enquiryUserId = this.getAttribute("data-enquiry-user-id");

                                // Check already viewed
                                const alreadyViewed = viewedContacts.some(
                                    item => item.enquiryId == enquiryId
                                );

                                if (!alreadyViewed) {
                                    // Count how many enquiries unlocked
                                    const userViewedCount = viewedContacts.length;

                                    if (userViewedCount >= MAX_VIEWS) {
                                        // Show upgrade modal
                                        const modal = document.createElement('div');
                                        modal.innerHTML = `
                                            <div class="modal fade" id="upgradeModal" tabindex="-1" role="dialog">
                                                <div class="modal-dialog modal-dialog-centered" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title">Upgrade Required</h5>
                                                            <button type="button" class="close" data-dismiss="modal">&times;</button>
                                                        </div>
                                                        <div class="modal-body">
                                                            Dear ${AUTH_USER_TYPE}, you can only view ${MAX_VIEWS} leads on free plan. Kindly upgrade your package to view all.
                                                        </div>
                                                        <div class="modal-footer">
                                                            <a href="{{ route('agent.packages.all')}}" class="btn btn-primary" >OK</a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        `;
                                        document.body.appendChild(modal);
                                        $('#upgradeModal').modal('show');
                                        return;
                                    }
                                    // Save enquiry
                                    viewedContacts.push({
                                        enquiryUserId: enquiryUserId,
                                        propertyId: propertyId,
                                        enquiryId: enquiryId
                                    });
                                    localStorage.setItem("viewedContacts", JSON.stringify(viewedContacts));
                                }

                                // Show lead details
                                const section = document.getElementById(`lead-section-${enquiryId}`);
                                const leadBtn = section.querySelector(".view-leads-btn");
                                const leadDetails = section.querySelector(".lead-details");

                                if (leadBtn) leadBtn.remove();
                                if (leadDetails) leadDetails.style.display = "block";
                            });
                        });
                    });
                </script>

                @if ($property->status == 1)
                <a class="btn btn-sm btn-outline-primary contact mt-1" href="{{ $propertyUrl }}" target="_blank">
                    View Properties
                </a>
                @else
                <a href="#" class="btn btn-sm btn-outline-primary mt-1 contact"
                    onclick="alert('Property might be pending.'); return false;">
                    View Properties
                </a>
                @endif
            </div>


        </div>
    </div>
    @endif
    @endforeach
    <div class="mt-3">
        {{ $contacts->links() }}
    </div>
</div>

@endsection
@section('scripts')
<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
    function toggleShareOptions(event, propertyId) {
        event.stopPropagation();
        var shareOptions = document.getElementById('share-options-' + propertyId);
        shareOptions.style.display = (shareOptions.style.display === 'none' || shareOptions.style.display === '') ?
            'block' : 'none';
        setTimeout(function() {
            shareOptions.style.display = 'none';
        }, 3000);
    }

    function copyLink(link) {
        navigator.clipboard.writeText(link).then(() => {
            alert('Link copied to clipboard!');
        }).catch(() => {
            alert('Failed to copy link!');
        });
    }
    // Close dropdown on click outside
    document.addEventListener('click', function() {
        document.querySelectorAll('.share-options').forEach(el => el.style.display = 'none');
    });
</script>
@endsection