@props([
    'attributes' => collect(), // Default empty collection
    'selected' => [],
])

@if($attributes->isNotEmpty())
    @foreach($attributes as $attribute)
        <div class="card my-4">
            <div class="card-header">
                <h6>{{ $attribute->name }} 
                    <small>(Select at least 2)</small>
                </h6>
            </div>
            <div class="card-body">
                @foreach($attribute->options as $option)
                    <div class="form-check">
                        <input type="checkbox" 
                               class="form-check-input"
                               name="attributes[{{ $attribute->id }}][]"
                               value="{{ $option->id }}"
                               id="attr-{{ $attribute->id }}-opt-{{ $option->id }}"
                               {{ in_array($option->id, $selected[$attribute->id] ?? []) ? 'checked' : '' }}>
                        <label class="form-check-label" for="attr-{{ $attribute->id }}-opt-{{ $option->id }}">
                            {{ $option->name }}
                        </label>
                    </div>
                @endforeach
            </div>
        </div>
    @endforeach
@endif