@props([
    'areaLabel' => 'Plot Area',
    'areaName' => 'plot_area',
    'lengthName' => 'plot_length',
    'widthName' => 'plot_width',
    'unitName' => 'area_unit',
    'unitLabel' => 'Select Unit',
    'selectedArea' => old('plot_area'),
    'selectedLength' => old('plot_length'),
    'selectedWidth' => old('plot_width'),
    'selectedUnit' => old('area_unit'), // No default here to show "Select Unit"
    'showDimensions' => true,
    'id' => 'area-' . uniqid(),
])
@php
    $unitId = $id . '-unit-selector';
    $unitMap = [
        'sqft' => 'Sq. Ft.',
        'sqm' => 'Sq. Mtr.',
        'acres' => 'Acres',
    ];
    $unitLabels = [
        'sqft' => 'feet',
        'sqm' => 'meter',
        'acres' => 'acres',
    ];

    // For display purposes, default to 'sqft' but don't select it in dropdown
$displayUnit = in_array($selectedUnit, ['sqft', 'sqm', 'acres']) ? $selectedUnit : 'sqft';
@endphp
<div id="{{ $id }}-wrapper" class="area-component-wrapper">
    <div class="card my-1">
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <div class="form-group px-3">
                        <h6 class="my-2">
                            {{ __($areaLabel) }}
                            <span data-unit-display>(in {{ $unitMap[$displayUnit] }})</span>
                        </h6>

                        <div class="d-flex align-items-center gap-0">
                            <div class="flex-grow-1">
                                <input type="number" placeholder="Enter the area of plot" name="{{ $areaName }}"
                                    class="form-control" step="0.2" value="{{ $selectedArea }}"
                                    data-unit-dependent="true">
                            </div>
                            <div style="width: 150px;">
                                <select name="{{ $unitName }}" class="form-control unit-select"
                                    id="{{ $unitId }}">
                                    <option value="" {{ empty($selectedUnit) ? 'selected' : '' }}>
                                        {{ __('Select Unit') }}</option>
                                    <option value="sqft" {{ $selectedUnit == 'sqft' ? 'selected' : '' }}>Sq. Ft.
                                    </option>
                                    <option value="sqm" {{ $selectedUnit == 'sqm' ? 'selected' : '' }}>Sq. Mtr.
                                    </option>
                                    @if (isset($property) && $property->category_id == 33)
                                        <option value="acres" {{ $selectedUnit == 'acres' ? 'selected' : '' }}>Acres
                                            {{ $property->category_id == 33 ? '(For Plots)' : '' }}
                                        </option>
                                    @endif
                                </select>
                            </div>
                        </div>
                        @error($areaName)
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                        @error($unitName)
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6"></div>
            </div>

            @if ($showDimensions)
                <div class="row px-3">
                    <div class="col-md-12">
                        <h6 class="my-2">{{ __('Plot Dimensions') }}</h6>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <p>Length (in <span class="unit-label">{{ $unitLabels[$displayUnit] }}</span>)</p>
                            <input type="number" name="{{ $lengthName }}" placeholder="Length" class="form-control"
                                value="{{ $selectedLength }}" data-unit-dependent="true">
                            @error($lengthName)
                                <small class="text-danger">{{ $message }}</small>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <p>Breadth (in <span class="unit-label">{{ $unitLabels[$displayUnit] }}</span>)</p>
                            <input type="number" name="{{ $widthName }}" placeholder="Breadth" class="form-control"
                                value="{{ $selectedWidth }}" data-unit-dependent="true">
                            @error($widthName)
                                <small class="text-danger">{{ $message }}</small>
                            @enderror
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const unitMap = @json($unitMap);
        const unitLabels = @json($unitLabels);

        const unitSelect = document.getElementById('{{ $unitId }}');

        function updateUnitDisplays(selectedUnit) {
            // Default to 'sqft' for display if nothing selected
            const displayUnit = selectedUnit || 'sqft';

            // Update area unit display
            document.querySelectorAll('[data-unit-display]').forEach(el => {
                el.textContent = `(in ${unitMap[displayUnit]})`;
            });

            // Update dimension unit labels
            document.querySelectorAll('.unit-label').forEach(el => {
                el.textContent = unitLabels[displayUnit];
            });
        }

        // Initialize with current selected unit or 'sqft' for display
        updateUnitDisplays('{{ $selectedUnit }}');

        // Handle changes
        if (unitSelect) {
            unitSelect.addEventListener('change', function() {
                updateUnitDisplays(this.value);
            });

            // Ensure 'sqft' is submitted if nothing selected
            unitSelect.form?.addEventListener('submit', function() {
                if (!unitSelect.value) {
                    const hiddenInput = document.createElement('input');
                    hiddenInput.type = 'hidden';
                    hiddenInput.name = unitSelect.name;
                    hiddenInput.value = 'sqft';
                    unitSelect.parentNode.appendChild(hiddenInput);
                }
            });
        }
    });
</script>
