
        <div class="form-group">
            <h6 class="my-2">{{ __($label) }}</h6>
            <div class="checkbox-button-group">
                @php
                    $selectedOptions = old($name, $selected ?? []);
                @endphp
                @foreach ($options as $key => $option)
                    @php
                        $optionValue = is_string($key) ? $key : $option;
                        $optionId = $name . '_' . preg_replace('/[^a-z0-9_]+/i', '_', $optionValue);
                        $isChecked = is_array($selectedOptions) && in_array($optionValue, $selectedOptions);
                    @endphp
                    <div class="checkbox-button">
                        <input type="checkbox" id="{{ $optionId }}" name="{{ $name }}[]"
                            value="{{ $optionValue }}" {{ $isChecked ? 'checked' : '' }}>
                        <label for="{{ $optionId }}">{{ $option }}</label>
                    </div>
                @endforeach
            </div>
                    @error($name)
            <small class="text-danger">{{ $message }}</small>
        @enderror
        </div>
