@props([
    'label' => 'Construction Status',
    'constructionStatus' => old('construction_status', isset($property) ? $property->construction_status : ''),
    'possessionDate' => old('possession_date', isset($property) ? $property->possession_date : null),
    'propertyAge' => old('property_age', isset($property) ? $property->property_age : null),
    'possessionDateLabel' => $possessionDateLabel ?? 'Possession Date',
    'property' => null,
])
<div class="card my-1" id="construction_status">
    <div class="card-body">
        <div class="form-group">
            <label for="">{{ $label }} </label>
            <div class="d-flex flex-wrap">
                <div>
                    <input type="radio" id="ready_to_move" name="construction_status" value="ready-to-move"
                        {{ $constructionStatus == 'ready-to-move' ? 'checked' : '' }}>
                    <label for="ready_to_move">&nbsp;Ready to Move &nbsp;</label>
                </div>
                <div>
                    <input type="radio" id="under_construction" name="construction_status" value="under-construction"
                        {{ $constructionStatus == 'under-construction' ? 'checked' : '' }}>
                    <label for="under_construction">&nbsp;Under Construction &nbsp;</label>
                </div>
            </div>
            @error('construction_status')
                <small class="text-danger">{{ $message }}</small>
            @enderror
        </div>
        <div id="possession_date_field"
            style="{{ $constructionStatus == 'under-construction' || $possessionDate ? '' : 'display:none;' }}">
            <div class="form-group">
                <label for="possession_date">{{ $possessionDateLabel }}</label><br>
                <input type="date" id="possession_date" name="possession_date" class="form-control calender w-25"
                    value="{{ $possessionDate }}"
                    x-bind:required="document.getElementById('under_construction').checked">
                @error('possession_date')
                    <small class="text-danger">{{ $message }}</small>
                @enderror
            </div>
        </div>
        <div id="age_field" style="{{ $constructionStatus == 'ready-to-move' || $propertyAge ? '' : 'display:none;' }}">
           @if($property->looking_for == 'for_rent')
                <div class="form-group">
                    <label for="possession_date">{{ $possessionDateLabel }}</label><br>
                    <input type="date" id="possession_date" name="possession_date" class="form-control calender w-25"
                        value="{{ $possessionDate }}"
                        x-bind:required="document.getElementById('under_construction').checked">
                    @error('possession_date')
                        <small class="text-danger">{{ $message }}</small>
                    @enderror
                </div>
            @endif 
            <div class="form-group">
                <label for="property_age">Age of Property (in years)</label>
                <div class="d-flex align-items-center">
                    <input type="text" id="property_age_display" class="form-control w-25"
                        placeholder="Enter age of property"
                        x-bind:required="document.getElementById('ready_to_move').checked"
                        value="{{ $propertyAge ? $propertyAge . ' ' . ($propertyAge == 1 ? 'year' : 'years') : '' }}">
                    <input type="hidden" id="property_age" name="property_age" value="{{ $propertyAge }}">
                </div>
                @error('property_age')
                    <small class="text-danger">{{ $message }}</small>
                @enderror
            </div>
        </div>
    </div>
</div>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const ageDisplayInput = document.getElementById('property_age_display');
        const ageHiddenInput = document.getElementById('property_age');

        function formatAgeInput() {
            if (!ageDisplayInput || !ageHiddenInput) return;

            let input = ageDisplayInput.value.replace(/[^\d]/g, ''); // remove non-digit characters
            const num = parseInt(input);

            if (!isNaN(num) && num >= 0) {
                const suffix = (num === 1) ? 'year' : 'years';
                ageDisplayInput.value = `${num} ${suffix}`;
                ageHiddenInput.value = num; // update actual form value
            } else {
                ageDisplayInput.value = '';
                ageHiddenInput.value = '';
            }
        }

        if (ageDisplayInput) {
            ageDisplayInput.addEventListener('input', formatAgeInput);
            formatAgeInput(); // trigger on load
        }

        const readyToMoveRadio = document.getElementById('ready_to_move');
        const underConstructionRadio = document.getElementById('under_construction');
        const ageField = document.getElementById('age_field');
        const possessionDateField = document.getElementById('possession_date_field');
        const possessionDateInput = document.getElementById('possession_date');
        const propertyAgeDisplayInput = document.getElementById('property_age_display');

        function toggleConstructionFields() {
            if (!readyToMoveRadio || !underConstructionRadio || !ageField || !possessionDateField) return;

            if (readyToMoveRadio.checked) {
                ageField.style.display = 'block';
                possessionDateField.style.display = 'none';
                // Clear possession date when switching to ready-to-move
                possessionDateInput.value = '';
                possessionDateInput.removeAttribute('required');
                propertyAgeDisplayInput.setAttribute('required', 'required');
            } else if (underConstructionRadio.checked) {
                ageField.style.display = 'none';
                possessionDateField.style.display = 'block';
                // Clear property age when switching to under-construction
                document.getElementById('property_age').value = '';
                ageDisplayInput.value = '';
                possessionDateInput.setAttribute('required', 'required');
                propertyAgeDisplayInput.removeAttribute('required');
            }
        }

        if (readyToMoveRadio && underConstructionRadio) {
            readyToMoveRadio.addEventListener('change', toggleConstructionFields);
            underConstructionRadio.addEventListener('change', toggleConstructionFields);
            toggleConstructionFields();
        }
    });

    // Calendar Picker
    const calendar = document.getElementById('possession_date');
    if (calendar) {
        calendar.addEventListener('click', function() {
            this.showPicker && this.showPicker(); // triggers native date picker
        });
    }
</script>
