@props([
    'totalFloors' => null, // Prop for Total Floors
    'propertyOnFloor' => null, // Prop for Property on Floor
])

        <!-- Total Floors Input -->
        <div class="form-group">
            <h6 class="my-2">{{ __('Total Floors') }}</h6>
            <input type="text" name="total_floors" id="total_floors" class="form-control w-50"
                value="{{ old('total_floors', $totalFloors ?? '') }}" placeholder="Enter total number of floors">
            @error('total_floors')
                <small class="text-danger">{{ $message }}</small>
            @enderror
        </div>

        <!-- Property on Floor Select Input -->
        <h6 class="my-2">{{ __('Property on Floor') }}</h6>
        <select class="form-control w-50" id="property-floor" name="property_on_floor">
            <option value="">{{ __('Select Floor') }}</option>
            <option value="basement" {{ $propertyOnFloor == 'basement' ? 'selected' : '' }}>
                Basement
            </option>
            <option value="lower-ground" {{ $propertyOnFloor == 'lower-ground' ? 'selected' : '' }}>
                Lower Ground
            </option>
            <option value="ground" {{ $propertyOnFloor == 'ground' ? 'selected' : '' }}>
                Ground
            </option>

            @for ($i = 1; $i <= 50; $i++)
                <option value="{{ $i }}" {{ $propertyOnFloor == $i ? 'selected' : '' }}>
                    {{ $i }}
                </option>
            @endfor

            <option value="50+" {{ $propertyOnFloor == '50+' ? 'selected' : '' }}>
                50+
            </option>
        </select>
        @error('property_on_floor')
            <small class="text-danger">{{ $message }}</small>
        @enderror


<script>
    document.addEventListener('DOMContentLoaded', function() {
        const totalFloorsInput = document.getElementById('total_floors');
        const floorSelect = document.getElementById('property-floor');
        const staticOptions = `
            <option value="">{{ __('Select Floor') }}</option>
            <option value="basement">Basement</option>
            <option value="lower-ground">Lower Ground</option>
            <option value="ground">Ground</option>
        `;

        // Pass the old value for property_on_floor from Blade to JavaScript
        const selected = @json(old('property_on_floor', $propertyOnFloor));

        function updateFloorOptions(maxFloor) {
            let options = staticOptions;
            maxFloor = parseInt(maxFloor);

            if (!isNaN(maxFloor) && maxFloor > 0) {
                if (maxFloor <= 50) {
                    // Show options from 1 to maxFloor
                    for (let i = 1; i <= maxFloor; i++) {
                        options += `<option value="${i}" ${selected == i ? 'selected' : ''}>${i}</option>`;
                    }
                } else {
                    // Show options from 1 to 50 and then show '50+'
                    for (let i = 1; i <= 50; i++) {
                        options += `<option value="${i}" ${selected == i ? 'selected' : ''}>${i}</option>`;
                    }
                    options += `<option value="50+" ${selected == '50+' ? 'selected' : ''}>50+</option>`;
                }
            }

            floorSelect.innerHTML = options;
        }

        // Listen for input changes in totalFloorsInput
        totalFloorsInput.addEventListener('input', function() {
            updateFloorOptions(this.value);
        });

        // Initial load (for old or edit value)
        updateFloorOptions(totalFloorsInput.value);

        // Also handle the case where the value is non-numeric (basement, lower-ground, etc.)
        if (['basement', 'lower-ground', 'ground'].includes(selected)) {
            floorSelect.value = selected;
        }
    });
</script>
