@props(['label' => 'Located Inside', 'name', 'options' => [], 'selected' => null, 'otherValue' => null])
<style>
    .simple-line {
        border: none;
        border-bottom: 1px solid #ccc;
        border-radius: 0;
        background: transparent;
        box-shadow: none;
        padding-left: 5;
        padding-right: 0;
        outline: none;
        width: 77%;
        font-size: 14px;
        color: #6e707e;
        margin-left: 10px;
    }

    .simple-line:focus {
        border-color: #007bff;
        box-shadow: none;
    }
</style>
<div class="card my-1">
    <div class="card-body">
        <div class="form-group">
            <h6 class="my-2">{{ $label }}</h6>
            <div class="d-flex flex-wrap">
                @foreach ($options as $value => $label)
                    <div>
                        <input type="radio" id="{{ $value }}" name="{{ $name }}"
                            value="{{ $value }}" {{ $selected === $value ? 'checked' : '' }}>
                        <label for="{{ $value }}">{{ $label }}</label>
                    </div>
                @endforeach
                {{-- Other Option --}}
                <div>
                    <input type="radio" id="other_{{ $name }}" name="{{ $name }}" value="other"
                        {{ $selected === 'other' ? 'checked' : '' }}>
                    <label for="other_{{ $name }}">Other</label>
                </div>
            </div>
            {{-- Other Input Field --}}
            <div class="mt-3" id="other-located-input"
            style="display: {{ $selected === 'other' ? 'block' : 'none' }};">
            <input type="text" id="other_{{ $name }}" name="other_{{ $name }}"
                placeholder="Other location" value="{{ $otherValue }}" class="simple-line">
        </div>
        </div>
    </div>
</div>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const radios = document.querySelectorAll('input[name="{{ $name }}"]');
        const otherInput = document.getElementById('other-located-input');

        function toggleOtherField() {
            const selected = document.querySelector('input[name="{{ $name }}"]:checked');
            otherInput.style.display = (selected && selected.value === 'other') ? 'block' : 'none';
        }

        radios.forEach(radio => radio.addEventListener('change', toggleOtherField));
        toggleOtherField();
    });
</script>
