@props([
    'totalFloors' => null,
    'propertyOnFloor' => null,
    'bhk', // 🆕 Required for nesting input names correctly
])

<!-- Total Floors Input -->
<div class="form-group">
    <h6 class="my-2">{{ __('Total Floors') }}</h6>
    <input type="text" name="flats[{{ $bhk }}][total_floors]" id="total_floors_{{ $bhk }}"
        class="form-control w-50" value="{{ old("flats.$bhk.total_floors", $totalFloors ?? '') }}"
        placeholder="Enter total number of floors">
    @error("flats.$bhk.total_floors")
        <small class="text-danger">{{ $message }}</small>
    @enderror
</div>

<!-- Property on Floor Select Input -->
<h6 class="my-2">{{ __('Property on Floor') }}</h6>
<select class="form-control w-50" id="property-floor-{{ $bhk }}"
    name="flats[{{ $bhk }}][property_on_floor]">
    <option value="">{{ __('Select Floor') }}</option>
    <option value="basement" {{ $propertyOnFloor == 'basement' ? 'selected' : '' }}>Basement</option>
    <option value="lower-ground" {{ $propertyOnFloor == 'lower-ground' ? 'selected' : '' }}>Lower Ground</option>
    <option value="ground" {{ $propertyOnFloor == 'ground' ? 'selected' : '' }}>Ground</option>
    @for ($i = 1; $i <= 50; $i++)
        <option value="{{ $i }}" {{ $propertyOnFloor == $i ? 'selected' : '' }}>{{ $i }}
        </option>
    @endfor
    <option value="50+" {{ $propertyOnFloor == '50+' ? 'selected' : '' }}>50+</option>
</select>
@error("flats.$bhk.property_on_floor")
    <small class="text-danger">{{ $message }}</small>
@enderror

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const totalFloorsInput = document.getElementById('total_floors_{{ $bhk }}');
        const floorSelect = document.getElementById('property-floor-{{ $bhk }}');
        const staticOptions = `
            <option value="">{{ __('Select Floor') }}</option>
            <option value="basement">Basement</option>
            <option value="lower-ground">Lower Ground</option>
            <option value="ground">Ground</option>
        `;

        const selected = @json(old("flats.$bhk.property_on_floor", $propertyOnFloor));

        function updateFloorOptions(maxFloor) {
            let options = staticOptions;
            maxFloor = parseInt(maxFloor);

            if (!isNaN(maxFloor) && maxFloor > 0) {
                if (maxFloor <= 50) {
                    for (let i = 1; i <= maxFloor; i++) {
                        options += `<option value="${i}" ${selected == i ? 'selected' : ''}>${i}</option>`;
                    }
                } else {
                    for (let i = 1; i <= 50; i++) {
                        options += `<option value="${i}" ${selected == i ? 'selected' : ''}>${i}</option>`;
                    }
                    options += `<option value="50+" ${selected == '50+' ? 'selected' : ''}>50+</option>`;
                }
            }

            floorSelect.innerHTML = options;
        }

        totalFloorsInput.addEventListener('input', function() {
            updateFloorOptions(this.value);
        });

        updateFloorOptions(totalFloorsInput.value);

        if (['basement', 'lower-ground', 'ground'].includes(selected)) {
            floorSelect.value = selected;
        }
    });
</script>
