<div class="card my-1">
    <div class="card-body">
        <h6 class="my-1">{{ __($label) }}</h6>
        <div id="dynamic-fields-container">
            @php
                $facilities = $facilities ?? [];
                $facilityDistances = old('facilities')
                    ? collect(old('facilities'))->map(function ($facility, $index) {
                        return [
                            'facility_id' => old("facilities.$index"),
                            'distance' => old("distances.$index"),
                            'distance_unit' => old("distance_units.$index"),
                        ];
                    })->toArray()
                    : ($facilityDistances ?? []);

                $facilityCount = max(2, count($facilityDistances));
            @endphp

            @for ($i = 0; $i < $facilityCount; $i++)
                <div class="row dynamic-field">
                    <!-- Facility Selection -->
                    <div class="col-md-3">
                        <select name="facilities[]" class="form-control" {{ $i < 2 ? 'required' : '' }}>
                            <option value="">{{ __('Select Facility') }}</option>
                            @foreach ($facilities as $facility)
                                <option value="{{ $facility->id }}" {{ ($facilityDistances[$i]['facility_id'] ?? '') == $facility->id ? 'selected' : '' }}>
                                    {{ $facility->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <!-- Distance Input & Unit -->
                    <div class="col-md-7 d-flex">
                        <input type="number" class="form-control" name="distances[]"
                            placeholder="Distance (e.g., 200m, 1km...)"
                            value="{{ $facilityDistances[$i]['distance'] ?? '' }}" {{ $i < 2 ? 'required' : '' }}>

                        <select class="form-control ml-2" name="distance_units[]" {{ $i < 2 ? 'required' : '' }}>
                            <option value="">{{ __('Select Unit') }}</option>
                            
                            <option value="Meter" {{ ($facilityDistances[$i]['distance_unit'] ?? '') == 'Meter' ? 'selected' : '' }}>
                                Meter
                            </option>
                            <option value="Kilometer" {{ ($facilityDistances[$i]['distance_unit'] ?? '') == 'Kilometer' ? 'selected' : '' }}>
                                Kilometer
                            </option>
                        </select>
                    </div>
                    <!-- Remove Button -->
                    <div class="col-md-1 d-flex align-items-center">
                        <button type="button" class="btn btn-light btn-sm remove-field-btn">X</button>
                    </div>
                </div>
            @endfor
        </div>
        <!-- Add New Field Button -->
        <button type="button" class="btn btn-light mt-3" id="add-new-form-btn">{{ __('Add New') }}</button>
    </div>
</div>

<script>
    document.addEventListener("DOMContentLoaded", function () {
        let container = document.getElementById("dynamic-fields-container");
        let addButton = document.getElementById("add-new-form-btn");

        addButton.addEventListener("click", function () {
            let newField = document.createElement("div");
            newField.classList.add("row", "dynamic-field", "mt-2");

            newField.innerHTML = `
            <div class="col-md-3">
                <select name="facilities[]" class="form-control">
                    <option value="">Select Facility</option>
                    @foreach ($facilities as $facility)
                        <option value="{{ $facility->id }}">{{ $facility->name }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-7 d-flex">
                <input type="number" class="form-control" name="distances[]" placeholder="Distance (e.g., 200m, 1km...)">
                <select class="form-control ml-2" name="distance_units[]">
                    <option>Select Unit</option>
                    <option value="Kilometer">Kilometer</option>
                    <option value="Meter">Meter</option>
                </select>
            </div>
            <div class="col-md-1 d-flex align-items-center">
                <button type="button" class="btn btn-light btn-sm remove-field-btn">X</button>
            </div>
        `;
            container.appendChild(newField);
        });

        container.addEventListener("click", function (e) {
            if (e.target.classList.contains("remove-field-btn")) {
                if (container.children.length > 2) {
                    e.target.closest(".dynamic-field").remove();
                }
            }
        });
    });
</script>