@props([
    // Field Naming
    'statusName' => 'status',
    'dateName' => 'date',

    // Status Options
    'statusOptions' => [
        'ready' => 'Ready to Move',
        'future' => 'Future Possession',
    ],

    // Current Values
    'selectedStatus' => old('status'),
    'selectedDate' => old('date'),

    // Labels
    'statusLabel' => 'Status',
    'dateLabel' => 'Date',

    // Customization
    'dateMin' => now()->format('Y-m-d'),
    'futureValue' => 'future',
    'readyValue' => 'ready',
])

<div x-data="{ showDate: @json($selectedStatus === $futureValue) }" class="status-date-toggle-wrapper" id="status-toggle-{{ $statusName }}">

    <!-- Dynamic Status Radio Group -->
    <div class="form-group">
        <label class="font-weight-bold">{{ $statusLabel }}</label>
        <div class="d-flex gap-4 mt-2">
            @foreach ($statusOptions as $value => $label)
                <div class="form-check">
                    <input class="form-check-input" type="radio" name="{{ $statusName }}"
                        id="{{ $statusName }}_{{ $value }}" value="{{ $value }}"
                        @checked($selectedStatus === $value)
                        x-on:change="showDate = ($event.target.value === '{{ $futureValue }}')">
                    <label class="form-check-label" for="{{ $statusName }}_{{ $value }}">
                        {{ $label }}
                    </label>
                </div>
            @endforeach
        </div>
    </div>

    <!-- Dynamic Date Field -->
    <div class="form-group mt-3" x-show="showDate" x-cloak>
        <label for="{{ $dateName }}">{{ $dateLabel }}</label>
        <input type="date" name="{{ $dateName }}" id="{{ $dateName }}" class="form-control calender"
            value="{{ $selectedDate }}" min="{{ $dateMin }}">
    </div>
</div>
