@props(['name', 'label' => '', 'options' => [], 'selected' => ''])
@if ($label)
    <label for="{{ $name }}" class="block font-medium text-sm text-gray-700 mb-1">
        {{ $label }}
    </label>
@endif

<select name="{{ $name }}" id="{{ $name }}" {{ $attributes->merge(['class' => 'form-control w-auto']) }}>
    <option value="">Select Last Entry</option>
    @foreach ($options as $value => $text)
        <option value="{{ $value }}" {{ (string) $selected === (string) $value ? 'selected' : '' }}>
            {{ $text }}
        </option>
    @endforeach
</select>
