@props([
'unitLabel' => 'Select Unit',
'unitName' => 'area_unit',
'selectedUnit' => old('area_unit'),
'id' => 'unit-selector-'.uniqid(),
])

@php
$unitMap = [
'sqft' => 'fit',
'sqm' => 'meter',
'acres' => 'acres',
];
@endphp

<div id="{{ $id }}" class="unit-selector-wrapper">
    <div class="card my-1">
        <div class="card-body">
            <div class="row">
                <div class="col-md-5">
                    <div class="form-group">
                        <h6 class="my-2">{{ __($unitLabel) }}</h6>
                        <select name="{{ $unitName }}" class="form-control unit-select">
                            <option value="select" {{ $selectedUnit == 'select' ? 'selected' : '' }} disabled selected>Select Unit</option>
                            <option value="sqft" {{ $selectedUnit == 'sqft' ? 'selected' : '' }}>Sq Fit</option>
                            <option value="sqm" {{ $selectedUnit == 'sqm' ? 'selected' : '' }}>Sq Meter</option>
                            <option value="acres" {{ $selectedUnit == 'acres' ? 'selected' : '' }}>Acres</option>
                        </select>
                        @error($name)
                        <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const unitMap = {
            'sqft': 'fit',
            'sqm': 'meter',
            'acres': 'acres'
        };

        const unitSelect = document.querySelector('#{{ $id }} .unit-select');
        const defaultUnit = 'meter'; // Set your default unit here

        function updateAllUnitDisplays(unitText) {
            if (unitText) {
                document.querySelectorAll('[data-unit-display]').forEach(element => {
                    element.textContent = unitText;
                });
                document.querySelectorAll('[data-unit-dependent="true"]').forEach(field => {
                    const formGroup = field.closest('.form-group');
                    if (formGroup) {
                        const labelElement = formGroup.querySelector('h6');
                        if (labelElement) {
                            const originalText = labelElement.textContent.replace(/\(.*\)/, '').trim();

                            if (field.name === 'price_per_sqft') {
                                labelElement.textContent = `Price Per Sq. (${unitText})`;
                            } else if (field.name === 'built_up_area') {
                                labelElement.textContent = `Built Up Area (in ${unitText})`;
                            } else if (field.name === 'carpet_area') {
                                labelElement.textContent = `Carpet Area (in ${unitText})`;
                            } else if (field.name === 'price') {
                                labelElement.textContent = `Property Expected Price ( In Rupee )`;
                            } else {
                                labelElement.textContent = `${originalText} (${unitText})`;
                            }
                        }
                    }
                });
            }
        }

        unitSelect.addEventListener('change', function() {
            const selectedUnit = this.value;
            if (selectedUnit) { // Only proceed if a unit is selected
                const unitText = unitMap[selectedUnit];
                updateAllUnitDisplays(unitText);

                document.dispatchEvent(new CustomEvent('unitChanged', {
                    detail: {
                        unit: selectedUnit,
                        unitText: unitText
                    }
                }));
            }
        });

        // Initialize with default unit if none selected
        if (!unitSelect.value) {
            unitSelect.value = defaultUnit;
            const defaultUnitText = unitMap[defaultUnit];
            updateAllUnitDisplays(defaultUnitText);
        } else {
            // Initialize with stored unit
            const initialUnit = unitSelect.value;
            const initialUnitText = unitMap[initialUnit];
            updateAllUnitDisplays(initialUnitText);
        }
    });
</script>