@props([
    'name' => 'zone_type',
    'options' => [
        'industrial' => 'Industrial',
        'commercial' => 'Commercial',
        'residential' => 'Residential',
        'special-economic-zone' => 'Special Economic Zone',
        'open-space' => 'Open Space',
        'agricultural-zone' => 'Agricultural Zone',
        'other' => 'Other',
    ],
    'selected' => old('zone_type', isset($property) ? $property->zone_type : ''),
    'otherValue' => old('other_zone_type', isset($property) ? $property->other_zone_type : ''),
])

<div class="card my-1" id="zone_type">
    <div class="card-body">
        <div class="form-group">
            <h6 class="my-2">{{ __('Zone Type') }}</h6>
            <div class="d-flex flex-wrap">
                <div>
                    @foreach ($options as $value => $label)
                        <input type="radio" id="{{ $name }}_{{ $value }}" name="{{ $name }}"
                            value="{{ $value }}" {{ $selected == $value ? 'checked' : '' }}>
                        <label for="{{ $name }}_{{ $value }}">&nbsp;{{ $label }}&nbsp;</label>
                    @endforeach
                </div>
            </div>

            @if (in_array('other', array_keys($options)))
                <div class="mt-2" id="other-zone-input"
                    style="{{ $selected == 'other' ? 'display: block;' : 'display: none;' }}">
                    <input type="text" class="w-full py-1 border-0 border-b border-gray-300 focus:outline-none px-0"
                        id="other_{{ $name }}" name="other_{{ $name }}"
                        placeholder="Specify zone type" value="{{ $otherValue }}">
                </div>
            @endif

            @error($name)
                <small class="text-danger">{{ $message }}</small>
            @enderror
            @error('other_' . $name)
                <small class="text-danger">{{ $message }}</small>
            @enderror
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const zoneRadios = document.querySelectorAll('input[name="{{ $name }}"]');
        const otherZoneInput = document.getElementById('other-zone-input');

        function toggleOtherInput() {
            if (otherZoneInput) {
                const otherRadio = document.querySelector(
                    'input[name="{{ $name }}"][value="other"]:checked');
                otherZoneInput.style.display = otherRadio ? 'block' : 'none';
            }
        }

        // Initial check
        toggleOtherInput();

        // Add event listeners
        zoneRadios.forEach(radio => {
            radio.addEventListener('change', toggleOtherInput);
        });
    });
</script>
