@extends('layouts.front')

@push('css')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/css/intlTelInput.css" />
<style>
    .iti {
        width: 100%;
    }
    .iti__country-list {
        position: absolute;
        z-index: 2;
        width: 273px;
    }
    .iti__dropdown {
        width: 100% !important;
        box-shadow: 0px 4px 8px rgba(0, 0, 0, 0.1); 
        z-index: 1050; 
    }
    .btn-primary1{
        background: #f02c2d
    }
</style>
@endpush

@section('content')
    <section class="gray"style="background: url('https://images.unsplash.com/photo-1605146769289-440113cc3d00?q=80&w=1470&auto=format&fit=crop&ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D') no-repeat center center;
background-size: cover;">
        <div class="container">
            <div class="row align-items-start justify-content-center">
                <div class="col-xl-5 ">

                    <div class="signup-screen-wrap">
                        <div class="signup-screen-single light">
                            <div class="text-center">
                                <h4 class="text-center">Give us some details about yourself</h4>
                            </div>
                            <form id="registerform1" class="row gy-3" action="{{ route('agent.register.submit') }}" method="POST">
                                @includeIf('partials.user.form-both')
                                @csrf
                                <div class="radio-group d-flex justify-content-center mb-4">
                                    <button type="button" class="btn text-dark rounded border border-dark m-2 user-type-btn" data-value="Owner">Owner</button>
                                    <button type="button" class="btn text-dark rounded border border-dark m-2 user-type-btn" data-value="Agent">Agent</button>
                                    <button type="button" class="btn text-dark rounded border border-dark m-2 user-type-btn" data-value="Builder">Builder</button>
                                </div>
                                
                    
                                <input type="hidden" name="user_type" id="user_type" value="" required>
                    
                                <!--<div class="form-group">-->
                                <!--    <label for="phone" class="form-label">{{ session('phone') }}</label>-->
                                    <!--<input type="tel" name="phone" id="phone" class="form-control rounded" placeholder = "Enter your number" required>-->
                                <!--</div>-->
                    
                                <div class="form-group">
                                    <label class="mb-1">@lang('Your Name')</label>
                                    <input type="text" name="name" class="form-control rounded" required>
                                </div>
                    
                                <div class="form-group">
                                    <label class="mb-1">@lang('Email')</label>
                                    <input type="email" name="email" class="form-control rounded" required>
                                </div>
                    
                                <div class="form-group">
                                    <label class="mb-1">@lang('Password')</label>
                                    <input type="password" name="password" class="form-control rounded" required>
                                </div>
                    
                                <div class="form-group">
                                    <button type="submit" class="btn rounded add-listing theme-bg w-100">
                                        @lang('Continue') <div class="spinner-border formSpin d-none" role="status"></div>
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>


                </div>
            </div>
        </div>
    </section>

@includeIf('partials.front.cta')
@endsection

@push('js')
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="{{asset('assets/front/js/custom-agent.js')}}"></script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/intlTelInput.min.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const phoneInput = document.querySelector("#phone");

        const iti = intlTelInput(phoneInput, {
            initialCountry: "in", 
            separateDialCode: true,
            preferredCountries: ["in", "us", "gb"], 
            utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/utils.js", 
        });

        const continueButton = document.querySelector("#continueButton");
        const otpModal = new bootstrap.Modal(document.getElementById('otpModal'));
        const hiddenPhoneInput = document.querySelector("#hiddenPhoneInput");

        continueButton.addEventListener("click", function () {
            const fullPhoneNumber = iti.getNumber(); 
            hiddenPhoneInput.value = fullPhoneNumber; 
            otpModal.show(); 
        });
    });
</script>
<script>
      document.addEventListener('DOMContentLoaded', function () {
            const userTypeButtons = document.querySelectorAll('.user-type-btn');
            const userTypeInput = document.getElementById('user_type');
        
            userTypeButtons.forEach(button => {
                button.addEventListener('click', function () {
                    userTypeInput.value = this.getAttribute('data-value'); 
                    
                    userTypeButtons.forEach(btn => btn.classList.remove('theme-bg', 'text-white'));
                    this.classList.add('theme-bg', 'text-white');
                });
            });
        
            document.getElementById('registerform1').addEventListener('submit', function(e) {
                const userType = userTypeInput.value; 
                if (!userType) {
                    e.preventDefault(); 
                    alert('Please select a user type'); 
                }
            });
        });

    
</script>

@endpush
