@extends('layouts.front')
@push('css')
@endpush
@section('content')
@if (in_array('Banner', $home_modules))
<!-- ============================ Hero Banner  Start================================== -->
<div class="image-cover hero-banner"
    style="background:url({{ asset('assets/images/' . $ps->hero_photo) }}) no-repeat;" data-overlay="6">
    <div class="container">
        <h1 class="big-header-capt mb-1">{{ $ps->banner_title }}</h1>
        <form action="" method="GET" id="search-form">
            <input name="type" type="hidden" value="for_sell" />
            <div class="property-search">
                <a id="buy-link" href="{{ route('buy.index.location', ['city' => 'CITY_PLACEHOLDER']) }}">
                    <label class="active">@lang('BUY')</label>
                </a>
                <a id="rent-link" href="{{ route('rent.index.location', ['city' => 'CITY_PLACEHOLDER']) }}">
                    <label>@lang('RENT')</label>
                </a>
                <a id="commercial-link"
                    href="{{ route('commercial.index.location', ['city' => 'CITY_PLACEHOLDER']) }}">
                    <label>@lang('COMMERCIAL')</label>
                </a>
                <a id="pg-link" href="{{ route('pg.index.location', ['city' => 'CITY_PLACEHOLDER']) }}">
                    <label>@lang('PG/CO-LIVING')</label>
                </a>
                <a id="plot-link" href="{{ route('plot.index.location', ['city' => 'CITY_PLACEHOLDER']) }}">
                    <label>@lang('PLOTS')</label>
                </a>
            </div>

            <div class="full-search-2 eclip-search italian-search hero-search-radius">
                <div class="hero-search-content">
                    <div class="row">
                        <div class="col-lg-3 col-md-3 col-sm-12 small-padd">
                            <div class="form-group">
                                <div class="input-with-icon b-l b-r">
                                    <select id="location" class="form-control" name="location_id">
                                        <option value=""></option>
                                        <optgroup label="Top Cities">
                                            @foreach ($topCities as $data)
                                            <option value="{{ $data->id }}"
                                                data-city="{{ strtolower(Str::slug($data->name)) }}"
                                                {{ strtolower(Str::slug($data->name)) == strtolower(Str::slug($currentLocation)) ? 'selected' : '' }}>
                                                {{ $data->name }}
                                            </option>
                                            @endforeach
                                        </optgroup>

                                        <optgroup label="Other Cities">
                                            @foreach ($otherCities as $data)
                                            <option value="{{ $data->id }}"
                                                data-city="{{ strtolower(Str::slug($data->name)) }}"
                                                {{ strtolower(Str::slug($data->name)) == strtolower(Str::slug($currentLocation)) ? 'selected' : '' }}>
                                                {{ $data->name }}
                                            </option>
                                            @endforeach
                                        </optgroup>
                                    </select>
                                    <i class="ti-location-pin"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-6 col-sm-12 small-padd">
                            <div class="form-group relative">
                                <div class="input-with-icon">
                                    <input type="text" class="form-control b-r" id="locality-search"
                                        name="name" autocomplete="off" placeholder="@lang('Search for locality, landmark, project, or builder')">
                                    <div class="w-100" id="suggestions"></div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-1 col-md-1 col-sm-12 small-padd">
                        </div>
                        <div class="col-lg-2 col-md-2 col-sm-12 small-padd">
                            <div class="form-group">
                                <button type="submit" class="btn search-btn">@lang('Search')</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>
<!-- ============================ Hero Banner End ================================== -->
@endif
@if (in_array('Explore Property', $home_modules))
<!-- ============================ Latest Property For Sale Start ================================== -->
<section class="gray">
    <div class="container">
        <div class="row">
            <div class="col-lg-12 col-md-12">
                <div class="sec-heading center mb-3">
                    <h2>{{ $ps->explore_ptitle }}</h2>
                    <p>{{ $ps->explore_psub }}</p>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12 col-md-12">
                <div class="property-slide">
                    @foreach ($properties as $key => $data)
                    <!-- Single Property -->
                    <div class="single-items">
                        <a href="{{ route('buy.details', $data->slug) }}">
                            <div class="property_item classical-list">
                                <div class="image">
                                    <img src="{{ asset('assets/images/' . $data->photo) }}"
                                        alt="latest property" class="img-fluid"
                                        style="width: 422px; height: 260px; object-fit: cover;">
                                    <div class="sb-date">
                                        <span class="tag">
                                            <i class="ti-calendar"></i>
                                            {{ $data->created_at->diffForHumans() }}
                                        </span>
                                    </div>
                                    <span class="tag_t">
                                        {{ $data->type == 'for_rent' ? __('For Rent') : __('For Sell') }}
                                    </span>
                                </div>
                                @php
                                $features = [];
                                if ($data->no_of_bhk) {
                                $features[] =
                                '<p><i class="bi bi-house-door"></i> No Of BHK <b><br>' .
                                        strtoupper($data->no_of_bhk) .
                                        '</b></p>';
                                }

                                if ($data->carpet_area) {
                                $features[] =
                                '<p><i class="bi bi-rulers"></i> Carpet Area <b><br>' .
                                        $data->carpet_area .
                                        ' ' .
                                        $data->area_unit .
                                        '</b></p>';
                                }

                                if ($data->price_per_sqft) {
                                $features[] =
                                '<p><i class="bi bi-currency-rupee"></i> Price/' .
                                    $data->area_unit .
                                    ' <b><br>₹' .
                                        $data->price_per_sqft .
                                        '</b></p>';
                                }

                                if ($data->construction_status) {
                                $features[] =
                                '<p><i class="bi bi-building"></i> Construction Status <b><br>' .
                                        ucwords(str_replace('-', ' ', $data->construction_status)) .
                                        '</b></p>';
                                }

                                if (
                                $data->construction_status == 'under-construction' &&
                                $data->possession_date
                                ) {
                                $features[] =
                                '<p><i class="bi bi-calendar-check"></i> Possession Date <b><br>' .
                                        $data->possession_date .
                                        '</b></p>';
                                } elseif (
                                $data->construction_status == 'ready-to-move' &&
                                $data->property_age
                                ) {
                                $features[] =
                                '<p><i class="bi bi-clock-history"></i> Property Age <b><br>' .
                                        $data->property_age .
                                        ' ' .
                                        ($data->property_age == 1 ? 'Year' : 'Years') .
                                        '</b></p>';
                                }

                                if ($data->sale_type) {
                                $features[] =
                                '<p><i class="bi bi-tags"></i> Booking Type <b><br>' .
                                        ucfirst(str_replace('-', ' ', $data->sale_type)) .
                                        '</b></p>';
                                }

                                if ($data->plot_area) {
                                $features[] =
                                '<p><i class="bi bi-rulers"></i> Plot Area <b><br>' .
                                        $data->plot_area .
                                        ' ' .
                                        $data->area_unit .
                                        '</b></p>';
                                }

                                if ($data->plot_length && $data->plot_width) {
                                $features[] =
                                '<p><i class="bi bi-bounding-box-circles"></i> Plot Dimensions <b><br>' .
                                        ucfirst($data->plot_length . ' X ' . $data->plot_width) .
                                        '</b></p>';
                                }

                                if ($data->floors_allowed) {
                                $features[] =
                                '<p><i class="bi bi-building"></i> Floors Allowed <b><br>' .
                                        $data->floors_allowed .
                                        ' ' .
                                        ($data->floors_allowed == 1 ? 'Floor' : 'Floors') .
                                        '</b></p>';
                                }

                                if ($data->open_sides) {
                                $features[] =
                                '<p><i class="bi bi-box-arrow-in-left"></i> No. Of Open Sides <b><br>' .
                                        $data->open_sides .
                                        ' ' .
                                        ($data->open_sides == 1 ? 'Side' : 'Sides') .
                                        '</b></p>';
                                }

                                if ($data->construction_type) {
                                $features[] =
                                '<p><i class="bi bi-tools"></i> Type of Construction <b><br>' .
                                        ucfirst($data->construction_type) .
                                        '</b></p>';
                                }

                                if ($data->possession_status) {
                                $features[] =
                                '<p><i class="bi bi-info-circle"></i> Possession Status <b><br>' .
                                        ucfirst($data->possession_status) .
                                        '</b></p>';
                                }

                                if ($data->ownership) {
                                $features[] =
                                '<p><i class="bi bi-person-check"></i> Ownership <b><br>' .
                                        ucwords(str_replace('-', ' ', $data->ownership)) .
                                        '</b></p>';
                                }

                                // Limit to 6 features
                                $features = array_slice($features, 0, 6);
                                @endphp

                                <div class="proerty_content">
                                    <div class="proerty_text">
                                        <h3 class="captlize">{{ $data->name }}</h3>
                                        <p class="proerty_price">
                                            {{ showAmount($data->price ?? ($data->expacted_price ?? 'N/N')) }}
                                        </p>
                                    </div>

                                    <p class="property_add" style="font-size: 11px">
                                        <span
                                            class="comma-format">{{ $data->locality }}{{ $data->location ? ', ' . $data->location->name : '' }}</span>
                                    </p>

                                    @if (count($features) > 0)
                                    <div class="row text-muted" style="font-size: 11px">
                                        @foreach ($features as $feature)
                                        <div class="col-6 mb-2">
                                            {!! $feature !!}
                                        </div>
                                        @endforeach
                                    </div>
                                    @endif

                                    <div class="property_links">
                                        <button type="button" class="btn btn-primary rounded border-primary">
                                            @lang('Property Detail')
                                        </button>
                                    </div>
                                </div>

                            </div>
                        </a>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</section>
<!-- ============================ Latest Property For Sale End ================================== -->
@endif
@if (in_array('Location', $home_modules))
<!-- ============================ Property Location Start ================================== -->
<section>
    <div class="container">
        <div class="row">
            <div class="col-lg-12 col-md-12">
                <div class="sec-heading center">
                    <h2>{{ $ps->location_title }}</h2>
                    <p>{{ $ps->location_subtitle }}</p>
                </div>
            </div>
        </div>
        <div class="row">
            @foreach ($locations_for_section as $key => $data)
            <!-- Single Location Listing -->
            <div class="col-lg-3 col-md-3 col-sm-6">
                <div class="location-listing">
                    <div class="location-listing-thumb">
                        <a href="{{ route('buy.search', ['locality' => strtolower($data->name),'city' => strtolower($data->name)]) }}"><img
                                src="{{ asset('assets/images/' . $data->photo) }}" class="img-fluid"
                                alt="" /></a>
                    </div>
                    <div class="location-listing-caption">
                        <h4><a
                                href="{{ route('buy.search', ['locality' => strtolower($data->name),'city' => strtolower($data->name)]) }}">{{ $data->name }}</a>
                        </h4>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
    </div>
</section>
<!-- ============================ Property Location End ================================== -->
@endif
@if (in_array('Testimonials', $home_modules))
<!-- ============================ Smart Testimonials ================================== -->
<section class="image-cover pb-0"
    style="background:#122947 url({{ asset('assets/front/img/pattern.png') }}) no-repeat;">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6 col-md-7">
                <h2 class="text-light">{{ $ps->review_title }}</h2>
                <div class="smart-textimonials smart-light" id="smart-textimonials">
                    @foreach ($testimonials as $key => $data)
                    <!-- Single Item -->
                    <div class="item">
                        <div class="smart-tes-content">
                            <p>
                                @php
                                echo $data->details;
                                @endphp
                            </p>
                        </div>
                        <div class="smart-tes-author">
                            <div class="st-author-box">
                                <div class="st-author-thumb">
                                    <img src="{{ asset('assets/images/' . $data->photo) }}" class="img-fluid"
                                        alt="" />
                                </div>
                                <div class="st-author-info">
                                    <h4 class="st-author-title">{{ $data->title }}</h4>
                                    <span class="st-author-subtitle">{{ $data->subtitle }}</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
            <div class="col-lg-6 col-md-5">
                <img src="{{ asset('assets/images/' . $ps->review_photo) }}" class="img-fluid" alt="">
            </div>
        </div>
    </div>
</section>
<!-- ============================ Smart Testimonials End ================================== -->
@endif
@if (in_array('Blogs', $home_modules))
<!-- ================================= Blog Slider ================================== -->
<section>
    <div class="container">
        <div class="row">
            <div class="col text-center">
                <div class="sec-heading center">
                    <h2>{{ $ps->blog_title }}</h2>
                    <p>
                        @php
                        echo $ps->blog_subtitle;
                        @endphp
                    </p>
                </div>
            </div>
        </div>
        <div class="row">
            <div id="blogCarousel" class="carousel slide" data-bs-ride="carousel">
                <!-- Indicators -->
                <div class="carousel-indicators">
                    @foreach ($blogs->chunk(3) as $key => $chunk)
                    <button type="button" data-bs-target="#blogCarousel"
                        data-bs-slide-to="{{ $key }}" class="{{ $key === 0 ? 'active' : '' }}"
                        aria-current="true" aria-label="Slide {{ $key + 1 }}"></button>
                    @endforeach
                </div>
                <!-- Slides -->
                <div class="carousel-inner">
                    @foreach ($blogs->chunk(3) as $key => $chunk)
                    <div class="carousel-item {{ $key === 0 ? 'active' : '' }}">
                        <div class="row">
                            @foreach ($chunk as $data)
                            <div class="col-lg-4 col-md-6">
                                <div class="blog-wrap-grid">
                                    <div class="blog-thumb">
                                        <a href="{{ route('blog.details', $data->slug) }}">
                                            <img src="{{ asset('assets/images/' . $data->photo) }}"
                                                class="img-fluid" alt="" />
                                        </a>
                                    </div>
                                    <div class="blog-info">
                                        <span class="post-date"><i
                                                class="ti-calendar"></i>{{ Carbon\Carbon::parse($data->created_at)->format('d M Y') }}</span>
                                    </div>
                                    <div class="blog-body">
                                        <h4 class="bl-title">
                                            <a
                                                href="{{ route('blog.details', $data->slug) }}">{{ $data->title }}</a>
                                        </h4>
                                        <p>{{ Str::limit(strip_tags($data->details), 100) }}</p>
                                        <a href="{{ route('blog.details', $data->slug) }}"
                                            class="bl-continue">@lang('Continue')</a>
                                    </div>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>
                    @endforeach
                </div>
                <!-- Controls -->
                <button class="carousel-control-prev" type="button" data-bs-target="#blogCarousel"
                    data-bs-slide="prev">
                    <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                    <span class="visually-hidden">Previous</span>
                </button>
                <button class="carousel-control-next" type="button" data-bs-target="#blogCarousel"
                    data-bs-slide="next">
                    <span class="carousel-control-next-icon" aria-hidden="true"></span>
                    <span class="visually-hidden">Next</span>
                </button>
            </div>
        </div>
    </div>
</section>
<!-- ================= Blog Slider End ================= -->
@endif
@if (in_array('CTAs', $home_modules))
<!-- ============================ Call To Action ================================== -->
@includeIf('partials.front.cta')
<!-- ============================ Call To Action End ================================== -->
@endif
@endsection
@push('js')
<script>
    function slugify(text) {
        return text.toString().toLowerCase().replace(/\s+/g, '-')
            .replace(/[^\w\-]+/g, '')
            .replace(/\-\-+/g, '-')
            .replace(/^-+/, '')
            .replace(/-+$/, '');
    }

    $(document).ready(function() {
        var links = [{
                id: '#buy-link'
            },
            {
                id: '#rent-link'
            },
            {
                id: '#commercial-link'
            },
            {
                id: '#pg-link'
            },
            {
                id: '#plot-link'
            }
        ];

        var baseUrl = @json(url('/in'));

        links.forEach(function(link) {
            var $a = $(link.id);
            $a.data('original-href', $a.attr('href'));
        });

        function updateLinks() {
            var selectedOption = $('#location option:selected');
            var citySlug = selectedOption.data('city') || 'CITY_PLACEHOLDER';
            links.forEach(function(link) {
                var $a = $(link.id);
                var originalHref = $a.data('original-href');
                var newHref = originalHref.replace(/CITY_PLACEHOLDER/g, citySlug);
                $a.attr('href', newHref);
            });
        }

        $('#location').on('change', function() {
            updateLinks();
        });

        updateLinks();
        $('#search-form').on('submit', function(e) {
            e.preventDefault();
            var selectedOption = $('#location option:selected');
            var citySlug = selectedOption.data('city') || 'CITY_PLACEHOLDER';
            var keyword = $('#locality-search').val().trim();
            var localitySlug = keyword ? slugify(keyword) : citySlug;

            var actionUrl = baseUrl + '/buy/real-estate-in-' + localitySlug + '-in-' + citySlug;

            // Redirect directly instead of creating new form
            window.location.href = actionUrl + '?location_id=' + selectedOption.val() + '&name=' + keyword;
        });
    });
</script>
<script type="text/javascript">
        $(document).ready(function() {
            $('#locality-search').on('focus', function() {
                fetchSuggestions('');
            });
            $('#locality-search').on('input', function() {
                var query = $(this).val();
                fetchSuggestions(query);
            });

            function fetchSuggestions(query) {
                var location = $('#location').find(':selected').text();
                var type = $('input[name="type"]').val();
                // alert(type);
                $.ajax({
                    url: "{{ route('front.getSuggestions') }}",
                    type: "GET",
                    data: {
                        query: query,
                        location: location,
                        type: type
                    },
                    success: function(data) {
                        renderSuggestions(data, query);
                    },
                    error: function() {
                        $('#suggestions').html('<p>Something went wrong. Please try again.</p>');
                    }
                });
            }

            function renderSuggestions(data, query) {
                if (data.length === 0) {
                    $('#suggestions').html('<p>No data available for the selected location</p>');
                } else {
                    var list = '<ul class="list-group">';
                    data.forEach(function(item) {
                        var displayText = item.result ? item.result.Property + ', ' + item.result.City : item.locality;
                        var suggestionValue = item.result ? item.result.Property : item.locality;
                        var matchText = item.match;
                        list +=
                            '<li class="list-group-item suggestion-item d-flex justify-content-between align-items-center" ' +
                            'data-value="' + suggestionValue + '">' +
                            '<span>' + displayText + '</span>' +
                            '<small class="text-muted">' + matchText + '</small>' +
                            '</li>';
                    });
                    list += '</ul>';
                    $('#suggestions').html(list);
                    $('#suggestions').css({ 'display': 'block' });
                }
                // Show suggestions div
                
            }

            $(document).on('click', '.suggestion-item', function() {
                var value = $(this).data('value');
                $('#locality-search').val(value);
                $('#suggestions').html('');
                $('#suggestions').css({ 'display': 'none' });
            });

            // Hide suggestions when clicking outside
            $(document).on('mousedown', function(e) {
                var $suggestions = $('#suggestions');
                var $searchInput = $('#locality-search');
                if (
                    !$suggestions.is(e.target) &&
                    $suggestions.has(e.target).length === 0 &&
                    !$searchInput.is(e.target)
                ) {
                    $suggestions.css({ 'display': 'none' });
                }
            });
        });
    </script>
@endpush