@extends('layouts.front')
@push('css')
    <style>
        .btn-outline-primary {
            color: #3c3635;
            background-color: #fff;
            border-color: #e3dbd9;
            -webkit-transition: 0.2s ease-in;
            -o-transition: 0.2s ease-in;
            transition: 0.2s ease-in;
        }

        .btn-outline-primary:hover,
        .btn-outline-primary:focus,
        .btn-outline-primary.focus {
            background: #0d6efd;
            color: #fff;
            border-color: #0d6efd;
        }

        .property-type-container {
            position: relative;
        }

        .property-type-toggle {
            position: relative;
            padding: 8px 12px;
        }

        .property-type-options {
            position: absolute;
            width: auto;
            z-index: 1000;
        }

        input[type="checkbox"]:checked+label {
            background-color: #0d6efd;
            color: white;
        }

        .range-slider-wrapper {
            position: relative;
            height: 40px;
            display: flex;
            align-items: center;
        }

        .range-slider-wrapper input[type="range"] {
            position: absolute;
            width: 100%;
            height: 5px;
            -webkit-appearance: none;
            background: transparent;
            pointer-events: none;
        }

        .range-slider-wrapper input[type="range"]::-webkit-slider-thumb {
            -webkit-appearance: none;
            height: 15px;
            width: 15px;
            border-radius: 50%;
            background: #0d6efd;
            pointer-events: auto;
            cursor: pointer;
        }

        .slider-track {
            position: absolute;
            width: 100%;
            height: 5px;
            background: #e3dbd9;
            border-radius: 5px;
        }

        .fill-track {
            position: absolute;
            height: 5px;
            background: #0d6efd;
            border-radius: 5px;
        }
    </style>
@endpush
@section('content')
    <div class="container">
        <div class="row">
            <div class="col-lg-12 col-md-12">
                <div class="filter_search_opt">
                    <a id="toogle-sm-sidebar-btn" href="javascript:void(0);">@lang('Search Property')&nbsp;&nbsp; <i
                            class="ti-menu"></i></a>
                </div>
            </div>
        </div>
        <!-- Search Form -->
        <div class="">
            <div class="hero-search-content">
                <form id="search-form" action="{{ route('buy.search') }}" method="get">
                    <div class="row g-2 mt-3">
                        <!-- Location -->
                        <div class="col-lg-2 my-2">
                            <select id="location1" class="form-control" name="location_id">
                                <option value="">Select City</option>
                                <optgroup label="Top Cities">
                                    @foreach ($locations->where('is_top_city', 1) as $data)
                                        <option value="{{ $data->id }}"
                                            {{ old('location_id', request()->location_id) == $data->id ? 'selected' : '' }}>
                                            {{ $data->name }}
                                        </option>
                                    @endforeach
                                </optgroup>
                                <optgroup label="Other Cities">
                                    @foreach ($locations->where('is_top_city', 0) as $data)
                                        <option value="{{ $data->id }}"
                                            {{ old('location_id', request()->location_id) == $data->id ? 'selected' : '' }}>
                                            {{ $data->name }}
                                        </option>
                                    @endforeach
                                </optgroup>
                            </select>
                        </div>

                        <!-- Search by Locality -->
                        <div class="col-12 col-sm-8 col-lg-10">
                            <div class="input-group w-100">
                                <span class="input-group-text d-none d-sm-flex"><i class="fa fa-search"></i></span>
                                <input id="locality-search" type="text" class="form-control small-input" name="name"
                                    value="{{ old('name', request()->name) }}" placeholder="@lang('Search for locality, landmark, project, or builder')">
                            </div>
                            <div id="suggestions"></div>
                        </div>

                        <!-- Category -->
                        <div class="col-lg-2">
                            <select class="form-select" name="category_id">
                                <option value="">Property Type</option>
                                <option value="36"
                                    {{ old('category_id', request()->category_id) == '36' ? 'selected' : '' }}>Flat /
                                    Apartment</option>
                                <option value="34"
                                    {{ old('category_id', request()->category_id) == '34' ? 'selected' : '' }}>Independent
                                    Floor</option>
                                <option value="35"
                                    {{ old('category_id', request()->category_id) == '35' ? 'selected' : '' }}>Independent
                                    House / Villa</option>
                            </select>
                        </div>

                        <!-- BHK -->
                        <div class="col-lg-1">
                            <select class="form-select" name="no_of_bhk">
                                <option value="">BHK</option>
                                @foreach (['1-rk', '1-bhk', '1.5-bhk', '2-bhk', '2.5-bhk', '3-bhk', '3.5-bhk', '4-bhk', '4.5-bhk', '5-bhk', '6-bhk', '6+ bhk'] as $bhk)
                                    <option value="{{ $bhk }}"
                                        {{ old('no_of_bhk', request()->no_of_bhk) == $bhk ? 'selected' : '' }}>
                                        {{ strtoupper($bhk) }}</option>
                                @endforeach
                            </select>
                        </div>

                        <!-- Price Range -->
                        <div class="col-lg-3 position-relative">
                            <button type="button" class="form-select d-flex align-items-center justify-content-between"
                                id="priceToggleBtn">
                                <span>₹<span id="minPriceValue">{{ number_format(request()->minPrice ?? 0) }}</span> -
                                    ₹<span
                                        id="maxPriceValue">{{ (request()->maxPrice ?? 200000000) >= 200000000 ? '20,00,00,000+' : number_format(request()->maxPrice ?? 200000000) }}</span></span>
                            </button>
                            <div id="priceRangeContainer" class="bg-white p-3 border rounded shadow-sm RangeContainer"
                                style="display: none;">
                                <div class="d-flex justify-content-between">
                                    <span>₹0</span>
                                    <span>₹20,00,00,000+</span>
                                </div>
                                <div class="range-slider-wrapper">
                                    <input type="range" id="minRange" name="minPrice" min="0" max="200000000"
                                        step="10000" value="{{ request()->minPrice ?? 0 }}" oninput="updateSlider()">
                                    <input type="range" id="maxRange" name="maxPrice" min="0" max="200000000"
                                        step="10000"
                                        value="{{ request()->maxPrice ?? 200000000 }}"
                                        oninput="updateSlider()">
                                    <div class="slider-track">
                                        <div class="fill-track"></div>
                                    </div>
                                </div>
                                <div class="small text-muted text-center">
                                    ₹<span id="selectedMinPrice">{{ number_format(request()->minPrice ?? 0) }}</span> -
                                    ₹<span
                                        id="selectedMaxPrice">{{ (request()->maxPrice ?? 200000000) >= 200000000 ? '20,00,00,000+' : number_format(request()->maxPrice ?? 200000000) }}</span>
                                </div>
                            </div>
                        </div>

                        <!-- Sale Type -->
                        <div class="col-lg-2">
                            <select class="form-select" name="sale_type">
                                <option value="">Sale Type</option>
                                <option value="new-booking"
                                    {{ old('sale_type', request()->sale_type) == 'new-booking' ? 'selected' : '' }}>New
                                    Booking</option>
                                <option value="resale"
                                    {{ old('sale_type', request()->sale_type) == 'resale' ? 'selected' : '' }}>Resale
                                </option>
                            </select>
                        </div>

                        <!-- Construction Status -->
                        <div class="col-lg-2">
                            <select class="form-select" name="construction_status">
                                <option value="">Construction Status</option>
                                <option value="ready-to-move"
                                    {{ old('construction_status', request()->construction_status) == 'ready-to-move' ? 'selected' : '' }}>
                                    Ready to Move</option>
                                <option value="under-construction"
                                    {{ old('construction_status', request()->construction_status) == 'under-construction' ? 'selected' : '' }}>
                                    Under Construction</option>
                            </select>
                        </div>
                        <!-- Listed By -->
                        <div class="col-lg-1">
                            <select class="form-select" id="userTypeSelect" name="user_type">
                                <option value="">Listed By</option>
                                <option value="agent" {{ request('user_type') == 'agent' ? 'selected' : '' }}>Agent
                                </option>
                                <option value="owner" {{ request('user_type') == 'owner' ? 'selected' : '' }}>Owner
                                </option>
                                <option value="builder/developer"
                                    {{ request('user_type') == 'builder/developer' ? 'selected' : '' }}>Developer</option>
                            </select>
                        </div>

                        <div class="col-lg-1 d-flex">
                            <input type="hidden" name="type" value="{{ request()->type }}">
                            <button type="submit" class="btn btn-primary btn-sm rounded border-primary">Search
                            </button>
                            <button id="clearBtn" class="btn btn-secondary btn-sm rounded border-secondary mx-1">Clear
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <div class="col-lg-12 col-md-12">
            <h4 class="ipt-title mt-2">
                Properties for sale in,
                @if (request()->name)
                    {{ request()->name }},
                @endif
                @php
                    $locationName = $locations->where('id', request()->location_id)->first()->name ?? '';
                @endphp
                {{ $locationName }}
            </h4>
            <p class="text-muted small">
                Showing {{ $properties->firstItem() }} to {{ $properties->lastItem() }} of {{ $properties->total() }}
                results
            </p><br>
        </div>
        <div class="row">
            <div class="col-lg-12 col-md-12 col-md-12 list-layout">
                <div class="row">
                    <div class="col-lg-12 col-md-12">
                        <div class="filter-fl">
                            <h4>@lang('Search Results')</h4>
                        </div>
                        <hr>
                    </div>
                    @includeIf('partials.front.sell-property', ['properties' => $topSlotProperties, 'isSponsored' => true])
                    @includeIf('partials.front.sell-property', ['properties' => $mediumSlotProperties, 'isSponsored' => true])
                    @includeIf('partials.front.sell-property', ['properties' => $properties, 'isSponsored' => false])
                    {{-- @includeIf('partials.front.sell-property') --}}
                </div>
            </div>
        </div>
    </div>
    @includeIf('partials.front.cta')
@endsection

@push('js')
    <script>
        $(document).ready(function() {
            function slugify(text) {
                return text.toString().toLowerCase().trim()
                    .replace(/\s+/g, '-')
                    .replace(/[^\w\-]+/g, '')
                    .replace(/\-\-+/g, '-')
                    .replace(/^-+/, '')
                    .replace(/-+$/, '');
            }

            $(".input-group-text").on("click", function() {
                $("#search-form").trigger("submit");
            });

            $("#search-form").on("submit", function(e) {
                e.preventDefault();

                var cityText = $('#location1 option:selected').text().trim();
                var cityId = $('#location1').val();
                var citySlug = cityText ? slugify(cityText) : 'city';
                var keyword = $('#locality-search').val().trim();
                var localitySlug = keyword ? slugify(keyword) : citySlug;
                var baseUrl = "{{ url('/in') }}";
                var actionUrl = baseUrl + '/buy/real-estate-in-' + localitySlug + '-in-' + citySlug;
                var $form = $('<form>', {
                    method: 'GET',
                    action: actionUrl
                });
                // All input + select values (except token and category_id[])
                $("#search-form").find("input, select, checkbox").not(
                    '[name="_token"], [name="category_id[]"]').each(function() {
                    var name = $(this).attr('name');
                    var value = $(this).val();
                    if (name && value) {
                        $form.append($('<input>', {
                            type: 'hidden',
                            name: name,
                            value: value
                        }));
                    }
                });

                // If checkboxes used for category_id[]
                if ($("#search-form input[name='category_id[]']").length) {
                    $("#search-form input[name='category_id[]']:checked").each(function() {
                        $form.append($('<input>', {
                            type: 'hidden',
                            name: 'category_id[]',
                            value: $(this).val()
                        }));
                    });
                } else {
                    let catVal = $("select[name='category_id']").val();
                    if (catVal) {
                        $form.append($('<input>', {
                            type: 'hidden',
                            name: 'category_id',
                            value: catVal
                        }));
                    }
                }

                $('body').append($form);
                $form.submit();
            });

            $('#priceToggleBtn').on('click', function(e) {
                e.stopPropagation();
                $('#priceRangeContainer').toggle();
            });

            $(document).on('click', function(e) {
                if (!$(e.target).closest('#priceRangeContainer, #priceToggleBtn').length) {
                    $('#priceRangeContainer').hide();
                }
            });

            function formatINR(number) {
                return new Intl.NumberFormat('en-IN').format(number);
            }

            function updateSlider() {
                let minSlider = $('#minRange');
                let maxSlider = $('#maxRange');
                let fillTrack = $('.fill-track');

                let min = parseInt(minSlider.val());
                let max = parseInt(maxSlider.val());

                // Ensure min doesn't exceed max
                if (min > max) {
                    [min, max] = [max, min];
                    minSlider.val(min);
                    maxSlider.val(max);
                }

                let range = 200000000; // 20 crore
                let minPercent = ((min - parseInt(minSlider.attr('min'))) / range) * 100;
                let maxPercent = ((max - parseInt(minSlider.attr('min'))) / range) * 100;

                fillTrack.css('left', minPercent + '%');
                fillTrack.css('width', (maxPercent - minPercent) + '%');

                // Format values for display
                let minDisplay = formatINR(min);
                let maxDisplay = max >= 200000000 ? '20,00,00,000+' : formatINR(max);

                // Update all display elements
                $('#selectedMinPrice, #minPriceValue').text(minDisplay);
                $('#selectedMaxPrice, #maxPriceValue').text(maxDisplay);
            }

            $('#minRange, #maxRange').on('input', updateSlider);
            updateSlider();

            function setFilterValuesFromRequest() {
                $('#location1').val('{{ request()->location_id ?? '' }}');
                $('#locality-search').val('{{ request()->name ?? '' }}');
                $('select[name="no_of_bhk"]').val('{{ request()->no_of_bhk ?? '' }}');
                $('select[name="category_id"]').val('{{ request()->category_id ?? '' }}');
                $('select[name="construction_status"]').val('{{ request()->construction_status ?? '' }}');
                $('select[name="sale_type"]').val('{{ request()->sale_type ?? '' }}');

                // Handle price range initialization
                let minPrice = parseInt('{{ request()->minPrice ?? 0 }}');
                let maxPrice = parseInt('{{ request()->maxPrice ?? 200000000 }}');

                $('#minRange').val(minPrice);
                $('#maxRange').val(maxPrice);

                updateSlider();
            }
            setFilterValuesFromRequest();

            $('#clearBtn').on('click', function(e) {
                e.preventDefault();
                // Reset all select fields except location
                $('#search-form select').not('#location1').each(function() {
                    $(this).val('');
                });
                // Reset all text inputs
                $('#search-form input[type="text"]').val('');
                // Reset all hidden fields except CSRF
                $('#search-form input[type="hidden"]').not('[name="_token"]').val('');
                // Reset all checkboxes and radios
                $('#search-form input[type="checkbox"], #search-form input[type="radio"]').prop('checked', false);
                // Reset price range
                $('#minRange').val(0);
                $('#maxRange').val(200000000);
                updateSlider();
                // Reset suggestions if any
                $('#suggestions').empty();
            });
        });
         $(document).on('click', '#wishList', function() {
        let $this = $(this);
        let propertyId = $this.data('property');
        let userId = $this.data('user');

        if (!userId) {
            window.location.href = mainurl + '/login-register';
            return;
        }
        console.log("Wishlist Clicked!");

        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            method: "POST",
            url: mainurl + '/property/wishlist',
            data: {
                property_id: propertyId,
                user_id: userId
            },
            success: function(data) {
                if (data.success) {
                    $this.removeClass().addClass('like-bitt add-to-favorite');
                    toastr.success(data.success);
                } else {
                    $this.removeClass().addClass('add-to-favorite');
                    toastr.error(data.error);
                }
                setTimeout(() => {
                    location.reload();
                }, 1000);
            }
        });
    });
    </script>
       <script>
        document.addEventListener("DOMContentLoaded", function() {
            const form = document.getElementById("search-form");

            // On submit, capture and save to localStorage
            form.addEventListener("submit", function() {
                const formData = new FormData(form);
                let searchData = {};

                // Convert FormData to object
                formData.forEach((value, key) => {
                    if (value !== "") {
                        searchData[key] = value;
                    }
                });

                // Add min/max price from sliders (if you're using JS-controlled sliders)
                const minRange = document.getElementById("minRange")?.value;
                const maxRange = document.getElementById("maxRange")?.value;

                if (minRange && maxRange) {
                    searchData.minPrice = minRange;
                    searchData.maxPrice = maxRange;
                }

                // Load recent searches from localStorage
                let recentSearches = JSON.parse(localStorage.getItem("recentSearches")) || [];

                // Avoid duplicates
                let exists = recentSearches.some(search => JSON.stringify(search) === JSON.stringify(
                    searchData));
                if (!exists) {
                    recentSearches.unshift(searchData);
                    if (recentSearches.length > 25) recentSearches.pop(); // Limit to 25
                    localStorage.setItem("recentSearches", JSON.stringify(recentSearches));
                    console.log("✅ Search saved to localStorage:", searchData);
                } else {
                    console.log("ℹ️ Search already exists in localStorage");
                }
            });
        });
    </script>
@endpush
