@extends('layouts.front')
@push('css')
    <style>
        .btn-outline-primary {
            color: #3c3635;
            background-color: #fff;
            border-color: #e3dbd9;
            -webkit-transition: 0.2s ease-in;
            -o-transition: 0.2s ease-in;
            transition: 0.2s ease-in;
        }

        .btn-outline-primary:hover,
        .btn-outline-primary:focus,
        .btn-outline-primary.focus {
            background: #0d6efd;
            color: #fff;
            border-color: #0d6efd;
        }

        .property-type-container {
            position: relative;
        }

        .property-type-toggle {
            position: relative;
            padding: 8px 12px;
        }

        .property-type-options {
            position: absolute;
            width: auto;
            z-index: 1000;
        }

        input[type="checkbox"]:checked+label {
            background-color: #0d6efd;
            color: white;
        }
    </style>
@endpush
@section('content')
    <div class="container">
        <div class="row">
            <div class="col-lg-12 col-md-12">
                <div class="filter_search_opt">
                    <a id="toogle-sm-sidebar-btn" href="javascript:void(0);">@lang('Search Property')&nbsp;&nbsp; <i class="ti-menu"></i></a>
                </div>
            </div>
        </div>
        <!-- Search Form -->
        <div class="">
            <div class="hero-search-content">
                <form id="search-form" action="" method="GET">
                    <div class="row g-2 mt-3">
                        <div class="col-lg-2 my-2">
                            <select id="location1" class="form-control" name="location_id">
                                <option value="">&nbsp;Select City</option>
                                <optgroup label="Top Cities">
                                    @foreach ($locations->where('is_top_city', 1) as $data)
                                        <option value="{{ $data->id }}"
                                            {{ request()->location_id == $data->id ? 'selected' : '' }}>
                                            {{ $data->name }}
                                        </option>
                                    @endforeach
                                </optgroup>
                                <optgroup label="Other Cities">
                                    @foreach ($locations->where('is_top_city', 0) as $data)
                                        <option value="{{ $data->id }}"
                                            {{ request()->location_id == $data->id ? 'selected' : '' }}>
                                            {{ $data->name }}
                                        </option>
                                    @endforeach
                                </optgroup>
                            </select>
                        </div>
                        <div class="col-12 col-sm-8 col-lg-10">
                            <div class="input-group w-100">
                                <span class="input-group-text d-none d-sm-flex"><i class="fa fa-search"></i></span>
                                <input id="locality-search" type="text" class="form-control small-input" name="name"
                                    value="{{ old('name', request()->name) }}" placeholder="@lang('Search for locality, landmark, project, or builder')">
                            </div>
                            <div id="suggestions"></div>
                        </div>
                        <!-- Category -->
                        <div class="col-lg-2">
                            <select class="form-select" name="category_id">
                                <option value="">Property Type</option>
                                <option value="38"
                                    {{ old('category_id', request()->category_id) == '38' ? 'selected' : '' }}>Office
                                </option>
                                <option value="39"
                                    {{ old('category_id', request()->category_id) == '39' ? 'selected' : '' }}>Retail
                                </option>
                                <option value="41"
                                    {{ old('category_id', request()->category_id) == '41' ? 'selected' : '' }}>Industry
                                </option>
                                 <option value="40"
                                    {{ old('category_id', request()->category_id) == '40' ? 'selected' : '' }}>Storage
                                </option>
                                <option value="42"
                                    {{ old('category_id', request()->category_id) == '42' ? 'selected' : '' }}>Hospitality
                                </option>
                                <option value="44"
                                    {{ old('category_id', request()->category_id) == '44' ? 'selected' : '' }}>Other
                                </option>
                            </select>
                        </div>
                        <!-- Price Range -->
                        <div class="col-lg-3 position-relative">
                            <button type="button" class="form-select d-flex align-items-center justify-content-between" id="priceToggleBtn">
                                <span>₹<span id="minPriceValue">0</span> - ₹<span id="maxPriceValue">2,00,00,000</span></span>
                            </button>
                            <div id="priceRangeContainer" class="bg-white p-3 border rounded shadow-sm RangeContainer" style="display: none;">
                                <div class="d-flex justify-content-between">
                                    <span>₹0</span>
                                    <span>₹20,00,00,000</span>
                                </div>
                                <div class="range-slider-wrapper">
                                    <input type="range" id="minRange" name="minPrice" min="0" max="200000000" step="10000" value="{{ request()->minPrice ?? 0 }}" oninput="updateSlider()">
                                    <input type="range" id="maxRange" name="maxPrice" min="0" max="200000000" step="10000" value="{{ request()->maxPrice ?? 200000000 }}" oninput="updateSlider()">
                                    <div class="slider-track"><div class="fill-track"></div></div>
                                </div>
                                <div class="small text-muted text-center">
                                    ₹<span id="selectedMinPrice">0</span> - ₹<span id="selectedMaxPrice">20,00,00,000</span>
                                </div>
                            </div>
                        </div>
                        <!-- Area Range -->
                        <div class="col-lg-3 position-relative">
                            <button type="button" class="form-select d-flex align-items-center justify-content-between" id="areaToggleBtn">
                                <span><span id="minAreaValue">0</span> - <span id="maxAreaValue">5,000</span> sqft</span>
                            </button>
                            <div id="areaRangeContainer" class="bg-white p-3 border rounded shadow-sm RangeContainer" style="display: none;">
                                <div class="d-flex justify-content-between">
                                    <span>0 sqft</span>
                                    <span>5,000 sqft</span>
                                </div>
                                <div class="range-slider-wrapper">
                                    <input type="range" id="minArea" name="minArea" min="0" max="5000" step="10" value="{{ request()->minArea ?? 0 }}" oninput="updateAreaSlider()">
                                    <input type="range" id="maxArea" name="maxArea" min="0" max="5000" step="10" value="{{ request()->maxArea ?? 5000 }}" oninput="updateAreaSlider()">
                                    <div class="slider-track"><div class="fill-track-area"></div></div>
                                </div>
                                <div class="small text-muted text-center">
                                    <span id="selectedMinArea">0</span> - <span id="selectedMaxArea">5,000</span> sqft
                                </div>
                            </div>
                        </div>
                        <!-- Ownership Type -->
                        <div class="col-lg-1">
                            <select class="form-select" name="ownership">
                                <option value="">Ownership</option>
                                <option value="pre-holder">Pre-Holder
                                </option>
                                <option value="lease-holder">
                                    Lease-Holder</option>
                            </select>
                        </div>
                        <!-- Construction Status -->
                        <div class="col-lg-2 ">
                            <select class="form-select" name="construction_status">
                                <option value="">Possession Status</option>
                                <option value="ready-to-move">Ready to
                                    Move</option>
                                <option value="under-construction">
                                    Under Construction</option>
                            </select>
                        </div>
                        <!-- Listed By -->
                        <div class="col-lg-1">
                            <select class="form-select" id="userTypeSelect" name="user_type">
                                <option value="">Listed By</option>
                                <option value="agent" {{ request('user_type') == 'agent' ? 'selected' : '' }}>Agent
                                </option>
                                <option value="owner" {{ request('user_type') == 'owner' ? 'selected' : '' }}>Owner
                                </option>
                                <option value="builder/developer"
                                    {{ request('user_type') == 'builder/developer' ? 'selected' : '' }}>Developer</option>
                            </select>
                        </div>
                        <!-- Search Button -->
                        <div class="col-lg-2 d-flex">
                            <input type="hidden" name="type" value="{{ request()->type }}">
                            <button type="submit" class="btn btn-primary btn-sm rounded border-primary px-4">Search
                            </button>
                            <button id="clearBtn"
                                class="btn btn-secondary btn-sm rounded border-secondary px-4 mx-1">Clear
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <div class="col-lg-12 col-md-12">
            <h4 class="ipt-title mt-2">
                Properties for sale:
                @if (request()->name)
                    {{ request()->name }},
                @endif
                @php
                    $locationName = $locations->where('id', request()->location_id)->first()->name ?? '';
                @endphp
                {{ $locationName }}
            </h4>
            <p class="text-muted small">
                Showing {{ $properties->firstItem() }} to {{ $properties->lastItem() }} of {{ $properties->total() }}
                results
            </p><br>
        </div>
        <div class="row">
            <div class="col-lg-12 col-md-12 col-md-12 list-layout">
                <div class="row">
                    <div class="col-lg-12 col-md-12">
                        <div class="filter-fl">
                            <h4>@lang('Search Results')</h4>
                        </div>
                        <hr>
                    </div>
                    @includeIf('partials.front.commercial-property')
                </div>
            </div>
        </div>
    </div>
    @includeIf('partials.front.cta')
@endsection
@push('js')
    <script src="{{ asset('assets/front/js/map_infobox.js') }}"></script>
    <script src="{{ asset('assets/front/js/markerclusterer.js') }}"></script>
    <script src="{{ asset('assets/front/js/map.js') }}"></script>
    <script>
        $(document).ready(function() {
            // Slugify function
            function slugify(text) {
                return text.toString().toLowerCase().replace(/\s+/g, '-')
                    .replace(/[^\w\-]+/g, '')
                    .replace(/\-\-+/g, '-')
                    .replace(/^-+/, '')
                    .replace(/-+$/, '');
            }
            // Search icon click triggers form submit
            $(".input-group-text").on("click", function() {
                $("#search-form").trigger("submit");
            });

            // Pretty URL submit logic
            $("#search-form").on("submit", function(e) {
                e.preventDefault();
                var cityText = $('#location1 option:selected').text() || '';
                var cityId = $('#location1').val() || '';
                var citySlug = cityText ? slugify(cityText) : 'CITY_PLACEHOLDER';
                var keyword = $('#locality-search').val().trim();
                var localitySlug = keyword ? slugify(keyword) : citySlug;
                var baseUrl = "{{ url('/in') }}";
                var actionUrl = baseUrl + '/commercial/commercial-real-estate-' + localitySlug + '-in-' + citySlug;

                // Create a dynamic form for GET
                var $form = $('<form>', {
                    method: 'GET',
                    action: actionUrl
                });
                // Add all input, select, and textarea fields (including hidden, radio, checkbox, etc.)
                $('#search-form').find('input, select, textarea').each(function() {
                    var $el = $(this);
                    var name = $el.attr('name');
                    if (!name || name === '_token') return;
                    var type = $el.attr('type');
                    if (type === 'checkbox' || type === 'radio') {
                        if ($el.prop('checked')) {
                            $form.append($('<input>', {
                                type: 'hidden',
                                name: name,
                                value: $el.val()
                            }));
                        }
                    } else {
                        // Avoid duplicate fields
                        if (!$form.find('[name="' + name + '"]').length) {
                            $form.append($('<input>', {
                                type: 'hidden',
                                name: name,
                                value: $el.val()
                            }));
                        }
                    }
                });
                $form.appendTo('body').submit();
            });
            // Area range dropdown open/close
            $('#areaToggleBtn').on('click', function(e) {
                e.stopPropagation();
                var areaRangeContainer = $('#areaRangeContainer');
                areaRangeContainer.css('display', 'block');
            });
            $(document).on('click', function(e) {
                var areaRangeContainer = $('#areaRangeContainer');
                var areaButton = $('#areaToggleBtn');
                if (!$(e.target).closest('#areaRangeContainer, #areaToggleBtn').length) {
                    areaRangeContainer.css('display', 'none');
                }
            });

            // Area slider update logic
            function updateAreaSlider() {
                var minSlider = $('#minArea');
                var maxSlider = $('#maxArea');
                var fillTrack = $('.fill-track-area');
                var min = parseInt(minSlider.val());
                var max = parseInt(maxSlider.val());
                if (min > max) {
                    var temp = min;
                    min = max;
                    max = temp;
                    minSlider.val(min);
                    maxSlider.val(max);
                }
                var range = parseInt(minSlider.attr('max')) - parseInt(minSlider.attr('min'));
                var minPercent = ((min - parseInt(minSlider.attr('min'))) / range) * 100;
                var maxPercent = ((max - parseInt(minSlider.attr('min'))) / range) * 100;
                fillTrack.css('left', minPercent + '%');
                fillTrack.css('width', (maxPercent - minPercent) + '%');
                // Update visible area labels
                $('#selectedMinArea').text(min.toLocaleString());
                $('#selectedMaxArea').text(max.toLocaleString());
                // Update button text
                $('#minAreaValue').text(min.toLocaleString());
                $('#maxAreaValue').text(max.toLocaleString());
            }
            $('#minArea, #maxArea').on('input', updateAreaSlider);
            updateAreaSlider();
            // Price range dropdown open/close
            $('#priceToggleBtn').on('click', function(e) {
                e.stopPropagation();
                var priceRangeContainer = $('#priceRangeContainer');
                priceRangeContainer.css('display', 'block');
            });
            $(document).on('click', function(e) {
                var priceRangeContainer = $('#priceRangeContainer');
                var priceButton = $('#priceToggleBtn');
                if (!$(e.target).closest('#priceRangeContainer, #priceToggleBtn').length) {
                    priceRangeContainer.css('display', 'none');
                }
            });
            // Range slider update logic
            function formatINR(number) {
                return new Intl.NumberFormat('en-IN').format(number);
            }

            function updateSlider() {
                var minSlider = $('#minRange');
                var maxSlider = $('#maxRange');
                var fillTrack = $('.fill-track');
                var min = parseInt(minSlider.val());
                var max = parseInt(maxSlider.val());
                if (min > max) {
                    var temp = min;
                    min = max;
                    max = temp;
                    minSlider.val(min);
                    maxSlider.val(max);
                }
                var range = 200000000;
                var minPercent = ((min - 0) / range) * 100;
                var maxPercent = ((max - 0) / range) * 100;
                fillTrack.css('left', minPercent + '%');
                fillTrack.css('width', (maxPercent - minPercent) + '%');
                // Update visible price labels
                $('#selectedMinPrice').text(formatINR(min));
                $('#selectedMaxPrice').text(formatINR(max));
                // Update button text
                $('#minPriceValue').text(formatINR(min));
                $('#maxPriceValue').text(formatINR(max));
            }
            $('#minRange, #maxRange').on('input', updateSlider);
            updateSlider();

            // Restore filter values from request (after submit)
            function setFilterValuesFromRequest() {
                // City
                var cityId = '{{ request()->location_id ?? '' }}';
                if (cityId) $('#location1').val(cityId);
                // Locality
                var locality = '{{ request()->name ?? '' }}';
                if (locality) $('#locality-search').val(locality);
                // BHK
                var ownership = '{{ request()->ownership ?? '' }}';
                if (ownership) $('select[name="ownership"]').val(ownership);
                // Sale Type
                var userType = '{{ request()->user_type ?? '' }}';
                if (userType) $('select[name="user_type"]').val(userType);
                // Construction Status
                var constructionStatus = '{{ request()->construction_status ?? '' }}';
                if (constructionStatus) $('select[name="construction_status"]').val(constructionStatus);
                // Category checkboxes
                var cats = @json(request()->category_id ?? []);
                $('input[name="category_id[]"]').prop('checked', false);
                cats.forEach(function(catId) {
                    $('input[name="category_id[]"][value="' + catId + '"]').prop('checked', true);
                });
                // Price Range
                var minPrice = '{{ request()->minPrice ?? '' }}';
                var maxPrice = '{{ request()->maxPrice ?? '' }}';
                if (minPrice) $('#minRange').val(minPrice);
                if (maxPrice) $('#maxRange').val(maxPrice);
                // Update slider visuals
                if (minPrice || maxPrice) updateSlider();
            }
            setFilterValuesFromRequest();

            // Clear button logic
            $('#clearBtn').on('click', function(e) {
                e.preventDefault();
                $('#search-form')[0].reset();
                $('input[name="category_id[]"]').prop('checked', false);
                // Reset price range
                $('#minRange').val(0);
                $('#maxRange').val(200000000);
                updateSlider();
                // Reset area range
                $('#minArea').val(0);
                $('#maxArea').val(5000);
                updateAreaSlider();
                // Update button text for area
                $('#minAreaValue').text('0');
                $('#maxAreaValue').text('5,000');
                // Update visible area labels
                $('#selectedMinArea').text('0');
                $('#selectedMaxArea').text('5,000');
            });

        });
         $(document).on('click', '#wishList', function() {
        let $this = $(this);
        let propertyId = $this.data('property');
        let userId = $this.data('user');

        if (!userId) {
            window.location.href = mainurl + '/login-register';
            return;
        }
        console.log("Wishlist Clicked!");

        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            method: "POST",
            url: mainurl + '/property/wishlist',
            data: {
                property_id: propertyId,
                user_id: userId
            },
            success: function(data) {
                if (data.success) {
                    $this.removeClass().addClass('like-bitt add-to-favorite');
                    toastr.success(data.success);
                } else {
                    $this.removeClass().addClass('add-to-favorite');
                    toastr.error(data.error);
                }
                setTimeout(() => {
                    location.reload();
                }, 1000);
            }
        });
    });
    </script>
@endpush
