@extends('layouts.front')
<style>
    #suggestions {
        max-width: 100%;
        /* border: 1px solid #ccc; */
        border-radius: 5px;
        position: absolute;
        z-index: 1000;
        background-color: white;
    }

    #suggestions ul {
        list-style-type: none;
        padding: 8px;
        margin: 0;
    }

    #suggestions li:hover {
        background-color: #f0f0f0;
    }

    .d-flex {
        display: flex;
    }

    .justify-content-between {
        justify-content: space-between;
    }

    .list-group-item span:first-child {
        flex: 1;
        text-align: left;
    }

    .list-group-item span:last-child {
        flex: 1;
        text-align: right;
    }

    .relative {
        position: relative;
    }

    .custom-select-up {
        position: relative;
    }

    .custom-select-up select {
        position: absolute;
        bottom: 100%;
    }

    #search-form * {
        font-size: 17px !important;
    }
</style>
@push('css')
@endpush
@section('content')
    @if (in_array('Banner', $home_modules))
        <!-- ============================ Hero Banner  Start================================== -->
        <div class="image-cover hero-banner"
            style="background:url({{ asset('assets/images/' . $ps->hero_photo) }}) no-repeat;" data-overlay="6">
            <div class="container">
                <h1 class="big-header-capt mb-1">{{ $ps->banner_title }}</h1>
                <form action="{{ url('listing') }}" method="get" id="search-form">
                    <div class="property-search-type">
                        <label class="active"><input name="type" type="radio" value="for_sell">@lang('For Sell')</label>
                        <label><input name="type" type="radio" value="for_rent">@lang('For Rent')</label>
                    </div>
                    <div class="full-search-2 eclip-search italian-search hero-search-radius">
                        <div class="hero-search-content">
                            <div class="row">
                                <div class="col-lg-3 col-md-3 col-sm-12 small-padd">
                                    <div class="form-group position-relative">
                                        <div class="input-with-icon b-l b-r">
                                            <select id="location" class="form-control" name="location_id">
                                                <option value="">Select City</option>

                                                @foreach ($locations as $data)
                                                    <option value="{{ $data->id }}" data-name="{{ strtolower($data->name) }}">
                                                        {{ $data->name }}
                                                    </option>
                                                @endforeach
                                            </select>


                                            <script>
                                                document.addEventListener("DOMContentLoaded", function() {
                                                    if (navigator.geolocation) {
                                                        navigator.geolocation.getCurrentPosition(async function(position) {
                                                                let lat = position.coords.latitude;
                                                                let lon = position.coords.longitude;

                                                                let apiKey = "pk.97d3f1bb2bd0d3b51183592f63369793"; // ✅ Your token
                                                                let apiUrl =
                                                                    `https://us1.locationiq.com/v1/reverse.php?key=${apiKey}&lat=${lat}&lon=${lon}&format=json`;

                                                                try {
                                                                    let response = await fetch(apiUrl);
                                                                    let data = await response.json();

                                                                    let address = data.address || {};
                                                                    let detectedCity = (address.city || address.town || address.state || '')
                                                                        .toLowerCase();

                                                                    if (!detectedCity) {
                                                                        console.warn("❗City not found in LocationIQ response:", address);
                                                                        return;
                                                                    }

                                                                    const select = document.getElementById('location');
                                                                    let matched = false;

                                                                    select.querySelectorAll('option').forEach(option => {
                                                                        const dbCity = option.getAttribute('data-name')?.toLowerCase();
                                                                        if (dbCity === detectedCity) {
                                                                            select.value = option.value;
                                                                            matched = true;
                                                                        }
                                                                    });

                                                                    if (matched) {
                                                                        console.log("✅ Auto-selected city:", detectedCity);
                                                                    } else {
                                                                        console.warn("❌ City not matched in dropdown:", detectedCity);
                                                                    }

                                                                } catch (error) {
                                                                    console.error("Error fetching location:", error);
                                                                }
                                                            },
                                                            function(err) {
                                                                console.error("Geolocation error:", err.message);
                                                            });
                                                    } else {
                                                        console.warn("Geolocation not supported");
                                                    }
                                                });
                                            </script>

                                            <i class="ti-location-pin"></i>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-12 small-padd">
                                    <div class="form-group relative">
                                        <div class="input-with-icon">
                                            <input type="text" class="form-control b-r" id="locality-search"
                                                name="name" placeholder="@lang('Search for locality, landmark, project, or builder')">
                                            <div class="w-100" id="suggestions"></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-1 col-md-1 col-sm-12 small-padd">
                                </div>
                                <input type="hidden" name="autoSubmit" value="1">
                                <div class="col-lg-2 col-md-2 col-sm-12 small-padd">
                                    <div class="form-group">
                                        <button type="submit" class="btn search-btn">@lang('Search')</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <!-- ============================ Hero Banner End ================================== -->
    @endif
    @if (in_array('Explore Property', $home_modules))
        <!-- ============================ Latest Property For Sale Start ================================== -->
        <section class="gray">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12 col-md-12">
                        <div class="sec-heading center mb-3">
                            <h2>{{ $ps->explore_ptitle }}</h2>
                            <p>{{ $ps->explore_psub }}</p>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12 col-md-12">
                        <div class="property-slide">
                            @foreach ($properties as $key => $data)
                                <!-- Single Property -->
                                <div class="single-items">
                                    <a href="{{ route('front.property.details', $data->slug) }}">
                                        <div class="property_item classical-list">
                                            <div class="image">
                                                <img src="{{ asset('assets/images/' . $data->photo) }}"
                                                    alt="latest property" class="img-fluid"
                                                    style="width: 422px; height: 260px; object-fit: cover;">
                                                <div class="sb-date">
                                                    <span class="tag">
                                                        <i class="ti-calendar"></i>
                                                        {{ $data->created_at->diffForHumans() }}
                                                    </span>
                                                </div>
                                                <span class="tag_t">
                                                    {{ $data->type == 'for_rent' ? __('For Rent') : __('For Sale') }}
                                                </span>
                                            </div>
                                            <div class="proerty_content">
                                                <div class="proerty_text">
                                                    <h3 class="captlize">{{ $data->name }}</h3>
                                                    <p class="proerty_price">
                                                        {{ showAmount($data->price ?? ($data->expacted_price ?? 'N/N')) }}
                                                    </p>
                                                </div>
                                                <p class="property_add">
                                                    {{ $data->locality }},
                                                    {{ $data->location ? $data->location->name : '' }}
                                                </p>

                                                <div class="row text-muted small">
                                                    @if (in_array($data->category_id, [34,35,36]))
                                                        @if ($data->no_of_bhk)
                                                            <div class="col-6">
                                                                <p><i class="bi bi-house-door"></i> No Of BHK <b><br>
                                                                        {{ $data->no_of_bhk }}</b></p>
                                                            </div>
                                                        @endif

                                                        @if ($data->carpet_area)
                                                            <div class="col-6">
                                                                <p><i class="bi bi-rulers"></i> Carpet Area <b><br>
                                                                        {{ $data->carpet_area }} Sqft</b></p>
                                                            </div>
                                                        @endif

                                                        @if ($data->price_per_sqft)
                                                            <div class="col-6">
                                                                <p><i class="bi bi-currency-rupee"></i> Price/Sqft <b><br>
                                                                        ₹{{ $data->price_per_sqft }}</b></p>
                                                            </div>
                                                        @endif

                                                        @if ($data->construction_status)
                                                            <div class="col-6">
                                                                <p><i class="bi bi-building"></i> Construction Status <b><br>
                                                                        {{ ucwords(str_replace('-', ' ', $data->construction_status)) }}</b>
                                                                </p>
                                                            </div>
                                                        @endif

                                                        @if ($data->construction_status == 'under-construction' && $data->possession_date)
                                                            <div class="col-6">
                                                                <p><i class="bi bi-calendar-check"></i> Possession Date <b><br>
                                                                        {{ $data->possession_date }}</b></p>
                                                            </div>
                                                        @elseif ($data->construction_status == 'ready-to-move' && $data->property_age)
                                                            <div class="col-6">
                                                                <p><i class="bi bi-clock-history"></i> Property Age <b><br>
                                                                        {{ $data->property_age }} Years</b></p>
                                                            </div>
                                                        @endif

                                                        @if ($data->sale_type)
                                                            <div class="col-6">
                                                                <p><i class="bi bi-clock-history"></i> Booking Type <b><br>
                                                                        {{ ucfirst(str_replace('-', ' ', $data->sale_type)) }}</b>
                                                                </p>
                                                            </div>
                                                        @endif
                                                    @endif
                                                    @if (in_array($data->category_id, [32,33]))

                                                        @if ($data->plot_area)
                                                            <div class="col-6">
                                                                <p><i class="bi bi-rulers"></i> Plot Area <b><br>
                                                                        {{ $data->plot_area.' '.$data->area_unit}}</b></p>
                                                            </div>
                                                        @endif
                                                        @if ($data->plot_length)
                                                            <div class="col-6">
                                                                <p><i class="bi bi-clock-history"></i> Plot Dimensions <b><br>
                                                                        {{ ucfirst(str_replace('-', ' ', $data->plot_length.'X'.$data->plot_width)) }}</b>
                                                                </p>
                                                            </div>
                                                        @endif
                                                        @if ($data->floors_allowed)
                                                            <div class="col-6">
                                                                <p><i class="bi bi-rulers"></i> Floors Allowed<b><br>
                                                                        {{ $data->floors_allowed}}</b></p>
                                                            </div>
                                                        @endif
                                                        @if ($data->open_sides)
                                                            <div class="col-6">
                                                                <p><i class="bi bi-rulers"></i>No. Of Open Sides <b><br>
                                                                        {{ $data->open_sides}}</b></p>
                                                            </div>
                                                        @endif
                                                        @if ($data->construction_type)
                                                            <div class="col-6">
                                                                <p><i class="bi bi-rulers"></i> Type of Construction                                                                    <b><br>
                                                                        {{ ucfirst($data->construction_type)}}</b></p>
                                                            </div>
                                                        @endif
                                                        @if ($data->possession_status)
                                                            <div class="col-6">
                                                                <p><i class="bi bi-rulers"></i> Possession Status <b><br>
                                                                        {{ ucfirst($data->possession_status)}}</b></p>
                                                            </div>
                                                        @endif
                                                        @if ($data->Ownership)
                                                            <div class="col-6">
                                                                <p><i class="bi bi-rulers"></i> Possession Status <b><br>
                                                                        {{ $data->Ownership}}</b></p>
                                                            </div>
                                                        @endif
                                                    @endif
                                                </div>
                                                <div class="property_links">
                                                    <button type="button" class="btn btn-primary rounded border-primary">
                                                        @lang('Property Detail')
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </a>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- ============================ Latest Property For Sale End ================================== -->
    @endif
    @if (in_array('Location', $home_modules))
        <!-- ============================ Property Location Start ================================== -->
        <section>
            <div class="container">
                <div class="row">
                    <div class="col-lg-12 col-md-12">
                        <div class="sec-heading center">
                            <h2>{{ $ps->location_title }}</h2>
                            <p>{{ $ps->location_subtitle }}</p>
                        </div>
                    </div>
                </div>
                <div class="row">
                    @foreach ($locations_for_section as $key => $data)
                        <!-- Single Location Listing -->
                        <div class="col-lg-3 col-md-3 col-sm-6">
                            <div class="location-listing">
                                <div class="location-listing-thumb">
                                    <a href="{{ route('front.listing', ['location_id' => $data->id]) }}"><img
                                            src="{{ asset('assets/images/' . $data->photo) }}" class="img-fluid"
                                            alt="" /></a>
                                </div>
                                <div class="location-listing-caption">
                                    <h4><a
                                            href="{{ route('front.listing', ['location_id' => $data->id]) }}">{{ $data->name }}</a>
                                    </h4>
                                    <!--<span class="theme-cl">{{ count($data->properties) }} @lang('Property')</span>-->
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </section>
        <!-- ============================ Property Location End ================================== -->
    @endif
    @if (in_array('Testimonials', $home_modules))
        <!-- ============================ Smart Testimonials ================================== -->
        <section class="image-cover pb-0"
            style="background:#122947 url({{ asset('assets/front/img/pattern.png') }}) no-repeat;">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-6 col-md-7">
                        <h2 class="text-light">{{ $ps->review_title }}</h2>
                        <div class="smart-textimonials smart-light" id="smart-textimonials">
                            @foreach ($testimonials as $key => $data)
                                <!-- Single Item -->
                                <div class="item">
                                    <div class="smart-tes-content">
                                        <p>
                                            @php
                                                echo $data->details;
                                            @endphp
                                        </p>
                                    </div>
                                    <div class="smart-tes-author">
                                        <div class="st-author-box">
                                            <div class="st-author-thumb">
                                                <img src="{{ asset('assets/images/' . $data->photo) }}" class="img-fluid"
                                                    alt="" />
                                            </div>
                                            <div class="st-author-info">
                                                <h4 class="st-author-title">{{ $data->title }}</h4>
                                                <span class="st-author-subtitle">{{ $data->subtitle }}</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-5">
                        <img src="{{ asset('assets/images/' . $ps->review_photo) }}" class="img-fluid" alt="">
                    </div>
                </div>
            </div>
        </section>
        <!-- ============================ Smart Testimonials End ================================== -->
    @endif
    @if (in_array('Blogs', $home_modules))
        <!-- ================================= Blog Slider ================================== -->
        <section>
            <div class="container">
                <div class="row">
                    <div class="col text-center">
                        <div class="sec-heading center">
                            <h2>{{ $ps->blog_title }}</h2>
                            <p>
                                @php
                                    echo $ps->blog_subtitle;
                                @endphp
                            </p>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div id="blogCarousel" class="carousel slide" data-bs-ride="carousel">
                        <!-- Indicators -->
                        <div class="carousel-indicators">
                            @foreach ($blogs->chunk(3) as $key => $chunk)
                                <button type="button" data-bs-target="#blogCarousel"
                                    data-bs-slide-to="{{ $key }}" class="{{ $key === 0 ? 'active' : '' }}"
                                    aria-current="true" aria-label="Slide {{ $key + 1 }}"></button>
                            @endforeach
                        </div>
                        <!-- Slides -->
                        <div class="carousel-inner">
                            @foreach ($blogs->chunk(3) as $key => $chunk)
                                <div class="carousel-item {{ $key === 0 ? 'active' : '' }}">
                                    <div class="row">
                                        @foreach ($chunk as $data)
                                            <div class="col-lg-4 col-md-6">
                                                <div class="blog-wrap-grid">
                                                    <div class="blog-thumb">
                                                        <a href="{{ route('blog.details', $data->slug) }}">
                                                            <img src="{{ asset('assets/images/' . $data->photo) }}"
                                                                class="img-fluid" alt="" />
                                                        </a>
                                                    </div>
                                                    <div class="blog-info">
                                                        <span class="post-date"><i
                                                                class="ti-calendar"></i>{{ Carbon\Carbon::parse($data->created_at)->format('d M Y') }}</span>
                                                    </div>
                                                    <div class="blog-body">
                                                        <h4 class="bl-title">
                                                            <a
                                                                href="{{ route('blog.details', $data->slug) }}">{{ $data->title }}</a>
                                                        </h4>
                                                        <p>{{ Str::limit(strip_tags($data->details), 100) }}</p>
                                                        <a href="{{ route('blog.details', $data->slug) }}"
                                                            class="bl-continue">@lang('Continue')</a>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        <!-- Controls -->
                        <button class="carousel-control-prev" type="button" data-bs-target="#blogCarousel"
                            data-bs-slide="prev">
                            <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                            <span class="visually-hidden">Previous</span>
                        </button>
                        <button class="carousel-control-next" type="button" data-bs-target="#blogCarousel"
                            data-bs-slide="next">
                            <span class="carousel-control-next-icon" aria-hidden="true"></span>
                            <span class="visually-hidden">Next</span>
                        </button>
                    </div>
                </div>
            </div>
        </section>
        <!-- ================= Blog Slider End ================= -->
    @endif
    @if (in_array('CTAs', $home_modules))
        <!-- ============================ Call To Action ================================== -->
        @includeIf('partials.front.cta')
        <!-- ============================ Call To Action End ================================== -->
    @endif
@endsection
@push('js')
    <script type="text/javascript">
        $(document).ready(function() {
            $('#locality-search').on('focus', function() {
                fetchSuggestions('');
            });
            $('#locality-search').on('input', function() {
                var query = $(this).val();
                fetchSuggestions(query);
            });

            function fetchSuggestions(query) {
                var location = $('#location').find(':selected').text();
                var type = $('input[name="type"]:checked').val();
                $.ajax({
                    url: "{{ route('front.getSuggestions') }}",
                    type: "GET",
                    data: {
                        query: query,
                        location: location,
                        type: type
                    },
                    success: function(data) {
                        renderSuggestions(data, query);
                    },
                    error: function() {
                        $('#suggestions').html('<p>Something went wrong. Please try again.</p>');
                    }
                });
            }

            function renderSuggestions(data, query) {
                if (data.length === 0) {
                    $('#suggestions').html('<p>No data available for the selected location</p>');
                } else {
                    var list = '<ul class="list-group">';
                    data.forEach(function(item) {
                        var displayText = item.result ? item.result.Property + ', ' + item.result
                            .City : item.locality;
                        var matchText = item.match;
                        list +=
                            '<li class="list-group-item suggestion-item d-flex justify-content-between align-items-center" ' +
                            'data-value="' + displayText + '">' +
                            '<span>' + displayText + '</span>' +
                            '<small class="text-muted">' + matchText + '</small>' +
                            '</li>';
                    });
                    list += '</ul>';
                    $('#suggestions').html(list);
                }
            }
            $(document).on('click', '.suggestion-item', function() {
                var value = $(this).data('value');
                $('#locality-search').val(value);
                $('#suggestions').html('');
            });
        });
    </script>
@endpush
