@extends('layouts.front')
@push('css')
    <style>
        #search-form * {
            font-size: 15px !important;
        }

        @media (min-width: 1200px) {

            .container,
            .container-lg,
            .container-md,
            .container-sm,
            .container-xl {
                max-width: 1300px;
            }
        }

        .range-slider-wrapper {
            position: relative;
            height: 30px;
            width: 100%;
            margin-top: 10px;
        }

        .range-slider-wrapper input[type="range"] {
            position: absolute;
            width: 100%;
            height: 30px;
            background: transparent;
            pointer-events: none;
            -webkit-appearance: none;
            z-index: 3;
        }

        .range-slider-wrapper input[type="range"]::-webkit-slider-thumb {
            pointer-events: auto;
            -webkit-appearance: none;
            height: 16px;
            width: 16px;
            border-radius: 50%;
            background: #007bff;
            cursor: pointer;
            margin-top: -6px;
        }

        .range-slider-wrapper input[type="range"]::-webkit-slider-runnable-track {
            height: 4px;
            background: transparent;
        }

        .slider-track {
            position: absolute;
            height: 4px;
            background: #ddd;
            top: 50%;
            left: 0;
            right: 0;
            transform: translateY(-50%);
            border-radius: 2px;
            z-index: 1;
        }

        .fill-track {
            position: absolute;
            height: 100%;
            background-color: #007bff;
            border-radius: 2px;
            z-index: 2;
        }


        #suggestions {
            position: absolute;
            background: white;
            margin-left: 30px;
            max-height: 200px;
            overflow-y: auto;
            border: 1px solid #ddd;
            z-index: 1000;
            box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.1);
            display: none;
            top: 100%;
            left: 0;
            width: 87%;
        }

        #search-form .row .col-lg-1,
        #search-form .row .col-lg-2,
        #search-form .row .col-lg-3,
        #search-form .row .col-lg-10 {
            padding-right: 1px;
            padding-left: 1px;
        }

        #search-form .input-group-text {
            cursor: pointer;
            height: 35px;
        }

        select.form-control:not([size]):not([multiple]) {
            height: 35px;
        }

        .RangeContainer {
            display: block;
            position: absolute;
            width: 100%;
            z-index: 10;
        }

        @media (max-width: 767.98px) {
            #search-form * {
                font-size: 13px !important;
            }

            #search-form .row .col-lg-1,
            #search-form .row .col-lg-10,
            #search-form .row .col-lg-2,
            .col-lg-3 {
                padding-right: 30px !important;
                padding-left: 30px !important;
            }

            .RangeContainer {
                width: 84%;
            }

            .form-select {
                margin-bottom: 5px !important;
            }

            .form-control {
                margin-bottom: 5px !important;
            }
        }

        .custom-btn {
            height: 30px;
            display: flex;
            align-items: center;
            justify-content: center;
            white-space: nowrap;
            border-radius: 10px;
            border: #3936f8;
        }
    </style>
@endpush
@section('content')
    <div class="container">
        <div class="row">
            <div class="col-lg-12 col-md-12">
                <div class="filter_search_opt">
                    <a id="toogle-sm-sidebar-btn" href="javascript:void(0);">@lang('Search Property')&nbsp;&nbsp; <i
                            class="ti-menu"></i></a>
                </div>
            </div>
        </div>
        <!-- Search Form -->
        <div class="search-header-banner">
            <div class="hero-search-content">
                <form id="search-form" action="{{ route('front.listing') }}" method="get">
                    <div class="row">
                        <div class="">
                            <div>
                                <div class="row">
                                    <div class="col-lg-2">
                                        <select id="location1" class="form-control" name="location_id">
                                            <option value="">&nbsp;Select City</option>
                                            <optgroup label="Top Cities">
                                                @foreach ($locations->where('is_top_city', 1) as $data)
                                                    <option value="{{ $data->id }}"
                                                        {{ request()->location_id == $data->id ? 'selected' : '' }}>
                                                        {{ $data->name }}
                                                    </option>
                                                @endforeach
                                            </optgroup>
                                            <optgroup label="Other Cities">
                                                @foreach ($locations->where('is_top_city', 0) as $data)
                                                    <option value="{{ $data->id }}"
                                                        {{ request()->location_id == $data->id ? 'selected' : '' }}>
                                                        {{ $data->name }}
                                                    </option>
                                                @endforeach
                                            </optgroup>
                                        </select>
                                    </div>
                                    <div class="col-lg-10 position-relative">
                                        <div class="input-group" style="border: 1px solid #e0ecf5;">
                                            <span class="input-group-text"><i class="fa fa-search"></i></span>
                                            <input id="locality-search" type="text" class="form-control small-input"
                                                name="name" value="{{ old('name', request()->name) }}"
                                                placeholder="Enter Locality">
                                        </div>
                                        <div id="suggestions"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <br><br>
                        <div class="col-lg-2 ">
                            <select class="form-select" name="category_id">
                                <option value="">Category</option>
                                @foreach ($categories as $key => $data)
                                    <option value="{{ $data->id }}">
                                        {{ $data->title }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <!-- BHK Selection -->
                        <div class="col-lg-1">
                            <select class="form-select" name="no_of_bhk">
                                <option value="" disabled selected>BHK</option>
                                <option value="1 RK">1 RK</option>
                                <option value="1 BHK">1 BHK</option>
                                <option value="1.5 BHK">1.5 BHK</option>
                                <option value="2 BHK">2 BHK</option>
                                <option value="2.5 BHK">2.5 BHK</option>
                                <option value="3 BHK">3 BHK</option>
                                <option value="3.5 BHK">3.5 BHK</option>
                                <option value="4 BHK">4 BHK</option>
                                <option value="4.5 BHK">4.5 BHK</option>
                                <option value="5 BHK">5 BHK</option>
                                <option value="5.5 BHK">5.5 BHK</option>
                                <option value="6 BHK">6 BHK</option>
                                <option value="6.5 BHK">6.5 BHK</option>
                                <option value="7 BHK">7 BHK</option>
                                <option value="7+ BHK">7+ BHK</option>
                            </select>
                        </div>
                        <!-- Price Range -->
                        <div class="col-lg-3 position-relative">
                            <!-- Clickable Label to Toggle Price Range -->
                            <button type="button" class="form-select d-flex align-items-center justify-content-between"
                                id="priceToggleBtn">
                                <span>₹<span id="minPriceValue">50,000</span> - ₹<span
                                        id="maxPriceValue">1,00,00,000</span></span>
                            </button>
                            <!-- Price Range Dropdown -->
                            <div id="priceRangeContainer" class="bg-white p-3 border rounded shadow-sm RangeContainer"
                                style="display: none;">
                                <div class="d-flex justify-content-between">
                                    <span>₹50,000</span>
                                    <span>₹10,00,00,000</span>
                                </div>
                                <!-- Dual-Handle Range Slider -->
                                <div class="range-slider-wrapper">
                                    <input type="range" id="minRange" min="50000" max="100000000" step="50000"
                                        value="50000" oninput="updateSlider()">
                                    <input type="range" id="maxRange" min="50000" max="100000000" step="50000"
                                        value="50000000" oninput="updateSlider()">
                                    <div class="slider-track">
                                        <div class="fill-track"></div>
                                    </div>
                                </div>
                                <!-- Selected Price Display -->
                                <div class="small text-muted text-center">
                                    ₹<span id="selectedMinPrice">50,000</span> - ₹<span
                                        id="selectedMaxPrice">50,00,000</span>
                                </div>
                            </div>
                        </div>
                        <!-- Sale Type -->
                        <div class="col-lg-2 ">
                            <select class="form-select" name="sale_type">
                                <option value="">Sale Type</option>
                                <option value="new-booking">New Booking
                                </option>
                                <option value="resale">
                                    Resale</option>
                            </select>
                        </div>
                        <!-- Construction Status -->
                        <div class="col-lg-2 ">
                            <select class="form-select" name="construction_status">
                                <option value="">Construction Status</option>
                                <option value="under-construction">
                                    Under Construction</option>
                                <option value="ready-to-move">Ready to
                                    Move</option>
                            </select>
                        </div>
                        <!-- Search Button -->
                        <div class="col-lg-2 d-flex">
                            <input type="hidden" name="type" value="{{ request()->type }}">
                            <input type="hidden" name="autoSubmit"
                                value="{{ request()->autoSubmit ? request()->autoSubmit : 0 }}">
                            <button type="submit" class="btn btn-primary btn-sm rounded border-primary px-4">Search
                            </button>
                            <button id="clearBtn"
                                class="btn btn-secondary btn-sm rounded border-secondary px-4 mx-1">Clear
                            </button>
                        </div>
                    </div>
                </form>
                <script>
                    document.addEventListener("DOMContentLoaded", function() {
                        const form = document.getElementById("search-form");

                        // On submit, capture and save to localStorage
                        form.addEventListener("submit", function() {
                            const formData = new FormData(form);
                            let searchData = {};

                            // Convert FormData to object
                            formData.forEach((value, key) => {
                                if (value !== "") {
                                    searchData[key] = value;
                                }
                            });

                            // Add min/max price from sliders (if you're using JS-controlled sliders)
                            const minRange = document.getElementById("minRange")?.value;
                            const maxRange = document.getElementById("maxRange")?.value;

                            if (minRange && maxRange) {
                                searchData.minPrice = minRange;
                                searchData.maxPrice = maxRange;
                            }

                            // Load recent searches from localStorage
                            let recentSearches = JSON.parse(localStorage.getItem("recentSearches")) || [];

                            // Avoid duplicates
                            let exists = recentSearches.some(search => JSON.stringify(search) === JSON.stringify(
                                searchData));
                            if (!exists) {
                                recentSearches.unshift(searchData);
                                if (recentSearches.length > 25) recentSearches.pop(); // Limit to 25
                                localStorage.setItem("recentSearches", JSON.stringify(recentSearches));
                                console.log("✅ Search saved to localStorage:", searchData);
                            } else {
                                console.log("ℹ️ Search already exists in localStorage");
                            }
                        });
                    });
                </script>
            </div>
        </div>
        <div class="col-lg-12 col-md-12">
            <h4 class="ipt-title">
                Properties for sale:
                @if (request()->name)
                    {{ request()->name }},
                @endif
                @php
                    $locationName = $locations->where('id', request()->location_id)->first()->name ?? '';
                @endphp
                {{ $locationName }}
            </h4>
            <p class="text-muted small">
                Showing {{ $properties->firstItem() }} to {{ $properties->lastItem() }} of {{ $properties->total() }}
                results
            </p><br>
        </div>
        <div class="row">
            <div class="col-lg-12 col-md-12 col-md-12 list-layout">
                <div class="row">
                    <div class="col-lg-12 col-md-12">
                        <div class="filter-fl">
                            <h4>@lang('Search Results')</h4>
                        </div>
                        <hr>
                    </div>
                    @includeIf('partials.front.property')
                </div>
            </div>
        </div>
    </div>
    @includeIf('partials.front.cta')
@endsection
@push('js')
    <script src="{{ asset('assets/front/js/map_infobox.js') }}"></script>
    <script src="{{ asset('assets/front/js/markerclusterer.js') }}"></script>
    <script src="{{ asset('assets/front/js/map.js') }}"></script>
    <script>
        'use strict';
        document.addEventListener("DOMContentLoaded", function() {
            const searchIcon = document.querySelector(".input-group-text");
            const searchForm = document.getElementById("search-form");
            if (searchIcon && searchForm) {
                searchIcon.addEventListener("click", function() {
                    searchForm.submit();
                });
            }
        });

        function doSubmit() {
            $('#__search').submit();
        }
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        document.getElementById('clearBtn').addEventListener('click', function() {
            document.getElementById('search-form').reset();
        });
        $(document).ready(function() {
            if ($('input[name="autoSubmit"]').val() == 1) {
                $('input[name="autoSubmit"]').val(0);
                $('#search-form').trigger('submit');
            }
        });
        document.addEventListener("DOMContentLoaded", function() {
            var toggleBtn = document.getElementById("toogle-sm-sidebar-btn");
            var searchForm = document.getElementById("search-form");

            function checkWindowSize() {
                if (window.innerWidth <= 768) {
                    searchForm.style.display = "none";
                } else {
                    searchForm.style.display = "block";
                }
            }
            toggleBtn.addEventListener("click", function() {
                if (window.innerWidth <= 768) {
                    searchForm.style.display = searchForm.style.display === "none" ? "block" : "none";
                }
            });
            window.addEventListener("resize", checkWindowSize);
            checkWindowSize();
        });

        function showLoginPrompt() {
            alert('You need to log in to view contact details.');
            window.location.href = "{{ route('user.otp') }}";
        }

        function showContactModal(name, phone) {
            document.getElementById('contactName').innerText = name;
            document.getElementById('contactPhone').innerText = phone;
            $('#contactModal').modal('show');
        }

        function closeModal() {
            $('#contactModal').modal('hide');
        }

        function redirectToLogin() {
            window.location.href = "{{ route('user.otp') }}";
        }
        $(document).on('click', '.modal-close-btn', function() {
            closeModal();
        });
        $(document).on('click', '#wishList', function() {
            let $this = $(this);
            let propertyId = $(this).data('property');
            let userId = $(this).data('user');
            if (userId == '') {
                window.location.href = mainurl + '/user/login';
            }
            $.ajax({
                method: "POST",
                url: mainurl + '/property/wishlist',
                data: {
                    property_id: propertyId,
                    user_id: userId
                },
                success: function(data) {
                    if (data.success) {
                        $this.prop('class', '');
                        $this.prop('class', 'like-bitt add-to-favorite');
                        toastr.success(data.success);
                    } else {
                        $this.prop('class', '');
                        $this.prop('class', 'add-to-favorite');
                        toastr.error(data.error);
                    }
                }
            });
        });
        document.getElementById('priceToggleBtn').addEventListener('click', function(event) {
            let priceContainer = document.getElementById('priceRangeContainer');
            priceContainer.style.display = (priceContainer.style.display === 'none' || priceContainer.style
                .display === '') ? 'block' : 'none';
            event.stopPropagation();
        });

        function updateSlider() {
            const minSlider = document.getElementById('minRange');
            const maxSlider = document.getElementById('maxRange');
            const fillTrack = document.querySelector('.fill-track');

            let min = parseInt(minSlider.value);
            let max = parseInt(maxSlider.value);

            if (min > max) {
                [min, max] = [max, min]; // swap
                minSlider.value = min;
                maxSlider.value = max;
            }

            const range = minSlider.max - minSlider.min;
            const minPercent = ((min - minSlider.min) / range) * 100;
            const maxPercent = ((max - minSlider.min) / range) * 100;

            fillTrack.style.left = `${minPercent}%`;
            fillTrack.style.width = `${maxPercent - minPercent}%`;

            // Update visible price labels
            document.getElementById('selectedMinPrice').textContent = formatINR(min);
            document.getElementById('selectedMaxPrice').textContent = formatINR(max);

            // Update button text
            document.getElementById('minPriceValue').textContent = formatINR(min);
            document.getElementById('maxPriceValue').textContent = formatINR(max);
        }

        function formatINR(number) {
            return new Intl.NumberFormat('en-IN').format(number);
        }

        document.addEventListener("click", function(event) {
            let priceContainer = document.getElementById('priceRangeContainer');
            let priceButton = document.getElementById('priceToggleBtn');
            if (!priceContainer.contains(event.target) && !priceButton.contains(event.target)) {
                priceContainer.style.display = "none";
            }
        });
    </script>
    <script type="text/javascript">
        $(document).ready(function() {
            $('#locality-search').on('focus', function() {
                fetchSuggestions('');
            });
            $('#locality-search').on('input', function() {
                var query = $(this).val();
                fetchSuggestions(query);
            });

            function fetchSuggestions(query) {
                var location = $('#location1').find(':selected').text();
                var type = $('input[name="type"]').val();
                $.ajax({
                    url: "{{ route('front.getSuggestions') }}",
                    type: "GET",
                    data: {
                        query: query,
                        location: location,
                        type: type
                    },
                    success: function(data) {
                        renderSuggestions(data, query);
                    },
                    error: function() {
                        $('#suggestions').html('<p>Something went wrong. Please try again.</p>').show();
                    }
                });
            }

            function renderSuggestions(data, query) {
                if (data.length === 0) {
                    $('#suggestions').html('<p class="p-2">No data available for the selected location</p>').show();
                } else {
                    var list = '<ul class="list-group">';
                    data.forEach(function(item) {
                        var displayText = item.result ? item.result.Property + ', ' + item.result.City :
                            item.locality;
                        var matchText = item.match;
                        list +=
                            '<li class="list-group-item suggestion-item d-flex justify-content-between align-items-center" ' +
                            'data-value="' + displayText + '">' +
                            '<span>' + displayText + '</span>' +
                            '<small class="text-muted">' + matchText + '</small>' +
                            '</li>';
                    });
                    list += '</ul>';
                    $('#suggestions').html(list).show();
                }
            }
            $(document).on('click', '.suggestion-item', function() {
                var value = $(this).data('value');
                $('#locality-search').val(value);
                $('#suggestions').hide();
            });
            // Click outside to hide suggestions
            $(document).click(function(event) {
                if (!$(event.target).closest('#locality-search, #suggestions').length) {
                    $('#suggestions').hide();
                }
            });
        });
    </script>
@endpush
