@extends('layouts.front')
@push('css')
    <style>
        .input-with-icon input,
        .input-with-icon select {
            padding-left: 10px;
            padding-right: 10px;
            padding-top: 5px;
            padding-bottom: 5px;
        }

        .form-group {
            margin-bottom: 10px;
        }

        .search-header-banner .form-control,
        .search-header-banner select,
        .search-header-banner select option {
            font-size: 14px;
            /* Sabka text size 12px ho jayega */
        }
    </style>
@endpush
@section('content')
    <div class="container">
        <div class="row">
            <div class="col-lg-12 col-md-12">
                <div class="filter_search_opt">
                    <a id="toogle-sm-sidebar-btn" href="javascript:void(0);">@lang('Search Property')&nbsp;&nbsp; <i
                            class="ti-menu"></i></a>
                </div>
            </div>
        </div>
        <!-- Search Form -->
        <div class="search-header-banner">
            <div class="full-search-2 p-0 m-0">
                <div class="hero-search-content p-0 m-0">
                    <form id="search-form" action="{{ route('front.listing') }}" method="get">
                        <div class="forms-rows" style="display: flex; flex-wrap: wrap; gap: 10px;">
                            <div class="form-group m-0" style="flex:6 0 120px;">
                                <div class="input-with-icon">
                                    <input type="text" class="form-control" name="name"
                                        placeholder="@lang('Type here...')"
                                        value="{{ request()->name ? request()->name : '' }}">
                                </div>
                            </div>
                            <div class="form-group" style="flex: 2 0 160px;">
                                <div class="input-with-icon">
                                    <select id="ptypes" class="form-control" name="category_id">
                                        <option value=""></option>
                                        @foreach ($categories as $key => $data)
                                            <option value="{{ $data->id }}"
                                                {{ request()->category_id == $data->id ? 'selected' : '' }}>
                                                {{ $data->title }}
                                            </option>
                                        @endforeach
                                    </select><i class="ti-briefcase"></i>
                                </div>
                            </div>
                            <div class="form-group m-0" style="flex: 1 1 150px;">
                                <div class="input-with-icon">
                                    <select id="cities" name="location_id" class="form-control m-0 pl-2">
                                        <option value="">&nbsp;</option>
                                        @foreach ($locations as $key => $data)
                                            <option value="{{ $data->id }}"
                                                {{ request()->location_id == $data->id ? 'selected' : '' }}>
                                                {{ $data->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    <i class="ti-location-pin"></i>
                                </div>
                            </div>
                            <div class="form-group m-0" style="flex: 1 1 120px;">
                                <div class="input-with-icon">
                                    <input type="text" name="min" class="form-control" style="padding-left: 30px;"
                                        placeholder="@lang('Min')" value="{{ request()->min ? request()->min : '' }}"
                                        oninput="this.value = this.value.replace(/[^0-9.]/g, '')"><i class="">₹</i>
                                </div>
                            </div>
                            <div class="form-group m-0" style="flex: 1 1 120px;">
                                <div class="input-with-icon">
                                    <input type="text" class="form-control" style="padding-left: 30px;" name="max"
                                        placeholder="@lang('Max')" value="{{ request()->max ? request()->max : '' }}"
                                        oninput="this.value = this.value.replace(/[^0-9.]/g, '')"><i class="">₹</i>
                                </div>
                            </div>
                            <div class="form-group m-0" style="flex: 1 1 90px;">
                                <div class="input-with-icon">
                                    <input type="number" class="form-control m-0 pl-2" name="bed" step="3"
                                        placeholder="@lang('Bed')" value="{{ request()->bed ? request()->bed : '' }}">
                                    <i class="fas fa-bed"></i>
                                </div>
                            </div>
                            <div class="form-group m-0" style="flex: 1 1 90px;">
                                <div class="input-with-icon">
                                    <input type="number" class="form-control m-0 pl-2" name="bath" step="3"
                                        placeholder="@lang('Bath')"
                                        value="{{ request()->bath ? request()->bath : '' }}">
                                    <i class="fas fa-bath"></i>
                                </div>
                            </div>
                            <div class="form-group m-0" style="flex: 1 1 80px;">
                                <input type="hidden" name="autoSubmit"
                                    value="{{ request()->autoSubmit ? request()->autoSubmit : 0 }}">
                                <button type="submit" class="btn btn-theme" style="width: 100%;">@lang('Search')</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="col-lg-12 col-md-12">
            <h4 class="ipt-title">@lang('Property Results for ') {{ request()->name ? request()->name : '' }}</h4>
            <p class="text-muted small">
                Showing {{ $properties->firstItem() }} to {{ $properties->lastItem() }} of {{ $properties->total() }}
                results
            </p><br>
        </div>
        {{-- <section> --}}
        <div class="row">
            <div class="col-lg-12 col-md-12 col-md-12 list-layout">
                <div class="row">
                    <div class="col-lg-12 col-md-12">
                        <div class="filter-fl">
                            <h4>@lang('Search Results')</h4>
                        </div>
                    </div>
                    @includeIf('partials.front.property')
                </div>
            </div>
        </div>
        {{-- </section> --}}
        <!-- ============================ All Property ================================== -->

        <form id="__search" class="d-none" action="{{ route('front.listing') }}" method="get">
            <input type="text" name="location"
                value="{{ request()->input('location') ? request()->input('location') : '' }}" id="location">
            <input type="text" name="type" id="type"
                value="{{ request()->input('type') ? request()->input('type') : '' }}">
            <input type="text" name="bed" id="bed"
                value="{{ request()->input('bed') ? request()->input('bed') : '' }}">
            <input type="text" name="range" id="range"
                value="{{ request()->input('range') ? request()->input('range') : '' }}">
            <input type="text" name="shorty" id="shorty_val"
                value="{{ request()->input('shorty') ? request()->input('shorty') : '' }}">
        </form>
    </div>
    @includeIf('partials.front.cta')
@endsection
@push('js')
    <script src="{{ asset('assets/front/js/map_infobox.js') }}"></script>
    <script src="{{ asset('assets/front/js/markerclusterer.js') }}"></script>
    <script src="{{ asset('assets/front/js/map.js') }}"></script>
    <script>
        'use strict';
        $(document).on('click', '.search__by__location', function() {
            var location = $(this).val();
            $('#location').val(location);
            doSubmit();
        })
        $(document).on('click', '.search__by__type', function() {
            var type = $(this).val();
            $('#type').val(type);
            doSubmit();
        })
        $(document).on('click', '.search__by__bed', function() {
            var bed = $(this).val();
            $('#bed').val(bed);
            doSubmit();
        })
        $(document).on('click', '.search__by__range', function() {
            var range = $(this).val();
            $('#range').val(range);
            doSubmit();
        })
        $(document).on('change', '#shorty', function() {
            var shorty = $(this).val();
            $('#shorty_val').val(shorty);
            doSubmit();
        })

        function doSubmit() {
            $('#__search').submit();
        }
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        $(document).ready(function() {
            if ($('input[name="autoSubmit"]').val() == 1) {
                $('input[name="autoSubmit"]').val(0);
                $('#search-form').trigger('submit');
            }
        });
        document.addEventListener("DOMContentLoaded", function() {
            var toggleBtn = document.getElementById("toogle-sm-sidebar-btn");
            var searchForm = document.getElementById("search-form");

            function checkWindowSize() {
                if (window.innerWidth <= 768) {
                    searchForm.style.display = "none"; // Hide by default on mobile
                } else {
                    searchForm.style.display = "block"; // Always show on desktop
                }
            }
            toggleBtn.addEventListener("click", function() {
                if (window.innerWidth <= 768) {
                    searchForm.style.display = searchForm.style.display === "none" ? "block" : "none";
                }
            });
            window.addEventListener("resize", checkWindowSize);
            checkWindowSize();
        });

        function showLoginPrompt() {
            alert('You need to log in to view contact details.');
            window.location.href = '{{ route('user.login') }}';
        }

        function showContactModal(name, phone) {
            // Set modal content
            document.getElementById('contactName').innerText = name;
            document.getElementById('contactPhone').innerText = phone;
            // Show modal
            $('#contactModal').modal('show');
        }

        function closeModal() {
            // Close the modal explicitly
            $('#contactModal').modal('hide');
        }

        function redirectToLogin() {
            // Redirect to login page
            window.location.href = "{{ route('user.login') }}";
        }
        $(document).on('click', '.modal-close-btn', function() {
            closeModal();
        });

        document.getElementById("contactForm").addEventListener("submit", function(event) {
            event.preventDefault();
            alert("Your message has been sent successfully!");
            var contactForm = new bootstrap.Modal(document.getElementById('contactForm'));
            contactForm.hide();
            this.reset();
        });

        $(document).on('click', '#wishList', function() {
            let $this = $(this);
            let propertyId = $(this).data('property');
            let userId = $(this).data('user');
            if (userId == '') {
                window.location.href = mainurl + '/user/login';
            }
            $.ajax({
                method: "POST",
                url: mainurl + '/property/wishlist',
                data: {
                    property_id: propertyId,
                    user_id: userId
                },
                success: function(data) {
                    if (data.success) {
                        $this.prop('class', '');
                        $this.prop('class', 'like-bitt add-to-favorite');
                        toastr.success(data.success);
                    } else {
                        $this.prop('class', '');
                        $this.prop('class', 'add-to-favorite');
                        toastr.error(data.error);
                    }
                }
            });
        });
    </script>
    <!-- JavaScript -->
    <script>
        document.getElementById("shareButton").addEventListener("click", function(event) {
            event.preventDefault();
            let shareMenu = document.getElementById("shareMenu");

            // Get button position
            let rect = this.getBoundingClientRect();
            let topPosition = rect.bottom + window.scrollY; // Position below the button
            let leftPosition = rect.left + window.scrollX; // Align with the button

            // Toggle Visibility
            if (shareMenu.style.display === "none") {
                shareMenu.style.display = "block";
                shareMenu.style.top = topPosition + "px";
                shareMenu.style.left = leftPosition + "px";
            } else {
                shareMenu.style.display = "none";
            }
        });

        // Copy Link Function
        function copyLink() {
            navigator.clipboard.writeText(window.location.href);
            alert("🔗 Link copied to clipboard!");
        }

        // Hide Menu on Click Outside
        document.addEventListener("click", function(event) {
            let shareMenu = document.getElementById("shareMenu");
            let shareButton = document.getElementById("shareButton");

            if (!shareMenu.contains(event.target) && event.target !== shareButton) {
                shareMenu.style.display = "none";
            }
        });
    </script>
    <script>
        document.getElementById('share').addEventListener('click', function() {
            let shareOptions = document.getElementById('shareOptions');
            shareOptions.classList.toggle('d-none');
        });
        document.getElementById('copyLink').addEventListener('click', function() {
            let propertyUrl = window.location.href;
            navigator.clipboard.writeText(propertyUrl).then(() => {
                alert('Link copied to clipboard!');
            });
        });
        document.getElementById('shareInstagram').addEventListener('click', function() {
            let propertyUrl = encodeURIComponent(window.location.href);
            window.open(`https://www.instagram.com/sharer/sharer.php?u=${propertyUrl}`, '_blank');
        });
        document.getElementById('shareFacebook').addEventListener('click', function() {
            let propertyUrl = encodeURIComponent(window.location.href);
            window.open(`https://www.facebook.com/sharer/sharer.php?u=${propertyUrl}`, '_blank');
        });
        document.getElementById('shareLinkedin').addEventListener('click', function() {
            let propertyUrl = encodeURIComponent(window.location.href);
            window.open(`https://www.linkedin.com/sharer/sharer.php?u=${propertyUrl}`, '_blank');
        });
        document.getElementById('shareTwitter').addEventListener('click', function() {
            let propertyUrl = encodeURIComponent(window.location.href);
            window.open(`https://twitter.com/intent/tweet?url=${propertyUrl}&text=Check out this property!`,
                '_blank');
        });
        document.getElementById('shareWhatsapp').addEventListener('click', function() {
            let propertyUrl = encodeURIComponent(window.location.href);
            window.open(`https://api.whatsapp.com/send?text=${propertyUrl}`, '_blank');
        });
    </script>
@endpush



{{--  --}}



@extends('layouts.front')
@push('css')
    <style>
        #search-form * {
            font-size: 15px !important;
        }

        @media (min-width: 1200px) {

            .container,
            .container-lg,
            .container-md,
            .container-sm,
            .container-xl {
                max-width: 1300px;
            }
        }

        .range-slider input[type="range"] {
            position: absolute;
            width: 85%;
            -webkit-appearance: none;
            background: transparent;
            pointer-events: none;
        }

        /* Make the range track visible */
        .range-slider input[type="range"]::-webkit-slider-runnable-track {
            width: 100%;
            height: 4px;
            background: #ddd;
            border-radius: 2px;
            cursor: pointer;
        }

        .range-slider input[type="range"]::-moz-range-track {
            width: 80%;
            height: 4px;
            background: #ddd;
            border-radius: 2px;
            cursor: pointer;
        }

        /* Custom slider styling for thumbs */
        .range-slider input[type="range"]::-webkit-slider-thumb {
            -webkit-appearance: none;
            width: 15px;
            height: 15px;
            background: #007bff;
            border-radius: 50%;
            cursor: pointer;
            pointer-events: auto;
            margin-top: -6px;
            /* Align thumb properly */
        }

        .range-slider input[type="range"]::-moz-range-thumb {
            width: 15px;
            height: 15px;
            background: #007bff;
            border-radius: 50%;
            cursor: pointer;
            pointer-events: auto;
        }
    </style>
@endpush
@section('content')
    <div class="container">
        <div class="row">
            <div class="col-lg-12 col-md-12">
                <div class="filter_search_opt">
                    <a id="toogle-sm-sidebar-btn" href="javascript:void(0);">@lang('Search Property')&nbsp;&nbsp; <i
                            class="ti-menu"></i></a>
                </div>
            </div>
        </div>
        <!-- Search Form -->
        <div class="search-header-banner">
            <div class="hero-search-content">
                <form id="search-form" action="{{ route('front.listing') }}" method="get">
                    <div class="row">
                        <div class="">
                            <div>
                                <div class="row">
                                    <div class="col-lg-2 ">
                                        <input type="hidden" name="type" value="{{ request()->type}}">
                                        <select id="location1" class="form-control custom-select-up" name="location_id">
                                            <option value="">&nbsp;</option>

                                            <optgroup label="Top Cities">
                                                @foreach ($locations->where('is_top_city', 1) as $data)
                                                    <option value="{{ $data->id }}" {{ request()->location_id == $data->id ? 'selected' : '' }}>
                                                        {{ $data->name }}
                                                    </option>
                                                @endforeach
                                            </optgroup>

                                            <optgroup label="Other Cities">
                                                @foreach ($locations->where('is_top_city', 0) as $data)
                                                    <option value="{{ $data->id }}" {{ request()->location_id == $data->id ? 'selected' : '' }}>
                                                        {{ $data->name }}
                                                    </option>
                                                @endforeach
                                            </optgroup>
                                        </select>

                                    </div>
                                    <div class="col-lg-10 position-relative">
                                        <div class="input-group">
                                            <span class="input-group-text"><i class="fa fa-search"></i></span>
                                            <input id="locality-search" type="text" class="form-control small-input" name="name"
                                                value="{{ old('name', request()->name) }}"
                                                placeholder="Enter Locality"
                                                style="height: 45px;">
                                                <div class="w-100" id="suggestions"></div>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <br><br><br>
                        <div class="col-lg-2 ">
                            <select class="form-select" name="category_id">
                                <option value="">Category</option>
                                @foreach ($categories as $key => $data)
                                    <option value="{{ $data->id }}">
                                        {{ $data->title }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <!-- BHK Selection -->
                        <div class="col-lg-1 ">
                            <select class="form-select" name="no_of_bhk">
                                <option value="" disabled selected>BHK</option>
                                <option value="1-RK">1 RK
                                </option>
                                <option value="1-BHK">1 BHK
                                </option>
                                <option value="2-BHK">2 BHK
                                </option>
                                <option value="3-BHK">3 BHK
                                </option>
                                <option value="4-BHK">4 BHK
                                </option>
                                <option value="5+-BHK">5+ BHK
                                </option>
                            </select>
                        </div>
                        <!-- Price Range -->
                        <div class="col-lg-3 position-relative">
                            <!-- Clickable Label to Toggle Price Range -->
                            <button type="button" class="form-select d-flex align-items-center justify-content-between p-2"
                                id="priceToggleBtn">
                                <span>₹<span id="minPriceValue">50,000</span> - ₹<span
                                        id="maxPriceValue">1,00,00,000</span></span>
                            </button>
                            <!-- Price Range Dropdown -->
                            <div id="priceRangeContainer" class="bg-white p-3 border rounded shadow-sm"
                                style="display: none; position: absolute; width: 100%; z-index: 10;">
                                <div class="d-flex justify-content-between">
                                    <span>₹50,000</span>
                                    <span>₹10,00,00,000</span>
                                </div>
                                <!-- Dual-Handle Range Slider -->
                                <div class="range-slider">
                                    <input type="range" name="min" id="minRange" min="50000" max="100000000" step="50000"
                                        value="50000" oninput="updateRange()">
                                    <input type="range" name="max" id="maxRange" min="50000" max="100000000" step="500000"
                                        value="50000000" oninput="updateRange()">
                                </div>
                                <!-- Selected Price Display -->
                                <div class="small text-muted text-center mt-2">
                                    <br>
                                    ₹<span id="selectedMinPrice">50,000</span> - ₹<span
                                        id="selectedMaxPrice">50,00,000</span>
                                </div>
                            </div>
                        </div>
                        <!-- Sale Type -->
                        <div class="col-lg-2 ">
                            <select class="form-select" name="looking_for">
                                <option value="">Sale Type</option>
                                <option value="new-booking">New Booking
                                </option>
                                <option value="resale">
                                    Resale</option>
                            </select>
                        </div>
                        <!-- Construction Status -->
                        <div class="col-lg-2 ">
                            <select class="form-select" name="construction_status">
                                <option value="">Construction Status</option>
                                <option value="under-construction">
                                    Under Construction</option>
                                <option value="ready-to-move">Ready to
                                    Move</option>
                            </select>
                        </div>
                        <!-- Search Button -->
                        <div class="col-lg-1 col-md-2 col-sm-3">
                            <input type="hidden" name="autoSubmit"
                                value="{{ request()->autoSubmit ? request()->autoSubmit : 0 }}">
                            <button type="submit"
                                class="btn btn-primary btn-sm rounded w-100 text-center border-primary">Search</button>
                        </div>
                        <!-- Clear All Filters Button -->
                        <div class="col-lg-1 col-md-2 col-sm-3">
                            <button id="clearBtn"
                                class="btn btn-secondary btn-sm rounded w-100 text-center border-secondary">Clear
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <div class="col-lg-12 col-md-12">
            <h4 class="ipt-title">
                Properties for sale:
                @if (request()->name)
                    {{ request()->name }},
                @endif
                @php
                    $locationName = $locations->where('id', request()->location_id)->first()->name ?? '';
                @endphp
                {{ $locationName }}
            </h4>
            <p class="text-muted small">
                Showing {{ $properties->firstItem() }} to {{ $properties->lastItem() }} of {{ $properties->total() }}
                results
            </p><br>
        </div>
        <div class="row">
            <div class="col-lg-12 col-md-12 col-md-12 list-layout">
                <div class="row">
                    <div class="col-lg-12 col-md-12">
                        <div class="filter-fl">
                            <h4>@lang('Search Results')</h4>
                        </div>
                        <hr>
                    </div>
                    @includeIf('partials.front.property')
                </div>
            </div>
        </div>
        <!-- ============================ All Property ================================== -->
        {{-- <form id="__search" class="d-none" action="{{ route('front.listing') }}" method="get">
            <input type="text" name="location"
                value="{{ request()->input('location') ? request()->input('location') : '' }}" id="location">
            <input type="text" name="type" id="type"
                value="{{ request()->input('type') ? request()->input('type') : '' }}">
            <input type="text" name="range" id="range"
                value="{{ request()->input('range') ? request()->input('range') : '' }}">
            <input type="text" name="shorty" id="shorty_val"
                value="{{ request()->input('shorty') ? request()->input('shorty') : '' }}">
        </form> --}}
    </div>
    @includeIf('partials.front.cta')
@endsection
@push('js')
    <script src="{{ asset('assets/front/js/map_infobox.js') }}"></script>
    <script src="{{ asset('assets/front/js/markerclusterer.js') }}"></script>
    <script src="{{ asset('assets/front/js/map.js') }}"></script>
    <script>
        'use strict';

        function doSubmit() {
            $('#__search').submit();
        }
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        document.getElementById('clearBtn').addEventListener('click', function() {
            document.getElementById('search-form').reset();
        });
        $(document).ready(function() {
            if ($('input[name="autoSubmit"]').val() == 1) {
                $('input[name="autoSubmit"]').val(0);
                $('#search-form').trigger('submit');
            }
        });
        document.addEventListener("DOMContentLoaded", function() {
            var toggleBtn = document.getElementById("toogle-sm-sidebar-btn");
            var searchForm = document.getElementById("search-form");

            function checkWindowSize() {
                if (window.innerWidth <= 768) {
                    searchForm.style.display = "none";
                } else {
                    searchForm.style.display = "block";
                }
            }
            toggleBtn.addEventListener("click", function() {
                if (window.innerWidth <= 768) {
                    searchForm.style.display = searchForm.style.display === "none" ? "block" : "none";
                }
            });
            window.addEventListener("resize", checkWindowSize);
            checkWindowSize();
        });

        function showLoginPrompt() {
            alert('You need to log in to view contact details.');
            window.location.href = '{{ route('user.login') }}';
        }

        function showContactModal(name, phone) {
            document.getElementById('contactName').innerText = name;
            document.getElementById('contactPhone').innerText = phone;
            $('#contactModal').modal('show');
        }

        function closeModal() {
            $('#contactModal').modal('hide');
        }

        function redirectToLogin() {
            window.location.href = "{{ route('user.login') }}";
        }
        $(document).on('click', '.modal-close-btn', function() {
            closeModal();
        });
        $(document).on('click', '#wishList', function() {
            let $this = $(this);
            let propertyId = $(this).data('property');
            let userId = $(this).data('user');
            if (userId == '') {
                window.location.href = mainurl + '/user/login';
            }
            $.ajax({
                method: "POST",
                url: mainurl + '/property/wishlist',
                data: {
                    property_id: propertyId,
                    user_id: userId
                },
                success: function(data) {
                    if (data.success) {
                        $this.prop('class', '');
                        $this.prop('class', 'like-bitt add-to-favorite');
                        toastr.success(data.success);
                    } else {
                        $this.prop('class', '');
                        $this.prop('class', 'add-to-favorite');
                        toastr.error(data.error);
                    }
                }
            });
        });
        document.getElementById('priceToggleBtn').addEventListener('click', function(event) {
            let priceContainer = document.getElementById('priceRangeContainer');
            priceContainer.style.display = (priceContainer.style.display === 'none' || priceContainer.style
                .display === '') ? 'block' : 'none';
            event.stopPropagation(); // Prevents event from triggering document click
        });

        function updateRange() {
            let minPrice = parseInt(document.getElementById('minRange').value);
            let maxPrice = parseInt(document.getElementById('maxRange').value);
            // Prevent min from exceeding max
            if (minPrice > maxPrice) {
                let temp = minPrice;
                minPrice = maxPrice;
                maxPrice = temp;
            }
            document.getElementById('minPriceValue').innerText = minPrice.toLocaleString();
            document.getElementById('maxPriceValue').innerText = maxPrice.toLocaleString();
            document.getElementById('selectedMinPrice').innerText = minPrice.toLocaleString();
            document.getElementById('selectedMaxPrice').innerText = maxPrice.toLocaleString();
        }
        document.addEventListener("click", function(event) {
            let priceContainer = document.getElementById('priceRangeContainer');
            let priceButton = document.getElementById('priceToggleBtn');
            if (!priceContainer.contains(event.target) && !priceButton.contains(event.target)) {
                priceContainer.style.display = "none";
            }
        });
    </script>
    <script type="text/javascript">
        $(document).ready(function() {
            $('#locality-search').on('focus', function() {
                fetchSuggestions('');
            });
            $('#locality-search').on('input', function() {
                var query = $(this).val();
                fetchSuggestions(query);
            });

            function fetchSuggestions(query) {
                var location = $('#location1').find(':selected').text();
                var type = $('input[name="type"]:checked').val();
                $.ajax({
                    url: "{{ route('front.getSuggestions') }}",
                    type: "GET",
                    data: {
                        query: query,
                        location: location,
                        type: type
                    },
                    success: function(data) {
                        renderSuggestions(data, query);
                    },
                    error: function() {
                        $('#suggestions').html('<p>Something went wrong. Please try again.</p>');
                    }
                });
            }

            function renderSuggestions(data, query) {
                if (data.length === 0) {
                    $('#suggestions').html('<p>No data available for the selected location</p>');
                } else {
                    var list = '<ul class="list-group">';
                    data.forEach(function(item) {
                        var displayText = item.result ? item.result.Property + ', ' + item.result
                            .City : item.locality;
                        var matchText = item.match;
                        list +=
                            '<li class="list-group-item suggestion-item d-flex justify-content-between align-items-center" ' +
                            'data-value="' + displayText + '">' +
                            '<span>' + displayText + '</span>' +
                            '<small class="text-muted">' + matchText + '</small>' +
                            '</li>';
                    });
                    list += '</ul>';
                    $('#suggestions').html(list);
                }
            }
            $(document).on('click', '.suggestion-item', function() {
                var value = $(this).data('value');
                $('#locality-search').val(value);
                $('#suggestions').html('');
            });
        });
    </script>
@endpush
