@extends('layouts.front')
@push('css')
<style>
    body {
        font-family: Jost;
        color: #111;
        font-size: 14px !important;
    }

    .active {
        background-color: #007bff;
        color: white;
    }

    input {
        font-size: 14px !important;
    }


    .like_share_wrap,
    .page-sidebar,
    .sm,
    input {
        font-size: 13px !important;
    }

    @media (max-width: 767.98px) {
        .block-wrap {
            padding: 10px;
        }
    }

    .img-wrapper {
        position: relative;
        width: 100%;
        aspect-ratio: 4 / 3;
        overflow: hidden;
        border-radius: 2px;
        padding: 8px;
    }

    .img-wrapper img {
        position: absolute;
        top: 0;
        left: 0;
        height: 100%;
        width: 100%;
        object-fit: cover;
    }
</style>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
@endpush
@section('content')
<!-- ============================ Hero Banner  Start================================== -->
<div class="featured-slick">
    <div class="featured-slick-slide">
        @if ($data->galleries)
        @foreach ($data->galleries as $key => $gallery)
        <div>
            <a href="{{ asset('assets/images/' . $gallery->photo) }}" class="mfp-gallery">
                <div class="img-wrapper">
                    <img src="{{ asset('assets/images/' . $gallery->photo) }}" class="img-fluid w-100 px-1"
                        alt="Gallery Image" />
                </div>
            </a>
        </div>
        @endforeach
        @endif
    </div>
</div>
<section class="spd-wrap">
    <div class="container">
        <div class="row">
            <div class="col-lg-12 col-md-12">
                <div class="slide-property-detail">
                    <div class="slide-property-first">
                        <div class="pr-price-into">
                            <h4>{{ $data->name ?? '' }} <br></h4>
                            <h2>
                                @if ($data->rooms && count($data->rooms))
                                @php
                                $bedRents = [];
                                $roomRents = [];

                                foreach ($data->rooms as $room) {
                                $type = strtolower(trim($room->type));
                                if ($type === 'private room') {
                                $roomRents[] = $room->rent;
                                } else {
                                $bedRents[] = $room->rent;
                                }
                                }

                                $minBed = count($bedRents) ? min($bedRents) : null;
                                $maxBed = count($bedRents) ? max($bedRents) : null;

                                $minRoom = count($roomRents) ? min($roomRents) : null;
                                $maxRoom = count($roomRents) ? max($roomRents) : null;
                                @endphp

                                <div>
                                    @if ($minBed)
                                    ₹{{ number_format($minBed) }}
                                    @if ($minBed != $maxBed)
                                    – ₹{{ number_format($maxBed) }}
                                    @endif
                                    /bed
                                    @endif

                                    @if ($minBed && $minRoom)
                                    —
                                    @endif

                                    @if ($minRoom)
                                    ₹{{ number_format($minRoom) }}
                                    @if ($minRoom != $maxRoom)
                                    – ₹{{ number_format($maxRoom) }}
                                    @endif
                                    /room
                                    @endif
                                </div> <span class="prt-type pg bg-success">@lang('For PG')</span>
                                @endif

                            </h2>
                            <span class="comma-format">
                                <i class="lni-map-marker"></i>
                                {{ $data->locality }}, {{ $data->location->name ?? '' }}
                            </span>
                        </div>
                    </div>
                    <div class="slide-property-sec">
                        <div class="pr-all-info">
                            <div class="pr-single-info d-flex">
                                <!-- Share Button -->
                                <a href="JavaScript:Void(0);" id="shareButton" data-bs-toggle="tooltip"
                                    data-original-title="Share Property">
                                    <i class="fa fa-share-alt"></i>
                                </a>

                                <!-- Wishlist Button -->
                                <a href="JavaScript:Void(0);" id="wishList"
                                    class="{{ $data->checkFavourite(auth()->id(), $data->id) ? 'like-bitt' : '' }} add-to-favorite"
                                    data-property="{{ $data->id }}" data-user="{{ auth()->id() }}"
                                    data-bs-toggle="tooltip" data-original-title="Add To Favorites">
                                    <i
                                        class="fa fa-heart {{ $data->checkFavourite(auth()->id(), $data->id) ? 'text-danger' : '' }}"></i>
                                </a>

                                <div id="shareOptions" class="d-none mt-2 p-4 shadow"
                                    style="position: absolute; top: 100%; left: 0; background: white; width: 160px; border: 1px solid #ccc; border-radius: 5px; z-index: 1050;">

                                    <a href="#" id="copyLink" class="d-flex align-items-center py-1 text-dark"
                                        style="font-size: 14px;">
                                        <i class="ti-link me-2"></i> Copy Link
                                    </a>
                                    <a href="#" id="shareInstagram"
                                        class="d-flex align-items-center py-1 text-dark" style="font-size: 14px;">
                                        <i class="ti-instagram me-2"></i> Instagram
                                    </a>
                                    <a href="#" id="shareFacebook"
                                        class="d-flex align-items-center py-1 text-dark" style="font-size: 14px;">
                                        <i class="ti-facebook me-2"></i> Facebook
                                    </a>
                                    <a href="#" id="shareTwitter" class="d-flex align-items-center py-1 text-dark"
                                        style="font-size: 14px;">
                                        <i class="ti-twitter me-2"></i> Twitter
                                    </a>
                                    <a href="#" id="shareLinkedin"
                                        class="d-flex align-items-center py-1 text-dark" style="font-size: 14px;">
                                        <i class="ti-linkedin me-2"></i> LinkedIn
                                    </a>
                                    <a href="#" id="shareWhatsapp"
                                        class="d-flex align-items-center py-1 text-dark" style="font-size: 14px;">
                                        <i class="fa-brands fa-whatsapp me-2"></i> WhatsApp
                                    </a>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- ============================ Property Detail Start ================================== -->
<section class="gray">
    <div class="container">
        <div class="row">
            <!-- property main detail -->
            <div class="col-lg-8 col-md-12 col-sm-12">
                <!-- Property Info-->
                <div class="block-wrap">
                    <div class="block-header">
                        <h4 class="block-title"><i class="fa-solid fa-info-circle me-2"></i>@lang('PG Details')</h4>
                    </div>
                    <div class="block-body">
                        <div class="row">
                            <!-- PG Plan Inputs Display Start -->
                            @if ($data->total_beds)
                            <div class="col-md-8">
                                <div class="form-group d-flex align-items-center">
                                    <i class="fa-solid fa-bed me-2"></i>
                                    <p class="my-3">{{ __('Total Beds : ') }}
                                        <span class="me-1 border px-3 rounded py-1">{{ $data->total_beds }} </span>
                                    </p>
                                </div>
                            </div>
                            @endif
                            @if ($data->pg_for)
                            @php
                            $pgForList = explode(',', $data->pg_for);
                            @endphp
                            <div class="col-md-8">
                                <div class="form-group d-flex align-items-center flex-wrap">
                                    <i class="fa-solid fa-venus-mars me-2"></i>
                                    <p class="my-3 mb-0 me-2">{{ __('PG is for : ') }}</p>
                                    @foreach ($pgForList as $item)
                                    <span
                                        class="me-2 mt-2 border px-3 rounded py-1 ">{{ ucwords(trim($item)) }}</span>
                                    @endforeach
                                </div>
                            </div>
                            @endif

                            @if ($data->suited_for)
                            @php
                            $suitedForList = explode(',', $data->suited_for);
                            @endphp
                            <div class="col-md-8">
                                <div class="form-group d-flex align-items-center flex-wrap">
                                    <i class="fa-solid fa-user-graduate me-2"></i>
                                    <p class="my-3 mb-0 me-2">{{ __('Best suited for : ') }}</p>
                                    @foreach ($suitedForList as $item)
                                    <span
                                        class="me-2 mt-2 border px-3 rounded py-1 ">{{ ucwords(trim($item)) }}</span>
                                    @endforeach
                                </div>
                            </div>
                            @endif

                            @if ($data->meals_available)
                            <div class="col-md-8">
                                <div class="form-group d-flex align-items-center">
                                    <i class="fa-solid fa-utensils me-2"></i>
                                    <p class="my-3">{{ __('Meals Available: ') }}
                                        <span
                                            class="me-1 border px-3 rounded py-1">{{ ucwords($data->meals_available) }}</span>
                                    </p>
                                </div>
                            </div>
                            @endif

                            @if ($data->meal_offerings)
                            @php
                            $mealOfferingsList = explode(',', $data->meal_offerings);
                            @endphp
                            <div class="col-md-8">
                                <div class="form-group d-flex align-items-center flex-wrap">
                                    <i class="fa-solid fa-utensils me-2"></i>
                                    <p class="my-3 mb-0 me-2">{{ __('Meal Offerings : ') }}</p>
                                    @foreach ($mealOfferingsList as $item)
                                    <span
                                        class="me-2 mt-2 border px-3 rounded py-1 ">{{ ucwords(trim($item)) }}</span>
                                    @endforeach
                                </div>
                            </div>
                            @endif

                            @if ($data->meal_speciality)
                            @php
                            $mealSpecialityList = explode(',', $data->meal_speciality);
                            @endphp
                            <div class="col-md-8">
                                <div class="form-group d-flex align-items-center flex-wrap">
                                    <i class="fa-solid fa-star me-2"></i>
                                    <p class="my-3 mb-0 me-2">{{ __('Meal Speciality : ') }}</p>
                                    @foreach ($mealSpecialityList as $item)
                                    <span
                                        class="me-2 mt-2 border px-3 rounded py-1 ">{{ ucwords(trim($item)) }}</span>
                                    @endforeach
                                </div>
                            </div>
                            @endif

                            @if ($data->notice_period)
                            <div class="col-md-8">
                                <div class="form-group d-flex align-items-center">
                                    <i class="fa-solid fa-calendar-day me-2"></i>
                                    <p class="my-3">{{ __('Notice Period (Days) : ') }}
                                        <span
                                            class="me-1 border px-3 rounded py-1">{{ $data->notice_period }}</span>
                                    </p>
                                </div>
                            </div>
                            @endif
                            @if ($data->lock_in_period)
                            <div class="col-md-8">
                                <div class="form-group d-flex align-items-center">
                                    <i class="fa-solid fa-lock me-2"></i>
                                    <p class="my-3">{{ __('Lock in Period (Days) : ') }}
                                        <span
                                            class="me-1 border px-3 rounded py-1">{{ $data->lock_in_period }}</span>
                                    </p>
                                </div>
                            </div>
                            @endif
                            @if ($data->common_areas)
                            @php
                            $commonAreasList = explode(',', $data->common_areas);
                            $commonAreasFormatted = collect($commonAreasList)
                            ->map(fn($item) => ucwords(str_replace('_', ' ', trim($item))))
                            ->implode(', ');
                            @endphp
                            <div class="col-md-8">
                                <div class="form-group d-flex align-items-center flex-wrap">
                                    <i class="fa-solid fa-users me-2"></i>
                                    <p class="my-3 mb-0 me-2 me-2">{{ __('Common Areas : ') }}</p>
                                    @foreach (explode(',', $commonAreasFormatted) as $area)
                                    <span
                                        class="me-2 mt-2 border px-3 rounded py-1 ">{{ trim($area) }}</span>
                                    @endforeach
                                </div>
                            </div>
                            @endif
                            <!-- PG Plan Inputs Display End -->
                        </div>
                    </div>
                </div>
                {{-- caretacker details --}}
                <div class="block-wrap">
                    <div class="block-header">
                        <h4 class="block-title"><i class="fa-solid fa-info-circle me-2"></i>@lang('Owner/Caretaker Details')</h4>
                    </div>
                    <div class="block-body">
                        <div class="row">
                            <div class="col-md-8">
                                <div class="form-group d-flex align-items-center">
                                    <i class="fa-solid fa-user-tie me-2"></i>
                                    <p class="my-3">{{ __('Property Managed By : ') }}
                                        <span
                                            class="me-1 border px-3 rounded py-1">{{ ucwords(str_replace('_', ' ', trim($data->caretaker))) }}</span>
                                    </p>
                                </div>
                            </div>
                            <div class="col-md-8">
                                <div class="form-group d-flex align-items-center">
                                    <i class="fa-solid fa-user-shield me-2"></i>
                                    <p class="my-3">{{ __('Property Manager stays at Property : ') }}
                                        <span
                                            class="me-1 border px-3 rounded py-1">{{ ucwords($data->is_manager_stays ?? '') }}</span>
                                    </p>
                                </div>
                            </div>
                            <!-- PG Plan Inputs Display End -->
                        </div>
                    </div>
                </div>

                {{-- pg rules --}}
                <div class="block-wrap">
                    <div class="block-header">
                        <h4 class="block-title"><i class="fa-solid fa-info-circle me-2"></i>@lang('PG Rules')</h4>
                    </div>
                    <div class="block-body">
                        <div class="row">

                            <div class="col-md-8">
                                <div class="form-group d-flex align-items-center">
                                    <i class="fa-solid fa-drumstick-bite me-2"></i>
                                    <p class="my-3">{{ __('Non-Veg Allowed : ') }}
                                        <span
                                            class="me-1 border px-3 rounded py-1">{{ ucwords($data->veg_allowed ?? '') }}</span>
                                    </p>
                                </div>
                            </div>
                            <div class="col-md-8">
                                <div class="form-group d-flex align-items-center">
                                    <i class="fa-solid fa-venus-mars me-2"></i>
                                    <p class="my-3">{{ __('Opposit Sex Allowed : ') }}
                                        <span
                                            class="me-1 border px-3 rounded py-1">{{ ucwords($data->opposit_sex_allowed ?? '') }}</span>
                                    </p>
                                </div>
                            </div>
                            <div class="col-md-8">
                                <div class="form-group d-flex align-items-center">
                                    <i class="fa-solid fa-clock me-2"></i>
                                    <p class="my-3">{{ __('Any Time Allowed : ') }}
                                        <span
                                            class="me-1 border px-3 rounded py-1">{{ ucwords($data->any_time_allowed ?? '') }}</span>
                                    </p>
                                </div>
                            </div>
                            @if ($data->any_time_allowed === 'no' && $data->last_entry_time)
                            <div class="col-md-8">
                                <div class="form-group d-flex align-items-center">
                                    <i class="fa-solid fa-door-closed me-2"></i>
                                    <p class="my-3">{{ __('Last Time Entry : ') }}
                                        <span
                                            class="me-1 border px-3 rounded py-1">{{ $data->last_entry_time }}</span>
                                    </p>
                                </div>
                            </div>
                            @endif
                            <div class="col-md-8">
                                <div class="form-group d-flex align-items-center">
                                    <i class="fa-solid fa-user-friends me-2"></i>
                                    <p class="my-3">{{ __('Visitors Allowed : ') }}
                                        <span
                                            class="me-1 border px-3 rounded py-1">{{ ucwords($data->visitors_allowed ?? '') }}</span>
                                    </p>
                                </div>
                            </div>
                            <div class="col-md-8">
                                <div class="form-group d-flex align-items-center">
                                    <i class="fa-solid fa-user-shield me-2"></i>
                                    <p class="my-3">{{ __('Guardians Allowed : ') }}
                                        <span
                                            class="me-1 border px-3 rounded py-1">{{ ucwords($data->guardians_allowed ?? '') }}</span>
                                    </p>
                                </div>
                            </div>
                            <div class="col-md-8">
                                <div class="form-group d-flex align-items-center">
                                    <i class="fa-solid fa-wine-glass me-2"></i>
                                    <p class="my-3">{{ __('Drinking Allowed : ') }}
                                        <span
                                            class="me-1 border px-3 rounded py-1">{{ ucwords($data->drinking_allowed ?? '') }}</span>
                                    </p>
                                </div>
                            </div>
                            <div class="col-md-8">
                                <div class="form-group d-flex align-items-center">
                                    <i class="fa-solid fa-smoking me-2"></i>
                                    <p class="my-3">{{ __('Smoking Allowed : ') }}
                                        <span
                                            class="me-1 border px-3 rounded py-1">{{ ucwords($data->smoking_allowed ?? '') }}</span>
                                    </p>
                                </div>
                            </div>
                            <!-- PG Plan Inputs Display End -->
                        </div>
                    </div>
                </div>
                {{-- rooms details  --}}
                <div class="block-wrap">
                    <div class="block-header">
                        <h4 class="block-title"><i class="fa-solid fa-info-circle me-2"></i>@lang('Rooms Details')</h4>
                    </div>
                    <div class="block-body">
                        <div class="row">
                            @foreach ($data->rooms as $room)
                            <div class="col-md-12 col-lg-12 mb-3">
                                <div class="border rounded p-3 ">
                                    <h6 class="fw-bold mb-2">
                                        @php
                                        $icon = '';
                                        $type = strtolower(trim($room->type));
                                        if ($type === 'private room') {
                                        $icon = '<i class="fa-solid fa-door-closed me-1"></i>';
                                        } elseif ($type === 'double sharing') {
                                        $icon = '<i class="fa-solid fa-user-group me-1"></i>';
                                        } elseif ($type === 'triple sharing' || $type === '3+ sharing') {
                                        $icon = '<i class="fa-solid fa-users me-1"></i>';
                                        } else {
                                        $icon = '<i class="fa-solid fa-bed me-1"></i>';
                                        }
                                        @endphp
                                        {!! $icon !!}{{ $room->type }}
                                    </h6>
                                    <div class="mb-1"><i class="fa-solid fa-bed me-1"></i> Beds:
                                        <b>{{ $room->total_beds }}</b>
                                    </div>
                                    <div class="mb-1"><i class="fa-solid fa-indian-rupee-sign me-1"></i>
                                        Rent: <b>₹{{ number_format($room->rent) }}</b></div>
                                    @if (!empty($room->deposit))
                                    <div class="mb-1"><i class="fa-solid fa-vault me-1"></i> Security
                                        Deposit: <b>₹{{ number_format($room->deposit) }}</b></div>
                                    @endif
                                    @if (!empty($room->facilities))
                                    @php
                                    // Decode JSON if it's a JSON string
                                    $facilities = $room->facilities;

                                    if (is_string($facilities)) {
                                    $decoded = json_decode($facilities, true);
                                    $facilities = is_array($decoded)
                                    ? $decoded
                                    : explode(',', $facilities);
                                    }
                                    @endphp

                                    @if (!empty($facilities) && is_array($facilities))
                                    <div class="mb-1">
                                        <i class="fa-solid fa-list me-1"></i> Facilities:
                                        <p class="d-block d-lg-inline">
                                            @foreach ($facilities as $facility)
                                        <p class="badge text-dark border me-1 mb-1">
                                            {{ ucwords(str_replace('_', ' ', trim($facility))) }}
                                        </p>
                                        @endforeach
                                        </p>
                                    </div>
                                    @endif
                                    @endif


                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>
                </div>
                <!-- Amenities Block -->
                @if ($data->attributes)
                @foreach ($attribute_name = json_decode($data->attributes, true) as $key => $attributes)
                <div class="block-wrap">
                    <div class="block-header">
                        <h4 class="block-title"><i class="fa-solid fa-list me-2"></i> {{ $key }}
                        </h4>
                    </div>
                    <div class="block-body">
                        <div class="row">
                            @foreach ($attributes as $key => $id)
                            <div class="col-md-4">
                                <div class="d-flex align-items-center">
                                    <i class="fa-solid fa-check-circle me-2"></i>
                                    <p class="m-0">
                                        {{ DB::table('attribute_options')->where('id', $id)->first()->name ?? '' }}
                                    </p>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>
                </div>
                @endforeach
                @endif
                {{-- Other Details --}}
                <div class="block-wrap">
                    <div class="block-header">
                        <h4 class="block-title"><i class="fa-solid fa-info-circle me-2"></i>@lang('Other Details')</h4>
                    </div>
                    <div class="block-body">
                        <div class="row">
                            <div class="col-md-8">
                                <div class="form-group d-flex align-items-center">
                                    <i class="fa-solid fa-money-bill-wave me-2"></i>
                                    <p class="my-3">{{ __('One Time Move in Charges (Rs) :') }}
                                        <span class="me-1 border px-3 rounded py-1">
                                            {{ $data->move_charges ? $data->move_charges : 'N/A' }}
                                        </span>
                                    </p>
                                </div>
                            </div>

                            <div class="col-md-8">
                                <div class="form-group d-flex align-items-center">
                                    <i class="fa-solid fa-utensils me-2"></i>
                                    <p class="my-3">{{ __('Meal Charges Per Month (Rs) :') }}
                                        <span class="me-1 border px-3 rounded py-1">
                                            {{ $data->meal_charges ? $data->meal_charges : 'N/A' }}
                                        </span>
                                    </p>
                                </div>
                            </div>

                            <div class="col-md-8">
                                <div class="form-group d-flex align-items-center">
                                    <i class="fa-solid fa-bolt me-2"></i>
                                    <p class="my-3">{{ __('Electricity Charges Per Month (Rs) :') }}
                                        <span class="me-1 border px-3 rounded py-1">
                                            {{ $data->electricity_charges ? $data->electricity_charges : 'N/A' }}
                                        </span>
                                    </p>
                                </div>
                            </div>

                            <div class="col-md-8">
                                <div class="form-group d-flex align-items-center">
                                    <i class="fa-solid fa-info-circle me-2"></i>
                                    <p class="my-3">{{ __('Additional Information (Rs) :') }}
                                        <span class="me-1 border px-3 rounded py-1">
                                            {{ $data->additional_info ? $data->additional_info : 'N/A' }}
                                        </span>
                                    </p>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>

                <!-- Property Reviews -->
                <div class="block-wrap">
                    <div class="block-header">
                        <h4 class="block-title">{{ count($reviews) }} @lang('Reviews')</h4>
                    </div>
                    <div class="block-body">
                        <div class="author-review">
                            <div class="comment-list">
                                <ul>
                                    @foreach ($reviews as $key => $review)
                                    <li class="article_comments_wrap">
                                        <article>
                                            <div class="article_comments_thumb">
                                                <img src="{{ asset('assets/images/' . $review->user->photo) }}"
                                                    alt="">
                                            </div>
                                            <div class="comment-details">
                                                <div class="comment-meta">
                                                    <div class="comment-left-meta">
                                                        <h4 class="author-name">{{ $review->user->name }}
                                                        </h4>
                                                        <div class="comment-date">
                                                            {{ $review->created_at->format('d M Y') }}
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="comment-text">
                                                    <p>{{ $review->message }}</p>
                                                </div>
                                            </div>
                                        </article>
                                    </li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Single Block Wrap -->
                <div class="block-wrap">
                    <div class="block-header">
                        <h4 class="block-title">@lang('Write A Review')</h4>
                    </div>
                    <div class="block-body">
                        <form class="simple-form" action="{{ route('user.property.review') }}" method="POST">
                            @csrf
                            <div class="row gy-3">
                                <input type="hidden" name="user_id" value="{{ auth()->id() }}">
                                <input type="hidden" name="property_id" value="{{ $data->id }}">
                                <input type="hidden" id="reviewRate" name="rate" value="">
                                <div class="form-group review-items review-icon sspd_review w-auto">
                                    <div class="item">
                                        <div class="fr-can-rating">
                                            <i class="fas fa-star rate_item" data-value="1"></i>
                                            <i class="fas fa-star rate_item" data-value="2"></i>
                                            <i class="fas fa-star rate_item" data-value="3"></i>
                                            <i class="fas fa-star rate_item" data-value="4"></i>
                                            <i class="fas fa-star rate_item" data-value="5"></i>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <input type="text" class="form-control" name="title"
                                            placeholder="@lang('Subject Title')">
                                    </div>
                                </div>
                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <textarea class="form-control ht-80" name="message" placeholder="@lang('Messages')"></textarea>
                                    </div>
                                </div>
                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <button class="btn btn-theme" type="submit">@lang('Submit Review')</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <!-- property Sidebar -->
            <div class="col-lg-4 col-md-12 col-sm-12">
                <div class="like_share_wrap mt-2">
                    @if ($data->is_invest == 1)
                    <div class="d-flex flex-row">
                        <div class="col-md-8">
                            @lang('Property Price')
                        </div>
                        <div class="col-md-6 prt-price-fix">
                            {{ showAmount($data->price) }}
                        </div>
                    </div>
                    <div class="d-flex flex-row mt-3">
                        <div class="col-md-8">
                            @lang('Min invest amount')
                        </div>
                        <div class="col-md-6 prt-price-fix">
                            {{ showAmount($data->min_invest) }}
                        </div>
                    </div>
                    <div class="d-flex flex-row mt-3">
                        <div class="col-md-8">
                            @lang('Max invest amount')
                        </div>
                        <div class="col-md-6 prt-price-fix">
                            {{ showAmount($data->max_invest) }}
                        </div>
                    </div>
                    <div class="d-flex flex-row mt-3">
                        <div class="col-md-8">
                            @lang('Future value')
                        </div>
                        <div class="col-md-6 prt-price-fix">
                            {{ showAmount($data->funding_amount) }}
                        </div>
                    </div>
                    <div class="d-flex flex-row mt-3">
                        <div class="col-md-8">
                            @lang('Total Invest amount')
                        </div>
                        <div class="col-md-6 prt-price-fix">
                            {{ showAmount($data->invest_amount) }}
                        </div>
                    </div>
                    <div class="d-flex flex-row mt-3">
                        <div class="col-md-8">
                            @lang('Hold Years')
                        </div>
                        <div class="col-md-6 prt-price-fix">
                            {{ $data->hold_years }} @lang(' Years')
                        </div>
                    </div>
                    <div class="d-flex flex-row mt-3">
                        <button type="button" class="btn btn-theme full-width" data-bs-toggle="modal"
                            data-bs-target="#exampleModalCenter">@lang('Invest Now')</button>
                    </div>
                    @else
                    <ul class="d-flex justify-content-center d-flex">
                        @if ($data->type == 'for_campaign')
                        <li><a href="{{ route('user.crowdfunding.checkout', $data->slug) }}"
                                class="btn btn-likes" data-toggle="tooltip" data-original-title="Share"><i
                                    class="ti-money"></i>
                                @lang('Invest')</a></li>
                        @else
                        @endif
                        <li class="mx-2">
                            @if ($data->isContacted)
                            <a href="#" class="btn btn-primary rounded w-100 border-primary view-contact">
                                Contacted
                            </a>
                            @endif
                        </li>
                        @if ($data->admin)
                        @auth
                        <button class="btn btn-primary rounded border-primary view-contact-btn sm "
                            onclick="showContactModal('{{ $data->admin->name }}', '{{ $data->admin->phone }}')">
                            View Contact
                        </button>
                        @else
                        <button class="btn btn-primary rounded border-primary view-contact-btn sm"
                            onclick="redirectToLogin()">
                            View Contact
                        </button>
                        @endauth
                        @else
                        @if ($data->user)
                        @auth
                        <button class="btn btn-primary rounded border-primary view-contact"
                            onclick="showContactModal('{{ $data->user->name }}', '{{ $data->user->phone }}')">
                            Contact Seller
                        </button>
                        @else
                        <button class="btn btn-primary rounded border-primary view-contact-btn sm"
                            onclick="redirectToLogin()">
                            Contact Seller
                        </button>
                        @endauth
                        @endif
                        @endif
                    </ul>
                    @endif
                </div>
                <div class="page-sidebar">
                    <!-- Agent Detail -->
                    <div class="agent-title mt-3" style="margin-bottom:80px;">
                        <div class="clearfix"></div>
                        <div class="card shadow-sm p-4">
                            <form action="{{ route('user.property.enquiry') }}" method="post">
                                @csrf
                                <h6 class="card-title mb-4 text-bold">Contact Seller</h6>

                                <!-- Seller Details -->
                                <div class="seller-details mb-4 d-flex">
                                    <img src="{{ asset('assets/images/' . $data->photo) }}" class="img-fluid"
                                        alt="Property Image" style="object-fit: cover;" width="70px">
                                    <span class="mx-3">
                                        {{ $data->user->name }}<br>
                                        &nbsp;{{ $data->user->user_type == 'Agent' ? 'Seller' : $data->user->user_type }}
                                        <br>
                                        +91-{{ substr($data->user->phone, 0, 4) }}-XXX-XXX<br>
                                    </span>
                                </div>

                                <!-- Hi User + Edit Details Block -->

                                @if (auth()->check())
                                <div>
                                    <h3>Hi <strong>{{ auth()->user()->name }}!</strong></h3>
                                </div>
                                @endif
                                @if ($data->isContacted)
                                <div>
                                    <a href="javascript:void(0);" id="contact-toggle">Edit Details</a>
                                </div>
                                @endif
                                {{-- @endif --}}

                                <!-- Contact Form (Initially Hidden if isContacted is true) -->
                                <div id="contact-form" style="{{ $data->isContacted ? 'display: none;' : '' }}">
                                    <p class="py-2">Please share your contact</p>
                                    <input type="hidden" name="property_id" value="{{ $data->id }}">

                                    @if ($data->admin)
                                    <input type="hidden" name="admin_id" value="{{ $data->admin->id }}">
                                    @else
                                    <input type="hidden" name="user_id"
                                        value="{{ $data->user ? $data->user->id : '' }}">
                                    @endif
                                    <div class="row">
                                        <!-- Your Name -->
                                        <div class="col-12">
                                            <label for="name" class="mb-1">@lang('Your Name')</label>
                                            <input type="text" class="form-control" name="name" id="name"
                                                value="{{ auth()->user() ? auth()->user()->name : '' }}">
                                        </div>

                                        <!-- Your Phone -->
                                        <div class="col-12 mt-2">
                                            <label for="phone" class="mb-1">@lang('Your Phone')</label>
                                            <input type="tel" class="form-control" name="phone"
                                                oninput="this.value = this.value.replace(/[^0-9]/g, '')"
                                                value="{{ auth()->user() ? '+91-' . auth()->user()->phone : '' }}">
                                        </div>

                                        <!-- Your Email -->
                                        <div class="col-12 mt-2">
                                            <label for="email" class="mb-1">@lang('Your Email')</label>
                                            <input type="email" class="form-control" name="email" id="email"
                                                value="{{ auth()->user() ? auth()->user()->email : '' }}">
                                        </div>
                                    </div>
                                </div>
                                <hr>
                                <!-- Agreement Checkboxes -->
                                <div class="form-group col-12">
                                    <div class="form-check">
                                        <input type="checkbox" class="form-check-input" id="agreement"
                                            name="agreement" required>
                                        <label class="form-check-label" for="agreement">
                                            I agree to be contacted by Velox Infra and agents via WhatsApp, SMS,
                                            phone,
                                            email etc.
                                        </label>
                                    </div>
                                    <div class="form-check">
                                        <input type="checkbox" class="form-check-input" id="agreement1"
                                            name="agreement1">
                                        <label class="form-check-label" for="agreement1">
                                            I am interested in Home Loans.<br>
                                            I hereby authorize veloxinfra.com.
                                        </label>
                                    </div>

                                    <!-- Submit Button with Dynamic Text -->
                                    <div class="form-group col-12 text-center">
                                        <button class="btn btn-theme full-width" type="submit">
                                            {{ $data->isContacted ? 'Contacted' : __('Get Contact Details') }}
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                    <!-- Featured Property -->
                    <div class="sidebar-widgets">
                        <h4>@lang('Featured Property')</h4>
                        <div class="sidebar_featured_property">
                            @foreach ($featured_properties as $key => $fproperty)
                            <!-- List Sibar Property -->
                            <div class="sides_list_property">
                                <div class="sides_list_property_thumb">
                                    <img src="{{ asset('assets/images/' . $fproperty->photo) }}"
                                        class="img-fluid" alt="">
                                </div>
                                <div class="sides_list_property_detail">
                                    <h4><a
                                            href="{{ route('front.property.details', $fproperty->slug) }}">{{ $fproperty->name }}</a>
                                    </h4>
                                    <span>
                                        <i class="ti-location-pin"></i>
                                        {{ $fproperty->location != null ? ($fproperty->location->parent_id != null ? $fproperty->location->name . ', ' . $fproperty->location->parent->name : $fproperty->location->name) : 'N/A' }}
                                    </span>
                                    <div class="lists_property_price">
                                        <div class="lists_property_types">
                                            <div class="property_types_vlix sale">
                                                {{ $fproperty->type == 'for_rent' ? __('For Rent') : __('For Sell') }}
                                            </div>
                                        </div>
                                        <div class="lists_property_price_value">
                                            <h4>{{ showAmount($fproperty->price) }}</h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- ============================ Invest Modal ================================== -->
<div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog"
    aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalCenterTitle">@lang('Invest Now')</h5>
                <button type="button" class="close border-0" data-bs-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-8">
                        <div class="wrap-modal-slider">
                            <div class="your-class">
                                @if ($data->galleries)
                                @foreach ($data->galleries as $key => $gallery)
                                <li>
                                    <a href="{{ asset('assets/images/' . $gallery->photo) }}"
                                        class="mfp-gallery"><img
                                            src="{{ asset('assets/images/' . $gallery->photo) }}"
                                            class="img-fluid mx-auto" alt="" /></a>
                                </li>
                                @endforeach
                                @endif
                            </div>
                        </div>
                    </div>
                    <div class="col-md-8">
                        <form action="{{ route('user.invest.property') }}" method="post">
                            @csrf
                            <div class="form-group">
                                <label>@lang('Amount')</label>
                                <input type="number" class="form-control" id="investAmount" name="amount"
                                    placeholder="@lang('Enter amount')">
                            </div>
                            <input type="hidden" name="property_id" value="{{ $data->id }}">
                            <input type="hidden" id="form_profit" name="return_amount" value="">
                            <p class="text-danger" id="profitFinalAmount"></p>
                            <button class="btn btn-theme full-width" id="investBtn">@lang('Invest')</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="contactModal" tabindex="-1" role="dialog" aria-labelledby="contactModalLabel"
    aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="contactModalLabel">Contact Details</h5>
                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <p><strong>Name:</strong> <span id="contactName"></span></p>
                <p><strong>Phone:</strong> <span id="contactPhone"></span></p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary modal-close-btn"
                    data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
@includeIf('partials.front.cta')
@endsection
@push('js')
<script src="http://maps.google.com/maps/api/js?key="></script>
<script src="{{ asset('assets/front/js/map_infobox.js') }}"></script>
<script src="{{ asset('assets/front/js/markerclusterer.js') }}"></script>
<script src="{{ asset('assets/front/js/map.js') }}"></script>
<script>
    'use strict';

    $(document).ready(function() {
        $('.your-class').slick();
    });

    $('.modal').on('shown.bs.modal', function(e) {
        $('.your-class').slick('setPosition');
        $('.wrap-modal-slider').addClass('open');
        $("#investAmount").val('');
        $("#profitFinalAmount").text('');
    });
    $(".rate_item").on('click', function() {
        let n = $(this).data('value');
        $(".rate_item").each(function(i) {
            $(this).removeClass('filled');
        });
        $(".rate_item").each(function(i) {
            if (i <= n - 1) {
                $(this).addClass('filled');
            }
        });
        $("#reviewRate").val(n);
    });
    $("#investAmount").on('input', function() {
        let amount = parseFloat($(this).val());
        let minAmount = '{{ $data->min_invest }}';
        let maxAmount = '{{ $data->max_invest }}';
        let property_price = '{{ $data->price }}';
        let finalAmount = '{{ $data->funding_amount }}';
        let ProfitAmount = parseFloat(finalAmount - property_price);
        let profitPercentage = parseFloat((ProfitAmount * 100) / property_price);
        let finalProfit = parseFloat((amount / 100) * profitPercentage) + amount;
        if (amount >= minAmount && amount <= maxAmount) {
            $("#profitFinalAmount").text(`You will get return ${finalProfit}`);
            $("#form_profit").val(finalProfit);
        } else {
            $("#profitFinalAmount").text('');
        }
    });
    $("#propertyPrint").on('click', function() {
        window.print();
    });
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    $(document).on('click', '#wishList', function() {
        let $this = $(this);
        let propertyId = $this.data('property');
        let userId = $this.data('user');

        if (!userId) {
            window.location.href = mainurl + '/login-register';
            return;
        }

        console.log("Wishlist Clicked!");

        $.ajax({
            method: "POST",
            url: mainurl + '/property/wishlist',
            data: {
                property_id: propertyId,
                user_id: userId
            },
            success: function(data) {
                if (data.success) {
                    $this.removeClass().addClass('like-bitt add-to-favorite');
                    toastr.success(data.success);
                } else {
                    $this.removeClass().addClass('add-to-favorite');
                    toastr.error(data.error);
                }
                setTimeout(() => {
                    location.reload();
                }, 1000);
            }
        });
    });

    $(document).on('click', '.save-to-favorite', function(e) {
        let $this = $(this);
        let propertyId = $this.data('property');
        let userId = $this.data('user');

        if (!userId) {
            window.location.href = mainurl + '/login-register';
            return;
        }

        console.log("Save Property Clicked!"); // Debugging log

        $.ajax({
            method: "POST",
            url: mainurl + '/property/save-property',
            data: {
                property_id: propertyId,
                user_id: userId
            },
            success: function(data) {
                if (data.success) {
                    $this.removeClass().addClass('like-bitt save-to-favorite');
                    toastr.success(data.success);
                } else {
                    $this.removeClass().addClass('save-to-favorite');
                    toastr.error(data.error);
                }
                setTimeout(() => {
                    location.reload();
                }, 1000);
            }
        });
    });


    function showLoginPrompt() {
        alert('You need to log in to view contact details.');
        window.location.href = "{{ route('user.otp') }}";
    }

    function showContactModal(name, phone) {
        document.getElementById('contactName').innerText = name;
        document.getElementById('contactPhone').innerText = '+91-' + phone;
        $('#contactModal').modal('show');
    }

    function closeModal() {
        $('#contactModal').modal('hide');
    }

    function redirectToLogin() {
        window.location.href = "{{ route('user.otp') }}";
    }
    $(document).on('click', '.modal-close-btn', function() {
        closeModal();
    });
    document.addEventListener("DOMContentLoaded", function() {
        var toggleButton = document.getElementById("contact-toggle");
        var contactForm = document.getElementById("contact-form");

        if (toggleButton) {
            toggleButton.addEventListener("click", function(e) {
                e.preventDefault();
                if (contactForm.style.display === "none") {
                    contactForm.style.display = "block";
                } else {
                    contactForm.style.display = "none";
                }
            });
        }
    });
</script>
<script>
    $(document).ready(function() {
        let shareOptions = $("#shareOptions");

        // Function to hide the shareOptions
        function hideShareOptions() {
            shareOptions.addClass("d-none");
        }
        $("#shareButton").on("click", function(e) {
            e.stopPropagation();
            shareOptions.removeClass("d-none");

            setTimeout(hideShareOptions, 5000);
        });
        $(document).on("click", function(e) {
            if (!$(e.target).closest("#shareOptions, #shareButton").length) {
                hideShareOptions();
            }
        });
    });
    document.getElementById('copyLink').addEventListener('click', function() {
        let propertyUrl = window.location.href;
        navigator.clipboard.writeText(propertyUrl).then(() => {
            alert('Link copied to clipboard!');
        });
    });
    document.getElementById('shareInstagram').addEventListener('click', function() {
        let propertyUrl = encodeURIComponent(window.location.href);
        window.open(`https://www.instagram.com/sharer/sharer.php?u=${propertyUrl}`, '_blank');
    });
    document.getElementById('shareFacebook').addEventListener('click', function() {
        let propertyUrl = encodeURIComponent(window.location.href);
        window.open(`https://www.facebook.com/sharer/sharer.php?u=${propertyUrl}`, '_blank');
    });
    document.getElementById('shareLinkedin').addEventListener('click', function() {
        let propertyUrl = encodeURIComponent(window.location.href);
        window.open(`https://www.linkedin.com/sharer/sharer.php?u=${propertyUrl}`, '_blank');
    });
    document.getElementById('shareTwitter').addEventListener('click', function() {
        let propertyUrl = encodeURIComponent(window.location.href);
        window.open(`https://twitter.com/intent/tweet?url=${propertyUrl}&text=Check out this property!`,
            '_blank');
    });
    document.getElementById('shareWhatsapp').addEventListener('click', function() {
        let propertyUrl = encodeURIComponent(window.location.href);
        window.open(`https://api.whatsapp.com/send?text=${propertyUrl}`, '_blank');
    });
</script>
@endpush